# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2023-06-11T10:00:45+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field

from ..v0 import field_0


class Rollup(BaseModel):
    type: Optional[str] = Field(None, description="Type of rollup")
    last_run: Optional[int] = Field(None, description="Timestamp of last rollup")
    last_cycle: Optional[int] = Field(None, description="Timestamp of last cycle")
    max_cycle: Optional[int] = Field(None, description="Max time of all cycles")
    total_time: Optional[int] = Field(
        None, description="Total time (s) spent doing rollup"
    )
    mean_cycles: Optional[int] = Field(None, description="Average time (s) of cycle")


class Time(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing this RPC type"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing this RPC type"
    )


class RPC(BaseModel):
    rpc: Optional[str] = Field(None, description="RPC type")
    count: Optional[int] = Field(None, description="Number of RPCs")
    time: Optional[Time] = Field(None, description="Time values")


class TimeModel(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing each user RPC"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing each user RPC"
    )


class User(BaseModel):
    user: Optional[str] = Field(None, description="User name")
    count: Optional[int] = Field(None, description="Number of RPCs")
    time: Optional[TimeModel] = Field(None, description="Time values")


class Field36CoordinatorInfo(BaseModel):
    name: Optional[str] = Field(None, description="Name of user")
    direct: Optional[int] = Field(
        None,
        description="If user is coordinator of this account directly or coordinator status was inheirted from a higher account in the tree",
    )


class Field36AssociationShortInfo(BaseModel):
    account: Optional[str] = Field(None, description="Account name")
    cluster: Optional[str] = Field(None, description="Cluster name")
    partition: Optional[str] = Field(None, description="Partition name (optional)")
    user: Optional[str] = Field(None, description="User name")


class Field36Wckey(BaseModel):
    accounts: Optional[List[str]] = Field(None, description="List of assigned accounts")
    cluster: Optional[str] = Field(None, description="Cluster name")
    id: Optional[int] = Field(None, description="wckey database unique id")
    name: Optional[str] = Field(None, description="wckey name")
    user: Optional[str] = Field(None, description="wckey user")
    flags: Optional[List[str]] = Field(None, description="List of properties of wckey")


class Controller(BaseModel):
    host: Optional[str] = Field(None, description="Hostname")
    port: Optional[int] = Field(None, description="Port number")


class Associations(BaseModel):
    root: Optional[Field36AssociationShortInfo] = None


class Default(BaseModel):
    account: Optional[str] = Field(None, description="Default account name")
    wckey: Optional[str] = Field(None, description="Default wckey")


class Field36User(BaseModel):
    administrator_level: Optional[str] = Field(
        None, description="Description of administrator level"
    )
    associations: Optional[Associations] = Field(
        None, description="Assigned associations"
    )
    coordinators: Optional[List[Field36CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    default: Optional[Default] = Field(None, description="Default settings")
    name: Optional[str] = Field(None, description="User name")


class DefaultModel(BaseModel):
    qos: Optional[str] = Field(None, description="Default QOS")


class Per(BaseModel):
    wall_clock: Optional[int] = Field(None, description="Max wallclock per job")


class Jobs(BaseModel):
    per: Optional[Per] = Field(None, description="Max jobs per settings")


class Account(BaseModel):
    wall_clock: Optional[int] = Field(None, description="Max wallclock per account")


class PerModel(BaseModel):
    account: Optional[Account] = Field(None, description="Max per accounting settings")


class Min(BaseModel):
    priority_threshold: Optional[int] = Field(
        None, description="Min priority threshold"
    )


class Usage(BaseModel):
    accrue_job_count: Optional[int] = Field(None, description="Jobs accuring priority")
    group_used_wallclock: Optional[float] = Field(
        None, description="Group used wallclock time (s)"
    )
    fairshare_factor: Optional[float] = Field(None, description="Fairshare factor")
    fairshare_shares: Optional[int] = Field(None, description="Fairshare shares")
    normalized_priority: Optional[int] = Field(
        None, description="Currently active jobs"
    )
    normalized_shares: Optional[float] = Field(None, description="Normalized shares")
    effective_normalized_usage: Optional[float] = Field(
        None, description="Effective normalized usage"
    )
    raw_usage: Optional[int] = Field(None, description="Raw usage")
    job_count: Optional[int] = Field(None, description="Total jobs submitted")
    fairshare_level: Optional[float] = Field(None, description="Fairshare level")


class PerModel1(BaseModel):
    qos: Optional[int] = Field(None, description="Max wallclock per QOS")
    job: Optional[int] = Field(None, description="Max wallclock per job")


class WallClock(BaseModel):
    per: Optional[PerModel1] = Field(
        None, description="Limit on wallclock per settings"
    )


class PerModel2(BaseModel):
    account: Optional[int] = Field(None, description="Max jobs per account")
    user: Optional[int] = Field(None, description="Max jobs per user")


class JobsModel(BaseModel):
    per: Optional[PerModel2] = Field(None, description="Limits on jobs per settings")


class PerModel3(BaseModel):
    account: Optional[int] = Field(
        None, description="Max accuring priority per account"
    )
    user: Optional[int] = Field(None, description="Max accuring priority per user")


class Accruing(BaseModel):
    per: Optional[PerModel3] = Field(
        None, description="Max accuring priority per setting"
    )


class Preempt(BaseModel):
    list: Optional[List[str]] = Field(None, description="List of preemptable QOS")
    mode: Optional[List[str]] = Field(None, description="List of preemption modes")
    exempt_time: Optional[int] = Field(
        None, description="Grace period (s) before jobs can preempted"
    )


class Field36TresListItem(BaseModel):
    type: Optional[str] = Field(None, description="TRES type")
    name: Optional[str] = Field(None, description="TRES name (optional)")
    id: Optional[int] = Field(None, description="database id")
    count: Optional[int] = Field(None, description="count of TRES")


class Field36TresList(BaseModel):
    __root__: Optional[List[Field36TresListItem]] = Field(
        None, description="TRES list of attributes"
    )


class Comment(BaseModel):
    administrator: Optional[str] = Field(None, description="Administrator set comment")
    job: Optional[str] = Field(None, description="Job comment")
    system: Optional[str] = Field(None, description="System set comment")


class Running(BaseModel):
    tasks: Optional[int] = Field(
        None, description="Max running tasks in array at any one time"
    )


class Max(BaseModel):
    running: Optional[Running] = Field(None, description="Limits on array settings")


class Limits(BaseModel):
    max: Optional[Max] = Field(None, description="Limits on array settings")


class Array(BaseModel):
    job_id: Optional[int] = Field(None, description="Job id of array")
    limits: Optional[Limits] = Field(None, description="Limits on array settings")
    task: Optional[str] = Field(None, description="Array task")
    task_id: Optional[int] = Field(None, description="Array task id")


class System(BaseModel):
    seconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the system on behalf of the process (in kernel mode), in seconds",
    )
    microseconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the system on behalf of the process (in kernel mode), in microseconds",
    )


class Total(BaseModel):
    seconds: Optional[int] = Field(
        None, description="Total number of CPU-seconds used by the job, in seconds"
    )
    microseconds: Optional[int] = Field(
        None, description="Total number of CPU-seconds used by the job, in microseconds"
    )


class UserModel(BaseModel):
    seconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in seconds",
    )
    microseconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in microseconds",
    )


class TimeModel1(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    eligible: Optional[int] = Field(None, description="Total time eligible to run")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    submission: Optional[int] = Field(
        None, description="Timestamp of when job submitted"
    )
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel] = Field(None, description="User land time values")
    limit: Optional[int] = Field(None, description="Job wall clock time limit")


class Het(BaseModel):
    job_id: Optional[Dict[str, Any]] = Field(None, description="Parent HetJob id")
    job_offset: Optional[Dict[str, Any]] = Field(
        None, description="Offset of this job to parent"
    )


class Mcs(BaseModel):
    label: Optional[str] = Field(None, description="Assigned MCS label")


class Required(BaseModel):
    CPUs: Optional[int] = Field(None, description="Required number of CPUs")
    memory: Optional[int] = Field(None, description="Required amount of memory (MiB)")


class Reservation(BaseModel):
    id: Optional[int] = Field(None, description="Database id of reservation")
    name: Optional[int] = Field(None, description="Name of reservation")


class State(BaseModel):
    current: Optional[str] = Field(None, description="Current state of job")
    previous: Optional[str] = Field(None, description="Last reason job didn't run")


class Tres(BaseModel):
    allocated: Optional[Field36TresList] = None
    requested: Optional[Field36TresList] = None


class Wckey(BaseModel):
    wckey: Optional[str] = Field(None, description="Job assigned wckey")
    flags: Optional[List[str]] = Field(None, description="wckey flags")


class Signal(BaseModel):
    signal_id: Optional[int] = Field(None, description="Signal number process received")
    name: Optional[str] = Field(None, description="Name of signal received")


class Field36JobExitCode(BaseModel):
    status: Optional[str] = Field(None, description="Job exit status")
    return_code: Optional[int] = Field(
        None, description="Return code from parent process"
    )
    signal: Optional[Signal] = Field(None, description="Signal details (if signaled)")


class TimeModel2(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel] = Field(None, description="User land time values")


class Nodes(BaseModel):
    count: Optional[int] = Field(None, description="Total number of nodes in step")
    range: Optional[str] = Field(None, description="Nodes in step")


class Tasks(BaseModel):
    count: Optional[int] = Field(None, description="Number of tasks in step")


class RequestedFrequency(BaseModel):
    min: Optional[int] = Field(None, description="Min CPU frequency")
    max: Optional[int] = Field(None, description="Max CPU frequency")


class CPU(BaseModel):
    requested_frequency: Optional[RequestedFrequency] = Field(
        None, description="CPU frequency requested"
    )
    governor: Optional[List[str]] = Field(None, description="CPU governor")


class CPUModel(BaseModel):
    actual_frequency: Optional[int] = Field(
        None, description="Actual frequency of CPU during step"
    )


class Energy(BaseModel):
    consumed: Optional[int] = Field(None, description="Energy consumed during step")


class Statistics(BaseModel):
    CPU: Optional[CPUModel] = Field(None, description="Statistics of CPU")
    energy: Optional[Energy] = Field(None, description="Statistics of energy")


class HetModel(BaseModel):
    component: Optional[int] = Field(None, description="Parent HetJob component id")


class Step(BaseModel):
    job_id: Optional[int] = Field(None, description="Parent job id")
    het: Optional[HetModel] = Field(None, description="Heterogeneous job details")
    id: Optional[str] = Field(None, description="Step id")
    name: Optional[str] = Field(None, description="Step name")


class Task(BaseModel):
    distribution: Optional[str] = Field(None, description="Task distribution type")


class Requested(BaseModel):
    average: Optional[Field36TresList] = None
    max: Optional[Field36TresList] = None
    min: Optional[Field36TresList] = None
    total: Optional[Field36TresList] = None


class Consumed(BaseModel):
    average: Optional[Field36TresList] = None
    max: Optional[Field36TresList] = None
    min: Optional[Field36TresList] = None
    total: Optional[Field36TresList] = None


class TresModel(BaseModel):
    requested: Optional[Requested] = Field(None, description="TRES requested for job")
    consumed: Optional[Consumed] = Field(None, description="TRES requested for job")
    allocated: Optional[Field36TresList] = None


class Field36JobStep(BaseModel):
    time: Optional[TimeModel2] = Field(None, description="Time properties")
    exit_code: Optional[Field36JobExitCode] = None
    nodes: Optional[Nodes] = Field(None, description="Node details")
    tasks: Optional[Tasks] = Field(None, description="Task properties")
    pid: Optional[str] = Field(None, description="First process PID")
    CPU: Optional[CPU] = Field(None, description="CPU properties")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    state: Optional[str] = Field(None, description="State of job step")
    statistics: Optional[Statistics] = Field(None, description="Statistics of job step")
    step: Optional[Step] = Field(None, description="Step details")
    task: Optional[Task] = Field(None, description="Task properties")
    tres: Optional[TresModel] = Field(None, description="TRES usage")


class Field36Error(BaseModel):
    errno: Optional[int] = Field(None, description="Error number")
    error: Optional[str] = Field(None, description="Error message")


class TimeModel3(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing this RPC type"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing this RPC type"
    )


class TimeModel4(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing each user RPC"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing each user RPC"
    )


class UserModel1(BaseModel):
    user: Optional[str] = Field(None, description="User name")
    count: Optional[int] = Field(None, description="Number of RPCs")
    time: Optional[TimeModel4] = Field(None, description="Time values")


class StatisticsModel(BaseModel):
    time_start: Optional[int] = Field(None, description="Unix timestamp of start time")
    rollups: Optional[List[Rollup]] = None
    RPCs: Optional[List[RPC]] = None
    users: Optional[List[UserModel1]] = None


class Field37CoordinatorInfo(BaseModel):
    name: Optional[str] = Field(None, description="Name of user")
    direct: Optional[int] = Field(
        None,
        description="If user is coordinator of this account directly or coordinator status was inheirted from a higher account in the tree",
    )


class Field37AssociationShortInfo(BaseModel):
    account: Optional[str] = Field(None, description="Account name")
    cluster: Optional[str] = Field(None, description="Cluster name")
    partition: Optional[str] = Field(None, description="Partition name (optional)")
    user: Optional[str] = Field(None, description="User name")


class Field37Wckey(BaseModel):
    accounts: Optional[List[str]] = Field(None, description="List of assigned accounts")
    cluster: Optional[str] = Field(None, description="Cluster name")
    id: Optional[int] = Field(None, description="wckey database unique id")
    name: Optional[str] = Field(None, description="wckey name")
    user: Optional[str] = Field(None, description="wckey user")
    flags: Optional[List[str]] = Field(None, description="List of properties of wckey")


class AssociationsModel(BaseModel):
    root: Optional[Field37AssociationShortInfo] = None


class DefaultModel1(BaseModel):
    account: Optional[str] = Field(None, description="Default account name")
    wckey: Optional[str] = Field(None, description="Default wckey")


class Field37User(BaseModel):
    administrator_level: Optional[str] = Field(
        None, description="Description of administrator level"
    )
    associations: Optional[AssociationsModel] = Field(
        None, description="Assigned associations"
    )
    coordinators: Optional[List[Field37CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    default: Optional[DefaultModel1] = Field(None, description="Default settings")
    name: Optional[str] = Field(None, description="User name")


class DefaultModel2(BaseModel):
    qos: Optional[str] = Field(None, description="Default QOS")


class PerModel4(BaseModel):
    wall_clock: Optional[int] = Field(None, description="Max wallclock per job")


class JobsModel1(BaseModel):
    active: Optional[int] = Field(None, description="Max TRES for active total jobs")
    accruing: Optional[int] = Field(
        None, description="Max TRES for job accruing priority"
    )
    total: Optional[int] = Field(None, description="Max TRES for job total submitted")
    per: Optional[PerModel4] = Field(None, description="Max jobs per settings")


class PerModel5(BaseModel):
    account: Optional[Account] = Field(None, description="Max per accounting settings")


class PerModel6(BaseModel):
    qos: Optional[int] = Field(None, description="Max wallclock per QOS")
    job: Optional[int] = Field(None, description="Max wallclock per job")


class PerModel7(BaseModel):
    account: Optional[int] = Field(None, description="Max jobs per account")
    user: Optional[int] = Field(None, description="Max jobs per user")


class ActiveJobs(BaseModel):
    per: Optional[PerModel7] = Field(
        None, description="Limits on active jobs per settings"
    )


class JobsModel2(BaseModel):
    active_jobs: Optional[ActiveJobs] = Field(
        None, description="Limits on active jobs settings"
    )


class PerModel8(BaseModel):
    account: Optional[int] = Field(
        None, description="Max accuring priority per account"
    )
    user: Optional[int] = Field(None, description="Max accuring priority per user")


class Field37TresListItem(BaseModel):
    type: Optional[str] = Field(None, description="TRES type")
    name: Optional[str] = Field(None, description="TRES name (optional)")
    id: Optional[int] = Field(None, description="database id")
    count: Optional[int] = Field(None, description="count of TRES")


class Field37TresList(BaseModel):
    __root__: Optional[List[Field37TresListItem]] = Field(
        None, description="TRES list of attributes"
    )


class UserModel2(BaseModel):
    seconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in seconds",
    )
    microseconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in microseconds",
    )


class TimeModel5(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    eligible: Optional[int] = Field(None, description="Total time eligible to run")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    submission: Optional[int] = Field(
        None, description="Timestamp of when job submitted"
    )
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel2] = Field(None, description="User land time values")
    limit: Optional[int] = Field(None, description="Job wall clock time limit")


class HetModel1(BaseModel):
    job_id: Optional[Dict[str, Any]] = Field(None, description="Parent HetJob id")
    job_offset: Optional[Dict[str, Any]] = Field(
        None, description="Offset of this job to parent"
    )


class StateModel(BaseModel):
    current: Optional[str] = Field(None, description="Current state of job")
    reason: Optional[str] = Field(None, description="Last reason job didn't run")


class TresModel1(BaseModel):
    allocated: Optional[Field37TresList] = None
    requested: Optional[Field37TresList] = None


class Field37JobExitCode(BaseModel):
    status: Optional[str] = Field(None, description="Job exit status")
    return_code: Optional[int] = Field(
        None, description="Return code from parent process"
    )
    signal: Optional[Signal] = Field(None, description="Signal details (if signaled)")


class TimeModel6(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel2] = Field(None, description="User land time values")


class CPUModel1(BaseModel):
    requested_frequency: Optional[RequestedFrequency] = Field(
        None, description="CPU frequency requested"
    )
    governor: Optional[List[str]] = Field(None, description="CPU governor")


class CPUModel2(BaseModel):
    actual_frequency: Optional[int] = Field(
        None, description="Actual frequency of CPU during step"
    )


class StatisticsModel1(BaseModel):
    CPU: Optional[CPUModel2] = Field(None, description="Statistics of CPU")
    energy: Optional[Energy] = Field(None, description="Statistics of energy")


class HetModel2(BaseModel):
    component: Optional[int] = Field(None, description="Parent HetJob component id")


class RequestedModel(BaseModel):
    average: Optional[Field37TresList] = None
    max: Optional[Field37TresList] = None
    min: Optional[Field37TresList] = None
    total: Optional[Field37TresList] = None


class ConsumedModel(BaseModel):
    average: Optional[Field37TresList] = None
    max: Optional[Field37TresList] = None
    min: Optional[Field37TresList] = None
    total: Optional[Field37TresList] = None


class TresModel2(BaseModel):
    requested: Optional[RequestedModel] = Field(
        None, description="TRES requested for job"
    )
    consumed: Optional[ConsumedModel] = Field(
        None, description="TRES requested for job"
    )
    allocated: Optional[Field37TresList] = None


class Field37JobStep(BaseModel):
    time: Optional[TimeModel6] = Field(None, description="Time properties")
    exit_code: Optional[Field37JobExitCode] = None
    nodes: Optional[Nodes] = Field(None, description="Node details")
    tasks: Optional[Tasks] = Field(None, description="Task properties")
    pid: Optional[str] = Field(None, description="First process PID")
    CPU: Optional[CPUModel1] = Field(None, description="CPU properties")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    state: Optional[str] = Field(None, description="State of job step")
    statistics: Optional[StatisticsModel1] = Field(
        None, description="Statistics of job step"
    )
    step: Optional[Step] = Field(None, description="Step details")
    task: Optional[Task] = Field(None, description="Task properties")
    tres: Optional[TresModel2] = Field(None, description="TRES usage")


class Field37Error(BaseModel):
    errno: Optional[int] = Field(None, description="Error number")
    error: Optional[str] = Field(None, description="Error message")


class TimeModel7(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing this RPC type"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing this RPC type"
    )


class TimeModel8(BaseModel):
    average: Optional[int] = Field(
        None, description="Average time spent processing each user RPC"
    )
    total: Optional[int] = Field(
        None, description="Total time spent processing each user RPC"
    )


class UserModel3(BaseModel):
    user: Optional[str] = Field(None, description="User name")
    count: Optional[int] = Field(None, description="Number of RPCs")
    time: Optional[TimeModel8] = Field(None, description="Time values")


class StatisticsModel2(BaseModel):
    time_start: Optional[int] = Field(None, description="Unix timestamp of start time")
    rollups: Optional[List[Rollup]] = None
    RPCs: Optional[List[RPC]] = None
    users: Optional[List[UserModel3]] = None


class Field38CoordinatorInfo(BaseModel):
    name: Optional[str] = Field(None, description="Name of user")
    direct: Optional[int] = Field(
        None,
        description="If user is coordinator of this account directly or coordinator status was inheirted from a higher account in the tree",
    )


class Field38AssociationShortInfo(BaseModel):
    account: Optional[str] = Field(None, description="Account name")
    cluster: Optional[str] = Field(None, description="Cluster name")
    partition: Optional[str] = Field(None, description="Partition name (optional)")
    user: Optional[str] = Field(None, description="User name")


class AssociationsModel1(BaseModel):
    root: Optional[Field38AssociationShortInfo] = None


class DefaultModel3(BaseModel):
    account: Optional[str] = Field(None, description="Default account name")
    wckey: Optional[str] = Field(None, description="Default wckey")


class Field38User(BaseModel):
    administrator_level: Optional[str] = Field(
        None, description="Description of administrator level"
    )
    associations: Optional[List[Field38AssociationShortInfo]] = Field(
        None, description="Assigned associations"
    )
    coordinators: Optional[List[Field38CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    default: Optional[DefaultModel3] = Field(None, description="Default settings")
    flags: Optional[List[str]] = Field(None, description="List of properties of user")
    name: Optional[str] = Field(None, description="User name")


class DefaultModel4(BaseModel):
    qos: Optional[str] = Field(None, description="Default QOS")


class PerModel9(BaseModel):
    wall_clock: Optional[int] = Field(None, description="Max wallclock per job")


class JobsModel3(BaseModel):
    per: Optional[PerModel9] = Field(None, description="Max jobs per settings")


class PerModel10(BaseModel):
    account: Optional[Account] = Field(None, description="Max per accounting settings")


class PerModel11(BaseModel):
    qos: Optional[int] = Field(None, description="Max wallclock per QOS")
    job: Optional[int] = Field(None, description="Max wallclock per job")


class PerModel12(BaseModel):
    account: Optional[int] = Field(None, description="Max jobs per account")
    user: Optional[int] = Field(None, description="Max jobs per user")


class JobsModel4(BaseModel):
    active_jobs: Optional[ActiveJobs] = Field(
        None, description="Limits on active jobs settings"
    )


class PerModel13(BaseModel):
    account: Optional[int] = Field(
        None, description="Max accuring priority per account"
    )
    user: Optional[int] = Field(None, description="Max accuring priority per user")


class Field38TresListItem(BaseModel):
    type: Optional[str] = Field(None, description="TRES type")
    name: Optional[str] = Field(None, description="TRES name (optional)")
    id: Optional[int] = Field(None, description="database id")
    count: Optional[int] = Field(None, description="count of TRES")


class Field38TresList(BaseModel):
    __root__: Optional[List[Field38TresListItem]] = Field(
        None, description="TRES list of attributes"
    )


class UserModel4(BaseModel):
    seconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in seconds",
    )
    microseconds: Optional[int] = Field(
        None,
        description="Total number of CPU-seconds used by the job in user land, in microseconds",
    )


class TimeModel9(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    eligible: Optional[int] = Field(None, description="Total time eligible to run")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    submission: Optional[int] = Field(
        None, description="Timestamp of when job submitted"
    )
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel4] = Field(None, description="User land time values")
    limit: Optional[int] = Field(None, description="Job wall clock time limit")


class HetModel3(BaseModel):
    job_id: Optional[int] = Field(None, description="Parent HetJob id")
    job_offset: Optional[int] = Field(None, description="Offset of this job to parent")


class TresModel3(BaseModel):
    allocated: Optional[Field38TresList] = None
    requested: Optional[Field38TresList] = None


class Field38JobExitCode(BaseModel):
    status: Optional[str] = Field(None, description="Job exit status")
    return_code: Optional[int] = Field(
        None, description="Return code from parent process"
    )
    signal: Optional[Signal] = Field(None, description="Signal details (if signaled)")


class TimeModel10(BaseModel):
    elapsed: Optional[int] = Field(None, description="Total time elapsed")
    end: Optional[int] = Field(None, description="Timestamp of when job ended")
    start: Optional[int] = Field(None, description="Timestamp of when job started")
    suspended: Optional[int] = Field(
        None, description="Timestamp of when job last suspended"
    )
    system: Optional[System] = Field(None, description="System time values")
    total: Optional[Total] = Field(None, description="System time values")
    user: Optional[UserModel4] = Field(None, description="User land time values")


class CPUModel3(BaseModel):
    requested_frequency: Optional[RequestedFrequency] = Field(
        None, description="CPU frequency requested"
    )
    governor: Optional[List[str]] = Field(None, description="CPU governor")


class CPUModel4(BaseModel):
    actual_frequency: Optional[int] = Field(
        None, description="Actual frequency of CPU during step"
    )


class StatisticsModel3(BaseModel):
    CPU: Optional[CPUModel4] = Field(None, description="Statistics of CPU")
    energy: Optional[Energy] = Field(None, description="Statistics of energy")


class HetModel4(BaseModel):
    component: Optional[int] = Field(None, description="Parent HetJob component id")


class RequestedModel1(BaseModel):
    average: Optional[Field38TresList] = None
    max: Optional[Field38TresList] = None
    min: Optional[Field38TresList] = None
    total: Optional[Field38TresList] = None


class ConsumedModel1(BaseModel):
    average: Optional[Field38TresList] = None
    max: Optional[Field38TresList] = None
    min: Optional[Field38TresList] = None
    total: Optional[Field38TresList] = None


class TresModel4(BaseModel):
    requested: Optional[RequestedModel1] = Field(
        None, description="TRES requested for job"
    )
    consumed: Optional[ConsumedModel1] = Field(
        None, description="TRES requested for job"
    )
    allocated: Optional[Field38TresList] = None


class Field38JobStep(BaseModel):
    time: Optional[TimeModel10] = Field(None, description="Time properties")
    exit_code: Optional[Field38JobExitCode] = None
    nodes: Optional[Nodes] = Field(None, description="Node details")
    tasks: Optional[Tasks] = Field(None, description="Task properties")
    pid: Optional[str] = Field(None, description="First process PID")
    CPU: Optional[CPUModel3] = Field(None, description="CPU properties")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    state: Optional[str] = Field(None, description="State of job step")
    statistics: Optional[StatisticsModel3] = Field(
        None, description="Statistics of job step"
    )
    step: Optional[Step] = Field(None, description="Step details")
    task: Optional[str] = Field(None, description="Task distribution properties")
    tres: Optional[TresModel4] = Field(None, description="TRES usage")


class Field38Error(BaseModel):
    error_number: Optional[int] = Field(None, description="Slurm internal error number")
    error: Optional[str] = Field(None, description="Error message")
    source: Optional[str] = Field(None, description="Where error occured in the source")
    description: Optional[str] = Field(
        None, description="Explaination of cause of error"
    )


class Plugin(BaseModel):
    type: Optional[str] = Field(None, description="")
    name: Optional[str] = Field(None, description="")


class Version(BaseModel):
    major: Optional[str] = Field(None, description="")
    micro: Optional[str] = Field(None, description="")
    minor: Optional[str] = Field(None, description="")


class Slurm(BaseModel):
    version: Optional[Version] = None
    release: Optional[str] = Field(None, description="version specifier")


class Field38Meta(BaseModel):
    plugin: Optional[Plugin] = None
    Slurm: Optional[Slurm] = Field(None, description="Slurm information")


class Field38UpdateUsers(BaseModel):
    users: Optional[List[Field38User]] = None


class Field38TresUpdate(BaseModel):
    tres: Optional[Field38TresList] = None


class Field38Accounting(BaseModel):
    allocated: Optional[int] = Field(None, description="total seconds allocated")
    id: Optional[int] = Field(None, description="association/wckey ID")
    start: Optional[int] = Field(
        None, description="UNIX timestamp when accounting period started"
    )
    TRES: Optional[Field38TresList] = None


class Field36Diag(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    time_start: Optional[int] = Field(None, description="Unix timestamp of start time")
    rollups: Optional[List[Rollup]] = None
    RPCs: Optional[List[RPC]] = None
    users: Optional[List[User]] = None


class Field36Account(BaseModel):
    associations: Optional[List[Field36AssociationShortInfo]] = Field(
        None, description="List of assigned associations"
    )
    coordinators: Optional[List[Field36CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    description: Optional[str] = Field(None, description="Description of account")
    name: Optional[str] = Field(None, description="Name of account")
    organization: Optional[str] = Field(
        None, description="Assigned organization of account"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of account"
    )


class Field36AccountInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    accounts: Optional[List[Field36Account]] = Field(
        None, description="List of accounts"
    )


class Field36ResponseAccountDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseWckeyAdd(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36WckeyInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    wckeys: Optional[List[Field36Wckey]] = Field(None, description="List of wckeys")


class Field36ResponseWckeyDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseClusterAdd(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseClusterDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseUserUpdate(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36UserInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    users: Optional[List[Field36User]] = Field(None, description="Array of users")


class Field36ResponseUserDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseAssociationDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class PerModel14(BaseModel):
    job: Optional[Field36TresList] = None
    node: Optional[Field36TresList] = None


class PerModel15(BaseModel):
    job: Optional[Field36TresList] = None


class Minutes(BaseModel):
    per: Optional[PerModel15] = Field(None, description="Max TRES minutes per settings")
    total: Optional[Field36TresList] = None


class TresModel5(BaseModel):
    per: Optional[PerModel14] = Field(None, description="Max TRES per settings")
    total: Optional[Field36TresList] = None
    minutes: Optional[Minutes] = Field(None, description="Max TRES minutes settings")


class MaxModel(BaseModel):
    jobs: Optional[Jobs] = Field(None, description="Max jobs settings")
    per: Optional[PerModel] = Field(None, description="Max per settings")
    tres: Optional[TresModel5] = Field(None, description="Max TRES settings")


class Field36Association(BaseModel):
    account: Optional[str] = Field(None, description="Assigned account")
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    default: Optional[DefaultModel] = Field(None, description="Default settings")
    flags: Optional[List[str]] = Field(
        None, description="List of properties of association"
    )
    max: Optional[MaxModel] = Field(None, description="Max settings")
    min: Optional[Min] = Field(None, description="Min settings")
    parent_account: Optional[str] = Field(None, description="Parent account name")
    partition: Optional[str] = Field(None, description="Assigned partition")
    priority: Optional[int] = Field(None, description="Assigned priority")
    qos: Optional[List[str]] = Field(None, description="Assigned QOS")
    shares_raw: Optional[int] = Field(None, description="Raw fairshare shares")
    usage: Optional[Usage] = Field(None, description="Association usage")
    user: Optional[str] = Field(None, description="Assigned user")


class Field36AssociationsInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    associations: Optional[List[Field36Association]] = Field(
        None, description="Array of associations"
    )


class PerModel16(BaseModel):
    job: Optional[Field36TresList] = None
    account: Optional[Field36TresList] = None
    user: Optional[Field36TresList] = None


class MinutesModel(BaseModel):
    per: Optional[PerModel16] = Field(None, description="Max TRES minutes per settings")


class PerModel17(BaseModel):
    account: Optional[Field36TresList] = None
    job: Optional[Field36TresList] = None
    node: Optional[Field36TresList] = None
    user: Optional[Field36TresList] = None


class TresModel6(BaseModel):
    minutes: Optional[MinutesModel] = Field(
        None, description="Max TRES minutes settings"
    )
    per: Optional[PerModel17] = Field(None, description="Max TRES per settings")


class MaxModel1(BaseModel):
    wall_clock: Optional[WallClock] = Field(
        None, description="Limit on wallclock settings"
    )
    jobs: Optional[JobsModel] = Field(None, description="Limits on jobs settings")
    accruing: Optional[Accruing] = Field(
        None, description="Limits on accruing priority"
    )
    tres: Optional[TresModel6] = Field(None, description="Limits on TRES")


class PerModel18(BaseModel):
    job: Optional[Field36TresList] = None


class TresModel7(BaseModel):
    per: Optional[PerModel18] = Field(None, description="Min tres per settings")


class MinModel(BaseModel):
    priority_threshold: Optional[int] = Field(
        None, description="Min priority threshold"
    )
    tres: Optional[TresModel7] = Field(None, description="Min tres settings")


class LimitsModel(BaseModel):
    max: Optional[MaxModel1] = Field(None, description="Limits on max settings")
    min: Optional[MinModel] = Field(None, description="Min limit settings")


class Field36Qos(BaseModel):
    description: Optional[str] = Field(None, description="QOS description")
    flags: Optional[List[str]] = Field(None, description="List of properties of QOS")
    id: Optional[str] = Field(None, description="Database id")
    limits: Optional[LimitsModel] = Field(None, description="Assigned limits")
    preempt: Optional[Preempt] = Field(None, description="Preemption settings")
    priority: Optional[int] = Field(None, description="QOS priority")
    usage_factor: Optional[float] = Field(None, description="Usage factor")
    usage_threshold: Optional[float] = Field(None, description="Usage threshold")


class Field36QosInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    qos: Optional[List[Field36Qos]] = Field(None, description="Array of QOS")


class Field36ResponseQosDelete(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ResponseTres(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36TresInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    tres: Optional[List[Field36TresList]] = Field(None, description="Array of tres")


class Field36Job(BaseModel):
    account: Optional[str] = Field(None, description="Account charged by job")
    comment: Optional[Comment] = Field(None, description="Job comments by type")
    allocation_nodes: Optional[str] = Field(None, description="Nodes allocated to job")
    array: Optional[Array] = Field(None, description="Array properties (optional)")
    time: Optional[TimeModel1] = Field(None, description="Time properties")
    association: Optional[Field36AssociationShortInfo] = None
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    constraints: Optional[str] = Field(None, description="Constraints on job")
    derived_exit_code: Optional[Field36JobExitCode] = None
    exit_code: Optional[Field36JobExitCode] = None
    flags: Optional[List[str]] = Field(None, description="List of properties of job")
    group: Optional[str] = Field(None, description="User's group to run job")
    het: Optional[Het] = Field(None, description="Heterogeneous Job details (optional)")
    job_id: Optional[int] = Field(None, description="Job id")
    name: Optional[str] = Field(None, description="Assigned job name")
    mcs: Optional[Mcs] = Field(None, description="Multi-Category Security")
    nodes: Optional[str] = Field(None, description="List of nodes allocated for job")
    partition: Optional[str] = Field(None, description="Assigned job's partition")
    priority: Optional[int] = Field(None, description="Priority")
    qos: Optional[str] = Field(None, description="Assigned qos name")
    required: Optional[Required] = Field(None, description="Job run requirements")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    reservation: Optional[Reservation] = Field(
        None, description="Reservation usage details"
    )
    state: Optional[State] = Field(None, description="State properties of job")
    steps: Optional[List[Field36JobStep]] = Field(
        None, description="Job step description"
    )
    tres: Optional[Tres] = Field(None, description="TRES settings")
    user: Optional[str] = Field(None, description="Job user")
    wckey: Optional[Wckey] = Field(None, description="Job assigned wckey details")
    working_directory: Optional[str] = Field(
        None, description="Directory where job was initially started"
    )


class Field36ConfigInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    tres: Optional[List[Field36TresList]] = Field(None, description="Array of TRES")
    accounts: Optional[List[Field36Account]] = Field(
        None, description="Array of accounts"
    )
    associations: Optional[List[Field36Association]] = Field(
        None, description="Array of associations"
    )
    users: Optional[List[Field36User]] = Field(None, description="Array of users")
    qos: Optional[List[Field36Qos]] = Field(None, description="Array of qos")
    wckeys: Optional[List[Field36Wckey]] = Field(None, description="Array of wckeys")


class Field36AccountResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field36ConfigResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")


class Field37Diag(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    statistics: Optional[StatisticsModel] = Field(
        None, description="dictionary of Slurmdb statistics"
    )


class Field37Account(BaseModel):
    associations: Optional[List[Field37AssociationShortInfo]] = Field(
        None, description="List of assigned associations"
    )
    coordinators: Optional[List[Field37CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    description: Optional[str] = Field(None, description="Description of account")
    name: Optional[str] = Field(None, description="Name of account")
    organization: Optional[str] = Field(
        None, description="Assigned organization of account"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of account"
    )


class Field37AccountInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    accounts: Optional[List[Field37Account]] = Field(
        None, description="List of accounts"
    )


class Field37ResponseAccountDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseWckeyAdd(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37WckeyInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    wckeys: Optional[List[Field37Wckey]] = Field(None, description="List of wckeys")


class Field37ResponseWckeyDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseClusterAdd(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseClusterDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseUserUpdate(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37UserInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    users: Optional[List[Field37User]] = Field(None, description="Array of users")


class Field37ResponseUserDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseAssociationDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Group(BaseModel):
    minutes: Optional[Field37TresList] = None
    active: Optional[Field37TresList] = None


class PerModel19(BaseModel):
    job: Optional[Field37TresList] = None
    node: Optional[Field37TresList] = None


class PerModel20(BaseModel):
    job: Optional[Field37TresList] = None


class MinutesModel1(BaseModel):
    per: Optional[PerModel20] = Field(None, description="Max TRES minutes per settings")
    total: Optional[Field37TresList] = None


class TresModel8(BaseModel):
    group: Optional[Group] = Field(None, description="Max TRES per group")
    per: Optional[PerModel19] = Field(None, description="Max TRES per settings")
    total: Optional[Field37TresList] = None
    minutes: Optional[MinutesModel1] = Field(
        None, description="Max TRES minutes settings"
    )


class MaxModel2(BaseModel):
    jobs: Optional[JobsModel1] = Field(None, description="Max jobs settings")
    per: Optional[PerModel5] = Field(None, description="Max per settings")
    tres: Optional[TresModel8] = Field(None, description="Max TRES settings")


class Field37Association(BaseModel):
    is_default: Optional[int] = Field(None, description="is default association")
    account: Optional[str] = Field(None, description="Assigned account")
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    default: Optional[DefaultModel2] = Field(None, description="Default settings")
    flags: Optional[List[str]] = Field(
        None, description="List of properties of association"
    )
    max: Optional[MaxModel2] = Field(None, description="Max settings")
    min: Optional[Min] = Field(None, description="Min settings")
    parent_account: Optional[str] = Field(None, description="Parent account name")
    partition: Optional[str] = Field(None, description="Assigned partition")
    priority: Optional[int] = Field(None, description="Assigned priority")
    qos: Optional[List[str]] = Field(None, description="Assigned QOS")
    shares_raw: Optional[int] = Field(None, description="Raw fairshare shares")
    usage: Optional[Usage] = Field(None, description="Association usage")
    user: Optional[str] = Field(None, description="Assigned user")


class Field37AssociationsInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    associations: Optional[List[Field37Association]] = Field(
        None, description="Array of associations"
    )


class PerModel21(BaseModel):
    job: Optional[Field37TresList] = None
    account: Optional[Field37TresList] = None
    user: Optional[Field37TresList] = None


class MinutesModel2(BaseModel):
    per: Optional[PerModel21] = Field(None, description="Max TRES minutes per settings")


class PerModel22(BaseModel):
    account: Optional[Field37TresList] = None
    job: Optional[Field37TresList] = None
    node: Optional[Field37TresList] = None
    user: Optional[Field37TresList] = None


class TresModel9(BaseModel):
    minutes: Optional[MinutesModel2] = Field(
        None, description="Max TRES minutes settings"
    )
    per: Optional[PerModel22] = Field(None, description="Max TRES per settings")


class MaxModel3(BaseModel):
    wall_clock: Optional[WallClock] = Field(
        None, description="Limit on wallclock settings"
    )
    jobs: Optional[JobsModel2] = Field(None, description="Limits on jobs settings")
    accruing: Optional[Accruing] = Field(
        None, description="Limits on accruing priority"
    )
    tres: Optional[TresModel9] = Field(None, description="Limits on TRES")


class PerModel23(BaseModel):
    job: Optional[Field37TresList] = None


class TresModel10(BaseModel):
    per: Optional[PerModel23] = Field(None, description="Min tres per settings")


class LimitsModel1(BaseModel):
    factor: Optional[float] = Field(
        None,
        description="factor to apply to TRES count for associations using this QOS",
    )
    max: Optional[MaxModel3] = Field(None, description="Limits on max settings")
    min: Optional[MinModel] = Field(None, description="Min limit settings")


class Field37Qos(BaseModel):
    description: Optional[str] = Field(None, description="QOS description")
    flags: Optional[List[str]] = Field(None, description="List of properties of QOS")
    id: Optional[str] = Field(None, description="Database id")
    limits: Optional[LimitsModel1] = Field(None, description="Assigned limits")
    preempt: Optional[Preempt] = Field(None, description="Preemption settings")
    priority: Optional[int] = Field(None, description="QOS priority")
    usage_factor: Optional[float] = Field(None, description="Usage factor")
    usage_threshold: Optional[float] = Field(None, description="Usage threshold")


class Field37QosInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    qos: Optional[List[Field37Qos]] = Field(None, description="Array of QOS")


class Field37ResponseQosDelete(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseAssociations(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ResponseTres(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37TresInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    tres: Optional[List[Field37TresList]] = Field(None, description="Array of tres")


class Field37Job(BaseModel):
    account: Optional[str] = Field(None, description="Account charged by job")
    comment: Optional[Comment] = Field(None, description="Job comments by type")
    allocation_nodes: Optional[str] = Field(None, description="Nodes allocated to job")
    array: Optional[Array] = Field(None, description="Array properties (optional)")
    time: Optional[TimeModel5] = Field(None, description="Time properties")
    association: Optional[Field37AssociationShortInfo] = None
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    constraints: Optional[str] = Field(None, description="Constraints on job")
    derived_exit_code: Optional[Field37JobExitCode] = None
    exit_code: Optional[Field37JobExitCode] = None
    flags: Optional[List[str]] = Field(None, description="List of properties of job")
    group: Optional[str] = Field(None, description="User's group to run job")
    het: Optional[HetModel1] = Field(
        None, description="Heterogeneous Job details (optional)"
    )
    job_id: Optional[int] = Field(None, description="Job id")
    name: Optional[str] = Field(None, description="Assigned job name")
    mcs: Optional[Mcs] = Field(None, description="Multi-Category Security")
    nodes: Optional[str] = Field(None, description="List of nodes allocated for job")
    partition: Optional[str] = Field(None, description="Assigned job's partition")
    priority: Optional[int] = Field(None, description="Priority")
    qos: Optional[str] = Field(None, description="Assigned qos name")
    required: Optional[Required] = Field(None, description="Job run requirements")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    reservation: Optional[Reservation] = Field(
        None, description="Reservation usage details"
    )
    state: Optional[StateModel] = Field(None, description="State properties of job")
    steps: Optional[List[Field37JobStep]] = Field(
        None, description="Job step description"
    )
    tres: Optional[TresModel1] = Field(None, description="TRES settings")
    user: Optional[str] = Field(None, description="Job user")
    wckey: Optional[Wckey] = Field(None, description="Job assigned wckey details")
    working_directory: Optional[str] = Field(
        None, description="Directory where job was initially started"
    )


class Field37ConfigInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    tres: Optional[List[Field37TresList]] = Field(None, description="Array of TRES")
    accounts: Optional[List[Field37Account]] = Field(
        None, description="Array of accounts"
    )
    associations: Optional[List[Field37Association]] = Field(
        None, description="Array of associations"
    )
    users: Optional[List[Field37User]] = Field(None, description="Array of users")
    qos: Optional[List[Field37Qos]] = Field(None, description="Array of qos")
    wckeys: Optional[List[Field37Wckey]] = Field(None, description="Array of wckeys")


class Field37AccountResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field37ConfigResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")


class Field38Diag(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    statistics: Optional[StatisticsModel2] = None


class Field38Account(BaseModel):
    associations: Optional[List[Field38AssociationShortInfo]] = Field(
        None, description="List of assigned associations"
    )
    coordinators: Optional[List[Field38CoordinatorInfo]] = Field(
        None, description="List of assigned coordinators"
    )
    description: Optional[str] = Field(None, description="Description of account")
    name: Optional[str] = Field(None, description="Name of account")
    organization: Optional[str] = Field(
        None, description="Assigned organization of account"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of account"
    )


class Field38AccountInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    accounts: Optional[List[Field38Account]] = Field(
        None, description="List of accounts"
    )


class Field38ResponseAccountDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseWckeyAdd(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38Wckey(BaseModel):
    cluster: Optional[str] = Field(None, description="Cluster name")
    id: Optional[int] = Field(None, description="wckey database unique id")
    name: Optional[str] = Field(None, description="wckey name")
    user: Optional[str] = Field(None, description="wckey user")
    flags: Optional[List[str]] = Field(None, description="List of properties of wckey")
    accounting: Optional[List[Field38Accounting]] = Field(
        None, description="List of accounting records"
    )


class Field38ResponseWckeyDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseClusterAdd(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseClusterDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseUserUpdate(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38UserInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    users: Optional[List[Field38User]] = Field(None, description="Array of users")


class Field38ResponseUserDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class PerModel24(BaseModel):
    job: Optional[Field38TresList] = None
    node: Optional[Field38TresList] = None


class PerModel25(BaseModel):
    job: Optional[Field38TresList] = None


class MinutesModel3(BaseModel):
    per: Optional[PerModel25] = Field(None, description="Max TRES minutes per settings")
    total: Optional[Field38TresList] = None


class TresModel11(BaseModel):
    per: Optional[PerModel24] = Field(None, description="Max TRES per settings")
    total: Optional[Field38TresList] = None
    minutes: Optional[MinutesModel3] = Field(
        None, description="Max TRES minutes settings"
    )


class MaxModel4(BaseModel):
    jobs: Optional[JobsModel3] = Field(None, description="Max jobs settings")
    per: Optional[PerModel10] = Field(None, description="Max per settings")
    tres: Optional[TresModel11] = Field(None, description="Max TRES settings")


class Field38Association(BaseModel):
    account: Optional[str] = Field(None, description="Assigned account")
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    default: Optional[DefaultModel4] = Field(None, description="Default settings")
    flags: Optional[List[str]] = Field(
        None, description="List of properties of association"
    )
    max: Optional[MaxModel4] = Field(None, description="Max settings")
    min: Optional[Min] = Field(None, description="Min settings")
    parent_account: Optional[str] = Field(None, description="Parent account name")
    partition: Optional[str] = Field(None, description="Assigned partition")
    priority: Optional[int] = Field(None, description="Assigned priority")
    shares_raw: Optional[int] = Field(None, description="Raw fairshare shares")
    usage: Optional[Usage] = Field(None, description="Association usage")
    user: Optional[str] = Field(None, description="Assigned user")
    QOS: Optional[List[str]] = Field(None, description="Assigned QOS")


class Field38AssociationsInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    associations: Optional[List[Field38Association]] = Field(
        None, description="Array of associations"
    )


class PerModel26(BaseModel):
    job: Optional[Field38TresList] = None
    account: Optional[Field38TresList] = None
    user: Optional[Field38TresList] = None
    qos: Optional[Field38TresList] = None


class MinutesModel4(BaseModel):
    per: Optional[PerModel26] = Field(None, description="Max TRES minutes per settings")


class PerModel27(BaseModel):
    account: Optional[Field38TresList] = None
    job: Optional[Field38TresList] = None
    node: Optional[Field38TresList] = None
    user: Optional[Field38TresList] = None


class TresModel12(BaseModel):
    minutes: Optional[MinutesModel4] = Field(
        None, description="Max TRES minutes settings"
    )
    per: Optional[PerModel27] = Field(None, description="Max TRES per settings")


class MaxModel5(BaseModel):
    wall_clock: Optional[WallClock] = Field(
        None, description="Limit on wallclock settings"
    )
    jobs: Optional[JobsModel4] = Field(None, description="Limits on jobs settings")
    accruing: Optional[Accruing] = Field(
        None, description="Limits on accruing priority"
    )
    tres: Optional[TresModel12] = Field(None, description="Limits on TRES")


class PerModel28(BaseModel):
    job: Optional[Field38TresList] = None


class TresModel13(BaseModel):
    per: Optional[PerModel28] = Field(None, description="Min tres per settings")


class Field38Qos(BaseModel):
    description: Optional[str] = Field(None, description="QOS description")
    flags: Optional[List[str]] = Field(None, description="List of properties of QOS")
    id: Optional[str] = Field(None, description="Database id")
    limits: Optional[LimitsModel1] = Field(None, description="Assigned limits")
    preempt: Optional[Preempt] = Field(None, description="Preemption settings")
    priority: Optional[int] = Field(None, description="QOS priority")
    usage_factor: Optional[float] = Field(None, description="Usage factor")
    usage_threshold: Optional[float] = Field(None, description="Usage threshold")
    name: Optional[str] = Field(None, description="Assigned name of QOS")


class Field38QosInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    qos: Optional[List[Field38Qos]] = Field(None, description="Array of QOS")


class Field38ResponseQos(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseQosDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseAssociations(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ResponseTres(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38TresInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    tres: Optional[Field38TresList] = None


class Field38Job(BaseModel):
    account: Optional[str] = Field(None, description="Account charged by job")
    comment: Optional[Comment] = Field(None, description="Job comments by type")
    allocation_nodes: Optional[str] = Field(None, description="Nodes allocated to job")
    array: Optional[Array] = Field(None, description="Array properties (optional)")
    time: Optional[TimeModel9] = Field(None, description="Time properties")
    association: Optional[Field38AssociationShortInfo] = None
    cluster: Optional[str] = Field(None, description="Assigned cluster")
    constraints: Optional[str] = Field(None, description="Constraints on job")
    derived_exit_code: Optional[Field38JobExitCode] = None
    exit_code: Optional[Field38JobExitCode] = None
    flags: Optional[List[str]] = Field(None, description="List of properties of job")
    group: Optional[str] = Field(None, description="User's group to run job")
    het: Optional[HetModel3] = Field(
        None, description="Heterogeneous Job details (optional)"
    )
    job_id: Optional[int] = Field(None, description="Job id")
    name: Optional[str] = Field(None, description="Assigned job name")
    mcs: Optional[Mcs] = Field(None, description="Multi-Category Security")
    nodes: Optional[str] = Field(None, description="List of nodes allocated for job")
    partition: Optional[str] = Field(None, description="Assigned job's partition")
    priority: Optional[int] = Field(None, description="Priority")
    qos: Optional[str] = Field(None, description="Assigned qos name")
    required: Optional[Required] = Field(None, description="Job run requirements")
    kill_request_user: Optional[str] = Field(
        None, description="User who requested job killed"
    )
    reservation: Optional[Reservation] = Field(
        None, description="Reservation usage details"
    )
    state: Optional[StateModel] = Field(None, description="State properties of job")
    steps: Optional[List[Field38JobStep]] = Field(
        None, description="Job step description"
    )
    tres: Optional[TresModel3] = Field(None, description="TRES settings")
    user: Optional[str] = Field(None, description="Job user")
    wckey: Optional[Wckey] = Field(None, description="Job assigned wckey details")
    working_directory: Optional[str] = Field(
        None, description="Directory where job was initially started"
    )
    container: Optional[str] = Field(
        None, description="absolute path to OCI container bundle"
    )


class Field38ConfigInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    tres: Optional[List[Field38TresList]] = Field(None, description="Array of TRES")
    accounts: Optional[List[Field38Account]] = Field(
        None, description="Array of accounts"
    )
    associations: Optional[List[Field38Association]] = Field(
        None, description="Array of associations"
    )
    users: Optional[List[Field38User]] = Field(None, description="Array of users")
    qos: Optional[List[Field38Qos]] = Field(None, description="Array of qos")
    wckeys: Optional[List[Field38Wckey]] = Field(None, description="Array of wckeys")


class Field38AccountResponse(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38ConfigResponse(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38Errors(BaseModel):
    __root__: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38UpdateQos(BaseModel):
    qos: Optional[List[Field38Qos]] = None


class Field38UpdateAccount(BaseModel):
    accounts: Optional[List[Field38Account]] = None


class Field38ResponseAssociationsDelete(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    removed_associations: Optional[List[str]] = Field(
        None, description="the associations"
    )


class Field36ClusterInfo(BaseModel):
    controller: Optional[Controller] = Field(
        None, description="Information about controller"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of cluster"
    )
    name: Optional[str] = Field(None, description="Cluster name")
    nodes: Optional[str] = Field(None, description="Assigned nodes")
    select_plugin: Optional[str] = Field(None, description="Configured select plugin")
    associations: Optional[Associations] = Field(
        None, description="Information about associations"
    )
    rpc_version: Optional[int] = Field(None, description="Number rpc version")
    tres: Optional[List[Field36ResponseTres]] = Field(
        None, description="List of TRES in cluster"
    )


class Field36JobInfo(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="Slurm errors")
    jobs: Optional[List[Field36Job]] = Field(None, description="Array of jobs")


class Field37ClusterInfo(BaseModel):
    controller: Optional[Controller] = Field(
        None, description="Information about controller"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of cluster"
    )
    name: Optional[str] = Field(None, description="Cluster name")
    nodes: Optional[str] = Field(None, description="Assigned nodes")
    select_plugin: Optional[str] = Field(None, description="Configured select plugin")
    associations: Optional[AssociationsModel] = Field(
        None, description="Information about associations"
    )
    rpc_version: Optional[int] = Field(None, description="Number rpc version")
    tres: Optional[List[Field37ResponseTres]] = Field(
        None, description="List of TRES in cluster"
    )


class Field37JobInfo(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="Slurm errors")
    jobs: Optional[List[Field37Job]] = Field(None, description="Array of jobs")


class Field38WckeyInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    wckeys: Optional[List[Field38Wckey]] = Field(None, description="List of wckeys")


class Field38ClusterInfo(BaseModel):
    controller: Optional[Controller] = Field(
        None, description="Information about controller"
    )
    flags: Optional[List[str]] = Field(
        None, description="List of properties of cluster"
    )
    name: Optional[str] = Field(None, description="Cluster name")
    nodes: Optional[str] = Field(None, description="Assigned nodes")
    select_plugin: Optional[str] = Field(None, description="Configured select plugin")
    associations: Optional[AssociationsModel1] = Field(
        None, description="Information about associations"
    )
    rpc_version: Optional[int] = Field(None, description="Number rpc version")
    tres: Optional[List[Field38ResponseTres]] = Field(
        None, description="List of TRES in cluster"
    )


class Field38JobInfo(BaseModel):
    meta: Optional[field_0.Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="Slurm errors")
    jobs: Optional[List[Field38Job]] = Field(None, description="Array of jobs")


class Field38ClustersProperties(BaseModel):
    clusters: Optional[Field38ClusterInfo] = None


class Field38SetConfig(BaseModel):
    clusters: Optional[List[Field38ClustersProperties]] = None
    TRES: Optional[List[Field38TresList]] = None
    accounts: Optional[List[Field38UpdateAccount]] = None
    users: Optional[List[Field38User]] = None
    qos: Optional[List[Field38Qos]] = None
    wckeys: Optional[List[Field38Wckey]] = None
    associations: Optional[List[Field38Association]] = None
