import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
/**
 * Metrics on the rate limiting performed on state machine execution.
 *
 * These rate limits are shared across all state machines.
 *
 * @stability stable
 */
export declare class StateTransitionMetric {
    /**
     * Return the given named metric for the service's state transition metrics.
     *
     * @default average over 5 minutes
     * @stability stable
     */
    static metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the number of available state transitions.
     *
     * @default average over 5 minutes
     * @stability stable
     */
    static metricProvisionedBucketSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the provisioned steady-state execution rate.
     *
     * @default average over 5 minutes
     * @stability stable
     */
    static metricProvisionedRefillRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the number of available state transitions per second.
     *
     * @default average over 5 minutes
     * @stability stable
     */
    static metricConsumedCapacity(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the number of throttled state transitions.
     *
     * @default sum over 5 minutes
     * @stability stable
     */
    static metricThrottledEvents(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
