# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['monipy', 'monipy.templates']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=2.11.3,<3.0.0',
 'fastapi>=0.63.0,<0.64.0',
 'loguru>=0.5.3,<0.6.0',
 'natsort>=7.1.1,<8.0.0',
 'palettable>=3.3.0,<4.0.0',
 'pandas>=1.2.4,<2.0.0',
 'rrdtool>=0.1.15,<0.2.0',
 'uvicorn>=0.13.4,<0.14.0']

entry_points = \
{'console_scripts': ['monipy = monipy:main']}

setup_kwargs = {
    'name': 'monipy',
    'version': '0.1.0',
    'description': 'Web-dashboard for resource monitoring data.',
    'long_description': '# monipy\n\n[![PyPI](https://img.shields.io/pypi/v/monipy.svg?style=flat)](https://pypi.python.org/pypi/monipy)\n[![Tests](https://github.com/kpj/monipy/workflows/Tests/badge.svg)](https://github.com/kpj/monipy/actions)\n\nThis project aims to be a modern, robust and easy-to-use web-based visualization for system resource monitoring data (e.g., generated by [collectd](https://collectd.org/)).\nIt was born when I was looking for a visualization solution which is more sophisticated than [collectd2html](https://github.com/collectd/collectd/blob/main/contrib/collectd2html.pl) but less complex than a full-blown [Graphite](https://github.com/graphite-project)/[Grafana](https://github.com/grafana/grafana) installation. At the same time I wanted a modern interface, non-outdated implementation and easy setup.\nAfter scouring through [the web](https://collectd.org/wiki/index.php/List_of_front-ends) and not finding anything to fulfil my desires, I did what any reasonable person (/s) would have done and decided to create [my own solution](https://xkcd.com/927/). Should I have spend more time checking [the many other alternatives](https://wiki.archlinux.org/index.php/TICK_stack)? Absolutely yes, yet here we are.\n\n\n## Installation\n\n```python\n$ pip install monipy\n```\n\n\n## Usage\n\nJust run\n\n```bash\n$ monipy\n```\n\n\n## Misc\n\nhttps://www.gitmemory.com/issue/oetiker/rrdtool-1.x/1042/522564694\n\nfind . -name "*.rrd" -exec rrdtool dump {} {}.xml \\;\nfind . -name "*.xml" -execdir bash -c \'rrdtool restore -f "${@}" "${@%.*}"\' bash {} \\;\n',
    'author': 'kpj',
    'author_email': 'kim.philipp.jablonski@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kpj/monipy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
