# monipy

[![PyPI](https://img.shields.io/pypi/v/monipy.svg?style=flat)](https://pypi.python.org/pypi/monipy)
[![Tests](https://github.com/kpj/monipy/workflows/Tests/badge.svg)](https://github.com/kpj/monipy/actions)

This project aims to be a modern, robust and easy-to-use web-based visualization for system resource monitoring data (e.g., generated by [collectd](https://collectd.org/)).
It was born when I was looking for a visualization solution which is more sophisticated than [collectd2html](https://github.com/collectd/collectd/blob/main/contrib/collectd2html.pl) but less complex than a full-blown [Graphite](https://github.com/graphite-project)/[Grafana](https://github.com/grafana/grafana) installation. At the same time I wanted a modern interface, non-outdated implementation and easy setup.
After scouring through [the web](https://collectd.org/wiki/index.php/List_of_front-ends) and not finding anything to fulfil my desires, I did what any reasonable person (/s) would have done and decided to create [my own solution](https://xkcd.com/927/). Should I have spend more time checking [the many other alternatives](https://wiki.archlinux.org/index.php/TICK_stack)? Absolutely yes, yet here we are.


## Installation

```python
$ pip install monipy
```


## Usage

Just run

```bash
$ monipy
```


## Misc

https://www.gitmemory.com/issue/oetiker/rrdtool-1.x/1042/522564694

find . -name "*.rrd" -exec rrdtool dump {} {}.xml \;
find . -name "*.xml" -execdir bash -c 'rrdtool restore -f "${@}" "${@%.*}"' bash {} \;
