"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/**
 * @experimental
 */
class GithubWorkflow extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, name) {
        super(github.project);
        this.events = {};
        this.jobs = {};
        this.name = name;
        this.file = new yaml_1.YamlFile(this.project, `.github/workflows/${name.toLocaleLowerCase()}.yml`, {
            obj: () => this.renderWorkflow(),
        });
    }
    /**
     * @experimental
     */
    on(events) {
        this.events = {
            ...this.events,
            ...events,
        };
    }
    /**
     * @experimental
     */
    addJobs(jobs) {
        this.jobs = {
            ...this.jobs,
            ...jobs,
        };
    }
    renderWorkflow() {
        return {
            name: this.name,
            on: this.events,
            jobs: this.jobs,
        };
    }
}
exports.GithubWorkflow = GithubWorkflow;
_a = JSII_RTTI_SYMBOL_1;
GithubWorkflow[_a] = { fqn: "projen.github.GithubWorkflow", version: "0.17.95" };
//# sourceMappingURL=data:application/json;base64,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