#
# Copyright (c) 2023 Airbyte, Inc., all rights reserved.
#


import sgqlc.types
import sgqlc.types.datetime
import sgqlc.types.relay

shopify_schema = sgqlc.types.Schema()


# Unexport Node/PageInfo, let schema re-declare them
shopify_schema -= sgqlc.types.relay.Node
shopify_schema -= sgqlc.types.relay.PageInfo


########################################################################
# Scalars and Enumerations
########################################################################
class ARN(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class AbandonmentAbandonmentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BROWSE", "CART", "CHECKOUT")


class AbandonmentDeliveryState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NOT_SENT", "SCHEDULED", "SENT")


class AbandonmentEmailState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NOT_SENT", "SCHEDULED", "SENT")


class AbandonmentEmailStateUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ABANDONMENT_NOT_FOUND",)


class AbandonmentUpdateActivitiesDeliveryStatusesUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ABANDONMENT_NOT_FOUND", "DELIVERY_STATUS_INFO_NOT_FOUND", "MARKETING_ACTIVITY_NOT_FOUND")


class AppDeveloperType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MERCHANT", "PARTNER", "SHOPIFY", "UNKNOWN")


class AppInstallationCategory(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CHANNEL", "POS_EMBEDDED")


class AppInstallationPrivacy(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PRIVATE", "PUBLIC")


class AppInstallationSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("APP_TITLE", "ID", "INSTALLED_AT", "RELEVANCE")


class AppPricingInterval(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ANNUAL", "EVERY_30_DAYS")


class AppPublicCategory(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CUSTOM", "OTHER", "PRIVATE", "PUBLIC")


class AppPurchaseStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "DECLINED", "EXPIRED", "PENDING")


class AppRevenueAttributionRecordCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "TAKEN")


class AppRevenueAttributionRecordDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID",)


class AppRevenueAttributionRecordSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class AppRevenueAttributionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("APPLICATION_PURCHASE", "APPLICATION_SUBSCRIPTION", "APPLICATION_USAGE", "OTHER")


class AppSubscriptionReplacementBehavior(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("APPLY_IMMEDIATELY", "APPLY_ON_NEXT_BILLING_CYCLE", "STANDARD")


class AppSubscriptionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class AppSubscriptionStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "CANCELLED", "DECLINED", "EXPIRED", "FROZEN", "PENDING")


class AppSubscriptionTrialExtendUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("SUBSCRIPTION_NOT_ACTIVE", "SUBSCRIPTION_NOT_FOUND", "TRIAL_NOT_ACTIVE")


class AppTransactionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class AppUsageRecordSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class AutomaticDiscountSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class BadgeType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ATTENTION", "DEFAULT", "INFO", "SUCCESS", "WARNING")


class BillingAttemptUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "CONTRACT_NOT_FOUND",
        "CYCLE_INDEX_OUT_OF_RANGE",
        "CYCLE_START_DATE_OUT_OF_RANGE",
        "INVALID",
        "ORIGIN_TIME_BEFORE_CONTRACT_CREATION",
        "ORIGIN_TIME_OUT_OF_RANGE",
        "UPCOMING_CYCLE_LIMIT_EXCEEDED",
    )


Boolean = sgqlc.types.Boolean


class BulkMutationErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INTERNAL_FILE_SERVER_ERROR", "INVALID_MUTATION", "INVALID_STAGED_UPLOAD_FILE", "NO_SUCH_FILE", "OPERATION_IN_PROGRESS")


class BulkOperationErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACCESS_DENIED", "INTERNAL_SERVER_ERROR", "TIMEOUT")


class BulkOperationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELED", "CANCELING", "COMPLETED", "CREATED", "EXPIRED", "FAILED", "RUNNING")


class BulkOperationType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MUTATION", "QUERY")


class BulkProductResourceFeedbackCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "INVALID",
        "LESS_THAN_OR_EQUAL_TO",
        "MAXIMUM_FEEDBACK_LIMIT_EXCEEDED",
        "OUTDATED_FEEDBACK",
        "PRESENT",
        "PRODUCT_NOT_FOUND",
    )


class BusinessCustomerErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "FAILED_TO_DELETE",
        "INTERNAL_ERROR",
        "INVALID",
        "INVALID_INPUT",
        "LIMIT_REACHED",
        "NO_INPUT",
        "REQUIRED",
        "RESOURCE_NOT_FOUND",
        "TAKEN",
        "TOO_LONG",
        "UNEXPECTED_TYPE",
    )


class CartTransformCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FUNCTION_ALREADY_REGISTERED", "FUNCTION_DOES_NOT_IMPLEMENT", "FUNCTION_NOT_FOUND", "INPUT_INVALID")


class CartTransformDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NOT_FOUND", "UNAUTHORIZED_APP_SCOPE")


class CatalogSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "RELEVANCE", "TITLE")


class CatalogStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "ARCHIVED", "DRAFT")


class CatalogType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("APP", "COMPANY_LOCATION", "MARKET", "NONE")


class CatalogUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_CATALOG_PRICE_LIST_ASSIGNMENT",
        "BLANK",
        "CANNOT_ADD_MORE_THAN_ONE_MARKET",
        "CANNOT_CREATE_APP_CATALOG",
        "CANNOT_CREATE_MARKET_CATALOG",
        "CANNOT_DELETE_APP_CATALOG",
        "CANNOT_DELETE_MARKET_CATALOG",
        "CANNOT_MODIFY_APP_CATALOG",
        "CANNOT_MODIFY_MARKET_CATALOG",
        "CATALOG_CONTEXT_DOES_NOT_SUPPORT_QUANTITY_RULES",
        "CATALOG_FAILED_TO_SAVE",
        "CATALOG_NOT_FOUND",
        "COMPANY_LOCATION_CATALOG_STATUS_PLAN",
        "COMPANY_LOCATION_NOT_FOUND",
        "CONTEXT_ALREADY_ASSIGNED_TO_CATALOG",
        "CONTEXT_CATALOG_LIMIT_REACHED",
        "CONTEXT_DRIVER_MISMATCH",
        "COUNTRY_PRICE_LIST_ASSIGNMENT",
        "INVALID",
        "INVALID_CATALOG_CONTEXT_TYPE",
        "MARKET_AND_PRICE_LIST_CURRENCY_MISMATCH",
        "MARKET_CATALOG_STATUS",
        "MARKET_NOT_FOUND",
        "MARKET_TAKEN",
        "MUST_PROVIDE_EXACTLY_ONE_CONTEXT_TYPE",
        "PRICE_LIST_FAILED_TO_SAVE",
        "PRICE_LIST_LOCKED",
        "PRICE_LIST_NOT_ALLOWED_FOR_PRIMARY_MARKET",
        "PRICE_LIST_NOT_FOUND",
        "PUBLICATION_NOT_FOUND",
        "REQUIRES_CONTEXTS_TO_ADD_OR_REMOVE",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNSUPPORTED_CATALOG_ACTION",
    )


class CheckoutProfileSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "EDITED_AT", "ID", "IS_PUBLISHED", "RELEVANCE", "UPDATED_AT")


class CodeDiscountSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ENDS_AT", "ID", "RELEVANCE", "STARTS_AT", "TITLE", "UPDATED_AT")


class CollectionAddProductsV2UserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANT_ADD_TO_SMART_COLLECTION", "COLLECTION_DOES_NOT_EXIST")


class CollectionRuleColumn(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "IS_PRICE_REDUCED",
        "PRODUCT_METAFIELD_DEFINITION",
        "PRODUCT_TAXONOMY_NODE_ID",
        "TAG",
        "TITLE",
        "TYPE",
        "VARIANT_COMPARE_AT_PRICE",
        "VARIANT_INVENTORY",
        "VARIANT_METAFIELD_DEFINITION",
        "VARIANT_PRICE",
        "VARIANT_TITLE",
        "VARIANT_WEIGHT",
        "VENDOR",
    )


class CollectionRuleRelation(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CONTAINS",
        "ENDS_WITH",
        "EQUALS",
        "GREATER_THAN",
        "IS_NOT_SET",
        "IS_SET",
        "LESS_THAN",
        "NOT_CONTAINS",
        "NOT_EQUALS",
        "STARTS_WITH",
    )


class CollectionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "RELEVANCE", "TITLE", "UPDATED_AT")


class CollectionSortOrder(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALPHA_ASC", "ALPHA_DESC", "BEST_SELLING", "CREATED", "CREATED_DESC", "MANUAL", "PRICE_ASC", "PRICE_DESC")


class CompanyAddressType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BILLING", "SHIPPING")


class CompanyContactRoleAssignmentSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "LOCATION_NAME", "RELEVANCE", "UPDATED_AT")


class CompanyContactRoleSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE", "UPDATED_AT")


class CompanyContactSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COMPANY_ID", "CREATED_AT", "EMAIL", "ID", "NAME", "NAME_EMAIL", "RELEVANCE", "TITLE", "UPDATED_AT")


class CompanyLocationSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COMPANY_AND_LOCATION_NAME", "COMPANY_ID", "CREATED_AT", "ID", "NAME", "RELEVANCE", "UPDATED_AT")


class CompanySortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "NAME", "ORDER_COUNT", "RELEVANCE", "SINCE_DATE", "TOTAL_SPENT", "UPDATED_AT")


class CountryCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "AM",
        "AN",
        "AO",
        "AR",
        "AT",
        "AU",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BB",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BQ",
        "BR",
        "BS",
        "BT",
        "BV",
        "BW",
        "BY",
        "BZ",
        "CA",
        "CC",
        "CD",
        "CF",
        "CG",
        "CH",
        "CI",
        "CK",
        "CL",
        "CM",
        "CN",
        "CO",
        "CR",
        "CU",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DE",
        "DJ",
        "DK",
        "DM",
        "DO",
        "DZ",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ES",
        "ET",
        "FI",
        "FJ",
        "FK",
        "FO",
        "FR",
        "GA",
        "GB",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GS",
        "GT",
        "GW",
        "GY",
        "HK",
        "HM",
        "HN",
        "HR",
        "HT",
        "HU",
        "ID",
        "IE",
        "IL",
        "IM",
        "IN",
        "IO",
        "IQ",
        "IR",
        "IS",
        "IT",
        "JE",
        "JM",
        "JO",
        "JP",
        "KE",
        "KG",
        "KH",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PS",
        "PT",
        "PY",
        "QA",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "US",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VN",
        "VU",
        "WF",
        "WS",
        "XK",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "ZZ",
    )


class CropRegion(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BOTTOM", "CENTER", "LEFT", "RIGHT", "TOP")


class CurrencyCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AED",
        "AFN",
        "ALL",
        "AMD",
        "ANG",
        "AOA",
        "ARS",
        "AUD",
        "AWG",
        "AZN",
        "BAM",
        "BBD",
        "BDT",
        "BGN",
        "BHD",
        "BIF",
        "BMD",
        "BND",
        "BOB",
        "BRL",
        "BSD",
        "BTN",
        "BWP",
        "BYN",
        "BZD",
        "CAD",
        "CDF",
        "CHF",
        "CLP",
        "CNY",
        "COP",
        "CRC",
        "CVE",
        "CZK",
        "DJF",
        "DKK",
        "DOP",
        "DZD",
        "EGP",
        "ERN",
        "ETB",
        "EUR",
        "FJD",
        "FKP",
        "GBP",
        "GEL",
        "GHS",
        "GIP",
        "GMD",
        "GNF",
        "GTQ",
        "GYD",
        "HKD",
        "HNL",
        "HRK",
        "HTG",
        "HUF",
        "IDR",
        "ILS",
        "INR",
        "IQD",
        "IRR",
        "ISK",
        "JEP",
        "JMD",
        "JOD",
        "JPY",
        "KES",
        "KGS",
        "KHR",
        "KID",
        "KMF",
        "KRW",
        "KWD",
        "KYD",
        "KZT",
        "LAK",
        "LBP",
        "LKR",
        "LRD",
        "LSL",
        "LTL",
        "LVL",
        "LYD",
        "MAD",
        "MDL",
        "MGA",
        "MKD",
        "MMK",
        "MNT",
        "MOP",
        "MRU",
        "MUR",
        "MVR",
        "MWK",
        "MXN",
        "MYR",
        "MZN",
        "NAD",
        "NGN",
        "NIO",
        "NOK",
        "NPR",
        "NZD",
        "OMR",
        "PAB",
        "PEN",
        "PGK",
        "PHP",
        "PKR",
        "PLN",
        "PYG",
        "QAR",
        "RON",
        "RSD",
        "RUB",
        "RWF",
        "SAR",
        "SBD",
        "SCR",
        "SDG",
        "SEK",
        "SGD",
        "SHP",
        "SLL",
        "SOS",
        "SRD",
        "SSP",
        "STN",
        "SYP",
        "SZL",
        "THB",
        "TJS",
        "TMT",
        "TND",
        "TOP",
        "TRY",
        "TTD",
        "TWD",
        "TZS",
        "UAH",
        "UGX",
        "USD",
        "UYU",
        "UZS",
        "VED",
        "VES",
        "VND",
        "VUV",
        "WST",
        "XAF",
        "XCD",
        "XOF",
        "XPF",
        "XXX",
        "YER",
        "ZAR",
        "ZMW",
    )


class CustomerConsentCollectedFrom(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("OTHER", "SHOPIFY")


class CustomerEmailAddressMarketingState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "NOT_SUBSCRIBED", "PENDING", "SUBSCRIBED", "UNSUBSCRIBED")


class CustomerEmailAddressOpenTrackingLevel(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("OPTED_IN", "OPTED_OUT", "UNKNOWN")


class CustomerEmailMarketingConsentUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INCLUSION", "INTERNAL_ERROR", "INVALID", "MISSING_ARGUMENT")


class CustomerEmailMarketingState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "NOT_SUBSCRIBED", "PENDING", "REDACTED", "SUBSCRIBED", "UNSUBSCRIBED")


class CustomerMarketingOptInLevel(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CONFIRMED_OPT_IN", "SINGLE_OPT_IN", "UNKNOWN")


class CustomerMergeErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CUSTOMER_HAS_GIFT_CARDS",
        "INTERNAL_ERROR",
        "INVALID_CUSTOMER",
        "INVALID_CUSTOMER_ID",
        "MISSING_OVERRIDE_ATTRIBUTE",
        "OVERRIDE_ATTRIBUTE_INVALID",
    )


class CustomerMergeErrorFieldType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "COMPANY_CONTACT",
        "CUSTOMER_PAYMENT_METHODS",
        "DELETED_AT",
        "GIFT_CARDS",
        "MERGE_IN_PROGRESS",
        "MULTIPASS_IDENTIFIER",
        "PENDING_DATA_REQUEST",
        "REDACTED_AT",
        "SUBSCRIPTIONS",
    )


class CustomerMergeRequestStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COMPLETED", "FAILED", "IN_PROGRESS", "REQUESTED")


class CustomerPaymentMethodCreateFromDuplicationDataUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CUSTOMER_DOES_NOT_EXIST", "INVALID_ENCRYPTED_DUPLICATION_DATA", "TOO_MANY_REQUESTS")


class CustomerPaymentMethodGetDuplicationDataUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CUSTOMER_DOES_NOT_EXIST",
        "INVALID_INSTRUMENT",
        "INVALID_ORGANIZATION_SHOP",
        "PAYMENT_METHOD_DOES_NOT_EXIST",
        "SAME_SHOP",
        "TOO_MANY_REQUESTS",
    )


class CustomerPaymentMethodGetUpdateUrlUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CUSTOMER_DOES_NOT_EXIST", "INVALID_INSTRUMENT", "PAYMENT_METHOD_DOES_NOT_EXIST", "TOO_MANY_REQUESTS")


class CustomerPaymentMethodRemoteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AUTHORIZE_NET_NOT_ENABLED_FOR_SUBSCRIPTIONS",
        "BRAINTREE_NOT_ENABLED_FOR_SUBSCRIPTIONS",
        "EXACTLY_ONE_REMOTE_REFERENCE_REQUIRED",
        "INVALID",
        "PRESENT",
        "TAKEN",
    )


class CustomerPaymentMethodRevocationReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AUTHORIZE_NET_GATEWAY_NOT_ENABLED",
        "AUTHORIZE_NET_RETURNED_NO_PAYMENT_METHOD",
        "BRAINTREE_API_AUTHENTICATION_ERROR",
        "BRAINTREE_GATEWAY_NOT_ENABLED",
        "BRAINTREE_PAYMENT_METHOD_NOT_CARD",
        "BRAINTREE_RETURNED_NO_PAYMENT_METHOD",
        "FAILED_TO_UPDATE_CREDIT_CARD",
        "MANUALLY_REVOKED",
        "MERGED",
        "STRIPE_API_AUTHENTICATION_ERROR",
        "STRIPE_API_INVALID_REQUEST_ERROR",
        "STRIPE_GATEWAY_NOT_ENABLED",
        "STRIPE_PAYMENT_METHOD_NOT_CARD",
        "STRIPE_RETURNED_NO_PAYMENT_METHOD",
    )


class CustomerPaymentMethodUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "PRESENT", "TAKEN")


class CustomerPredictedSpendTier(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("HIGH", "LOW", "MEDIUM")


class CustomerProductSubscriberStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "CANCELLED", "EXPIRED", "FAILED", "NEVER_SUBSCRIBED", "PAUSED")


class CustomerSavedSearchSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "NAME", "RELEVANCE")


class CustomerSegmentMembersQueryUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID",)


class CustomerSmsMarketingConsentErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INCLUSION", "INTERNAL_ERROR", "INVALID", "MISSING_ARGUMENT")


class CustomerSmsMarketingState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NOT_SUBSCRIBED", "PENDING", "REDACTED", "SUBSCRIBED", "UNSUBSCRIBED")


class CustomerSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "LAST_ORDER_DATE", "LOCATION", "NAME", "ORDERS_COUNT", "RELEVANCE", "TOTAL_SPENT", "UPDATED_AT")


class CustomerState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DECLINED", "DISABLED", "ENABLED", "INVITED")


Date = sgqlc.types.datetime.Date

DateTime = sgqlc.types.datetime.DateTime


class DayOfTheWeek(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FRIDAY", "MONDAY", "SATURDAY", "SUNDAY", "THURSDAY", "TUESDAY", "WEDNESDAY")


class Decimal(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class DelegateAccessTokenCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DELEGATE_ACCESS_TOKEN",
        "EMPTY_ACCESS_SCOPE",
        "EXPIRES_AFTER_PARENT",
        "NEGATIVE_EXPIRES_IN",
        "PERSISTENCE_FAILED",
        "REFRESH_TOKEN",
        "UNKNOWN_SCOPES",
    )


class DelegateAccessTokenDestroyUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACCESS_DENIED", "ACCESS_TOKEN_NOT_FOUND", "CAN_ONLY_DELETE_DELEGATE_TOKENS", "PERSISTENCE_FAILED")


class DeletionEventSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class DeletionEventSubjectType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COLLECTION", "PRODUCT")


class DeliveryConditionField(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("TOTAL_PRICE", "TOTAL_WEIGHT")


class DeliveryConditionOperator(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GREATER_THAN_OR_EQUAL_TO", "LESS_THAN_OR_EQUAL_TO")


class DeliveryCustomizationErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CUSTOM_APP_FUNCTION_NOT_ELIGIBLE",
        "DELIVERY_CUSTOMIZATION_FUNCTION_NOT_ELIGIBLE",
        "DELIVERY_CUSTOMIZATION_NOT_FOUND",
        "FUNCTION_DOES_NOT_IMPLEMENT",
        "FUNCTION_ID_CANNOT_BE_CHANGED",
        "FUNCTION_NOT_FOUND",
        "FUNCTION_PENDING_DELETION",
        "INVALID",
        "INVALID_METAFIELDS",
        "MAXIMUM_ACTIVE_DELIVERY_CUSTOMIZATIONS",
        "REQUIRED_INPUT_FIELD",
        "UNAUTHORIZED_APP_SCOPE",
    )


class DeliveryLegacyModeBlockedReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NO_LOCATIONS_FULFILLING_ONLINE_ORDERS",)


class DeliveryLocalPickupTime(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIVE_OR_MORE_DAYS", "FOUR_HOURS", "ONE_HOUR", "TWENTY_FOUR_HOURS", "TWO_HOURS", "TWO_TO_FOUR_DAYS")


class DeliveryLocationLocalPickupSettingsErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE_LOCATION_NOT_FOUND", "GENERIC_ERROR")


class DeliveryMethodDefinitionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MERCHANT", "PARTICIPANT")


class DeliveryMethodType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("LOCAL", "NONE", "PICK_UP", "RETAIL", "SHIPPING")


class DigitalWallet(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ANDROID_PAY", "APPLE_PAY", "GOOGLE_PAY", "SHOPIFY_PAY")


class DiscountApplicationAllocationMethod(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACROSS", "EACH")


class DiscountApplicationLevel(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("LINE", "ORDER")


class DiscountApplicationTargetSelection(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALL", "ENTITLED", "EXPLICIT")


class DiscountApplicationTargetType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("LINE_ITEM", "SHIPPING_LINE")


class DiscountClass(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER", "PRODUCT", "SHIPPING")


class DiscountCodeSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CODE", "CREATED_AT", "ID", "RELEVANCE")


class DiscountErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ACTIVE_PERIOD_OVERLAP",
        "BLANK",
        "CONFLICT",
        "DUPLICATE",
        "EQUAL_TO",
        "EXCEEDED_MAX",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL_TO",
        "IMPLICIT_DUPLICATE",
        "INCLUSION",
        "INTERNAL_ERROR",
        "INVALID",
        "INVALID_COMBINES_WITH_FOR_DISCOUNT_CLASS",
        "INVALID_DISCOUNT_CLASS_FOR_PRICE_RULE",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL_TO",
        "MAX_APP_DISCOUNTS",
        "MINIMUM_SUBTOTAL_AND_QUANTITY_RANGE_BOTH_PRESENT",
        "MISSING_ARGUMENT",
        "PRESENT",
        "TAKEN",
        "TOO_LONG",
        "TOO_MANY_ARGUMENTS",
        "TOO_SHORT",
        "VALUE_OUTSIDE_RANGE",
    )


class DiscountShareableUrlTargetType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COLLECTION", "HOME", "PRODUCT")


class DiscountSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ENDS_AT", "ID", "RELEVANCE", "STARTS_AT", "TITLE", "UPDATED_AT")


class DiscountStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "EXPIRED", "SCHEDULED")


class DiscountTargetType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("LINE_ITEM", "SHIPPING_LINE")


class DiscountType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CODE_DISCOUNT", "MANUAL")


class DisputeEvidenceUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DISPUTE_EVIDENCE_NOT_FOUND",
        "EVIDENCE_ALREADY_ACCEPTED",
        "EVIDENCE_PAST_DUE_DATE",
        "FILES_SIZE_EXCEEDED_LIMIT",
        "INVALID",
        "TOO_LARGE",
    )


class DisputeStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACCEPTED", "CHARGE_REFUNDED", "LOST", "NEEDS_RESPONSE", "UNDER_REVIEW", "WON")


class DisputeType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CHARGEBACK", "INQUIRY")


class DraftOrderAppliedDiscountType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIXED_AMOUNT", "PERCENTAGE")


class DraftOrderSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CUSTOMER_NAME", "ID", "NUMBER", "RELEVANCE", "STATUS", "TOTAL_PRICE", "UPDATED_AT")


class DraftOrderStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COMPLETED", "INVOICE_SENT", "OPEN")


class ErrorsServerPixelUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALREADY_EXISTS", "NEEDS_CONFIGURATION_TO_CONNECT", "NOT_FOUND", "PUB_SUB_ERROR")


class ErrorsWebPixelUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BLANK", "INVALID_SETTINGS", "NOT_FOUND", "TAKEN", "UNABLE_TO_DELETE")


class EventSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class FileContentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FILE", "IMAGE", "VIDEO")


class FileCreateInputDuplicateResolutionMode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("APPEND_UUID", "RAISE_ERROR", "REPLACE")


class FileErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DUPLICATE_FILENAME_ERROR",
        "EXTERNAL_VIDEO_EMBED_DISABLED",
        "EXTERNAL_VIDEO_EMBED_NOT_FOUND_OR_TRANSCODING",
        "EXTERNAL_VIDEO_INVALID_ASPECT_RATIO",
        "EXTERNAL_VIDEO_NOT_FOUND",
        "EXTERNAL_VIDEO_UNLISTED",
        "FILE_STORAGE_LIMIT_EXCEEDED",
        "GENERIC_FILE_DOWNLOAD_FAILURE",
        "GENERIC_FILE_INVALID_SIZE",
        "IMAGE_DOWNLOAD_FAILURE",
        "IMAGE_PROCESSING_FAILURE",
        "INVALID_IMAGE_ASPECT_RATIO",
        "INVALID_IMAGE_FILE_SIZE",
        "INVALID_IMAGE_RESOLUTION",
        "INVALID_SIGNED_URL",
        "MEDIA_TIMEOUT_ERROR",
        "MODEL3D_GLB_OUTPUT_CREATION_ERROR",
        "MODEL3D_GLB_TO_USDZ_CONVERSION_ERROR",
        "MODEL3D_PROCESSING_FAILURE",
        "MODEL3D_THUMBNAIL_GENERATION_ERROR",
        "MODEL3D_THUMBNAIL_REGENERATION_ERROR",
        "MODEL3D_VALIDATION_ERROR",
        "UNKNOWN",
        "UNSUPPORTED_IMAGE_FILE_TYPE",
        "VIDEO_INVALID_FILETYPE_ERROR",
        "VIDEO_MAX_DURATION_ERROR",
        "VIDEO_MAX_HEIGHT_ERROR",
        "VIDEO_MAX_WIDTH_ERROR",
        "VIDEO_METADATA_READ_ERROR",
        "VIDEO_MIN_DURATION_ERROR",
        "VIDEO_MIN_HEIGHT_ERROR",
        "VIDEO_MIN_WIDTH_ERROR",
        "VIDEO_VALIDATION_ERROR",
    )


class FileSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "FILENAME", "ID", "ORIGINAL_UPLOAD_SIZE", "RELEVANCE", "UPDATED_AT")


class FileStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FAILED", "PROCESSING", "READY", "UPLOADED")


class FilesErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ALT_VALUE_LIMIT_EXCEEDED",
        "BLANK_SEARCH",
        "FILENAME_ALREADY_EXISTS",
        "FILE_DOES_NOT_EXIST",
        "FILE_LOCKED",
        "INVALID",
        "INVALID_DUPLICATE_MODE_FOR_TYPE",
        "INVALID_FILENAME",
        "INVALID_FILENAME_EXTENSION",
        "INVALID_IMAGE_SOURCE_URL",
        "INVALID_QUERY",
        "MISMATCHED_FILENAME_AND_ORIGINAL_SOURCE",
        "MISSING_ARGUMENTS",
        "MISSING_FILENAME_FOR_DUPLICATE_MODE_REPLACE",
        "NON_IMAGE_MEDIA_PER_SHOP_LIMIT_EXCEEDED",
        "NON_READY_STATE",
        "TOO_MANY_ARGUMENTS",
        "UNACCEPTABLE_ASSET",
        "UNACCEPTABLE_TRIAL_ASSET",
        "UNACCEPTABLE_UNVERIFIED_TRIAL_ASSET",
        "UNSUPPORTED_MEDIA_TYPE_FOR_FILENAME_UPDATE",
    )


Float = sgqlc.types.Float


class FormattedString(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class FulfillmentDisplayStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ATTEMPTED_DELIVERY",
        "CANCELED",
        "CONFIRMED",
        "DELIVERED",
        "FAILURE",
        "FULFILLED",
        "IN_TRANSIT",
        "LABEL_PRINTED",
        "LABEL_PURCHASED",
        "LABEL_VOIDED",
        "MARKED_AS_FULFILLED",
        "NOT_DELIVERED",
        "OUT_FOR_DELIVERY",
        "PICKED_UP",
        "READY_FOR_PICKUP",
        "SUBMITTED",
    )


class FulfillmentEventSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("HAPPENED_AT", "ID", "RELEVANCE")


class FulfillmentEventStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ATTEMPTED_DELIVERY",
        "CONFIRMED",
        "DELIVERED",
        "FAILURE",
        "IN_TRANSIT",
        "LABEL_PRINTED",
        "LABEL_PURCHASED",
        "OUT_FOR_DELIVERY",
        "READY_FOR_PICKUP",
    )


class FulfillmentHoldReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AWAITING_PAYMENT",
        "HIGH_RISK_OF_FRAUD",
        "INCORRECT_ADDRESS",
        "INVENTORY_OUT_OF_STOCK",
        "ONLINE_STORE_POST_PURCHASE_CROSS_SELL",
        "OTHER",
        "UNKNOWN_DELIVERY_DATE",
    )


class FulfillmentOrderAction(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CANCEL_FULFILLMENT_ORDER",
        "CREATE_FULFILLMENT",
        "EXTERNAL",
        "HOLD",
        "MARK_AS_OPEN",
        "MERGE",
        "MOVE",
        "RELEASE_HOLD",
        "REQUEST_CANCELLATION",
        "REQUEST_FULFILLMENT",
        "SPLIT",
    )


class FulfillmentOrderAssignmentStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELLATION_REQUESTED", "FULFILLMENT_ACCEPTED", "FULFILLMENT_REQUESTED")


class FulfillmentOrderHoldUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_NOT_FOUND", "GREATER_THAN_ZERO", "INVALID_LINE_ITEM_QUANTITY", "TAKEN")


class FulfillmentOrderLineItemsPreparedForPickupUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_INVALID", "NO_LINE_ITEMS_TO_PREPARE_FOR_FULFILLMENT_ORDER", "UNABLE_TO_PREPARE_QUANTITY")


class FulfillmentOrderMerchantRequestKind(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELLATION_REQUEST", "FULFILLMENT_REQUEST")


class FulfillmentOrderMergeUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_NOT_FOUND", "GREATER_THAN", "INVALID_LINE_ITEM_QUANTITY")


class FulfillmentOrderRejectionReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INCORRECT_ADDRESS", "INELIGIBLE_PRODUCT", "INVENTORY_OUT_OF_STOCK", "OTHER", "UNDELIVERABLE_DESTINATION")


class FulfillmentOrderReleaseHoldUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_NOT_FOUND", "GREATER_THAN_ZERO", "INVALID_LINE_ITEM_QUANTITY")


class FulfillmentOrderRequestStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ACCEPTED",
        "CANCELLATION_ACCEPTED",
        "CANCELLATION_REJECTED",
        "CANCELLATION_REQUESTED",
        "CLOSED",
        "REJECTED",
        "SUBMITTED",
        "UNSUBMITTED",
    )


class FulfillmentOrderRescheduleUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_NOT_FOUND",)


class FulfillmentOrderSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "RELEVANCE")


class FulfillmentOrderSplitUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDER_NOT_FOUND", "GREATER_THAN", "INVALID_LINE_ITEM_QUANTITY")


class FulfillmentOrderStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELLED", "CLOSED", "INCOMPLETE", "IN_PROGRESS", "ON_HOLD", "OPEN", "SCHEDULED")


class FulfillmentOrdersReleaseHoldsUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FAILED_TO_CREATE_JOB",)


class FulfillmentOrdersSetFulfillmentDeadlineUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_ORDERS_NOT_FOUND",)


class FulfillmentServiceType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GIFT_CARD", "MANUAL", "THIRD_PARTY")


class FulfillmentStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELLED", "ERROR", "FAILURE", "SUCCESS")


class GiftCardErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GREATER_THAN", "INTERNAL_ERROR", "INVALID", "MISSING_ARGUMENT", "TAKEN", "TOO_LONG", "TOO_SHORT")


class GiftCardSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AMOUNT_SPENT",
        "BALANCE",
        "CODE",
        "CREATED_AT",
        "CUSTOMER_NAME",
        "DISABLED_AT",
        "EXPIRES_ON",
        "ID",
        "INITIAL_VALUE",
        "RELEVANCE",
        "UPDATED_AT",
    )


class HTML(sgqlc.types.Scalar):
    __schema__ = shopify_schema


ID = sgqlc.types.ID


class ImageContentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("JPG", "PNG", "WEBP")


Int = sgqlc.types.Int


class InventoryAdjustQuantitiesUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ADJUST_QUANTITIES_FAILED",
        "INTERNAL_LEDGER_DOCUMENT",
        "INVALID_AVAILABLE_DOCUMENT",
        "INVALID_INVENTORY_ITEM",
        "INVALID_LEDGER_DOCUMENT",
        "INVALID_LOCATION",
        "INVALID_QUANTITY_DOCUMENT",
        "INVALID_QUANTITY_NAME",
        "INVALID_QUANTITY_TOO_HIGH",
        "INVALID_QUANTITY_TOO_LOW",
        "INVALID_REASON",
        "INVALID_REFERENCE_DOCUMENT",
        "ITEM_NOT_STOCKED_AT_LOCATION",
        "MAX_ONE_LEDGER_DOCUMENT",
        "NON_MUTABLE_INVENTORY_ITEM",
    )


class InventoryBulkToggleActivationUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CANNOT_DEACTIVATE_FROM_ONLY_LOCATION",
        "COMMITTED_INVENTORY_AT_LOCATION",
        "FAILED_TO_STOCK_AT_LOCATION",
        "FAILED_TO_UNSTOCK_FROM_LOCATION",
        "GENERIC_ERROR",
        "INCOMING_INVENTORY_AT_LOCATION",
        "INVENTORY_ITEM_NOT_FOUND",
        "INVENTORY_MANAGED_BY_3RD_PARTY",
        "INVENTORY_MANAGED_BY_SHOPIFY",
        "LOCATION_NOT_FOUND",
        "MISSING_SKU",
        "RESERVED_INVENTORY_AT_LOCATION",
    )


class InventoryMoveQuantitiesUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DIFFERENT_LOCATIONS",
        "INTERNAL_LEDGER_DOCUMENT",
        "INVALID_AVAILABLE_DOCUMENT",
        "INVALID_INVENTORY_ITEM",
        "INVALID_LEDGER_DOCUMENT",
        "INVALID_LOCATION",
        "INVALID_QUANTITY_DOCUMENT",
        "INVALID_QUANTITY_NAME",
        "INVALID_QUANTITY_NEGATIVE",
        "INVALID_QUANTITY_TOO_HIGH",
        "INVALID_REASON",
        "INVALID_REFERENCE_DOCUMENT",
        "ITEM_NOT_STOCKED_AT_LOCATION",
        "MAXIMUM_LEDGER_DOCUMENT_URIS",
        "MOVE_QUANTITIES_FAILED",
        "NON_MUTABLE_INVENTORY_ITEM",
        "SAME_QUANTITY_NAME",
    )


class InventorySetOnHandQuantitiesUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "INVALID_INVENTORY_ITEM",
        "INVALID_LOCATION",
        "INVALID_QUANTITY_NEGATIVE",
        "INVALID_QUANTITY_TOO_HIGH",
        "INVALID_REASON",
        "INVALID_REFERENCE_DOCUMENT",
        "ITEM_NOT_STOCKED_AT_LOCATION",
        "NON_MUTABLE_INVENTORY_ITEM",
        "SET_ON_HAND_QUANTITIES_FAILED",
    )


class JSON(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class LanguageCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AF",
        "AK",
        "AM",
        "AR",
        "AS",
        "AZ",
        "BE",
        "BG",
        "BM",
        "BN",
        "BO",
        "BR",
        "BS",
        "CA",
        "CE",
        "CS",
        "CU",
        "CY",
        "DA",
        "DE",
        "DZ",
        "EE",
        "EL",
        "EN",
        "EO",
        "ES",
        "ET",
        "EU",
        "FA",
        "FF",
        "FI",
        "FO",
        "FR",
        "FY",
        "GA",
        "GD",
        "GL",
        "GU",
        "GV",
        "HA",
        "HE",
        "HI",
        "HR",
        "HU",
        "HY",
        "IA",
        "ID",
        "IG",
        "II",
        "IS",
        "IT",
        "JA",
        "JV",
        "KA",
        "KI",
        "KK",
        "KL",
        "KM",
        "KN",
        "KO",
        "KS",
        "KU",
        "KW",
        "KY",
        "LB",
        "LG",
        "LN",
        "LO",
        "LT",
        "LU",
        "LV",
        "MG",
        "MI",
        "MK",
        "ML",
        "MN",
        "MR",
        "MS",
        "MT",
        "MY",
        "NB",
        "ND",
        "NE",
        "NL",
        "NN",
        "NO",
        "OM",
        "OR",
        "OS",
        "PA",
        "PL",
        "PS",
        "PT",
        "PT_BR",
        "PT_PT",
        "QU",
        "RM",
        "RN",
        "RO",
        "RU",
        "RW",
        "SD",
        "SE",
        "SG",
        "SI",
        "SK",
        "SL",
        "SN",
        "SO",
        "SQ",
        "SR",
        "SU",
        "SV",
        "SW",
        "TA",
        "TE",
        "TG",
        "TH",
        "TI",
        "TK",
        "TO",
        "TR",
        "TT",
        "UG",
        "UK",
        "UR",
        "UZ",
        "VI",
        "VO",
        "WO",
        "XH",
        "YI",
        "YO",
        "ZH",
        "ZH_CN",
        "ZH_TW",
        "ZU",
    )


class LengthUnit(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CENTIMETERS", "FEET", "INCHES", "METERS", "MILLIMETERS", "YARDS")


class LocalizableContentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "FILE_REFERENCE",
        "HTML",
        "INLINE_RICH_TEXT",
        "JSON",
        "JSON_STRING",
        "LIST_FILE_REFERENCE",
        "LIST_MULTI_LINE_TEXT_FIELD",
        "LIST_SINGLE_LINE_TEXT_FIELD",
        "LIST_URL",
        "MULTI_LINE_TEXT_FIELD",
        "RICH_TEXT_FIELD",
        "SINGLE_LINE_TEXT_FIELD",
        "STRING",
        "URI",
        "URL",
    )


class LocalizationExtensionKey(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "SHIPPING_CREDENTIAL_BR",
        "SHIPPING_CREDENTIAL_CN",
        "SHIPPING_CREDENTIAL_KR",
        "TAX_CREDENTIAL_BR",
        "TAX_CREDENTIAL_IT",
        "TAX_EMAIL_IT",
    )


class LocalizationExtensionPurpose(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("SHIPPING", "TAX")


class LocationActivateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GENERIC_ERROR", "HAS_NON_UNIQUE_NAME", "HAS_ONGOING_RELOCATION", "LOCATION_LIMIT", "LOCATION_NOT_FOUND")


class LocationAddUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_NOT_AUTHORIZED",
        "BLANK",
        "DISALLOWED_OWNER_TYPE",
        "GENERIC_ERROR",
        "INCLUSION",
        "INVALID",
        "INVALID_TYPE",
        "INVALID_US_ZIPCODE",
        "INVALID_VALUE",
        "PRESENT",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNSTRUCTURED_RESERVED_NAMESPACE",
    )


class LocationDeactivateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CANNOT_DISABLE_ONLINE_ORDER_FULFILLMENT",
        "DESTINATION_LOCATION_IS_THE_SAME_LOCATION",
        "DESTINATION_LOCATION_NOT_FOUND_OR_INACTIVE",
        "FAILED_TO_RELOCATE_ACTIVE_INVENTORIES",
        "FAILED_TO_RELOCATE_INCOMING_MOVEMENTS",
        "FAILED_TO_RELOCATE_OPEN_PURCHASE_ORDERS",
        "FAILED_TO_RELOCATE_OPEN_TRANSFERS",
        "HAS_ACTIVE_INVENTORY_ERROR",
        "HAS_ACTIVE_RETAIL_SUBSCRIPTIONS",
        "HAS_FULFILLMENT_ORDERS_ERROR",
        "HAS_INCOMING_MOVEMENTS_ERROR",
        "HAS_OPEN_PURCHASE_ORDERS_ERROR",
        "HAS_OPEN_TRANSFERS_ERROR",
        "LOCATION_NOT_FOUND",
        "PERMANENTLY_BLOCKED_FROM_DEACTIVATION_ERROR",
        "TEMPORARILY_BLOCKED_FROM_DEACTIVATION_ERROR",
    )


class LocationDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "GENERIC_ERROR",
        "LOCATION_HAS_ACTIVE_RETAIL_SUBSCRIPTION",
        "LOCATION_HAS_INVENTORY",
        "LOCATION_HAS_PENDING_ORDERS",
        "LOCATION_IS_ACTIVE",
        "LOCATION_NOT_FOUND",
    )


class LocationEditUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_NOT_AUTHORIZED",
        "BLANK",
        "CANNOT_DISABLE_ONLINE_ORDER_FULFILLMENT",
        "DISALLOWED_OWNER_TYPE",
        "GENERIC_ERROR",
        "INCLUSION",
        "INVALID",
        "INVALID_TYPE",
        "INVALID_US_ZIPCODE",
        "INVALID_VALUE",
        "NOT_FOUND",
        "PRESENT",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNSTRUCTURED_RESERVED_NAMESPACE",
    )


class LocationSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "NAME", "RELEVANCE")


class MarketCurrencySettingsUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "MANAGED_MARKET",
        "MARKET_NOT_FOUND",
        "MULTIPLE_CURRENCIES_NOT_SUPPORTED",
        "NO_LOCAL_CURRENCIES_ON_SINGLE_COUNTRY_MARKET",
        "PRIMARY_MARKET_USES_SHOP_CURRENCY",
        "UNSUPPORTED_CURRENCY",
    )


class MarketLocalizableResourceType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("METAFIELD",)


class MarketUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "CANNOT_ADD_CUSTOMER_DOMAIN",
        "CANNOT_ADD_REGIONS_TO_PRIMARY_MARKET",
        "CANNOT_ADD_WEB_PRESENCE_TO_PRIMARY_MARKET",
        "CANNOT_DELETE_ONLY_REGION",
        "CANNOT_DELETE_PRIMARY_MARKET",
        "CANNOT_DELETE_PRIMARY_MARKET_WEB_PRESENCE",
        "CANNOT_DISABLE_PRIMARY_MARKET",
        "CANNOT_HAVE_SUBFOLDER_AND_DOMAIN",
        "CANNOT_SET_DEFAULT_LOCALE_TO_NULL",
        "DISABLED_LANGUAGE",
        "DOMAIN_NOT_FOUND",
        "DUPLICATE_LANGUAGES",
        "INVALID",
        "MARKET_NOT_FOUND",
        "NO_LANGUAGES",
        "PRIMARY_MARKET_MUST_USE_PRIMARY_DOMAIN",
        "REGION_NOT_FOUND",
        "REGION_SPECIFIC_LANGUAGE",
        "REQUIRES_DOMAIN_OR_SUBFOLDER",
        "REQUIRES_EXACTLY_ONE_OPTION",
        "SHOP_REACHED_MARKETS_LIMIT",
        "SUBFOLDER_SUFFIX_CANNOT_BE_SCRIPT_CODE",
        "SUBFOLDER_SUFFIX_MUST_CONTAIN_ONLY_LETTERS",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNPUBLISHED_LANGUAGE",
        "UNSUPPORTED_COUNTRY_REGION",
        "WEB_PRESENCE_NOT_FOUND",
    )


class MarketingActivityExtensionAppErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("API_ERROR", "INSTALL_REQUIRED_ERROR", "NOT_ONBOARDED_ERROR", "PLATFORM_ERROR", "VALIDATION_ERROR")


class MarketingActivitySortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE", "TITLE")


class MarketingActivityStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ACTIVE",
        "DELETED",
        "DELETED_EXTERNALLY",
        "DISCONNECTED",
        "DRAFT",
        "FAILED",
        "INACTIVE",
        "PAUSED",
        "PENDING",
        "SCHEDULED",
        "UNDEFINED",
    )


class MarketingActivityStatusBadgeType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ATTENTION", "DEFAULT", "INFO", "SUCCESS", "WARNING")


class MarketingActivityUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "TAKEN")


class MarketingBudgetBudgetType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DAILY", "LIFETIME")


class MarketingChannel(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DISPLAY", "EMAIL", "REFERRAL", "SEARCH", "SOCIAL")


class MarketingEventSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "RELEVANCE", "STARTED_AT")


class MarketingTactic(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ABANDONED_CART",
        "AD",
        "AFFILIATE",
        "DIRECT",
        "LINK",
        "LOYALTY",
        "MESSAGE",
        "NEWSLETTER",
        "NOTIFICATION",
        "POST",
        "RETARGETING",
        "SEO",
        "STOREFRONT_APP",
        "TRANSACTIONAL",
    )


class MediaContentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("EXTERNAL_VIDEO", "IMAGE", "MODEL_3D", "VIDEO")


class MediaErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DUPLICATE_FILENAME_ERROR",
        "EXTERNAL_VIDEO_EMBED_DISABLED",
        "EXTERNAL_VIDEO_EMBED_NOT_FOUND_OR_TRANSCODING",
        "EXTERNAL_VIDEO_INVALID_ASPECT_RATIO",
        "EXTERNAL_VIDEO_NOT_FOUND",
        "EXTERNAL_VIDEO_UNLISTED",
        "FILE_STORAGE_LIMIT_EXCEEDED",
        "GENERIC_FILE_DOWNLOAD_FAILURE",
        "GENERIC_FILE_INVALID_SIZE",
        "IMAGE_DOWNLOAD_FAILURE",
        "IMAGE_PROCESSING_FAILURE",
        "INVALID_IMAGE_ASPECT_RATIO",
        "INVALID_IMAGE_FILE_SIZE",
        "INVALID_IMAGE_RESOLUTION",
        "INVALID_SIGNED_URL",
        "MEDIA_TIMEOUT_ERROR",
        "MODEL3D_GLB_OUTPUT_CREATION_ERROR",
        "MODEL3D_GLB_TO_USDZ_CONVERSION_ERROR",
        "MODEL3D_PROCESSING_FAILURE",
        "MODEL3D_THUMBNAIL_GENERATION_ERROR",
        "MODEL3D_THUMBNAIL_REGENERATION_ERROR",
        "MODEL3D_VALIDATION_ERROR",
        "UNKNOWN",
        "UNSUPPORTED_IMAGE_FILE_TYPE",
        "VIDEO_INVALID_FILETYPE_ERROR",
        "VIDEO_MAX_DURATION_ERROR",
        "VIDEO_MAX_HEIGHT_ERROR",
        "VIDEO_MAX_WIDTH_ERROR",
        "VIDEO_METADATA_READ_ERROR",
        "VIDEO_MIN_DURATION_ERROR",
        "VIDEO_MIN_HEIGHT_ERROR",
        "VIDEO_MIN_WIDTH_ERROR",
        "VIDEO_VALIDATION_ERROR",
    )


class MediaHost(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("VIMEO", "YOUTUBE")


class MediaPreviewImageStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FAILED", "PROCESSING", "READY", "UPLOADED")


class MediaStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FAILED", "PROCESSING", "READY", "UPLOADED")


class MediaUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "INVALID",
        "INVALID_MEDIA_TYPE",
        "MAXIMUM_VARIANT_MEDIA_PAIRS_EXCEEDED",
        "MEDIA_CANNOT_BE_MODIFIED",
        "MEDIA_DOES_NOT_EXIST",
        "MEDIA_DOES_NOT_EXIST_ON_PRODUCT",
        "MEDIA_IS_NOT_ATTACHED_TO_VARIANT",
        "MODEL3D_THROTTLE_EXCEEDED",
        "MODEL3D_VALIDATION_ERROR",
        "NON_READY_MEDIA",
        "PRODUCT_DOES_NOT_EXIST",
        "PRODUCT_MEDIA_LIMIT_EXCEEDED",
        "PRODUCT_VARIANT_ALREADY_HAS_MEDIA",
        "PRODUCT_VARIANT_DOES_NOT_EXIST_ON_PRODUCT",
        "PRODUCT_VARIANT_SPECIFIED_MULTIPLE_TIMES",
        "SHOP_MEDIA_LIMIT_EXCEEDED",
        "TOO_MANY_MEDIA_PER_INPUT_PAIR",
        "VIDEO_THROTTLE_EXCEEDED",
        "VIDEO_VALIDATION_ERROR",
    )


class MediaWarningCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MODEL_LARGE_PHYSICAL_SIZE", "MODEL_SMALL_PHYSICAL_SIZE")


class MerchandiseDiscountClass(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER", "PRODUCT")


class MetafieldAdminAccess(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MERCHANT_READ", "MERCHANT_READ_WRITE", "PRIVATE", "PUBLIC_READ")


class MetafieldDefinitionCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DUPLICATE_OPTION",
        "INCLUSION",
        "INVALID",
        "INVALID_CHARACTER",
        "INVALID_OPTION",
        "LIMIT_EXCEEDED",
        "OWNER_TYPE_LIMIT_EXCEEDED_FOR_AUTOMATED_COLLECTIONS",
        "PINNED_LIMIT_REACHED",
        "PRESENT",
        "RESERVED_NAMESPACE_KEY",
        "RESOURCE_TYPE_LIMIT_EXCEEDED",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "TYPE_NOT_ALLOWED_FOR_CONDITIONS",
        "UNSTRUCTURED_ALREADY_EXISTS",
    )


class MetafieldDefinitionDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DISALLOWED_OWNER_TYPE",
        "INTERNAL_ERROR",
        "METAFIELD_DEFINITION_IN_USE",
        "NOT_FOUND",
        "PRESENT",
        "REFERENCE_TYPE_DELETION_ERROR",
    )


class MetafieldDefinitionPinUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALREADY_PINNED", "DISALLOWED_OWNER_TYPE", "INTERNAL_ERROR", "NOT_FOUND", "PINNED_LIMIT_REACHED")


class MetafieldDefinitionPinnedStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ANY", "PINNED", "UNPINNED")


class MetafieldDefinitionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "NAME", "PINNED_POSITION", "RELEVANCE")


class MetafieldDefinitionUnpinUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DISALLOWED_OWNER_TYPE", "INTERNAL_ERROR", "NOT_FOUND", "NOT_PINNED")


class MetafieldDefinitionUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "INTERNAL_ERROR",
        "INVALID_INPUT",
        "METAFIELD_DEFINITION_IN_USE",
        "NOT_FOUND",
        "OWNER_TYPE_LIMIT_EXCEEDED_FOR_AUTOMATED_COLLECTIONS",
        "PINNED_LIMIT_REACHED",
        "PRESENT",
        "TOO_LONG",
        "TYPE_NOT_ALLOWED_FOR_CONDITIONS",
    )


class MetafieldDefinitionValidationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALL_VALID", "IN_PROGRESS", "SOME_INVALID")


class MetafieldOwnerType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "API_PERMISSION",
        "ARTICLE",
        "BLOG",
        "COLLECTION",
        "COMPANY",
        "COMPANY_LOCATION",
        "CUSTOMER",
        "DELIVERY_CUSTOMIZATION",
        "DISCOUNT",
        "DRAFTORDER",
        "LOCATION",
        "MARKET",
        "MEDIA_IMAGE",
        "ORDER",
        "PAGE",
        "PAYMENT_CUSTOMIZATION",
        "PRODUCT",
        "PRODUCTVARIANT",
        "SHOP",
    )


class MetafieldValidationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ANY", "INVALID", "VALID")


class MetafieldValueType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BOOLEAN", "INTEGER", "JSON_STRING", "STRING")


class MetafieldsSetUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_NOT_AUTHORIZED",
        "BLANK",
        "INCLUSION",
        "INVALID_TYPE",
        "INVALID_VALUE",
        "LESS_THAN_OR_EQUAL_TO",
        "PRESENT",
        "TOO_LONG",
        "TOO_SHORT",
    )


class MetaobjectAdminAccess(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MERCHANT_READ", "MERCHANT_READ_WRITE", "PRIVATE", "PUBLIC_READ", "PUBLIC_READ_WRITE")


class MetaobjectStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "DRAFT")


class MetaobjectStorefrontAccess(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("NONE", "PUBLIC_READ")


class MetaobjectUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "CAPABILITY_NOT_ENABLED",
        "DUPLICATE_FIELD_INPUT",
        "IMMUTABLE",
        "INCLUSION",
        "INTERNAL_ERROR",
        "INVALID",
        "INVALID_OPTION",
        "INVALID_TYPE",
        "INVALID_VALUE",
        "MAX_DEFINITIONS_EXCEEDED",
        "MAX_OBJECTS_EXCEEDED",
        "NOT_AUTHORIZED",
        "OBJECT_FIELD_REQUIRED",
        "OBJECT_FIELD_TAKEN",
        "PRESENT",
        "RECORD_NOT_FOUND",
        "RESERVED_NAME",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNDEFINED_OBJECT_FIELD",
        "UNDEFINED_OBJECT_TYPE",
    )


class MethodDefinitionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "RATE_PROVIDER_TYPE", "RELEVANCE")


class Money(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class OrderActionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER", "ORDER_EDIT", "REFUND", "UNKNOWN")


class OrderCancelReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CUSTOMER", "DECLINED", "FRAUD", "INVENTORY", "OTHER")


class OrderCreateMandatePaymentUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER_MANDATE_PAYMENT_ERROR_CODE",)


class OrderDisplayFinancialStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("AUTHORIZED", "EXPIRED", "PAID", "PARTIALLY_PAID", "PARTIALLY_REFUNDED", "PENDING", "REFUNDED", "VOIDED")


class OrderDisplayFulfillmentStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "FULFILLED",
        "IN_PROGRESS",
        "ON_HOLD",
        "OPEN",
        "PARTIALLY_FULFILLED",
        "PENDING_FULFILLMENT",
        "RESTOCKED",
        "SCHEDULED",
        "UNFULFILLED",
    )


class OrderInvoiceSendUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER_INVOICE_SEND_UNSUCCESSFUL",)


class OrderPaymentStatusResult(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AUTHORIZED",
        "CAPTURED",
        "ERROR",
        "PROCESSING",
        "PURCHASED",
        "REDIRECT_REQUIRED",
        "REFUNDED",
        "RETRYABLE",
        "SUCCESS",
        "UNKNOWN",
        "VOIDED",
    )


class OrderReturnStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INSPECTION_COMPLETE", "IN_PROGRESS", "NO_RETURN", "RETURNED", "RETURN_FAILED", "RETURN_REQUESTED")


class OrderRiskLevel(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("HIGH", "LOW", "MEDIUM")


class OrderSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CREATED_AT",
        "CUSTOMER_NAME",
        "DESTINATION",
        "FINANCIAL_STATUS",
        "FULFILLMENT_STATUS",
        "ID",
        "ORDER_NUMBER",
        "PO_NUMBER",
        "PROCESSED_AT",
        "RELEVANCE",
        "TOTAL_ITEMS_QUANTITY",
        "TOTAL_PRICE",
        "UPDATED_AT",
    )


class OrderTransactionErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AMAZON_PAYMENTS_INVALID_PAYMENT_METHOD",
        "AMAZON_PAYMENTS_MAX_AMOUNT_CHARGED",
        "AMAZON_PAYMENTS_MAX_AMOUNT_REFUNDED",
        "AMAZON_PAYMENTS_MAX_AUTHORIZATIONS_CAPTURED",
        "AMAZON_PAYMENTS_MAX_REFUNDS_PROCESSED",
        "AMAZON_PAYMENTS_ORDER_REFERENCE_CANCELED",
        "AMAZON_PAYMENTS_STALE",
        "CALL_ISSUER",
        "CARD_DECLINED",
        "CONFIG_ERROR",
        "EXPIRED_CARD",
        "GENERIC_ERROR",
        "INCORRECT_ADDRESS",
        "INCORRECT_CVC",
        "INCORRECT_NUMBER",
        "INCORRECT_PIN",
        "INCORRECT_ZIP",
        "INVALID_AMOUNT",
        "INVALID_COUNTRY",
        "INVALID_CVC",
        "INVALID_EXPIRY_DATE",
        "INVALID_NUMBER",
        "PAYMENT_METHOD_UNAVAILABLE",
        "PICK_UP_CARD",
        "PROCESSING_ERROR",
        "TEST_MODE_LIVE_CARD",
        "UNSUPPORTED_FEATURE",
    )


class OrderTransactionKind(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("AUTHORIZATION", "CAPTURE", "CHANGE", "EMV_AUTHORIZATION", "REFUND", "SALE", "SUGGESTED_REFUND", "VOID")


class OrderTransactionStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("AWAITING_RESPONSE", "ERROR", "FAILURE", "PENDING", "SUCCESS", "UNKNOWN")


class ParseErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BACKFILL_DATE_RANGE_NOT_FOUND",
        "COLUMN_NOT_FOUND",
        "COMPARE_TO_INCOMPATIBLE_PERIOD",
        "COMPARE_TO_INVALID_PERIOD",
        "COMPARE_TO_MISSING_PERIOD",
        "COMPARISON_WITH_NON_AGGREGATE_FIELDS",
        "DATE_INTERVAL_NOT_FOUND",
        "DATE_NOT_PARSABLE",
        "DATE_TIME_NOT_PARSABLE",
        "EXCESS_BACKFILL_DIMENSIONS",
        "EXCESS_DIMENSIONS",
        "EXCESS_PERIODS",
        "EXCESS_PRESENTMENTS",
        "FROM_NOT_FOUND",
        "FUNCTION_ARGUMENTS_NOT_FOUND",
        "FUNCTION_EXCESS_ARGUMENTS",
        "FUNCTION_INCOMPATIBLE_TYPES",
        "FUNCTION_MODIFIER_NOT_FOUND",
        "FUNCTION_NESTED_AGGREGATE",
        "FUNCTION_NOT_FOUND",
        "INVALID_DATE_RANGE",
        "LIMIT_INVALID",
        "LIST_MIXED_ARGUMENT_TYPES",
        "MIXED_AGGREGATE_AND_NON_AGGREGATE",
        "NAMED_DATE_NOT_FOUND",
        "OPERATOR_INCOMPATIBLE_TYPES",
        "PRESENTMENT_NOT_FOUND",
        "REQUIRED_GROUP_BY_NOT_FOUND",
        "SEMANTICALLY_INVALID",
        "SORT_FIELD_NOT_FOUND",
        "SYNTAX_FAILED_PREDICATE",
        "SYNTAX_INPUT_MISMATCH",
        "SYNTAX_INVALID_TOKEN",
        "SYNTAX_MISSING_TOKEN",
        "SYNTAX_NOT_RECOGNIZED",
        "SYNTAX_NO_VIABLE_ALTERNATIVE",
        "SYNTAX_UNWANTED_TOKEN",
        "TABLE_NOT_FOUND",
        "TIME_FUNCTION_NOT_FOUND",
        "UNBACKFILLED_TIME_GROUP_BY_COMPARISON",
        "UNKNOWN",
        "VALUE_NOT_PARSABLE",
        "VISUALIZE_CHART_TYPE_NOT_FOUND",
        "VISUALIZE_EXCESS_PROJECTIONS",
        "VISUALIZE_GROUP_BY_MIXED_BACKFILL",
        "VISUALIZE_GROUP_BY_NOT_FOUND",
        "VISUALIZE_INCOMPATIBLE_TYPES",
    )


class PaymentCustomizationErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CUSTOM_APP_FUNCTION_NOT_ELIGIBLE",
        "FUNCTION_DOES_NOT_IMPLEMENT",
        "FUNCTION_ID_CANNOT_BE_CHANGED",
        "FUNCTION_NOT_FOUND",
        "FUNCTION_PENDING_DELETION",
        "INVALID",
        "INVALID_METAFIELDS",
        "MAXIMUM_ACTIVE_PAYMENT_CUSTOMIZATIONS",
        "PAYMENT_CUSTOMIZATION_FUNCTION_NOT_ELIGIBLE",
        "PAYMENT_CUSTOMIZATION_NOT_FOUND",
        "REQUIRED_INPUT_FIELD",
    )


class PaymentMethods(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AMERICAN_EXPRESS",
        "BITCOIN",
        "BOGUS",
        "DANKORT",
        "DINERS_CLUB",
        "DISCOVER",
        "DOGECOIN",
        "EFTPOS",
        "ELO",
        "FORBRUGSFORENINGEN",
        "INTERAC",
        "JCB",
        "LITECOIN",
        "MAESTRO",
        "MASTERCARD",
        "PAYPAL",
        "UNIONPAY",
        "VISA",
    )


class PaymentReminderSendUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PAYMENT_REMINDER_SEND_UNSUCCESSFUL",)


class PaymentTermsCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PAYMENT_TERMS_CREATION_UNSUCCESSFUL",)


class PaymentTermsDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PAYMENT_TERMS_DELETE_UNSUCCESSFUL",)


class PaymentTermsType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIXED", "FULFILLMENT", "NET", "RECEIPT", "UNKNOWN")


class PaymentTermsUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PAYMENT_TERMS_UPDATE_UNSUCCESSFUL",)


class PaypalExpressSubscriptionsGatewayStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DISABLED", "ENABLED", "PENDING")


class PriceCalculationType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COMPONENTS_SUM", "FIXED", "NONE")


class PriceListAdjustmentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PERCENTAGE_DECREASE", "PERCENTAGE_INCREASE")


class PriceListCompareAtMode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ADJUSTED", "NULLIFY")


class PriceListFixedPricesByProductBulkUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "DUPLICATE_ID_IN_INPUT",
        "ID_MUST_BE_MUTUALLY_EXCLUSIVE",
        "NO_UPDATE_OPERATIONS_SPECIFIED",
        "PRICES_TO_ADD_CURRENCY_MISMATCH",
        "PRICE_LIMIT_EXCEEDED",
        "PRICE_LIST_DOES_NOT_EXIST",
        "PRODUCT_DOES_NOT_EXIST",
    )


class PriceListPriceOriginType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIXED", "RELATIVE")


class PriceListPriceUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BLANK", "PRICE_LIST_CURRENCY_MISMATCH", "PRICE_LIST_NOT_FOUND", "PRICE_NOT_FIXED", "VARIANT_NOT_FOUND")


class PriceListSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "NAME", "RELEVANCE")


class PriceListUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_CATALOG_PRICE_LIST_ASSIGNMENT",
        "BLANK",
        "CATALOG_ASSIGNMENT_NOT_ALLOWED",
        "CATALOG_CANNOT_CHANGE_CONTEXT_TYPE",
        "CATALOG_CONTEXT_DOES_NOT_SUPPORT_QUANTITY_RULES",
        "CATALOG_DOES_NOT_EXIST",
        "CATALOG_MARKET_AND_PRICE_LIST_CURRENCY_MISMATCH",
        "CATALOG_TAKEN",
        "CONTEXT_RULE_COUNTRIES_LIMIT",
        "CONTEXT_RULE_COUNTRY_TAKEN",
        "CONTEXT_RULE_LIMIT_ONE_OPTION",
        "CONTEXT_RULE_MARKET_NOT_FOUND",
        "CONTEXT_RULE_MARKET_TAKEN",
        "COUNTRY_CURRENCY_MISMATCH",
        "COUNTRY_PRICE_LIST_ASSIGNMENT",
        "CURRENCY_COUNTRY_MISMATCH",
        "CURRENCY_MARKET_MISMATCH",
        "CURRENCY_NOT_SUPPORTED",
        "GENERIC_ERROR",
        "INCLUSION",
        "INVALID_ADJUSTMENT_MAX_VALUE",
        "INVALID_ADJUSTMENT_MIN_VALUE",
        "INVALID_ADJUSTMENT_VALUE",
        "MARKET_CURRENCY_MISMATCH",
        "PRICE_LIST_LOCKED",
        "PRICE_LIST_NOT_ALLOWED_FOR_PRIMARY_MARKET",
        "PRICE_LIST_NOT_FOUND",
        "TAKEN",
        "TOO_LONG",
    )


class PriceRuleAllocationMethod(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACROSS", "EACH")


class PriceRuleErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ALLOCATION_METHOD_MUST_BE_ACROSS_FOR_GIVEN_TARGET_SELECTION",
        "APPLIES_ON_NOTHING",
        "BLANK",
        "BOGO_INVALID_TARGET_SELECTION",
        "BOGO_INVALID_TARGET_TYPE",
        "BOGO_INVALID_VALUE_TYPE",
        "BOTH_CUSTOMER_AND_SAVED_SEARCH_PREREQUISITES_SELECTED",
        "BOTH_CUSTOMER_AND_SEGMENT_PREREQUISITES_SELECTED",
        "BOTH_SAVED_SEARCH_AND_SEGMENT_PREREQUISITES_SELECTED",
        "CANNOT_ENTITLE_COLLECTIONS_WITH_PRODUCTS_OR_VARIANTS",
        "CANNOT_PREREQUISITE_COLLECTION_WITH_PRODUCT_OR_VARIANTS",
        "CUSTOMER_PREREQUISITES_EXCEEDED_MAX",
        "CUSTOMER_PREREQUISITES_INVALID_SELECTION",
        "CUSTOMER_PREREQUISITES_MISSING",
        "CUSTOMER_PREREQUISITE_DUPLICATE",
        "CUSTOMER_SAVED_SEARCH_DUPLICATE",
        "CUSTOMER_SAVED_SEARCH_EXCEEDED_MAX",
        "CUSTOMER_SAVED_SEARCH_INVALID",
        "CUSTOMER_SEGMENT_EXCEEDED_MAX",
        "CUSTOMER_SEGMENT_INVALID",
        "CUSTOMER_SEGMENT_PREREQUISITE_DUPLICATE",
        "DISCOUNT_CODE_DUPLICATE",
        "END_DATE_BEFORE_START_DATE",
        "EQUAL_TO",
        "EXCEEDED_MAX",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL_TO",
        "INTERNAL_ERROR",
        "INVALID",
        "INVALID_COMBINES_WITH_FOR_DISCOUNT_CLASS",
        "INVALID_DISCOUNT_CLASS_FOR_PRICE_RULE",
        "INVALID_TARGET_TYPE_PREREQUISITE_SHIPPING_PRICE_RANGE",
        "ITEM_ENTITLEMENTS_DUPLICATE_COLLECTION",
        "ITEM_ENTITLEMENTS_DUPLICATE_PRODUCT",
        "ITEM_ENTITLEMENTS_DUPLICATE_VARIANT",
        "ITEM_ENTITLEMENTS_EXCEEDED_MAX_COLLECTION",
        "ITEM_ENTITLEMENTS_EXCEEDED_MAX_PRODUCT",
        "ITEM_ENTITLEMENTS_EXCEEDED_MAX_VARIANT",
        "ITEM_ENTITLEMENTS_INVALID_COLLECTION",
        "ITEM_ENTITLEMENTS_INVALID_PRODUCT",
        "ITEM_ENTITLEMENTS_INVALID_TARGET_TYPE_OR_SELECTION",
        "ITEM_ENTITLEMENTS_INVALID_VARIANT",
        "ITEM_ENTITLEMENTS_MISSING",
        "ITEM_ENTITLEMENT_INVALID_TYPE",
        "ITEM_PREREQUISITES_DUPLICATE_COLLECTION",
        "ITEM_PREREQUISITES_DUPLICATE_PRODUCT",
        "ITEM_PREREQUISITES_DUPLICATE_VARIANT",
        "ITEM_PREREQUISITES_EXCEEDED_MAX",
        "ITEM_PREREQUISITES_INVALID_COLLECTION",
        "ITEM_PREREQUISITES_INVALID_PRODUCT",
        "ITEM_PREREQUISITES_INVALID_TYPE",
        "ITEM_PREREQUISITES_INVALID_VARIANT",
        "ITEM_PREREQUISITES_MISSING",
        "ITEM_PREREQUISITES_MUST_BE_EMPTY",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL_TO",
        "MISSING_ARGUMENT",
        "MULTIPLE_RECURRING_CYCLE_LIMIT_FOR_NON_SUBSCRIPTION_ITEMS",
        "PREREQUISITE_SUBTOTAL_AND_QUANTITY_RANGE_BOTH_PRESENT",
        "PRICE_RULE_ALLOCATION_LIMIT_IS_ZERO",
        "PRICE_RULE_ALLOCATION_LIMIT_ON_NON_BOGO",
        "PRICE_RULE_EXCEEDED_MAX_DISCOUNT_CODE",
        "PRICE_RULE_PERCENTAGE_VALUE_OUTSIDE_RANGE",
        "SHIPPING_ENTITLEMENTS_DUPLICATE_COUNTRY",
        "SHIPPING_ENTITLEMENTS_EXCEEDED_MAX",
        "SHIPPING_ENTITLEMENTS_INVALID_COUNTRY",
        "SHIPPING_ENTITLEMENTS_INVALID_TARGET_TYPE_OR_SELECTION",
        "SHIPPING_ENTITLEMENTS_MISSING",
        "SHIPPING_ENTITLEMENTS_UNSUPPORTED_DESTINATION_TYPE",
        "SHOP_EXCEEDED_MAX_PRICE_RULES",
        "TAKEN",
        "TOO_LONG",
        "TOO_MANY_ARGUMENTS",
        "TOO_SHORT",
        "VARIANT_ALREADY_ENTITLED_THROUGH_PRODUCT",
    )


class PriceRuleFeature(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BULK", "BUY_ONE_GET_ONE", "BUY_ONE_GET_ONE_WITH_ALLOCATION_LIMIT", "QUANTITY_DISCOUNTS", "SPECIFIC_CUSTOMERS")


class PriceRuleShareableUrlTargetType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("COLLECTION", "HOME", "PRODUCT")


class PriceRuleSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ENDS_AT", "ID", "RELEVANCE", "STARTS_AT", "TITLE", "UPDATED_AT")


class PriceRuleStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "EXPIRED", "SCHEDULED")


class PriceRuleTarget(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("LINE_ITEM", "SHIPPING_LINE")


class PriceRuleTrait(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BULK", "BUY_ONE_GET_ONE", "BUY_ONE_GET_ONE_WITH_ALLOCATION_LIMIT", "QUANTITY_DISCOUNTS", "SPECIFIC_CUSTOMERS")


class PrivateMetafieldValueType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INTEGER", "JSON_STRING", "STRING")


class ProductChangeStatusUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PRODUCT_NOT_FOUND",)


class ProductCollectionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BEST_SELLING", "COLLECTION_DEFAULT", "CREATED", "ID", "MANUAL", "PRICE", "RELEVANCE", "TITLE")


class ProductDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GENERIC_ERROR", "PRODUCT_DOES_NOT_EXIST")


class ProductDuplicateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BUNDLES_ERROR", "EMPTY_TITLE", "EMPTY_VARIANT", "FAILED_TO_SAVE", "GENERIC_ERROR", "PRODUCT_DOES_NOT_EXIST")


class ProductFeedCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID", "TAKEN")


class ProductFeedDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID",)


class ProductFeedStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "INACTIVE")


class ProductFullSyncUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID",)


class ProductImageSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "POSITION", "RELEVANCE")


class ProductMediaSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "POSITION", "RELEVANCE")


class ProductSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "INVENTORY_TOTAL", "PRODUCT_TYPE", "PUBLISHED_AT", "RELEVANCE", "TITLE", "UPDATED_AT", "VENDOR")


class ProductStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "ARCHIVED", "DRAFT")


class ProductVariantInventoryManagement(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_SERVICE", "NOT_MANAGED", "SHOPIFY")


class ProductVariantInventoryPolicy(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CONTINUE", "DENY")


class ProductVariantRelationshipBulkUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CIRCULAR_REFERENCE",
        "DUPLICATE_PRODUCT_VARIANT_RELATIONSHIP",
        "EXCEEDED_PRODUCT_VARIANT_RELATIONSHIP_LIMIT",
        "FAILED_TO_CREATE",
        "FAILED_TO_REMOVE",
        "FAILED_TO_UPDATE",
        "FAILED_TO_UPDATE_PARENT_PRODUCT_VARIANT_PRICE",
        "INVALID_QUANTITY",
        "MUST_SPECIFY_COMPONENTS",
        "NESTED_PARENT_PRODUCT_VARIANT",
        "PARENT_PRODUCT_VARIANT_CANNOT_BE_GIFT_CARD",
        "PARENT_PRODUCT_VARIANT_CANNOT_REQUIRE_SELLING_PLAN",
        "PARENT_REQUIRED",
        "PRODUCT_EXPANDER_APP_OWNERSHIP_ALREADY_EXISTS",
        "PRODUCT_VARIANTS_NOT_COMPONENTS",
        "PRODUCT_VARIANTS_NOT_FOUND",
        "PRODUCT_VARIANT_RELATIONSHIP_TYPE_CONFLICT",
        "UNEXPECTED_ERROR",
        "UNSUPPORTED_MULTIPACK_RELATIONSHIP",
        "UPDATE_PARENT_VARIANT_PRICE_REQUIRED",
    )


class ProductVariantSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "FULL_TITLE",
        "ID",
        "INVENTORY_LEVELS_AVAILABLE",
        "INVENTORY_MANAGEMENT",
        "INVENTORY_POLICY",
        "INVENTORY_QUANTITY",
        "NAME",
        "POPULAR",
        "POSITION",
        "RELEVANCE",
        "SKU",
        "TITLE",
    )


class ProductVariantsBulkCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "GREATER_THAN_OR_EQUAL_TO",
        "INVALID",
        "MUST_BE_FOR_THIS_PRODUCT",
        "NEED_TO_ADD_OPTION_VALUES",
        "NEGATIVE_PRICE_VALUE",
        "NOT_DEFINED_FOR_SHOP",
        "NO_KEY_ON_CREATE",
        "OPTION_VALUES_FOR_NUMBER_OF_UNKNOWN_OPTIONS",
        "PRODUCT_DOES_NOT_EXIST",
        "SUBSCRIPTION_VIOLATION",
        "TOO_MANY_INVENTORY_LOCATIONS",
        "TRACKED_VARIANT_LOCATION_NOT_FOUND",
        "VARIANT_ALREADY_EXISTS",
        "VARIANT_ALREADY_EXISTS_CHANGE_OPTION_VALUE",
    )


class ProductVariantsBulkDeleteUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("AT_LEAST_ONE_VARIANT_DOES_NOT_BELONG_TO_THE_PRODUCT", "CANNOT_DELETE_LAST_VARIANT", "PRODUCT_DOES_NOT_EXIST")


class ProductVariantsBulkReorderUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DUPLICATED_VARIANT_ID", "INVALID_POSITION", "MISSING_VARIANT", "PRODUCT_DOES_NOT_EXIST")


class ProductVariantsBulkUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "GREATER_THAN_OR_EQUAL_TO",
        "NEED_TO_ADD_OPTION_VALUES",
        "NEGATIVE_PRICE_VALUE",
        "NO_INVENTORY_QUANTITES_DURING_UPDATE",
        "NO_INVENTORY_QUANTITIES_ON_VARIANTS_UPDATE",
        "OPTION_VALUES_FOR_NUMBER_OF_UNKNOWN_OPTIONS",
        "PRODUCT_DOES_NOT_EXIST",
        "PRODUCT_VARIANT_DOES_NOT_EXIST",
        "PRODUCT_VARIANT_ID_MISSING",
        "SUBSCRIPTION_VIOLATION",
        "VARIANT_ALREADY_EXISTS",
    )


class ProfileItemSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "INVENTORY_TOTAL", "PRODUCT_TYPE", "PUBLISHED_AT", "RELEVANCE", "TITLE", "UPDATED_AT", "VENDOR")


class PubSubWebhookSubscriptionCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID_PARAMETERS",)


class PubSubWebhookSubscriptionUpdateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID_PARAMETERS",)


class PublicationCreateInputPublicationDefaultState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALL_PRODUCTS", "EMPTY")


class PublicationUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "CANNOT_MODIFY_APP_CATALOG",
        "CANNOT_MODIFY_APP_CATALOG_PUBLICATION",
        "CANNOT_MODIFY_MARKET_CATALOG",
        "CANNOT_MODIFY_MARKET_CATALOG_PUBLICATION",
        "CATALOG_NOT_FOUND",
        "INVALID",
        "INVALID_PUBLISHABLE_ID",
        "MARKET_NOT_FOUND",
        "PRODUCT_TYPE_INCOMPATIBLE_WITH_CATALOG_TYPE",
        "PUBLICATION_LOCKED",
        "PUBLICATION_NOT_FOUND",
        "PUBLICATION_UPDATE_LIMIT_EXCEEDED",
        "TAKEN",
        "TOO_LONG",
        "TOO_SHORT",
        "UNSUPPORTED_PUBLICATION_ACTION",
        "UNSUPPORTED_PUBLISHABLE_TYPE",
    )


class QuantityRuleOriginType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIXED", "RELATIVE")


class QuantityRuleUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "CATALOG_CONTEXT_DOES_NOT_SUPPORT_QUANTITY_RULES",
        "GENERIC_ERROR",
        "GREATER_THAN_OR_EQUAL_TO",
        "INCREMENT_IS_GREATER_THAN_MINIMUM",
        "MAXIMUM_NOT_MULTIPLE_OF_INCREMENT",
        "MINIMUM_IS_GREATER_THAN_MAXIMUM",
        "MINIMUM_NOT_MULTIPLE_OF_INCREMENT",
        "PRICE_LIST_DOES_NOT_EXIST",
        "PRODUCT_VARIANT_DOES_NOT_EXIST",
        "VARIANT_QUANTITY_RULE_DOES_NOT_EXIST",
    )


class RefundDutyRefundType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULL", "PROPORTIONAL")


class RefundLineItemRestockType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCEL", "LEGACY_RESTOCK", "NO_RESTOCK", "RETURN")


class ResourceAlertIcon(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CHECKMARK_CIRCLE", "INFORMATION_CIRCLE")


class ResourceAlertSeverity(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CRITICAL", "DEFAULT", "INFO", "SUCCESS", "WARNING")


class ResourceFeedbackState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACCEPTED", "REQUIRES_ACTION")


class ResourceOperationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "COMPLETE", "CREATED")


class ReturnDeclineReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FINAL_SALE", "OTHER", "RETURN_PERIOD_ENDED")


class ReturnErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ALREADY_EXISTS",
        "BLANK",
        "CREATION_FAILED",
        "EQUAL_TO",
        "FEATURE_NOT_ENABLED",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL_TO",
        "INCLUSION",
        "INTERNAL_ERROR",
        "INVALID",
        "INVALID_STATE",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL_TO",
        "NOTIFICATION_FAILED",
        "NOT_A_NUMBER",
        "NOT_EDITABLE",
        "NOT_FOUND",
        "PRESENT",
        "TAKEN",
        "TOO_BIG",
        "TOO_LONG",
        "TOO_MANY_ARGUMENTS",
        "TOO_SHORT",
        "WRONG_LENGTH",
    )


class ReturnReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "COLOR",
        "DEFECTIVE",
        "NOT_AS_DESCRIBED",
        "OTHER",
        "SIZE_TOO_LARGE",
        "SIZE_TOO_SMALL",
        "STYLE",
        "UNKNOWN",
        "UNWANTED",
        "WRONG_ITEM",
    )


class ReturnStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELED", "CLOSED", "DECLINED", "OPEN", "REQUESTED")


class ReverseFulfillmentOrderDispositionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MISSING", "NOT_RESTOCKED", "PROCESSING_REQUIRED", "RESTOCKED")


class ReverseFulfillmentOrderStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELED", "CLOSED", "OPEN")


class ReverseFulfillmentOrderThirdPartyConfirmationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACCEPTED", "CANCEL_ACCEPTED", "CANCEL_REJECTED", "PENDING_ACCEPTANCE", "PENDING_CANCELATION", "REJECTED")


class SaleActionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ORDER", "RETURN", "UNKNOWN", "UPDATE")


class SaleLineType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ADDITIONAL_FEE", "ADJUSTMENT", "DUTY", "GIFT_CARD", "PRODUCT", "SHIPPING", "TIP", "UNKNOWN")


class ScriptTagDisplayScope(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALL", "ONLINE_STORE", "ORDER_STATUS")


class SearchResultType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "COLLECTION",
        "CUSTOMER",
        "DISCOUNT_REDEEM_CODE",
        "DRAFT_ORDER",
        "FILE",
        "ONLINE_STORE_ARTICLE",
        "ONLINE_STORE_BLOG",
        "ONLINE_STORE_PAGE",
        "ORDER",
        "PRICE_RULE",
        "PRODUCT",
        "URL_REDIRECT",
    )


class SegmentSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATION_DATE", "ID", "LAST_EDIT_DATE", "RELEVANCE")


class SellingPlanAnchorType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("MONTHDAY", "WEEKDAY", "YEARDAY")


class SellingPlanCategory(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("OTHER", "PRE_ORDER", "SUBSCRIPTION", "TRY_BEFORE_YOU_BUY")


class SellingPlanCheckoutChargeType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PERCENTAGE", "PRICE")


class SellingPlanFixedDeliveryPolicyIntent(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_BEGIN",)


class SellingPlanFixedDeliveryPolicyPreAnchorBehavior(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ASAP", "NEXT")


class SellingPlanFulfillmentTrigger(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ANCHOR", "ASAP", "EXACT_TIME", "UNKNOWN")


class SellingPlanGroupSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "NAME", "RELEVANCE", "UPDATED_AT")


class SellingPlanGroupUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BILLING_AND_DELIVERY_POLICY_TYPES_MUST_BE_THE_SAME",
        "BLANK",
        "CHECKOUT_CHARGE_VALUE_AND_TYPE_MUST_MATCH",
        "EQUAL_TO",
        "ERROR_ADDING_RESOURCE_TO_GROUP",
        "FULFILLMENT_EXACT_TIME_NOT_ALLOWED",
        "FULFILLMENT_EXACT_TIME_REQUIRED",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL_TO",
        "GROUP_COULD_NOT_BE_DELETED",
        "GROUP_DOES_NOT_EXIST",
        "INCLUSION",
        "INVALID",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL_TO",
        "NOT_A_NUMBER",
        "NOT_FOUND",
        "ONLY_NEED_ONE_BILLING_POLICY_TYPE",
        "ONLY_NEED_ONE_CHECKOUT_CHARGE_VALUE",
        "ONLY_NEED_ONE_DELIVERY_POLICY_TYPE",
        "ONLY_NEED_ONE_PRICING_POLICY_TYPE",
        "ONLY_NEED_ONE_PRICING_POLICY_VALUE",
        "ONLY_ONE_OF_FIXED_OR_RECURRING_BILLING",
        "ONLY_ONE_OF_FIXED_OR_RECURRING_DELIVERY",
        "PLAN_DOES_NOT_EXIST",
        "PLAN_ID_MUST_BE_SPECIFIED_TO_UPDATE",
        "PRESENT",
        "PRICING_POLICY_ADJUSTMENT_VALUE_AND_TYPE_MUST_MATCH",
        "PRODUCT_DOES_NOT_EXIST",
        "PRODUCT_VARIANT_DOES_NOT_EXIST",
        "REMAINING_BALANCE_CHARGE_EXACT_TIME_NOT_ALLOWED",
        "REMAINING_BALANCE_CHARGE_EXACT_TIME_REQUIRED",
        "REMAINING_BALANCE_CHARGE_TIME_AFTER_CHECKOUT_MUST_BE_GREATER_THAN_ZERO",
        "REMAINING_BALANCE_CHARGE_TRIGGER_NO_REMAINING_BALANCE_ON_PARTIAL_PERCENTAGE_CHECKOUT_CHARGE",
        "REMAINING_BALANCE_CHARGE_TRIGGER_NO_REMAINING_BALANCE_ON_PRICE_CHECKOUT_CHARGE",
        "REMAINING_BALANCE_CHARGE_TRIGGER_ON_FULL_CHECKOUT",
        "RESOURCE_LIST_CONTAINS_INVALID_IDS",
        "SELLING_PLAN_ANCHORS_NOT_ALLOWED",
        "SELLING_PLAN_ANCHORS_REQUIRED",
        "SELLING_PLAN_BILLING_AND_DELIVERY_POLICY_ANCHORS_MUST_BE_EQUAL",
        "SELLING_PLAN_BILLING_CYCLE_MUST_BE_A_MULTIPLE_OF_DELIVERY_CYCLE",
        "SELLING_PLAN_BILLING_POLICY_MISSING",
        "SELLING_PLAN_COUNT_LOWER_BOUND",
        "SELLING_PLAN_COUNT_UPPER_BOUND",
        "SELLING_PLAN_DELIVERY_POLICY_MISSING",
        "SELLING_PLAN_DUPLICATE_NAME",
        "SELLING_PLAN_DUPLICATE_OPTIONS",
        "SELLING_PLAN_FIXED_PRICING_POLICIES_LIMIT",
        "SELLING_PLAN_MAX_CYCLES_MUST_BE_GREATER_THAN_MIN_CYCLES",
        "SELLING_PLAN_MISSING_OPTION2_LABEL_ON_PARENT_GROUP",
        "SELLING_PLAN_MISSING_OPTION3_LABEL_ON_PARENT_GROUP",
        "SELLING_PLAN_OPTION2_REQUIRED_AS_DEFINED_ON_PARENT_GROUP",
        "SELLING_PLAN_OPTION3_REQUIRED_AS_DEFINED_ON_PARENT_GROUP",
        "SELLING_PLAN_PRICING_POLICIES_LIMIT",
        "SELLING_PLAN_PRICING_POLICIES_MUST_CONTAIN_A_FIXED_PRICING_POLICY",
        "TAKEN",
        "TOO_BIG",
        "TOO_LONG",
        "TOO_SHORT",
        "WRONG_LENGTH",
    )


class SellingPlanInterval(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DAY", "MONTH", "WEEK", "YEAR")


class SellingPlanPricingPolicyAdjustmentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FIXED_AMOUNT", "PERCENTAGE", "PRICE")


class SellingPlanRecurringDeliveryPolicyIntent(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FULFILLMENT_BEGIN",)


class SellingPlanRecurringDeliveryPolicyPreAnchorBehavior(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ASAP", "NEXT")


class SellingPlanRemainingBalanceChargeTrigger(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("EXACT_TIME", "NO_REMAINING_BALANCE", "TIME_AFTER_CHECKOUT")


class SellingPlanReserve(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ON_FULFILLMENT", "ON_SALE")


class ServerPixelStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CONNECTED", "DISCONNECTED_CONFIGURED", "DISCONNECTED_UNCONFIGURED")


class ShippingDiscountClass(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("SHIPPING",)


class ShippingPackageType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BOX", "ENVELOPE", "FLAT_RATE", "SOFT_PACK")


class ShopBranding(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ROGERS", "SHOPIFY", "SHOPIFY_GOLD", "SHOPIFY_PLUS")


class ShopCustomerAccountsSetting(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DISABLED", "OPTIONAL", "REQUIRED")


class ShopPolicyErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("TOO_BIG",)


class ShopPolicyType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CONTACT_INFORMATION",
        "LEGAL_NOTICE",
        "PRIVACY_POLICY",
        "REFUND_POLICY",
        "SHIPPING_POLICY",
        "SUBSCRIPTION_POLICY",
        "TERMS_OF_SALE",
        "TERMS_OF_SERVICE",
    )


class ShopResourceFeedbackCreateUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BLANK", "INVALID", "OUTDATED_FEEDBACK", "PRESENT")


class ShopTagSort(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALPHABETICAL", "POPULAR")


class ShopifyPaymentsBankAccountStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ERRORED", "NEW", "VALIDATED", "VERIFIED")


class ShopifyPaymentsDisputeEvidenceFileType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CANCELLATION_POLICY_FILE",
        "CUSTOMER_COMMUNICATION_FILE",
        "REFUND_POLICY_FILE",
        "SERVICE_DOCUMENTATION_FILE",
        "SHIPPING_DOCUMENTATION_FILE",
        "UNCATEGORIZED_FILE",
    )


class ShopifyPaymentsDisputeReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BANK_CANNOT_PROCESS",
        "CREDIT_NOT_PROCESSED",
        "CUSTOMER_INITIATED",
        "DEBIT_NOT_AUTHORIZED",
        "DUPLICATE",
        "FRAUDULENT",
        "GENERAL",
        "INCORRECT_ACCOUNT_DETAILS",
        "INSUFFICIENT_FUNDS",
        "PRODUCT_NOT_RECEIVED",
        "PRODUCT_UNACCEPTABLE",
        "SUBSCRIPTION_CANCELLED",
        "UNRECOGNIZED",
    )


class ShopifyPaymentsPayoutInterval(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DAILY", "MANUAL", "MONTHLY", "WEEKLY")


class ShopifyPaymentsPayoutStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CANCELED", "FAILED", "IN_TRANSIT", "PAID", "SCHEDULED")


class ShopifyPaymentsPayoutTransactionType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DEPOSIT", "WITHDRAWAL")


class ShopifyPaymentsVerificationDocumentType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DRIVERS_LICENSE", "GOVERNMENT_IDENTIFICATION", "PASSPORT")


class ShopifyPaymentsVerificationStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("PENDING", "UNVERIFIED", "VERIFIED")


class StaffMemberDefaultImage(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("DEFAULT", "NOT_FOUND", "TRANSPARENT")


class StaffMemberPermission(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APPLICATIONS",
        "CHANNELS",
        "CUSTOMERS",
        "DASHBOARD",
        "DOMAINS",
        "DRAFT_ORDERS",
        "EDIT_ORDERS",
        "GIFT_CARDS",
        "LINKS",
        "LOCATIONS",
        "MARKETING",
        "MARKETING_SECTION",
        "ORDERS",
        "OVERVIEWS",
        "PAGES",
        "PAY_ORDERS_BY_VAULTED_CARD",
        "PREFERENCES",
        "PRODUCTS",
        "REPORTS",
        "THEMES",
    )


class StagedUploadHttpMethodType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("POST", "PUT")


class StagedUploadTargetGenerateUploadResource(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BULK_MUTATION_VARIABLES",
        "COLLECTION_IMAGE",
        "FILE",
        "IMAGE",
        "MODEL_3D",
        "PRODUCT_IMAGE",
        "RETURN_LABEL",
        "SHOP_IMAGE",
        "URL_REDIRECT_IMPORT",
        "VIDEO",
    )


class StandardMetafieldDefinitionEnableUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "INVALID",
        "LIMIT_EXCEEDED",
        "TAKEN",
        "TEMPLATE_NOT_FOUND",
        "TYPE_NOT_ALLOWED_FOR_CONDITIONS",
        "UNSTRUCTURED_ALREADY_EXISTS",
    )


class StorefrontID(sgqlc.types.Scalar):
    __schema__ = shopify_schema


String = sgqlc.types.String


class SubscriptionBillingAttemptErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "AMOUNT_TOO_SMALL",
        "AUTHENTICATION_ERROR",
        "BUYER_CANCELED_PAYMENT_METHOD",
        "CUSTOMER_INVALID",
        "CUSTOMER_NOT_FOUND",
        "EXPIRED_PAYMENT_METHOD",
        "INVALID_CUSTOMER_BILLING_AGREEMENT",
        "INVALID_PAYMENT_METHOD",
        "INVALID_SHIPPING_ADDRESS",
        "INVENTORY_ALLOCATIONS_NOT_FOUND",
        "INVOICE_ALREADY_PAID",
        "PAYMENT_METHOD_DECLINED",
        "PAYMENT_METHOD_INCOMPATIBLE_WITH_GATEWAY_CONFIG",
        "PAYMENT_METHOD_NOT_FOUND",
        "PAYMENT_PROVIDER_IS_NOT_ENABLED",
        "TEST_MODE",
        "TRANSIENT_ERROR",
        "UNEXPECTED_ERROR",
    )


class SubscriptionBillingAttemptsSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class SubscriptionBillingCycleBillingCycleStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BILLED", "UNBILLED")


class SubscriptionBillingCycleErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BILLING_DATE_SET_ON_SKIPPED",
        "CYCLE_INDEX_OUT_OF_RANGE",
        "CYCLE_NOT_FOUND",
        "CYCLE_START_DATE_OUT_OF_RANGE",
        "EMPTY_BILLING_CYCLE_EDIT_SCHEDULE_INPUT",
        "INCOMPLETE_BILLING_ATTEMPTS",
        "INVALID",
        "INVALID_CYCLE_INDEX",
        "INVALID_DATE",
        "NO_CYCLE_EDITS",
        "OUT_OF_BOUNDS",
        "UPCOMING_CYCLE_LIMIT_EXCEEDED",
    )


class SubscriptionBillingCycleScheduleEditInputScheduleEditReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BUYER_INITIATED", "DEV_INITIATED", "MERCHANT_INITIATED")


class SubscriptionBillingCyclesSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CYCLE_INDEX", "ID", "RELEVANCE")


class SubscriptionBillingCyclesTargetSelection(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALL",)


class SubscriptionContractErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID",)


class SubscriptionContractLastPaymentStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("FAILED", "SUCCEEDED")


class SubscriptionContractSubscriptionStatus(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "CANCELLED", "EXPIRED", "FAILED", "PAUSED", "STALE")


class SubscriptionDiscountRejectionReason(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CURRENTLY_INACTIVE",
        "CUSTOMER_NOT_ELIGIBLE",
        "CUSTOMER_USAGE_LIMIT_REACHED",
        "INCOMPATIBLE_PURCHASE_TYPE",
        "INTERNAL_ERROR",
        "NOT_FOUND",
        "NO_ENTITLED_LINE_ITEMS",
        "NO_ENTITLED_SHIPPING_LINES",
        "PURCHASE_NOT_IN_RANGE",
        "QUANTITY_NOT_IN_RANGE",
        "USAGE_LIMIT_REACHED",
    )


class SubscriptionDraftErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "ALREADY_REMOVED",
        "BILLING_CYCLE_ABSENT",
        "BILLING_CYCLE_CONTRACT_DRAFT_BILLING_POLICY_INVALID",
        "BILLING_CYCLE_CONTRACT_DRAFT_DELIVERY_POLICY_INVALID",
        "BILLING_CYCLE_PRESENT",
        "BLANK",
        "COMMITTED",
        "CONCATENATION_BILLING_CYCLE_CONTRACT_DRAFT_REQUIRED",
        "CURRENCY_NOT_ENABLED",
        "CUSTOMER_DOES_NOT_EXIST",
        "CUSTOMER_MISMATCH",
        "CYCLE_DISCOUNTS_UNIQUE_AFTER_CYCLE",
        "CYCLE_INDEX_OUT_OF_RANGE",
        "CYCLE_SELECTOR_VALIDATE_ONE_OF",
        "CYCLE_START_DATE_OUT_OF_RANGE",
        "DELIVERY_METHOD_REQUIRED",
        "DELIVERY_MUST_BE_MULTIPLE_OF_BILLING",
        "DUPLICATE_CONCATENATED_CONTRACTS",
        "EXCEEDED_MAX_CONCATENATED_CONTRACTS",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL_TO",
        "HAS_FUTURE_EDITS",
        "INVALID",
        "INVALID_ADJUSTMENT_TYPE",
        "INVALID_ADJUSTMENT_VALUE",
        "INVALID_BILLING_DATE",
        "INVALID_LINES",
        "INVALID_NOTE_LENGTH",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL_TO",
        "MISSING_LOCAL_DELIVERY_OPTIONS",
        "NOT_AN_INTEGER",
        "NOT_IN_RANGE",
        "NO_ENTITLED_LINES",
        "PRESENCE",
        "SELLING_PLAN_MAX_CYCLES_MUST_BE_GREATER_THAN_MIN_CYCLES",
        "STALE_CONTRACT",
        "TOO_LONG",
        "TOO_SHORT",
        "UPCOMING_CYCLE_LIMIT_EXCEEDED",
    )


class SuggestedOrderTransactionKind(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("SUGGESTED_REFUND",)


class TaxAppConfigureUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("TAX_PARTNER_ALREADY_ACTIVE", "TAX_PARTNER_NOT_FOUND", "TAX_PARTNER_STATE_UPDATE_FAILED")


class TaxExemption(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "CA_BC_COMMERCIAL_FISHERY_EXEMPTION",
        "CA_BC_CONTRACTOR_EXEMPTION",
        "CA_BC_PRODUCTION_AND_MACHINERY_EXEMPTION",
        "CA_BC_RESELLER_EXEMPTION",
        "CA_BC_SUB_CONTRACTOR_EXEMPTION",
        "CA_DIPLOMAT_EXEMPTION",
        "CA_MB_COMMERCIAL_FISHERY_EXEMPTION",
        "CA_MB_FARMER_EXEMPTION",
        "CA_MB_RESELLER_EXEMPTION",
        "CA_NS_COMMERCIAL_FISHERY_EXEMPTION",
        "CA_NS_FARMER_EXEMPTION",
        "CA_ON_PURCHASE_EXEMPTION",
        "CA_PE_COMMERCIAL_FISHERY_EXEMPTION",
        "CA_SK_COMMERCIAL_FISHERY_EXEMPTION",
        "CA_SK_CONTRACTOR_EXEMPTION",
        "CA_SK_FARMER_EXEMPTION",
        "CA_SK_PRODUCTION_AND_MACHINERY_EXEMPTION",
        "CA_SK_RESELLER_EXEMPTION",
        "CA_SK_SUB_CONTRACTOR_EXEMPTION",
        "CA_STATUS_CARD_EXEMPTION",
        "EU_REVERSE_CHARGE_EXEMPTION_RULE",
        "US_AK_RESELLER_EXEMPTION",
        "US_AL_RESELLER_EXEMPTION",
        "US_AR_RESELLER_EXEMPTION",
        "US_AZ_RESELLER_EXEMPTION",
        "US_CA_RESELLER_EXEMPTION",
        "US_CO_RESELLER_EXEMPTION",
        "US_CT_RESELLER_EXEMPTION",
        "US_DC_RESELLER_EXEMPTION",
        "US_DE_RESELLER_EXEMPTION",
        "US_FL_RESELLER_EXEMPTION",
        "US_GA_RESELLER_EXEMPTION",
        "US_HI_RESELLER_EXEMPTION",
        "US_IA_RESELLER_EXEMPTION",
        "US_ID_RESELLER_EXEMPTION",
        "US_IL_RESELLER_EXEMPTION",
        "US_IN_RESELLER_EXEMPTION",
        "US_KS_RESELLER_EXEMPTION",
        "US_KY_RESELLER_EXEMPTION",
        "US_LA_RESELLER_EXEMPTION",
        "US_MA_RESELLER_EXEMPTION",
        "US_MD_RESELLER_EXEMPTION",
        "US_ME_RESELLER_EXEMPTION",
        "US_MI_RESELLER_EXEMPTION",
        "US_MN_RESELLER_EXEMPTION",
        "US_MO_RESELLER_EXEMPTION",
        "US_MS_RESELLER_EXEMPTION",
        "US_MT_RESELLER_EXEMPTION",
        "US_NC_RESELLER_EXEMPTION",
        "US_ND_RESELLER_EXEMPTION",
        "US_NE_RESELLER_EXEMPTION",
        "US_NH_RESELLER_EXEMPTION",
        "US_NJ_RESELLER_EXEMPTION",
        "US_NM_RESELLER_EXEMPTION",
        "US_NV_RESELLER_EXEMPTION",
        "US_NY_RESELLER_EXEMPTION",
        "US_OH_RESELLER_EXEMPTION",
        "US_OK_RESELLER_EXEMPTION",
        "US_OR_RESELLER_EXEMPTION",
        "US_PA_RESELLER_EXEMPTION",
        "US_RI_RESELLER_EXEMPTION",
        "US_SC_RESELLER_EXEMPTION",
        "US_SD_RESELLER_EXEMPTION",
        "US_TN_RESELLER_EXEMPTION",
        "US_TX_RESELLER_EXEMPTION",
        "US_UT_RESELLER_EXEMPTION",
        "US_VA_RESELLER_EXEMPTION",
        "US_VT_RESELLER_EXEMPTION",
        "US_WA_RESELLER_EXEMPTION",
        "US_WI_RESELLER_EXEMPTION",
        "US_WV_RESELLER_EXEMPTION",
        "US_WY_RESELLER_EXEMPTION",
    )


class TaxPartnerState(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ACTIVE", "PENDING", "READY")


class TranslatableResourceType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "COLLECTION",
        "DELIVERY_METHOD_DEFINITION",
        "EMAIL_TEMPLATE",
        "FILTER",
        "LINK",
        "METAFIELD",
        "METAOBJECT",
        "ONLINE_STORE_ARTICLE",
        "ONLINE_STORE_BLOG",
        "ONLINE_STORE_MENU",
        "ONLINE_STORE_PAGE",
        "ONLINE_STORE_THEME",
        "PACKING_SLIP_TEMPLATE",
        "PAYMENT_GATEWAY",
        "PRODUCT",
        "PRODUCT_OPTION",
        "PRODUCT_VARIANT",
        "SELLING_PLAN",
        "SELLING_PLAN_GROUP",
        "SHOP",
        "SHOP_POLICY",
    )


class TranslationErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "BLANK",
        "FAILS_RESOURCE_VALIDATION",
        "INVALID",
        "INVALID_CODE",
        "INVALID_FORMAT",
        "INVALID_KEY_FOR_MODEL",
        "INVALID_LOCALE_FOR_MARKET",
        "INVALID_LOCALE_FOR_SHOP",
        "INVALID_MARKET_LOCALIZABLE_CONTENT",
        "INVALID_TRANSLATABLE_CONTENT",
        "INVALID_VALUE_FOR_HANDLE_TRANSLATION",
        "MARKET_CUSTOM_CONTENT_NOT_ALLOWED",
        "MARKET_DOES_NOT_EXIST",
        "MARKET_LOCALE_CREATION_FAILED",
        "RESOURCE_NOT_FOUND",
        "RESOURCE_NOT_MARKET_CUSTOMIZABLE",
        "RESOURCE_NOT_TRANSLATABLE",
        "TOO_MANY_KEYS_FOR_RESOURCE",
    )


class URL(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class UnitSystem(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("IMPERIAL_SYSTEM", "METRIC_SYSTEM")


class UnsignedInt64(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class UrlRedirectBulkDeleteByIdsUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("IDS_EMPTY",)


class UrlRedirectBulkDeleteBySavedSearchUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID_SAVED_SEARCH_QUERY", "SAVED_SEARCH_NOT_FOUND")


class UrlRedirectBulkDeleteBySearchUserErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("INVALID_SEARCH_ARGUMENT",)


class UrlRedirectErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATE_FAILED", "DELETE_FAILED", "DOES_NOT_EXIST", "UPDATE_FAILED")


class UrlRedirectImportErrorCode(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ALREADY_IMPORTED", "IN_PROGRESS", "NOT_FOUND")


class UrlRedirectSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("ID", "PATH", "RELEVANCE")


class UtcOffset(sgqlc.types.Scalar):
    __schema__ = shopify_schema


class VisualizationType(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("BAR", "LINE")


class WebhookSubscriptionFormat(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("JSON", "XML")


class WebhookSubscriptionSortKeys(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("CREATED_AT", "ID", "RELEVANCE")


class WebhookSubscriptionTopic(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = (
        "APP_PURCHASES_ONE_TIME_UPDATE",
        "APP_SUBSCRIPTIONS_APPROACHING_CAPPED_AMOUNT",
        "APP_SUBSCRIPTIONS_UPDATE",
        "APP_UNINSTALLED",
        "ATTRIBUTED_SESSIONS_FIRST",
        "ATTRIBUTED_SESSIONS_LAST",
        "AUDIT_EVENTS_ADMIN_API_ACTIVITY",
        "BULK_OPERATIONS_FINISH",
        "CARTS_CREATE",
        "CARTS_UPDATE",
        "CHANNELS_DELETE",
        "CHECKOUTS_CREATE",
        "CHECKOUTS_DELETE",
        "CHECKOUTS_UPDATE",
        "COLLECTIONS_CREATE",
        "COLLECTIONS_DELETE",
        "COLLECTIONS_UPDATE",
        "COLLECTION_LISTINGS_ADD",
        "COLLECTION_LISTINGS_REMOVE",
        "COLLECTION_LISTINGS_UPDATE",
        "COLLECTION_PUBLICATIONS_CREATE",
        "COLLECTION_PUBLICATIONS_DELETE",
        "COLLECTION_PUBLICATIONS_UPDATE",
        "COMPANIES_CREATE",
        "COMPANIES_DELETE",
        "COMPANIES_UPDATE",
        "COMPANY_CONTACTS_CREATE",
        "COMPANY_CONTACTS_DELETE",
        "COMPANY_CONTACTS_UPDATE",
        "COMPANY_CONTACT_ROLES_ASSIGN",
        "COMPANY_CONTACT_ROLES_REVOKE",
        "COMPANY_LOCATIONS_CREATE",
        "COMPANY_LOCATIONS_DELETE",
        "COMPANY_LOCATIONS_UPDATE",
        "CUSTOMERS_CREATE",
        "CUSTOMERS_DELETE",
        "CUSTOMERS_DISABLE",
        "CUSTOMERS_EMAIL_MARKETING_CONSENT_UPDATE",
        "CUSTOMERS_ENABLE",
        "CUSTOMERS_MARKETING_CONSENT_UPDATE",
        "CUSTOMERS_MERGE",
        "CUSTOMERS_UPDATE",
        "CUSTOMER_GROUPS_CREATE",
        "CUSTOMER_GROUPS_DELETE",
        "CUSTOMER_GROUPS_UPDATE",
        "CUSTOMER_PAYMENT_METHODS_CREATE",
        "CUSTOMER_PAYMENT_METHODS_REVOKE",
        "CUSTOMER_PAYMENT_METHODS_UPDATE",
        "CUSTOMER_TAGS_ADDED",
        "CUSTOMER_TAGS_REMOVED",
        "DISPUTES_CREATE",
        "DISPUTES_UPDATE",
        "DOMAINS_CREATE",
        "DOMAINS_DESTROY",
        "DOMAINS_UPDATE",
        "DRAFT_ORDERS_CREATE",
        "DRAFT_ORDERS_DELETE",
        "DRAFT_ORDERS_UPDATE",
        "FULFILLMENTS_CREATE",
        "FULFILLMENTS_UPDATE",
        "FULFILLMENT_EVENTS_CREATE",
        "FULFILLMENT_EVENTS_DELETE",
        "FULFILLMENT_ORDERS_CANCELLATION_REQUEST_ACCEPTED",
        "FULFILLMENT_ORDERS_CANCELLATION_REQUEST_REJECTED",
        "FULFILLMENT_ORDERS_CANCELLATION_REQUEST_SUBMITTED",
        "FULFILLMENT_ORDERS_CANCELLED",
        "FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_ACCEPTED",
        "FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_REJECTED",
        "FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_SUBMITTED",
        "FULFILLMENT_ORDERS_FULFILLMENT_SERVICE_FAILED_TO_COMPLETE",
        "FULFILLMENT_ORDERS_HOLD_RELEASED",
        "FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_LOCAL_DELIVERY",
        "FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_PICKUP",
        "FULFILLMENT_ORDERS_MOVED",
        "FULFILLMENT_ORDERS_ORDER_ROUTING_COMPLETE",
        "FULFILLMENT_ORDERS_PLACED_ON_HOLD",
        "FULFILLMENT_ORDERS_RESCHEDULED",
        "FULFILLMENT_ORDERS_SCHEDULED_FULFILLMENT_ORDER_READY",
        "INVENTORY_ITEMS_CREATE",
        "INVENTORY_ITEMS_DELETE",
        "INVENTORY_ITEMS_UPDATE",
        "INVENTORY_LEVELS_CONNECT",
        "INVENTORY_LEVELS_DISCONNECT",
        "INVENTORY_LEVELS_UPDATE",
        "LOCALES_CREATE",
        "LOCALES_UPDATE",
        "LOCATIONS_ACTIVATE",
        "LOCATIONS_CREATE",
        "LOCATIONS_DEACTIVATE",
        "LOCATIONS_DELETE",
        "LOCATIONS_UPDATE",
        "MARKETS_CREATE",
        "MARKETS_DELETE",
        "MARKETS_UPDATE",
        "ORDERS_CANCELLED",
        "ORDERS_CREATE",
        "ORDERS_DELETE",
        "ORDERS_EDITED",
        "ORDERS_FULFILLED",
        "ORDERS_PAID",
        "ORDERS_PARTIALLY_FULFILLED",
        "ORDERS_UPDATED",
        "ORDER_TRANSACTIONS_CREATE",
        "PAYMENT_SCHEDULES_DUE",
        "PAYMENT_TERMS_CREATE",
        "PAYMENT_TERMS_DELETE",
        "PAYMENT_TERMS_UPDATE",
        "PRODUCTS_CREATE",
        "PRODUCTS_DELETE",
        "PRODUCTS_UPDATE",
        "PRODUCT_FEEDS_CREATE",
        "PRODUCT_FEEDS_FULL_SYNC",
        "PRODUCT_FEEDS_INCREMENTAL_SYNC",
        "PRODUCT_FEEDS_UPDATE",
        "PRODUCT_LISTINGS_ADD",
        "PRODUCT_LISTINGS_REMOVE",
        "PRODUCT_LISTINGS_UPDATE",
        "PRODUCT_PUBLICATIONS_CREATE",
        "PRODUCT_PUBLICATIONS_DELETE",
        "PRODUCT_PUBLICATIONS_UPDATE",
        "PROFILES_CREATE",
        "PROFILES_DELETE",
        "PROFILES_UPDATE",
        "REFUNDS_CREATE",
        "RETURNS_APPROVE",
        "RETURNS_CANCEL",
        "RETURNS_CLOSE",
        "RETURNS_DECLINE",
        "RETURNS_REOPEN",
        "RETURNS_REQUEST",
        "REVERSE_DELIVERIES_ATTACH_DELIVERABLE",
        "REVERSE_FULFILLMENT_ORDERS_DISPOSE",
        "SCHEDULED_PRODUCT_LISTINGS_ADD",
        "SCHEDULED_PRODUCT_LISTINGS_REMOVE",
        "SCHEDULED_PRODUCT_LISTINGS_UPDATE",
        "SEGMENTS_CREATE",
        "SEGMENTS_DELETE",
        "SEGMENTS_UPDATE",
        "SELLING_PLAN_GROUPS_CREATE",
        "SELLING_PLAN_GROUPS_DELETE",
        "SELLING_PLAN_GROUPS_UPDATE",
        "SHIPPING_ADDRESSES_CREATE",
        "SHIPPING_ADDRESSES_UPDATE",
        "SHOP_UPDATE",
        "SUBSCRIPTION_BILLING_ATTEMPTS_CHALLENGED",
        "SUBSCRIPTION_BILLING_ATTEMPTS_FAILURE",
        "SUBSCRIPTION_BILLING_ATTEMPTS_SUCCESS",
        "SUBSCRIPTION_BILLING_CYCLE_EDITS_CREATE",
        "SUBSCRIPTION_BILLING_CYCLE_EDITS_DELETE",
        "SUBSCRIPTION_BILLING_CYCLE_EDITS_UPDATE",
        "SUBSCRIPTION_CONTRACTS_CREATE",
        "SUBSCRIPTION_CONTRACTS_UPDATE",
        "TAX_PARTNERS_UPDATE",
        "TAX_SERVICES_CREATE",
        "TAX_SERVICES_UPDATE",
        "TENDER_TRANSACTIONS_CREATE",
        "THEMES_CREATE",
        "THEMES_DELETE",
        "THEMES_PUBLISH",
        "THEMES_UPDATE",
        "VARIANTS_IN_STOCK",
        "VARIANTS_OUT_OF_STOCK",
    )


class WeightUnit(sgqlc.types.Enum):
    __schema__ = shopify_schema
    __choices__ = ("GRAMS", "KILOGRAMS", "OUNCES", "POUNDS")


########################################################################
# Input Objects
########################################################################
class AppPlanInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("app_usage_pricing_details", "app_recurring_pricing_details")
    app_usage_pricing_details = sgqlc.types.Field("AppUsagePricingInput", graphql_name="appUsagePricingDetails")
    app_recurring_pricing_details = sgqlc.types.Field("AppRecurringPricingInput", graphql_name="appRecurringPricingDetails")


class AppRecurringPricingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "price", "discount")
    interval = sgqlc.types.Field(AppPricingInterval, graphql_name="interval")
    price = sgqlc.types.Field(sgqlc.types.non_null("MoneyInput"), graphql_name="price")
    discount = sgqlc.types.Field("AppSubscriptionDiscountInput", graphql_name="discount")


class AppRevenueAttributionRecordInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("idempotency_key", "captured_at", "amount", "type", "test")
    idempotency_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="idempotencyKey")
    captured_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="capturedAt")
    amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyInput"), graphql_name="amount")
    type = sgqlc.types.Field(sgqlc.types.non_null(AppRevenueAttributionType), graphql_name="type")
    test = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="test")


class AppSubscriptionDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "duration_limit_in_intervals")
    value = sgqlc.types.Field("AppSubscriptionDiscountValueInput", graphql_name="value")
    duration_limit_in_intervals = sgqlc.types.Field(Int, graphql_name="durationLimitInIntervals")


class AppSubscriptionDiscountValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage", "amount")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")
    amount = sgqlc.types.Field(Decimal, graphql_name="amount")


class AppSubscriptionLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("plan",)
    plan = sgqlc.types.Field(sgqlc.types.non_null(AppPlanInput), graphql_name="plan")


class AppUsagePricingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("capped_amount", "terms")
    capped_amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyInput"), graphql_name="cappedAmount")
    terms = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="terms")


class AttributeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class BuyerExperienceConfigurationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("checkout_to_draft", "payment_terms_template_id", "editable_shipping_address")
    checkout_to_draft = sgqlc.types.Field(Boolean, graphql_name="checkoutToDraft")
    payment_terms_template_id = sgqlc.types.Field(ID, graphql_name="paymentTermsTemplateId")
    editable_shipping_address = sgqlc.types.Field(Boolean, graphql_name="editableShippingAddress")


class CatalogContextInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("company_location_ids",)
    company_location_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="companyLocationIds")


class CatalogCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "status", "context", "price_list_id", "publication_id")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    status = sgqlc.types.Field(sgqlc.types.non_null(CatalogStatus), graphql_name="status")
    context = sgqlc.types.Field(sgqlc.types.non_null(CatalogContextInput), graphql_name="context")
    price_list_id = sgqlc.types.Field(ID, graphql_name="priceListId")
    publication_id = sgqlc.types.Field(ID, graphql_name="publicationId")


class CatalogUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "status", "context", "price_list_id", "publication_id")
    title = sgqlc.types.Field(String, graphql_name="title")
    status = sgqlc.types.Field(CatalogStatus, graphql_name="status")
    context = sgqlc.types.Field(CatalogContextInput, graphql_name="context")
    price_list_id = sgqlc.types.Field(ID, graphql_name="priceListId")
    publication_id = sgqlc.types.Field(ID, graphql_name="publicationId")


class CollectionDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class CollectionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "description_html",
        "handle",
        "id",
        "image",
        "products",
        "rule_set",
        "template_suffix",
        "sort_order",
        "title",
        "metafields",
        "seo",
        "redirect_new_handle",
    )
    description_html = sgqlc.types.Field(String, graphql_name="descriptionHtml")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    id = sgqlc.types.Field(ID, graphql_name="id")
    image = sgqlc.types.Field("ImageInput", graphql_name="image")
    products = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="products")
    rule_set = sgqlc.types.Field("CollectionRuleSetInput", graphql_name="ruleSet")
    template_suffix = sgqlc.types.Field(String, graphql_name="templateSuffix")
    sort_order = sgqlc.types.Field(CollectionSortOrder, graphql_name="sortOrder")
    title = sgqlc.types.Field(String, graphql_name="title")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")
    seo = sgqlc.types.Field("SEOInput", graphql_name="seo")
    redirect_new_handle = sgqlc.types.Field(Boolean, graphql_name="redirectNewHandle")


class CollectionPublicationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publication_id",)
    publication_id = sgqlc.types.Field(ID, graphql_name="publicationId")


class CollectionPublishInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "collection_publications")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    collection_publications = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionPublicationInput))), graphql_name="collectionPublications"
    )


class CollectionRuleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("column", "relation", "condition", "condition_object_id")
    column = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleColumn), graphql_name="column")
    relation = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleRelation), graphql_name="relation")
    condition = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="condition")
    condition_object_id = sgqlc.types.Field(ID, graphql_name="conditionObjectId")


class CollectionRuleSetInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("applied_disjunctively", "rules")
    applied_disjunctively = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliedDisjunctively")
    rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(CollectionRuleInput)), graphql_name="rules")


class CollectionUnpublishInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "collection_publications")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    collection_publications = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionPublicationInput))), graphql_name="collectionPublications"
    )


class CompanyAddressInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "zip", "recipient", "phone", "zone_code", "country_code")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    zip = sgqlc.types.Field(String, graphql_name="zip")
    recipient = sgqlc.types.Field(String, graphql_name="recipient")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    zone_code = sgqlc.types.Field(String, graphql_name="zoneCode")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")


class CompanyContactInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("first_name", "last_name", "email", "title", "locale", "phone")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    email = sgqlc.types.Field(String, graphql_name="email")
    title = sgqlc.types.Field(String, graphql_name="title")
    locale = sgqlc.types.Field(String, graphql_name="locale")
    phone = sgqlc.types.Field(String, graphql_name="phone")


class CompanyContactRoleAssign(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact_role_id", "company_location_id")
    company_contact_role_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyContactRoleId")
    company_location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyLocationId")


class CompanyCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("company", "company_contact", "company_location")
    company = sgqlc.types.Field(sgqlc.types.non_null("CompanyInput"), graphql_name="company")
    company_contact = sgqlc.types.Field(CompanyContactInput, graphql_name="companyContact")
    company_location = sgqlc.types.Field("CompanyLocationInput", graphql_name="companyLocation")


class CompanyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "note", "external_id", "customer_since")
    name = sgqlc.types.Field(String, graphql_name="name")
    note = sgqlc.types.Field(String, graphql_name="note")
    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    customer_since = sgqlc.types.Field(DateTime, graphql_name="customerSince")


class CompanyLocationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "name",
        "phone",
        "locale",
        "external_id",
        "note",
        "buyer_experience_configuration",
        "billing_address",
        "shipping_address",
        "billing_same_as_shipping",
        "tax_registration_id",
        "tax_exemptions",
    )
    name = sgqlc.types.Field(String, graphql_name="name")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    locale = sgqlc.types.Field(String, graphql_name="locale")
    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    note = sgqlc.types.Field(String, graphql_name="note")
    buyer_experience_configuration = sgqlc.types.Field(BuyerExperienceConfigurationInput, graphql_name="buyerExperienceConfiguration")
    billing_address = sgqlc.types.Field(CompanyAddressInput, graphql_name="billingAddress")
    shipping_address = sgqlc.types.Field(CompanyAddressInput, graphql_name="shippingAddress")
    billing_same_as_shipping = sgqlc.types.Field(Boolean, graphql_name="billingSameAsShipping")
    tax_registration_id = sgqlc.types.Field(String, graphql_name="taxRegistrationId")
    tax_exemptions = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption)), graphql_name="taxExemptions")


class CompanyLocationRoleAssign(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact_role_id", "company_contact_id")
    company_contact_role_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyContactRoleId")
    company_contact_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyContactId")


class CompanyLocationUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "phone", "locale", "external_id", "note", "buyer_experience_configuration")
    name = sgqlc.types.Field(String, graphql_name="name")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    locale = sgqlc.types.Field(String, graphql_name="locale")
    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    note = sgqlc.types.Field(String, graphql_name="note")
    buyer_experience_configuration = sgqlc.types.Field(BuyerExperienceConfigurationInput, graphql_name="buyerExperienceConfiguration")


class ContextualPricingContext(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("country", "company_location_id")
    country = sgqlc.types.Field(CountryCode, graphql_name="country")
    company_location_id = sgqlc.types.Field(ID, graphql_name="companyLocationId")


class ContextualPublicationContext(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("country", "company_location_id")
    country = sgqlc.types.Field(CountryCode, graphql_name="country")
    company_location_id = sgqlc.types.Field(ID, graphql_name="companyLocationId")


class CountryHarmonizedSystemCodeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("harmonized_system_code", "country_code")
    harmonized_system_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="harmonizedSystemCode")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")


class CreateMediaInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("original_source", "alt", "media_content_type")
    original_source = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="originalSource")
    alt = sgqlc.types.Field(String, graphql_name="alt")
    media_content_type = sgqlc.types.Field(sgqlc.types.non_null(MediaContentType), graphql_name="mediaContentType")


class CustomShippingPackageInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("weight", "dimensions", "default", "name", "type")
    weight = sgqlc.types.Field("WeightInput", graphql_name="weight")
    dimensions = sgqlc.types.Field("ObjectDimensionsInput", graphql_name="dimensions")
    default = sgqlc.types.Field(Boolean, graphql_name="default")
    name = sgqlc.types.Field(String, graphql_name="name")
    type = sgqlc.types.Field(ShippingPackageType, graphql_name="type")


class CustomerDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class CustomerEmailMarketingConsentInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_opt_in_level", "marketing_state", "consent_updated_at")
    marketing_opt_in_level = sgqlc.types.Field(CustomerMarketingOptInLevel, graphql_name="marketingOptInLevel")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerEmailMarketingState), graphql_name="marketingState")
    consent_updated_at = sgqlc.types.Field(DateTime, graphql_name="consentUpdatedAt")


class CustomerEmailMarketingConsentUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "email_marketing_consent")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="customerId")
    email_marketing_consent = sgqlc.types.Field(
        sgqlc.types.non_null(CustomerEmailMarketingConsentInput), graphql_name="emailMarketingConsent"
    )


class CustomerInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "addresses",
        "email",
        "first_name",
        "id",
        "last_name",
        "locale",
        "metafields",
        "note",
        "phone",
        "tags",
        "email_marketing_consent",
        "sms_marketing_consent",
        "tax_exempt",
        "tax_exemptions",
    )
    addresses = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MailingAddressInput")), graphql_name="addresses")
    email = sgqlc.types.Field(String, graphql_name="email")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    id = sgqlc.types.Field(ID, graphql_name="id")
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    locale = sgqlc.types.Field(String, graphql_name="locale")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")
    note = sgqlc.types.Field(String, graphql_name="note")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    tags = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tags")
    email_marketing_consent = sgqlc.types.Field(CustomerEmailMarketingConsentInput, graphql_name="emailMarketingConsent")
    sms_marketing_consent = sgqlc.types.Field("CustomerSmsMarketingConsentInput", graphql_name="smsMarketingConsent")
    tax_exempt = sgqlc.types.Field(Boolean, graphql_name="taxExempt")
    tax_exemptions = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption)), graphql_name="taxExemptions")


class CustomerMergeOverrideFields(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "customer_id_of_first_name_to_keep",
        "customer_id_of_last_name_to_keep",
        "customer_id_of_email_to_keep",
        "customer_id_of_phone_number_to_keep",
        "customer_id_of_default_address_to_keep",
        "note",
        "tags",
    )
    customer_id_of_first_name_to_keep = sgqlc.types.Field(ID, graphql_name="customerIdOfFirstNameToKeep")
    customer_id_of_last_name_to_keep = sgqlc.types.Field(ID, graphql_name="customerIdOfLastNameToKeep")
    customer_id_of_email_to_keep = sgqlc.types.Field(ID, graphql_name="customerIdOfEmailToKeep")
    customer_id_of_phone_number_to_keep = sgqlc.types.Field(ID, graphql_name="customerIdOfPhoneNumberToKeep")
    customer_id_of_default_address_to_keep = sgqlc.types.Field(ID, graphql_name="customerIdOfDefaultAddressToKeep")
    note = sgqlc.types.Field(String, graphql_name="note")
    tags = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tags")


class CustomerPaymentMethodRemoteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("stripe_payment_method", "authorize_net_customer_payment_profile", "braintree_payment_method")
    stripe_payment_method = sgqlc.types.Field("RemoteStripePaymentMethodInput", graphql_name="stripePaymentMethod")
    authorize_net_customer_payment_profile = sgqlc.types.Field(
        "RemoteAuthorizeNetCustomerPaymentProfileInput", graphql_name="authorizeNetCustomerPaymentProfile"
    )
    braintree_payment_method = sgqlc.types.Field("RemoteBraintreePaymentMethodInput", graphql_name="braintreePaymentMethod")


class CustomerSegmentMembersQueryInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("segment_id", "query", "reverse", "sort_key")
    segment_id = sgqlc.types.Field(ID, graphql_name="segmentId")
    query = sgqlc.types.Field(String, graphql_name="query")
    reverse = sgqlc.types.Field(Boolean, graphql_name="reverse")
    sort_key = sgqlc.types.Field(String, graphql_name="sortKey")


class CustomerSmsMarketingConsentInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_opt_in_level", "marketing_state", "consent_updated_at")
    marketing_opt_in_level = sgqlc.types.Field(CustomerMarketingOptInLevel, graphql_name="marketingOptInLevel")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerSmsMarketingState), graphql_name="marketingState")
    consent_updated_at = sgqlc.types.Field(DateTime, graphql_name="consentUpdatedAt")


class CustomerSmsMarketingConsentUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "sms_marketing_consent")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="customerId")
    sms_marketing_consent = sgqlc.types.Field(sgqlc.types.non_null(CustomerSmsMarketingConsentInput), graphql_name="smsMarketingConsent")


class DelegateAccessTokenInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("delegate_access_scope", "expires_in")
    delegate_access_scope = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="delegateAccessScope"
    )
    expires_in = sgqlc.types.Field(Int, graphql_name="expiresIn")


class DeliveryCountryInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("code", "rest_of_world", "provinces", "include_all_provinces")
    code = sgqlc.types.Field(CountryCode, graphql_name="code")
    rest_of_world = sgqlc.types.Field(Boolean, graphql_name="restOfWorld")
    provinces = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProvinceInput")), graphql_name="provinces")
    include_all_provinces = sgqlc.types.Field(Boolean, graphql_name="includeAllProvinces")


class DeliveryCustomizationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("function_id", "title", "enabled", "metafields")
    function_id = sgqlc.types.Field(String, graphql_name="functionId")
    title = sgqlc.types.Field(String, graphql_name="title")
    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")


class DeliveryLocationGroupZoneInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "name", "countries", "method_definitions_to_create", "method_definitions_to_update")
    id = sgqlc.types.Field(ID, graphql_name="id")
    name = sgqlc.types.Field(String, graphql_name="name")
    countries = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(DeliveryCountryInput)), graphql_name="countries")
    method_definitions_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryMethodDefinitionInput")), graphql_name="methodDefinitionsToCreate"
    )
    method_definitions_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryMethodDefinitionInput")), graphql_name="methodDefinitionsToUpdate"
    )


class DeliveryLocationLocalPickupEnableInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("location_id", "pickup_time", "instructions")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")
    pickup_time = sgqlc.types.Field(sgqlc.types.non_null(DeliveryLocalPickupTime), graphql_name="pickupTime")
    instructions = sgqlc.types.Field(String, graphql_name="instructions")


class DeliveryMethodDefinitionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "id",
        "name",
        "description",
        "active",
        "rate_definition",
        "participant",
        "weight_conditions_to_create",
        "price_conditions_to_create",
        "conditions_to_update",
    )
    id = sgqlc.types.Field(ID, graphql_name="id")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    active = sgqlc.types.Field(Boolean, graphql_name="active")
    rate_definition = sgqlc.types.Field("DeliveryRateDefinitionInput", graphql_name="rateDefinition")
    participant = sgqlc.types.Field("DeliveryParticipantInput", graphql_name="participant")
    weight_conditions_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryWeightConditionInput")), graphql_name="weightConditionsToCreate"
    )
    price_conditions_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryPriceConditionInput")), graphql_name="priceConditionsToCreate"
    )
    conditions_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryUpdateConditionInput")), graphql_name="conditionsToUpdate"
    )


class DeliveryParticipantInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "carrier_service_id", "fixed_fee", "percentage_of_rate_fee", "participant_services", "adapt_to_new_services")
    id = sgqlc.types.Field(ID, graphql_name="id")
    carrier_service_id = sgqlc.types.Field(ID, graphql_name="carrierServiceId")
    fixed_fee = sgqlc.types.Field("MoneyInput", graphql_name="fixedFee")
    percentage_of_rate_fee = sgqlc.types.Field(Float, graphql_name="percentageOfRateFee")
    participant_services = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryParticipantServiceInput")), graphql_name="participantServices"
    )
    adapt_to_new_services = sgqlc.types.Field(Boolean, graphql_name="adaptToNewServices")


class DeliveryParticipantServiceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "active")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    active = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="active")


class DeliveryPriceConditionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("criteria", "operator")
    criteria = sgqlc.types.Field("MoneyInput", graphql_name="criteria")
    operator = sgqlc.types.Field(DeliveryConditionOperator, graphql_name="operator")


class DeliveryProfileInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "name",
        "profile_location_groups",
        "location_groups_to_create",
        "location_groups_to_update",
        "location_groups_to_delete",
        "variants_to_associate",
        "variants_to_dissociate",
        "zones_to_delete",
        "method_definitions_to_delete",
        "conditions_to_delete",
        "selling_plan_groups_to_associate",
        "selling_plan_groups_to_dissociate",
    )
    name = sgqlc.types.Field(String, graphql_name="name")
    profile_location_groups = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileLocationGroupInput")), graphql_name="profileLocationGroups"
    )
    location_groups_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileLocationGroupInput")), graphql_name="locationGroupsToCreate"
    )
    location_groups_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileLocationGroupInput")), graphql_name="locationGroupsToUpdate"
    )
    location_groups_to_delete = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="locationGroupsToDelete")
    variants_to_associate = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="variantsToAssociate")
    variants_to_dissociate = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="variantsToDissociate")
    zones_to_delete = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="zonesToDelete")
    method_definitions_to_delete = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="methodDefinitionsToDelete"
    )
    conditions_to_delete = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="conditionsToDelete")
    selling_plan_groups_to_associate = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="sellingPlanGroupsToAssociate"
    )
    selling_plan_groups_to_dissociate = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="sellingPlanGroupsToDissociate"
    )


class DeliveryProfileLocationGroupInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "locations", "locations_to_add", "locations_to_remove", "zones_to_create", "zones_to_update")
    id = sgqlc.types.Field(ID, graphql_name="id")
    locations = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="locations")
    locations_to_add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="locationsToAdd")
    locations_to_remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="locationsToRemove")
    zones_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(DeliveryLocationGroupZoneInput)), graphql_name="zonesToCreate"
    )
    zones_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(DeliveryLocationGroupZoneInput)), graphql_name="zonesToUpdate"
    )


class DeliveryProvinceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("code",)
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")


class DeliveryRateDefinitionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "price")
    id = sgqlc.types.Field(ID, graphql_name="id")
    price = sgqlc.types.Field(sgqlc.types.non_null("MoneyInput"), graphql_name="price")


class DeliverySettingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("legacy_mode_profiles",)
    legacy_mode_profiles = sgqlc.types.Field(Boolean, graphql_name="legacyModeProfiles")


class DeliveryUpdateConditionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "criteria", "criteria_unit", "field", "operator")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    criteria = sgqlc.types.Field(Float, graphql_name="criteria")
    criteria_unit = sgqlc.types.Field(String, graphql_name="criteriaUnit")
    field = sgqlc.types.Field(DeliveryConditionField, graphql_name="field")
    operator = sgqlc.types.Field(DeliveryConditionOperator, graphql_name="operator")


class DeliveryWeightConditionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("criteria", "operator")
    criteria = sgqlc.types.Field("WeightInput", graphql_name="criteria")
    operator = sgqlc.types.Field(DeliveryConditionOperator, graphql_name="operator")


class DiscountAmountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "applies_on_each_item")
    amount = sgqlc.types.Field(Decimal, graphql_name="amount")
    applies_on_each_item = sgqlc.types.Field(Boolean, graphql_name="appliesOnEachItem")


class DiscountAutomaticAppInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("combines_with", "function_id", "title", "starts_at", "ends_at", "metafields")
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    function_id = sgqlc.types.Field(String, graphql_name="functionId")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")


class DiscountAutomaticBasicInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("combines_with", "title", "starts_at", "ends_at", "minimum_requirement", "customer_gets")
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    minimum_requirement = sgqlc.types.Field("DiscountMinimumRequirementInput", graphql_name="minimumRequirement")
    customer_gets = sgqlc.types.Field("DiscountCustomerGetsInput", graphql_name="customerGets")


class DiscountAutomaticBxgyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("combines_with", "starts_at", "ends_at", "title", "uses_per_order_limit", "customer_buys", "customer_gets")
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    title = sgqlc.types.Field(String, graphql_name="title")
    uses_per_order_limit = sgqlc.types.Field(UnsignedInt64, graphql_name="usesPerOrderLimit")
    customer_buys = sgqlc.types.Field("DiscountCustomerBuysInput", graphql_name="customerBuys")
    customer_gets = sgqlc.types.Field("DiscountCustomerGetsInput", graphql_name="customerGets")


class DiscountCodeAppInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "combines_with",
        "function_id",
        "title",
        "starts_at",
        "ends_at",
        "usage_limit",
        "applies_once_per_customer",
        "customer_selection",
        "code",
        "metafields",
    )
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    function_id = sgqlc.types.Field(String, graphql_name="functionId")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    applies_once_per_customer = sgqlc.types.Field(Boolean, graphql_name="appliesOncePerCustomer")
    customer_selection = sgqlc.types.Field("DiscountCustomerSelectionInput", graphql_name="customerSelection")
    code = sgqlc.types.Field(String, graphql_name="code")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")


class DiscountCodeBasicInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "combines_with",
        "title",
        "starts_at",
        "ends_at",
        "usage_limit",
        "applies_once_per_customer",
        "minimum_requirement",
        "customer_gets",
        "customer_selection",
        "code",
        "recurring_cycle_limit",
    )
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    applies_once_per_customer = sgqlc.types.Field(Boolean, graphql_name="appliesOncePerCustomer")
    minimum_requirement = sgqlc.types.Field("DiscountMinimumRequirementInput", graphql_name="minimumRequirement")
    customer_gets = sgqlc.types.Field("DiscountCustomerGetsInput", graphql_name="customerGets")
    customer_selection = sgqlc.types.Field("DiscountCustomerSelectionInput", graphql_name="customerSelection")
    code = sgqlc.types.Field(String, graphql_name="code")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")


class DiscountCodeBxgyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "combines_with",
        "title",
        "starts_at",
        "ends_at",
        "customer_buys",
        "customer_gets",
        "customer_selection",
        "code",
        "usage_limit",
        "uses_per_order_limit",
        "applies_once_per_customer",
    )
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    customer_buys = sgqlc.types.Field("DiscountCustomerBuysInput", graphql_name="customerBuys")
    customer_gets = sgqlc.types.Field("DiscountCustomerGetsInput", graphql_name="customerGets")
    customer_selection = sgqlc.types.Field("DiscountCustomerSelectionInput", graphql_name="customerSelection")
    code = sgqlc.types.Field(String, graphql_name="code")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    uses_per_order_limit = sgqlc.types.Field(Int, graphql_name="usesPerOrderLimit")
    applies_once_per_customer = sgqlc.types.Field(Boolean, graphql_name="appliesOncePerCustomer")


class DiscountCodeFreeShippingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "combines_with",
        "title",
        "starts_at",
        "ends_at",
        "code",
        "usage_limit",
        "applies_once_per_customer",
        "minimum_requirement",
        "customer_selection",
        "destination",
        "maximum_shipping_price",
        "recurring_cycle_limit",
        "applies_on_one_time_purchase",
        "applies_on_subscription",
    )
    combines_with = sgqlc.types.Field("DiscountCombinesWithInput", graphql_name="combinesWith")
    title = sgqlc.types.Field(String, graphql_name="title")
    starts_at = sgqlc.types.Field(DateTime, graphql_name="startsAt")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    code = sgqlc.types.Field(String, graphql_name="code")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    applies_once_per_customer = sgqlc.types.Field(Boolean, graphql_name="appliesOncePerCustomer")
    minimum_requirement = sgqlc.types.Field("DiscountMinimumRequirementInput", graphql_name="minimumRequirement")
    customer_selection = sgqlc.types.Field("DiscountCustomerSelectionInput", graphql_name="customerSelection")
    destination = sgqlc.types.Field("DiscountShippingDestinationSelectionInput", graphql_name="destination")
    maximum_shipping_price = sgqlc.types.Field(Decimal, graphql_name="maximumShippingPrice")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")
    applies_on_one_time_purchase = sgqlc.types.Field(Boolean, graphql_name="appliesOnOneTimePurchase")
    applies_on_subscription = sgqlc.types.Field(Boolean, graphql_name="appliesOnSubscription")


class DiscountCollectionsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("add", "remove")
    add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="add")
    remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="remove")


class DiscountCombinesWithInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_discounts", "order_discounts", "shipping_discounts")
    product_discounts = sgqlc.types.Field(Boolean, graphql_name="productDiscounts")
    order_discounts = sgqlc.types.Field(Boolean, graphql_name="orderDiscounts")
    shipping_discounts = sgqlc.types.Field(Boolean, graphql_name="shippingDiscounts")


class DiscountCountriesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("add", "remove", "include_rest_of_world")
    add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode)), graphql_name="add")
    remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode)), graphql_name="remove")
    include_rest_of_world = sgqlc.types.Field(Boolean, graphql_name="includeRestOfWorld")


class DiscountCustomerBuysInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "items")
    value = sgqlc.types.Field("DiscountCustomerBuysValueInput", graphql_name="value")
    items = sgqlc.types.Field("DiscountItemsInput", graphql_name="items")


class DiscountCustomerBuysValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("quantity", "amount")
    quantity = sgqlc.types.Field(UnsignedInt64, graphql_name="quantity")
    amount = sgqlc.types.Field(Decimal, graphql_name="amount")


class DiscountCustomerGetsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "items", "applies_on_one_time_purchase", "applies_on_subscription")
    value = sgqlc.types.Field("DiscountCustomerGetsValueInput", graphql_name="value")
    items = sgqlc.types.Field("DiscountItemsInput", graphql_name="items")
    applies_on_one_time_purchase = sgqlc.types.Field(Boolean, graphql_name="appliesOnOneTimePurchase")
    applies_on_subscription = sgqlc.types.Field(Boolean, graphql_name="appliesOnSubscription")


class DiscountCustomerGetsValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("discount_on_quantity", "percentage", "discount_amount")
    discount_on_quantity = sgqlc.types.Field("DiscountOnQuantityInput", graphql_name="discountOnQuantity")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")
    discount_amount = sgqlc.types.Field(DiscountAmountInput, graphql_name="discountAmount")


class DiscountCustomerSegmentsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("add", "remove")
    add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="add")
    remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="remove")


class DiscountCustomerSelectionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("all", "customers", "customer_segments")
    all = sgqlc.types.Field(Boolean, graphql_name="all")
    customers = sgqlc.types.Field("DiscountCustomersInput", graphql_name="customers")
    customer_segments = sgqlc.types.Field(DiscountCustomerSegmentsInput, graphql_name="customerSegments")


class DiscountCustomersInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("add", "remove")
    add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="add")
    remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="remove")


class DiscountEffectInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")


class DiscountItemsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("products", "collections", "all")
    products = sgqlc.types.Field("DiscountProductsInput", graphql_name="products")
    collections = sgqlc.types.Field(DiscountCollectionsInput, graphql_name="collections")
    all = sgqlc.types.Field(Boolean, graphql_name="all")


class DiscountMinimumQuantityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than_or_equal_to_quantity",)
    greater_than_or_equal_to_quantity = sgqlc.types.Field(UnsignedInt64, graphql_name="greaterThanOrEqualToQuantity")


class DiscountMinimumRequirementInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("quantity", "subtotal")
    quantity = sgqlc.types.Field(DiscountMinimumQuantityInput, graphql_name="quantity")
    subtotal = sgqlc.types.Field("DiscountMinimumSubtotalInput", graphql_name="subtotal")


class DiscountMinimumSubtotalInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than_or_equal_to_subtotal",)
    greater_than_or_equal_to_subtotal = sgqlc.types.Field(Decimal, graphql_name="greaterThanOrEqualToSubtotal")


class DiscountOnQuantityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("quantity", "effect")
    quantity = sgqlc.types.Field(UnsignedInt64, graphql_name="quantity")
    effect = sgqlc.types.Field(DiscountEffectInput, graphql_name="effect")


class DiscountProductsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("products_to_add", "products_to_remove", "product_variants_to_add", "product_variants_to_remove")
    products_to_add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productsToAdd")
    products_to_remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productsToRemove")
    product_variants_to_add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantsToAdd")
    product_variants_to_remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantsToRemove")


class DiscountRedeemCodeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("code",)
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")


class DiscountShippingDestinationSelectionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("all", "countries")
    all = sgqlc.types.Field(Boolean, graphql_name="all")
    countries = sgqlc.types.Field(DiscountCountriesInput, graphql_name="countries")


class DraftOrderAppliedDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "description", "title", "value", "value_type")
    amount = sgqlc.types.Field(Money, graphql_name="amount")
    description = sgqlc.types.Field(String, graphql_name="description")
    title = sgqlc.types.Field(String, graphql_name="title")
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    value_type = sgqlc.types.Field(sgqlc.types.non_null(DraftOrderAppliedDiscountType), graphql_name="valueType")


class DraftOrderDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class DraftOrderInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "applied_discount",
        "billing_address",
        "custom_attributes",
        "email",
        "line_items",
        "metafields",
        "localization_extensions",
        "note",
        "shipping_address",
        "shipping_line",
        "tags",
        "tax_exempt",
        "use_customer_default_address",
        "visible_to_customer",
        "reserve_inventory_until",
        "presentment_currency_code",
        "market_region_country_code",
        "phone",
        "payment_terms",
        "purchasing_entity",
        "source_name",
        "po_number",
    )
    applied_discount = sgqlc.types.Field(DraftOrderAppliedDiscountInput, graphql_name="appliedDiscount")
    billing_address = sgqlc.types.Field("MailingAddressInput", graphql_name="billingAddress")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")
    email = sgqlc.types.Field(String, graphql_name="email")
    line_items = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("DraftOrderLineItemInput")), graphql_name="lineItems")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")
    localization_extensions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("LocalizationExtensionInput")), graphql_name="localizationExtensions"
    )
    note = sgqlc.types.Field(String, graphql_name="note")
    shipping_address = sgqlc.types.Field("MailingAddressInput", graphql_name="shippingAddress")
    shipping_line = sgqlc.types.Field("ShippingLineInput", graphql_name="shippingLine")
    tags = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tags")
    tax_exempt = sgqlc.types.Field(Boolean, graphql_name="taxExempt")
    use_customer_default_address = sgqlc.types.Field(Boolean, graphql_name="useCustomerDefaultAddress")
    visible_to_customer = sgqlc.types.Field(Boolean, graphql_name="visibleToCustomer")
    reserve_inventory_until = sgqlc.types.Field(DateTime, graphql_name="reserveInventoryUntil")
    presentment_currency_code = sgqlc.types.Field(CurrencyCode, graphql_name="presentmentCurrencyCode")
    market_region_country_code = sgqlc.types.Field(CountryCode, graphql_name="marketRegionCountryCode")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    payment_terms = sgqlc.types.Field("PaymentTermsInput", graphql_name="paymentTerms")
    purchasing_entity = sgqlc.types.Field("PurchasingEntityInput", graphql_name="purchasingEntity")
    source_name = sgqlc.types.Field(String, graphql_name="sourceName")
    po_number = sgqlc.types.Field(String, graphql_name="poNumber")


class DraftOrderLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "applied_discount",
        "custom_attributes",
        "original_unit_price",
        "quantity",
        "requires_shipping",
        "sku",
        "taxable",
        "title",
        "variant_id",
        "weight",
    )
    applied_discount = sgqlc.types.Field(DraftOrderAppliedDiscountInput, graphql_name="appliedDiscount")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")
    original_unit_price = sgqlc.types.Field(Money, graphql_name="originalUnitPrice")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    requires_shipping = sgqlc.types.Field(Boolean, graphql_name="requiresShipping")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    taxable = sgqlc.types.Field(Boolean, graphql_name="taxable")
    title = sgqlc.types.Field(String, graphql_name="title")
    variant_id = sgqlc.types.Field(ID, graphql_name="variantId")
    weight = sgqlc.types.Field("WeightInput", graphql_name="weight")


class EmailInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("subject", "to", "from_", "body", "bcc", "custom_message")
    subject = sgqlc.types.Field(String, graphql_name="subject")
    to = sgqlc.types.Field(String, graphql_name="to")
    from_ = sgqlc.types.Field(String, graphql_name="from")
    body = sgqlc.types.Field(String, graphql_name="body")
    bcc = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="bcc")
    custom_message = sgqlc.types.Field(String, graphql_name="customMessage")


class EventBridgeWebhookSubscriptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("arn", "format", "include_fields", "metafield_namespaces")
    arn = sgqlc.types.Field(ARN, graphql_name="arn")
    format = sgqlc.types.Field(WebhookSubscriptionFormat, graphql_name="format")
    include_fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="includeFields")
    metafield_namespaces = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="metafieldNamespaces")


class FileCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("filename", "original_source", "content_type", "alt", "duplicate_resolution_mode")
    filename = sgqlc.types.Field(String, graphql_name="filename")
    original_source = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="originalSource")
    content_type = sgqlc.types.Field(FileContentType, graphql_name="contentType")
    alt = sgqlc.types.Field(String, graphql_name="alt")
    duplicate_resolution_mode = sgqlc.types.Field(FileCreateInputDuplicateResolutionMode, graphql_name="duplicateResolutionMode")


class FileUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "alt", "original_source", "preview_image_source", "filename")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    alt = sgqlc.types.Field(String, graphql_name="alt")
    original_source = sgqlc.types.Field(String, graphql_name="originalSource")
    preview_image_source = sgqlc.types.Field(String, graphql_name="previewImageSource")
    filename = sgqlc.types.Field(String, graphql_name="filename")


class FulfillmentEventInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "address1",
        "city",
        "country",
        "estimated_delivery_at",
        "happened_at",
        "fulfillment_id",
        "latitude",
        "longitude",
        "message",
        "province",
        "status",
        "zip",
    )
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    city = sgqlc.types.Field(String, graphql_name="city")
    country = sgqlc.types.Field(String, graphql_name="country")
    estimated_delivery_at = sgqlc.types.Field(DateTime, graphql_name="estimatedDeliveryAt")
    happened_at = sgqlc.types.Field(DateTime, graphql_name="happenedAt")
    fulfillment_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentId")
    latitude = sgqlc.types.Field(Float, graphql_name="latitude")
    longitude = sgqlc.types.Field(Float, graphql_name="longitude")
    message = sgqlc.types.Field(String, graphql_name="message")
    province = sgqlc.types.Field(String, graphql_name="province")
    status = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentEventStatus), graphql_name="status")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class FulfillmentOrderHoldInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reason", "reason_notes", "notify_merchant", "external_id", "fulfillment_order_line_items")
    reason = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentHoldReason), graphql_name="reason")
    reason_notes = sgqlc.types.Field(String, graphql_name="reasonNotes")
    notify_merchant = sgqlc.types.Field(Boolean, graphql_name="notifyMerchant")
    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    fulfillment_order_line_items = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderLineItemInput")), graphql_name="fulfillmentOrderLineItems"
    )


class FulfillmentOrderLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "quantity")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class FulfillmentOrderLineItemsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_id", "fulfillment_order_line_items")
    fulfillment_order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentOrderId")
    fulfillment_order_line_items = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemInput)), graphql_name="fulfillmentOrderLineItems"
    )


class FulfillmentOrderLineItemsPreparedForPickupInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("line_items_by_fulfillment_order",)
    line_items_by_fulfillment_order = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PreparedFulfillmentOrderLineItemsInput"))),
        graphql_name="lineItemsByFulfillmentOrder",
    )


class FulfillmentOrderMergeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("merge_intents",)
    merge_intents = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderMergeInputMergeIntent"))),
        graphql_name="mergeIntents",
    )


class FulfillmentOrderMergeInputMergeIntent(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_line_items", "fulfillment_order_id")
    fulfillment_order_line_items = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemInput)), graphql_name="fulfillmentOrderLineItems"
    )
    fulfillment_order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentOrderId")


class FulfillmentOrderSplitInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_line_items", "fulfillment_order_id")
    fulfillment_order_line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemInput))),
        graphql_name="fulfillmentOrderLineItems",
    )
    fulfillment_order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentOrderId")


class FulfillmentOriginAddressInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "zip", "province_code", "country_code")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    zip = sgqlc.types.Field(String, graphql_name="zip")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="countryCode")


class FulfillmentTrackingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("number", "url", "company", "numbers", "urls")
    number = sgqlc.types.Field(String, graphql_name="number")
    url = sgqlc.types.Field(URL, graphql_name="url")
    company = sgqlc.types.Field(String, graphql_name="company")
    numbers = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="numbers")
    urls = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(URL)), graphql_name="urls")


class FulfillmentV2Input(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("tracking_info", "notify_customer", "line_items_by_fulfillment_order", "origin_address")
    tracking_info = sgqlc.types.Field(FulfillmentTrackingInput, graphql_name="trackingInfo")
    notify_customer = sgqlc.types.Field(Boolean, graphql_name="notifyCustomer")
    line_items_by_fulfillment_order = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemsInput))),
        graphql_name="lineItemsByFulfillmentOrder",
    )
    origin_address = sgqlc.types.Field(FulfillmentOriginAddressInput, graphql_name="originAddress")


class GiftCardCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("initial_value", "code", "customer_id", "expires_on", "note", "template_suffix")
    initial_value = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="initialValue")
    code = sgqlc.types.Field(String, graphql_name="code")
    customer_id = sgqlc.types.Field(ID, graphql_name="customerId")
    expires_on = sgqlc.types.Field(Date, graphql_name="expiresOn")
    note = sgqlc.types.Field(String, graphql_name="note")
    template_suffix = sgqlc.types.Field(String, graphql_name="templateSuffix")


class GiftCardUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("note", "expires_on", "customer_id", "template_suffix")
    note = sgqlc.types.Field(String, graphql_name="note")
    expires_on = sgqlc.types.Field(Date, graphql_name="expiresOn")
    customer_id = sgqlc.types.Field(ID, graphql_name="customerId")
    template_suffix = sgqlc.types.Field(String, graphql_name="templateSuffix")


class ImageInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "alt_text", "src")
    id = sgqlc.types.Field(ID, graphql_name="id")
    alt_text = sgqlc.types.Field(String, graphql_name="altText")
    src = sgqlc.types.Field(String, graphql_name="src")


class ImageTransformInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("crop", "max_width", "max_height", "scale", "preferred_content_type")
    crop = sgqlc.types.Field(CropRegion, graphql_name="crop")
    max_width = sgqlc.types.Field(Int, graphql_name="maxWidth")
    max_height = sgqlc.types.Field(Int, graphql_name="maxHeight")
    scale = sgqlc.types.Field(Int, graphql_name="scale")
    preferred_content_type = sgqlc.types.Field(ImageContentType, graphql_name="preferredContentType")


class IncomingRequestLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_line_item_id", "message")
    fulfillment_order_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentOrderLineItemId")
    message = sgqlc.types.Field(String, graphql_name="message")


class InventoryAdjustItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_item_id", "available_delta")
    inventory_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="inventoryItemId")
    available_delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="availableDelta")


class InventoryAdjustQuantitiesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reason", "name", "reference_document_uri", "changes")
    reason = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="reason")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    reference_document_uri = sgqlc.types.Field(String, graphql_name="referenceDocumentUri")
    changes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryChangeInput"))), graphql_name="changes"
    )


class InventoryAdjustQuantityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_level_id", "available_delta")
    inventory_level_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="inventoryLevelId")
    available_delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="availableDelta")


class InventoryBulkToggleActivationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("location_id", "activate")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")
    activate = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="activate")


class InventoryChangeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("delta", "inventory_item_id", "location_id", "ledger_document_uri")
    delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="delta")
    inventory_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="inventoryItemId")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")
    ledger_document_uri = sgqlc.types.Field(String, graphql_name="ledgerDocumentUri")


class InventoryItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("cost", "tracked")
    cost = sgqlc.types.Field(Decimal, graphql_name="cost")
    tracked = sgqlc.types.Field(Boolean, graphql_name="tracked")


class InventoryItemUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "cost",
        "tracked",
        "country_code_of_origin",
        "province_code_of_origin",
        "harmonized_system_code",
        "country_harmonized_system_codes",
    )
    cost = sgqlc.types.Field(Decimal, graphql_name="cost")
    tracked = sgqlc.types.Field(Boolean, graphql_name="tracked")
    country_code_of_origin = sgqlc.types.Field(CountryCode, graphql_name="countryCodeOfOrigin")
    province_code_of_origin = sgqlc.types.Field(String, graphql_name="provinceCodeOfOrigin")
    harmonized_system_code = sgqlc.types.Field(String, graphql_name="harmonizedSystemCode")
    country_harmonized_system_codes = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(CountryHarmonizedSystemCodeInput)), graphql_name="countryHarmonizedSystemCodes"
    )


class InventoryLevelInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("available_quantity", "location_id")
    available_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="availableQuantity")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")


class InventoryMoveQuantitiesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reason", "reference_document_uri", "changes")
    reason = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="reason")
    reference_document_uri = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="referenceDocumentUri")
    changes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryMoveQuantityChange"))), graphql_name="changes"
    )


class InventoryMoveQuantityChange(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_item_id", "quantity", "from_", "to")
    inventory_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="inventoryItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    from_ = sgqlc.types.Field(sgqlc.types.non_null("InventoryMoveQuantityTerminalInput"), graphql_name="from")
    to = sgqlc.types.Field(sgqlc.types.non_null("InventoryMoveQuantityTerminalInput"), graphql_name="to")


class InventoryMoveQuantityTerminalInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("location_id", "name", "ledger_document_uri")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    ledger_document_uri = sgqlc.types.Field(String, graphql_name="ledgerDocumentUri")


class InventorySetOnHandQuantitiesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reason", "reference_document_uri", "set_quantities")
    reason = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="reason")
    reference_document_uri = sgqlc.types.Field(String, graphql_name="referenceDocumentUri")
    set_quantities = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventorySetQuantityInput"))), graphql_name="setQuantities"
    )


class InventorySetQuantityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_item_id", "location_id", "quantity")
    inventory_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="inventoryItemId")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class LocalizationExtensionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(LocalizationExtensionKey), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class LocationAddAddressInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "phone", "zip", "country_code", "province_code")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    zip = sgqlc.types.Field(String, graphql_name="zip")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")


class LocationAddInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "address", "fulfills_online_orders", "metafields")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    address = sgqlc.types.Field(sgqlc.types.non_null(LocationAddAddressInput), graphql_name="address")
    fulfills_online_orders = sgqlc.types.Field(Boolean, graphql_name="fulfillsOnlineOrders")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")


class LocationEditAddressInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "phone", "zip", "country_code", "province_code")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    zip = sgqlc.types.Field(String, graphql_name="zip")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")


class LocationEditInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "address", "fulfills_online_orders", "metafields")
    name = sgqlc.types.Field(String, graphql_name="name")
    address = sgqlc.types.Field(LocationEditAddressInput, graphql_name="address")
    fulfills_online_orders = sgqlc.types.Field(Boolean, graphql_name="fulfillsOnlineOrders")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldInput")), graphql_name="metafields")


class MailingAddressInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "address1",
        "address2",
        "city",
        "company",
        "country_code",
        "first_name",
        "last_name",
        "phone",
        "province_code",
        "zip",
    )
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    company = sgqlc.types.Field(String, graphql_name="company")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class MarketCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "handle", "enabled", "regions")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")
    regions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketRegionCreateInput"))), graphql_name="regions"
    )


class MarketCurrencySettingsUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("base_currency", "local_currencies")
    base_currency = sgqlc.types.Field(CurrencyCode, graphql_name="baseCurrency")
    local_currencies = sgqlc.types.Field(Boolean, graphql_name="localCurrencies")


class MarketLocalizationRegisterInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("market_id", "key", "value", "market_localizable_content_digest")
    market_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="marketId")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    market_localizable_content_digest = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="marketLocalizableContentDigest")


class MarketRegionCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("country_code",)
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")


class MarketUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "handle", "enabled")
    name = sgqlc.types.Field(String, graphql_name="name")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")


class MarketWebPresenceCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("domain_id", "default_locale", "alternate_locales", "subfolder_suffix")
    domain_id = sgqlc.types.Field(ID, graphql_name="domainId")
    default_locale = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="defaultLocale")
    alternate_locales = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="alternateLocales")
    subfolder_suffix = sgqlc.types.Field(String, graphql_name="subfolderSuffix")


class MarketWebPresenceUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("domain_id", "default_locale", "alternate_locales", "subfolder_suffix")
    domain_id = sgqlc.types.Field(ID, graphql_name="domainId")
    default_locale = sgqlc.types.Field(String, graphql_name="defaultLocale")
    alternate_locales = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="alternateLocales")
    subfolder_suffix = sgqlc.types.Field(String, graphql_name="subfolderSuffix")


class MarketingActivityBudgetInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("budget_type", "total")
    budget_type = sgqlc.types.Field(MarketingBudgetBudgetType, graphql_name="budgetType")
    total = sgqlc.types.Field("MoneyInput", graphql_name="total")


class MarketingActivityCreateExternalInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "title",
        "utm",
        "budget",
        "ad_spend",
        "remote_id",
        "remote_url",
        "remote_preview_image_url",
        "tactic",
        "channel",
        "referring_domain",
        "scheduled_start",
        "scheduled_end",
        "start",
        "end",
    )
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    utm = sgqlc.types.Field(sgqlc.types.non_null("UTMInput"), graphql_name="utm")
    budget = sgqlc.types.Field(MarketingActivityBudgetInput, graphql_name="budget")
    ad_spend = sgqlc.types.Field("MoneyInput", graphql_name="adSpend")
    remote_id = sgqlc.types.Field(String, graphql_name="remoteId")
    remote_url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="remoteUrl")
    remote_preview_image_url = sgqlc.types.Field(URL, graphql_name="remotePreviewImageUrl")
    tactic = sgqlc.types.Field(sgqlc.types.non_null(MarketingTactic), graphql_name="tactic")
    channel = sgqlc.types.Field(sgqlc.types.non_null(MarketingChannel), graphql_name="channel")
    referring_domain = sgqlc.types.Field(String, graphql_name="referringDomain")
    scheduled_start = sgqlc.types.Field(DateTime, graphql_name="scheduledStart")
    scheduled_end = sgqlc.types.Field(DateTime, graphql_name="scheduledEnd")
    start = sgqlc.types.Field(DateTime, graphql_name="start")
    end = sgqlc.types.Field(DateTime, graphql_name="end")


class MarketingActivityCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_activity_title", "form_data", "marketing_activity_extension_id", "context", "utm", "status", "budget")
    marketing_activity_title = sgqlc.types.Field(String, graphql_name="marketingActivityTitle")
    form_data = sgqlc.types.Field(String, graphql_name="formData")
    marketing_activity_extension_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="marketingActivityExtensionId")
    context = sgqlc.types.Field(String, graphql_name="context")
    utm = sgqlc.types.Field("UTMInput", graphql_name="utm")
    status = sgqlc.types.Field(sgqlc.types.non_null(MarketingActivityStatus), graphql_name="status")
    budget = sgqlc.types.Field(MarketingActivityBudgetInput, graphql_name="budget")


class MarketingActivityUpdateExternalInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "title",
        "utm",
        "budget",
        "ad_spend",
        "remote_url",
        "remote_preview_image_url",
        "tactic",
        "channel",
        "referring_domain",
        "scheduled_start",
        "scheduled_end",
        "start",
        "end",
    )
    title = sgqlc.types.Field(String, graphql_name="title")
    utm = sgqlc.types.Field("UTMInput", graphql_name="utm")
    budget = sgqlc.types.Field(MarketingActivityBudgetInput, graphql_name="budget")
    ad_spend = sgqlc.types.Field("MoneyInput", graphql_name="adSpend")
    remote_url = sgqlc.types.Field(URL, graphql_name="remoteUrl")
    remote_preview_image_url = sgqlc.types.Field(URL, graphql_name="remotePreviewImageUrl")
    tactic = sgqlc.types.Field(MarketingTactic, graphql_name="tactic")
    channel = sgqlc.types.Field(MarketingChannel, graphql_name="channel")
    referring_domain = sgqlc.types.Field(String, graphql_name="referringDomain")
    scheduled_start = sgqlc.types.Field(DateTime, graphql_name="scheduledStart")
    scheduled_end = sgqlc.types.Field(DateTime, graphql_name="scheduledEnd")
    start = sgqlc.types.Field(DateTime, graphql_name="start")
    end = sgqlc.types.Field(DateTime, graphql_name="end")


class MarketingActivityUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "id",
        "marketing_recommendation_id",
        "title",
        "budget",
        "status",
        "target_status",
        "form_data",
        "utm",
        "marketed_resources",
        "errors",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    marketing_recommendation_id = sgqlc.types.Field(ID, graphql_name="marketingRecommendationId")
    title = sgqlc.types.Field(String, graphql_name="title")
    budget = sgqlc.types.Field(MarketingActivityBudgetInput, graphql_name="budget")
    status = sgqlc.types.Field(MarketingActivityStatus, graphql_name="status")
    target_status = sgqlc.types.Field(MarketingActivityStatus, graphql_name="targetStatus")
    form_data = sgqlc.types.Field(String, graphql_name="formData")
    utm = sgqlc.types.Field("UTMInput", graphql_name="utm")
    marketed_resources = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="marketedResources")
    errors = sgqlc.types.Field(JSON, graphql_name="errors")


class MarketingEngagementInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "occurred_on",
        "impressions_count",
        "views_count",
        "clicks_count",
        "shares_count",
        "favorites_count",
        "comments_count",
        "unsubscribes_count",
        "complaints_count",
        "fails_count",
        "sends_count",
        "unique_views_count",
        "unique_clicks_count",
        "ad_spend",
        "is_cumulative",
        "utc_offset",
        "fetched_at",
    )
    occurred_on = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="occurredOn")
    impressions_count = sgqlc.types.Field(Int, graphql_name="impressionsCount")
    views_count = sgqlc.types.Field(Int, graphql_name="viewsCount")
    clicks_count = sgqlc.types.Field(Int, graphql_name="clicksCount")
    shares_count = sgqlc.types.Field(Int, graphql_name="sharesCount")
    favorites_count = sgqlc.types.Field(Int, graphql_name="favoritesCount")
    comments_count = sgqlc.types.Field(Int, graphql_name="commentsCount")
    unsubscribes_count = sgqlc.types.Field(Int, graphql_name="unsubscribesCount")
    complaints_count = sgqlc.types.Field(Int, graphql_name="complaintsCount")
    fails_count = sgqlc.types.Field(Int, graphql_name="failsCount")
    sends_count = sgqlc.types.Field(Int, graphql_name="sendsCount")
    unique_views_count = sgqlc.types.Field(Int, graphql_name="uniqueViewsCount")
    unique_clicks_count = sgqlc.types.Field(Int, graphql_name="uniqueClicksCount")
    ad_spend = sgqlc.types.Field("MoneyInput", graphql_name="adSpend")
    is_cumulative = sgqlc.types.Field(Boolean, graphql_name="isCumulative")
    utc_offset = sgqlc.types.Field(UtcOffset, graphql_name="utcOffset")
    fetched_at = sgqlc.types.Field(DateTime, graphql_name="fetchedAt")


class MetafieldAccessInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("admin",)
    admin = sgqlc.types.Field(sgqlc.types.non_null(MetafieldAdminAccess), graphql_name="admin")


class MetafieldDefinitionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "namespace",
        "key",
        "name",
        "description",
        "owner_type",
        "type",
        "validations",
        "visible_to_storefront_api",
        "use_as_collection_condition",
        "pin",
        "access",
    )
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    owner_type = sgqlc.types.Field(sgqlc.types.non_null(MetafieldOwnerType), graphql_name="ownerType")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    validations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionValidationInput")), graphql_name="validations"
    )
    visible_to_storefront_api = sgqlc.types.Field(Boolean, graphql_name="visibleToStorefrontApi")
    use_as_collection_condition = sgqlc.types.Field(Boolean, graphql_name="useAsCollectionCondition")
    pin = sgqlc.types.Field(Boolean, graphql_name="pin")
    access = sgqlc.types.Field(MetafieldAccessInput, graphql_name="access")


class MetafieldDefinitionUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "namespace",
        "key",
        "name",
        "description",
        "owner_type",
        "validations",
        "pin",
        "visible_to_storefront_api",
        "use_as_collection_condition",
        "access",
    )
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    owner_type = sgqlc.types.Field(sgqlc.types.non_null(MetafieldOwnerType), graphql_name="ownerType")
    validations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionValidationInput")), graphql_name="validations"
    )
    pin = sgqlc.types.Field(Boolean, graphql_name="pin")
    visible_to_storefront_api = sgqlc.types.Field(Boolean, graphql_name="visibleToStorefrontApi")
    use_as_collection_condition = sgqlc.types.Field(Boolean, graphql_name="useAsCollectionCondition")
    access = sgqlc.types.Field(MetafieldAccessInput, graphql_name="access")


class MetafieldDefinitionValidationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class MetafieldDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class MetafieldInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "namespace", "key", "value", "type")
    id = sgqlc.types.Field(ID, graphql_name="id")
    namespace = sgqlc.types.Field(String, graphql_name="namespace")
    key = sgqlc.types.Field(String, graphql_name="key")
    value = sgqlc.types.Field(String, graphql_name="value")
    type = sgqlc.types.Field(String, graphql_name="type")


class MetafieldStorefrontVisibilityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("namespace", "key", "owner_type")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    owner_type = sgqlc.types.Field(sgqlc.types.non_null(MetafieldOwnerType), graphql_name="ownerType")


class MetafieldsSetInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("owner_id", "namespace", "key", "value", "type")
    owner_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="ownerId")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    type = sgqlc.types.Field(String, graphql_name="type")


class MetaobjectAccessInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("admin", "storefront")
    admin = sgqlc.types.Field(MetaobjectAdminAccess, graphql_name="admin")
    storefront = sgqlc.types.Field(MetaobjectStorefrontAccess, graphql_name="storefront")


class MetaobjectBulkDeleteWhereCondition(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "ids")
    type = sgqlc.types.Field(String, graphql_name="type")
    ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids")


class MetaobjectCapabilityCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "translatable")
    publishable = sgqlc.types.Field("MetaobjectCapabilityPublishableInput", graphql_name="publishable")
    translatable = sgqlc.types.Field("MetaobjectCapabilityTranslatableInput", graphql_name="translatable")


class MetaobjectCapabilityDataInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publishable",)
    publishable = sgqlc.types.Field("MetaobjectCapabilityDataPublishableInput", graphql_name="publishable")


class MetaobjectCapabilityDataPublishableInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("status",)
    status = sgqlc.types.Field(sgqlc.types.non_null(MetaobjectStatus), graphql_name="status")


class MetaobjectCapabilityPublishableInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("enabled",)
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")


class MetaobjectCapabilityTranslatableInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("enabled",)
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")


class MetaobjectCapabilityUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "translatable")
    publishable = sgqlc.types.Field(MetaobjectCapabilityPublishableInput, graphql_name="publishable")
    translatable = sgqlc.types.Field(MetaobjectCapabilityTranslatableInput, graphql_name="translatable")


class MetaobjectCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "handle", "fields", "capabilities")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectFieldInput")), graphql_name="fields")
    capabilities = sgqlc.types.Field(MetaobjectCapabilityDataInput, graphql_name="capabilities")


class MetaobjectDefinitionCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "description", "type", "field_definitions", "access", "display_name_key", "capabilities")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    field_definitions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectFieldDefinitionCreateInput"))),
        graphql_name="fieldDefinitions",
    )
    access = sgqlc.types.Field(MetaobjectAccessInput, graphql_name="access")
    display_name_key = sgqlc.types.Field(String, graphql_name="displayNameKey")
    capabilities = sgqlc.types.Field(MetaobjectCapabilityCreateInput, graphql_name="capabilities")


class MetaobjectDefinitionUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "description", "field_definitions", "access", "display_name_key", "reset_field_order", "capabilities")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    field_definitions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectFieldDefinitionOperationInput")), graphql_name="fieldDefinitions"
    )
    access = sgqlc.types.Field(MetaobjectAccessInput, graphql_name="access")
    display_name_key = sgqlc.types.Field(String, graphql_name="displayNameKey")
    reset_field_order = sgqlc.types.Field(Boolean, graphql_name="resetFieldOrder")
    capabilities = sgqlc.types.Field(MetaobjectCapabilityUpdateInput, graphql_name="capabilities")


class MetaobjectFieldDefinitionCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key", "type", "name", "description", "required", "validations")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    required = sgqlc.types.Field(Boolean, graphql_name="required")
    validations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(MetafieldDefinitionValidationInput)), graphql_name="validations"
    )


class MetaobjectFieldDefinitionDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key",)
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")


class MetaobjectFieldDefinitionOperationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("create", "update", "delete")
    create = sgqlc.types.Field(MetaobjectFieldDefinitionCreateInput, graphql_name="create")
    update = sgqlc.types.Field("MetaobjectFieldDefinitionUpdateInput", graphql_name="update")
    delete = sgqlc.types.Field(MetaobjectFieldDefinitionDeleteInput, graphql_name="delete")


class MetaobjectFieldDefinitionUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key", "name", "description", "required", "validations")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    required = sgqlc.types.Field(Boolean, graphql_name="required")
    validations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(MetafieldDefinitionValidationInput)), graphql_name="validations"
    )


class MetaobjectFieldInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class MetaobjectHandleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "handle")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")


class MetaobjectUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("handle", "fields", "capabilities")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetaobjectFieldInput)), graphql_name="fields")
    capabilities = sgqlc.types.Field(MetaobjectCapabilityDataInput, graphql_name="capabilities")


class MetaobjectUpsertInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("handle", "fields", "capabilities")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetaobjectFieldInput)), graphql_name="fields")
    capabilities = sgqlc.types.Field(MetaobjectCapabilityDataInput, graphql_name="capabilities")


class MoneyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "currency_code")
    amount = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="amount")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")


class MoveInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "new_position")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    new_position = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="newPosition")


class ObjectDimensionsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("length", "width", "height", "unit")
    length = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="length")
    width = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="width")
    height = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="height")
    unit = sgqlc.types.Field(sgqlc.types.non_null(LengthUnit), graphql_name="unit")


class OrderCaptureInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "parent_transaction_id", "amount", "currency")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    parent_transaction_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="parentTransactionId")
    amount = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="amount")
    currency = sgqlc.types.Field(CurrencyCode, graphql_name="currency")


class OrderCloseInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class OrderEditAppliedDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("description", "fixed_value", "percent_value")
    description = sgqlc.types.Field(String, graphql_name="description")
    fixed_value = sgqlc.types.Field(MoneyInput, graphql_name="fixedValue")
    percent_value = sgqlc.types.Field(Float, graphql_name="percentValue")


class OrderInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "id",
        "email",
        "note",
        "tags",
        "shipping_address",
        "custom_attributes",
        "metafields",
        "localization_extensions",
        "po_number",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    email = sgqlc.types.Field(String, graphql_name="email")
    note = sgqlc.types.Field(String, graphql_name="note")
    tags = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tags")
    shipping_address = sgqlc.types.Field(MailingAddressInput, graphql_name="shippingAddress")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldInput)), graphql_name="metafields")
    localization_extensions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(LocalizationExtensionInput)), graphql_name="localizationExtensions"
    )
    po_number = sgqlc.types.Field(String, graphql_name="poNumber")


class OrderMarkAsPaidInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class OrderOpenInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class OrderTransactionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "gateway", "kind", "order_id", "parent_id")
    amount = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="amount")
    gateway = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="gateway")
    kind = sgqlc.types.Field(sgqlc.types.non_null(OrderTransactionKind), graphql_name="kind")
    order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="orderId")
    parent_id = sgqlc.types.Field(ID, graphql_name="parentId")


class PaymentCustomizationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("function_id", "title", "enabled", "metafields")
    function_id = sgqlc.types.Field(String, graphql_name="functionId")
    title = sgqlc.types.Field(String, graphql_name="title")
    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldInput)), graphql_name="metafields")


class PaymentScheduleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("issued_at", "due_at")
    issued_at = sgqlc.types.Field(DateTime, graphql_name="issuedAt")
    due_at = sgqlc.types.Field(DateTime, graphql_name="dueAt")


class PaymentTermsCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms_template_id", "payment_schedules")
    payment_terms_template_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="paymentTermsTemplateId")
    payment_schedules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(PaymentScheduleInput)), graphql_name="paymentSchedules")


class PaymentTermsDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms_id",)
    payment_terms_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="paymentTermsId")


class PaymentTermsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms_template_id", "payment_schedules")
    payment_terms_template_id = sgqlc.types.Field(ID, graphql_name="paymentTermsTemplateId")
    payment_schedules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(PaymentScheduleInput)), graphql_name="paymentSchedules")


class PaymentTermsUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms_id", "payment_terms_attributes")
    payment_terms_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="paymentTermsId")
    payment_terms_attributes = sgqlc.types.Field(sgqlc.types.non_null(PaymentTermsInput), graphql_name="paymentTermsAttributes")


class PreparedFulfillmentOrderLineItemsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_id",)
    fulfillment_order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentOrderId")


class PriceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("calculation", "price")
    calculation = sgqlc.types.Field(PriceCalculationType, graphql_name="calculation")
    price = sgqlc.types.Field(Money, graphql_name="price")


class PriceListAdjustmentInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "type")
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    type = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustmentType), graphql_name="type")


class PriceListAdjustmentSettingsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("compare_at_mode",)
    compare_at_mode = sgqlc.types.Field(sgqlc.types.non_null(PriceListCompareAtMode), graphql_name="compareAtMode")


class PriceListCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "currency", "parent", "catalog_id")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    currency = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currency")
    parent = sgqlc.types.Field(sgqlc.types.non_null("PriceListParentCreateInput"), graphql_name="parent")
    catalog_id = sgqlc.types.Field(ID, graphql_name="catalogId")


class PriceListParentCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("adjustment", "settings")
    adjustment = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustmentInput), graphql_name="adjustment")
    settings = sgqlc.types.Field(PriceListAdjustmentSettingsInput, graphql_name="settings")


class PriceListParentUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("adjustment", "settings")
    adjustment = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustmentInput), graphql_name="adjustment")
    settings = sgqlc.types.Field(PriceListAdjustmentSettingsInput, graphql_name="settings")


class PriceListPriceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("variant_id", "price", "compare_at_price")
    variant_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="variantId")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyInput), graphql_name="price")
    compare_at_price = sgqlc.types.Field(MoneyInput, graphql_name="compareAtPrice")


class PriceListProductPriceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_id", "price")
    product_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productId")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyInput), graphql_name="price")


class PriceListUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("name", "currency", "parent", "catalog_id")
    name = sgqlc.types.Field(String, graphql_name="name")
    currency = sgqlc.types.Field(CurrencyCode, graphql_name="currency")
    parent = sgqlc.types.Field(PriceListParentUpdateInput, graphql_name="parent")
    catalog_id = sgqlc.types.Field(ID, graphql_name="catalogId")


class PriceRuleCustomerSelectionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("for_all_customers", "segment_ids", "customer_ids_to_add", "customer_ids_to_remove")
    for_all_customers = sgqlc.types.Field(Boolean, graphql_name="forAllCustomers")
    segment_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="segmentIds")
    customer_ids_to_add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="customerIdsToAdd")
    customer_ids_to_remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="customerIdsToRemove")


class PriceRuleDiscountCodeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("code",)
    code = sgqlc.types.Field(String, graphql_name="code")


class PriceRuleEntitlementToPrerequisiteQuantityRatioInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("entitlement_quantity", "prerequisite_quantity")
    entitlement_quantity = sgqlc.types.Field(Int, graphql_name="entitlementQuantity")
    prerequisite_quantity = sgqlc.types.Field(Int, graphql_name="prerequisiteQuantity")


class PriceRuleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "combines_with",
        "validity_period",
        "once_per_customer",
        "customer_selection",
        "usage_limit",
        "title",
        "allocation_limit",
        "allocation_method",
        "value",
        "target",
        "prerequisite_subtotal_range",
        "prerequisite_quantity_range",
        "prerequisite_shipping_price_range",
        "item_entitlements",
        "item_prerequisites",
        "shipping_entitlements",
        "prerequisite_to_entitlement_quantity_ratio",
    )
    combines_with = sgqlc.types.Field(DiscountCombinesWithInput, graphql_name="combinesWith")
    validity_period = sgqlc.types.Field("PriceRuleValidityPeriodInput", graphql_name="validityPeriod")
    once_per_customer = sgqlc.types.Field(Boolean, graphql_name="oncePerCustomer")
    customer_selection = sgqlc.types.Field(PriceRuleCustomerSelectionInput, graphql_name="customerSelection")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    title = sgqlc.types.Field(String, graphql_name="title")
    allocation_limit = sgqlc.types.Field(Int, graphql_name="allocationLimit")
    allocation_method = sgqlc.types.Field(PriceRuleAllocationMethod, graphql_name="allocationMethod")
    value = sgqlc.types.Field("PriceRuleValueInput", graphql_name="value")
    target = sgqlc.types.Field(PriceRuleTarget, graphql_name="target")
    prerequisite_subtotal_range = sgqlc.types.Field("PriceRuleMoneyRangeInput", graphql_name="prerequisiteSubtotalRange")
    prerequisite_quantity_range = sgqlc.types.Field("PriceRuleQuantityRangeInput", graphql_name="prerequisiteQuantityRange")
    prerequisite_shipping_price_range = sgqlc.types.Field("PriceRuleMoneyRangeInput", graphql_name="prerequisiteShippingPriceRange")
    item_entitlements = sgqlc.types.Field("PriceRuleItemEntitlementsInput", graphql_name="itemEntitlements")
    item_prerequisites = sgqlc.types.Field("PriceRuleItemPrerequisitesInput", graphql_name="itemPrerequisites")
    shipping_entitlements = sgqlc.types.Field("PriceRuleShippingEntitlementsInput", graphql_name="shippingEntitlements")
    prerequisite_to_entitlement_quantity_ratio = sgqlc.types.Field(
        "PriceRulePrerequisiteToEntitlementQuantityRatioInput", graphql_name="prerequisiteToEntitlementQuantityRatio"
    )


class PriceRuleItemEntitlementsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("target_all_line_items", "product_ids", "product_variant_ids", "collection_ids")
    target_all_line_items = sgqlc.types.Field(Boolean, graphql_name="targetAllLineItems")
    product_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productIds")
    product_variant_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantIds")
    collection_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="collectionIds")


class PriceRuleItemPrerequisitesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_ids", "product_variant_ids", "collection_ids")
    product_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productIds")
    product_variant_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantIds")
    collection_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="collectionIds")


class PriceRuleMoneyRangeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("less_than", "less_than_or_equal_to", "greater_than", "greater_than_or_equal_to")
    less_than = sgqlc.types.Field(Money, graphql_name="lessThan")
    less_than_or_equal_to = sgqlc.types.Field(Money, graphql_name="lessThanOrEqualTo")
    greater_than = sgqlc.types.Field(Money, graphql_name="greaterThan")
    greater_than_or_equal_to = sgqlc.types.Field(Money, graphql_name="greaterThanOrEqualTo")


class PriceRulePrerequisiteToEntitlementQuantityRatioInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("entitlement_quantity", "prerequisite_quantity")
    entitlement_quantity = sgqlc.types.Field(Int, graphql_name="entitlementQuantity")
    prerequisite_quantity = sgqlc.types.Field(Int, graphql_name="prerequisiteQuantity")


class PriceRuleQuantityRangeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("less_than", "less_than_or_equal_to", "greater_than", "greater_than_or_equal_to")
    less_than = sgqlc.types.Field(Int, graphql_name="lessThan")
    less_than_or_equal_to = sgqlc.types.Field(Int, graphql_name="lessThanOrEqualTo")
    greater_than = sgqlc.types.Field(Int, graphql_name="greaterThan")
    greater_than_or_equal_to = sgqlc.types.Field(Int, graphql_name="greaterThanOrEqualTo")


class PriceRuleShippingEntitlementsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("target_all_shipping_lines", "country_codes", "include_rest_of_world")
    target_all_shipping_lines = sgqlc.types.Field(Boolean, graphql_name="targetAllShippingLines")
    country_codes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode)), graphql_name="countryCodes")
    include_rest_of_world = sgqlc.types.Field(Boolean, graphql_name="includeRestOfWorld")


class PriceRuleValidityPeriodInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("start", "end")
    start = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="start")
    end = sgqlc.types.Field(DateTime, graphql_name="end")


class PriceRuleValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage_value", "fixed_amount_value")
    percentage_value = sgqlc.types.Field(Float, graphql_name="percentageValue")
    fixed_amount_value = sgqlc.types.Field(Money, graphql_name="fixedAmountValue")


class PrivateMetafieldDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("owner", "namespace", "key")
    owner = sgqlc.types.Field(ID, graphql_name="owner")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")


class PrivateMetafieldInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("owner", "namespace", "key", "value_input")
    owner = sgqlc.types.Field(ID, graphql_name="owner")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value_input = sgqlc.types.Field(sgqlc.types.non_null("PrivateMetafieldValueInput"), graphql_name="valueInput")


class PrivateMetafieldValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "value_type")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    value_type = sgqlc.types.Field(sgqlc.types.non_null(PrivateMetafieldValueType), graphql_name="valueType")


class ProductAppendImagesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "images")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    images = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ImageInput))), graphql_name="images")


class ProductCategoryInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_taxonomy_node_id",)
    product_taxonomy_node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productTaxonomyNodeId")


class ProductDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class ProductDuplicateAsyncInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_id", "new_title", "new_status", "include_images")
    product_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productId")
    new_title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="newTitle")
    new_status = sgqlc.types.Field(ProductStatus, graphql_name="newStatus")
    include_images = sgqlc.types.Field(Boolean, graphql_name="includeImages")


class ProductFeedInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("language", "country")
    language = sgqlc.types.Field(sgqlc.types.non_null(LanguageCode), graphql_name="language")
    country = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="country")


class ProductInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "description_html",
        "handle",
        "redirect_new_handle",
        "seo",
        "product_type",
        "standardized_product_type",
        "product_category",
        "custom_product_type",
        "tags",
        "template_suffix",
        "gift_card",
        "gift_card_template_suffix",
        "title",
        "vendor",
        "collections_to_join",
        "collections_to_leave",
        "id",
        "metafields",
        "options",
        "variants",
        "status",
        "requires_selling_plan",
    )
    description_html = sgqlc.types.Field(String, graphql_name="descriptionHtml")
    handle = sgqlc.types.Field(String, graphql_name="handle")
    redirect_new_handle = sgqlc.types.Field(Boolean, graphql_name="redirectNewHandle")
    seo = sgqlc.types.Field("SEOInput", graphql_name="seo")
    product_type = sgqlc.types.Field(String, graphql_name="productType")
    standardized_product_type = sgqlc.types.Field("StandardizedProductTypeInput", graphql_name="standardizedProductType")
    product_category = sgqlc.types.Field(ProductCategoryInput, graphql_name="productCategory")
    custom_product_type = sgqlc.types.Field(String, graphql_name="customProductType")
    tags = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tags")
    template_suffix = sgqlc.types.Field(String, graphql_name="templateSuffix")
    gift_card = sgqlc.types.Field(Boolean, graphql_name="giftCard")
    gift_card_template_suffix = sgqlc.types.Field(String, graphql_name="giftCardTemplateSuffix")
    title = sgqlc.types.Field(String, graphql_name="title")
    vendor = sgqlc.types.Field(String, graphql_name="vendor")
    collections_to_join = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="collectionsToJoin")
    collections_to_leave = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="collectionsToLeave")
    id = sgqlc.types.Field(ID, graphql_name="id")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldInput)), graphql_name="metafields")
    options = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="options")
    variants = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantInput")), graphql_name="variants")
    status = sgqlc.types.Field(ProductStatus, graphql_name="status")
    requires_selling_plan = sgqlc.types.Field(Boolean, graphql_name="requiresSellingPlan")


class ProductPublicationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publication_id", "publish_date")
    publication_id = sgqlc.types.Field(ID, graphql_name="publicationId")
    publish_date = sgqlc.types.Field(DateTime, graphql_name="publishDate")


class ProductPublishInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "product_publications")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    product_publications = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductPublicationInput))), graphql_name="productPublications"
    )


class ProductResourceFeedbackInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_id", "state", "feedback_generated_at", "product_updated_at", "messages")
    product_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productId")
    state = sgqlc.types.Field(sgqlc.types.non_null(ResourceFeedbackState), graphql_name="state")
    feedback_generated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="feedbackGeneratedAt")
    product_updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="productUpdatedAt")
    messages = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="messages")


class ProductUnpublishInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "product_publications")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    product_publications = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductPublicationInput))), graphql_name="productPublications"
    )


class ProductVariantAppendMediaInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("variant_id", "media_ids")
    variant_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="variantId")
    media_ids = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="mediaIds")


class ProductVariantDetachMediaInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("variant_id", "media_ids")
    variant_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="variantId")
    media_ids = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="mediaIds")


class ProductVariantGroupRelationshipInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "quantity")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class ProductVariantInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "requires_components",
        "barcode",
        "compare_at_price",
        "harmonized_system_code",
        "id",
        "media_id",
        "media_src",
        "inventory_policy",
        "inventory_quantities",
        "inventory_item",
        "metafields",
        "options",
        "position",
        "price",
        "product_id",
        "requires_shipping",
        "sku",
        "taxable",
        "tax_code",
        "weight",
        "weight_unit",
    )
    requires_components = sgqlc.types.Field(Boolean, graphql_name="requiresComponents")
    barcode = sgqlc.types.Field(String, graphql_name="barcode")
    compare_at_price = sgqlc.types.Field(Money, graphql_name="compareAtPrice")
    harmonized_system_code = sgqlc.types.Field(String, graphql_name="harmonizedSystemCode")
    id = sgqlc.types.Field(ID, graphql_name="id")
    media_id = sgqlc.types.Field(ID, graphql_name="mediaId")
    media_src = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="mediaSrc")
    inventory_policy = sgqlc.types.Field(ProductVariantInventoryPolicy, graphql_name="inventoryPolicy")
    inventory_quantities = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(InventoryLevelInput)), graphql_name="inventoryQuantities"
    )
    inventory_item = sgqlc.types.Field(InventoryItemInput, graphql_name="inventoryItem")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldInput)), graphql_name="metafields")
    options = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="options")
    position = sgqlc.types.Field(Int, graphql_name="position")
    price = sgqlc.types.Field(Money, graphql_name="price")
    product_id = sgqlc.types.Field(ID, graphql_name="productId")
    requires_shipping = sgqlc.types.Field(Boolean, graphql_name="requiresShipping")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    taxable = sgqlc.types.Field(Boolean, graphql_name="taxable")
    tax_code = sgqlc.types.Field(String, graphql_name="taxCode")
    weight = sgqlc.types.Field(Float, graphql_name="weight")
    weight_unit = sgqlc.types.Field(WeightUnit, graphql_name="weightUnit")


class ProductVariantPositionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "position")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    position = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="position")


class ProductVariantRelationshipUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "parent_product_variant_id",
        "parent_product_id",
        "product_variant_relationships_to_create",
        "product_variant_relationships_to_update",
        "product_variant_relationships_to_remove",
        "remove_all_product_variant_relationships",
        "price_input",
    )
    parent_product_variant_id = sgqlc.types.Field(ID, graphql_name="parentProductVariantId")
    parent_product_id = sgqlc.types.Field(ID, graphql_name="parentProductId")
    product_variant_relationships_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantGroupRelationshipInput)), graphql_name="productVariantRelationshipsToCreate"
    )
    product_variant_relationships_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantGroupRelationshipInput)), graphql_name="productVariantRelationshipsToUpdate"
    )
    product_variant_relationships_to_remove = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantRelationshipsToRemove"
    )
    remove_all_product_variant_relationships = sgqlc.types.Field(Boolean, graphql_name="removeAllProductVariantRelationships")
    price_input = sgqlc.types.Field(PriceInput, graphql_name="priceInput")


class ProductVariantsBulkInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "barcode",
        "compare_at_price",
        "harmonized_system_code",
        "id",
        "media_src",
        "inventory_policy",
        "inventory_quantities",
        "inventory_item",
        "media_id",
        "metafields",
        "options",
        "price",
        "requires_shipping",
        "sku",
        "taxable",
        "tax_code",
        "weight",
        "weight_unit",
    )
    barcode = sgqlc.types.Field(String, graphql_name="barcode")
    compare_at_price = sgqlc.types.Field(Money, graphql_name="compareAtPrice")
    harmonized_system_code = sgqlc.types.Field(String, graphql_name="harmonizedSystemCode")
    id = sgqlc.types.Field(ID, graphql_name="id")
    media_src = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="mediaSrc")
    inventory_policy = sgqlc.types.Field(ProductVariantInventoryPolicy, graphql_name="inventoryPolicy")
    inventory_quantities = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(InventoryLevelInput)), graphql_name="inventoryQuantities"
    )
    inventory_item = sgqlc.types.Field(InventoryItemInput, graphql_name="inventoryItem")
    media_id = sgqlc.types.Field(ID, graphql_name="mediaId")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldInput)), graphql_name="metafields")
    options = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="options")
    price = sgqlc.types.Field(Money, graphql_name="price")
    requires_shipping = sgqlc.types.Field(Boolean, graphql_name="requiresShipping")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    taxable = sgqlc.types.Field(Boolean, graphql_name="taxable")
    tax_code = sgqlc.types.Field(String, graphql_name="taxCode")
    weight = sgqlc.types.Field(Float, graphql_name="weight")
    weight_unit = sgqlc.types.Field(WeightUnit, graphql_name="weightUnit")


class PubSubWebhookSubscriptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("pub_sub_project", "pub_sub_topic", "format", "include_fields", "metafield_namespaces")
    pub_sub_project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pubSubProject")
    pub_sub_topic = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pubSubTopic")
    format = sgqlc.types.Field(WebhookSubscriptionFormat, graphql_name="format")
    include_fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="includeFields")
    metafield_namespaces = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="metafieldNamespaces")


class PublicationCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("catalog_id", "default_state", "auto_publish")
    catalog_id = sgqlc.types.Field(ID, graphql_name="catalogId")
    default_state = sgqlc.types.Field(PublicationCreateInputPublicationDefaultState, graphql_name="defaultState")
    auto_publish = sgqlc.types.Field(Boolean, graphql_name="autoPublish")


class PublicationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publication_id", "publish_date")
    publication_id = sgqlc.types.Field(ID, graphql_name="publicationId")
    publish_date = sgqlc.types.Field(DateTime, graphql_name="publishDate")


class PublicationUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("publishables_to_add", "publishables_to_remove", "auto_publish")
    publishables_to_add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="publishablesToAdd")
    publishables_to_remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="publishablesToRemove")
    auto_publish = sgqlc.types.Field(Boolean, graphql_name="autoPublish")


class PurchasingCompanyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("company_id", "company_contact_id", "company_location_id")
    company_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyId")
    company_contact_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyContactId")
    company_location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="companyLocationId")


class PurchasingEntityInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "purchasing_company")
    customer_id = sgqlc.types.Field(ID, graphql_name="customerId")
    purchasing_company = sgqlc.types.Field(PurchasingCompanyInput, graphql_name="purchasingCompany")


class QuantityRuleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("increment", "maximum", "minimum", "variant_id")
    increment = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="increment")
    maximum = sgqlc.types.Field(Int, graphql_name="maximum")
    minimum = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="minimum")
    variant_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="variantId")


class RefundDutyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("duty_id", "refund_type")
    duty_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="dutyId")
    refund_type = sgqlc.types.Field(RefundDutyRefundType, graphql_name="refundType")


class RefundInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("currency", "order_id", "note", "notify", "shipping", "refund_line_items", "refund_duties", "transactions")
    currency = sgqlc.types.Field(CurrencyCode, graphql_name="currency")
    order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="orderId")
    note = sgqlc.types.Field(String, graphql_name="note")
    notify = sgqlc.types.Field(Boolean, graphql_name="notify")
    shipping = sgqlc.types.Field("ShippingRefundInput", graphql_name="shipping")
    refund_line_items = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("RefundLineItemInput")), graphql_name="refundLineItems")
    refund_duties = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(RefundDutyInput)), graphql_name="refundDuties")
    transactions = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(OrderTransactionInput)), graphql_name="transactions")


class RefundLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("line_item_id", "quantity", "restock_type", "location_id")
    line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="lineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    restock_type = sgqlc.types.Field(RefundLineItemRestockType, graphql_name="restockType")
    location_id = sgqlc.types.Field(ID, graphql_name="locationId")


class RefundShippingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("shipping_refund_amount", "full_refund")
    shipping_refund_amount = sgqlc.types.Field(MoneyInput, graphql_name="shippingRefundAmount")
    full_refund = sgqlc.types.Field(Boolean, graphql_name="fullRefund")


class RemoteAuthorizeNetCustomerPaymentProfileInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_profile_id", "customer_payment_profile_id")
    customer_profile_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="customerProfileId")
    customer_payment_profile_id = sgqlc.types.Field(String, graphql_name="customerPaymentProfileId")


class RemoteBraintreePaymentMethodInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "payment_method_token")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="customerId")
    payment_method_token = sgqlc.types.Field(String, graphql_name="paymentMethodToken")


class RemoteStripePaymentMethodInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "payment_method_id")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="customerId")
    payment_method_id = sgqlc.types.Field(String, graphql_name="paymentMethodId")


class ResourceFeedbackCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("feedback_generated_at", "messages", "state")
    feedback_generated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="feedbackGeneratedAt")
    messages = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="messages")
    state = sgqlc.types.Field(sgqlc.types.non_null(ResourceFeedbackState), graphql_name="state")


class ReturnApproveRequestInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class ReturnDeclineRequestInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "decline_reason")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    decline_reason = sgqlc.types.Field(sgqlc.types.non_null(ReturnDeclineReason), graphql_name="declineReason")


class ReturnInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("order_id", "return_line_items", "notify_customer", "requested_at")
    order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="orderId")
    return_line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnLineItemInput"))), graphql_name="returnLineItems"
    )
    notify_customer = sgqlc.types.Field(Boolean, graphql_name="notifyCustomer")
    requested_at = sgqlc.types.Field(DateTime, graphql_name="requestedAt")


class ReturnLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_line_item_id", "quantity", "return_reason", "return_reason_note")
    fulfillment_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    return_reason = sgqlc.types.Field(sgqlc.types.non_null(ReturnReason), graphql_name="returnReason")
    return_reason_note = sgqlc.types.Field(String, graphql_name="returnReasonNote")


class ReturnRefundInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("return_id", "return_refund_line_items", "refund_shipping", "refund_duties", "order_transactions", "notify_customer")
    return_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="returnId")
    return_refund_line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnRefundLineItemInput"))), graphql_name="returnRefundLineItems"
    )
    refund_shipping = sgqlc.types.Field(RefundShippingInput, graphql_name="refundShipping")
    refund_duties = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(RefundDutyInput)), graphql_name="refundDuties")
    order_transactions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("ReturnRefundOrderTransactionInput")), graphql_name="orderTransactions"
    )
    notify_customer = sgqlc.types.Field(Boolean, graphql_name="notifyCustomer")


class ReturnRefundLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("return_line_item_id", "quantity")
    return_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="returnLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class ReturnRefundOrderTransactionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("transaction_amount", "parent_id")
    transaction_amount = sgqlc.types.Field(sgqlc.types.non_null(MoneyInput), graphql_name="transactionAmount")
    parent_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="parentId")


class ReturnRequestInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("order_id", "return_line_items")
    order_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="orderId")
    return_line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnRequestLineItemInput"))), graphql_name="returnLineItems"
    )


class ReturnRequestLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_line_item_id", "quantity", "return_reason", "customer_note")
    fulfillment_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="fulfillmentLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    return_reason = sgqlc.types.Field(sgqlc.types.non_null(ReturnReason), graphql_name="returnReason")
    customer_note = sgqlc.types.Field(String, graphql_name="customerNote")


class ReverseDeliveryDisposeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_delivery_line_item_id", "quantity", "disposition_type", "location_id")
    reverse_delivery_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="reverseDeliveryLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    disposition_type = sgqlc.types.Field(sgqlc.types.non_null(ReverseFulfillmentOrderDispositionType), graphql_name="dispositionType")
    location_id = sgqlc.types.Field(ID, graphql_name="locationId")


class ReverseDeliveryLabelInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("file_url",)
    file_url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="fileUrl")


class ReverseDeliveryLineItemInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_fulfillment_order_line_item_id", "quantity")
    reverse_fulfillment_order_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="reverseFulfillmentOrderLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class ReverseDeliveryTrackingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("number", "url")
    number = sgqlc.types.Field(String, graphql_name="number")
    url = sgqlc.types.Field(URL, graphql_name="url")


class ReverseFulfillmentOrderDisposeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_fulfillment_order_line_item_id", "quantity", "location_id", "disposition_type")
    reverse_fulfillment_order_line_item_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="reverseFulfillmentOrderLineItemId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    location_id = sgqlc.types.Field(ID, graphql_name="locationId")
    disposition_type = sgqlc.types.Field(sgqlc.types.non_null(ReverseFulfillmentOrderDispositionType), graphql_name="dispositionType")


class SEOInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "description")
    title = sgqlc.types.Field(String, graphql_name="title")
    description = sgqlc.types.Field(String, graphql_name="description")


class SavedSearchCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("resource_type", "name", "query")
    resource_type = sgqlc.types.Field(sgqlc.types.non_null(SearchResultType), graphql_name="resourceType")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="query")


class SavedSearchDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class SavedSearchUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "name", "query")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    name = sgqlc.types.Field(String, graphql_name="name")
    query = sgqlc.types.Field(String, graphql_name="query")


class ScriptTagInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("src", "display_scope", "cache")
    src = sgqlc.types.Field(URL, graphql_name="src")
    display_scope = sgqlc.types.Field(ScriptTagDisplayScope, graphql_name="displayScope")
    cache = sgqlc.types.Field(Boolean, graphql_name="cache")


class SellingPlanAnchorInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "day", "month", "cutoff_day")
    type = sgqlc.types.Field(SellingPlanAnchorType, graphql_name="type")
    day = sgqlc.types.Field(Int, graphql_name="day")
    month = sgqlc.types.Field(Int, graphql_name="month")
    cutoff_day = sgqlc.types.Field(Int, graphql_name="cutoffDay")


class SellingPlanBillingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fixed", "recurring")
    fixed = sgqlc.types.Field("SellingPlanFixedBillingPolicyInput", graphql_name="fixed")
    recurring = sgqlc.types.Field("SellingPlanRecurringBillingPolicyInput", graphql_name="recurring")


class SellingPlanCheckoutChargeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "value")
    type = sgqlc.types.Field(SellingPlanCheckoutChargeType, graphql_name="type")
    value = sgqlc.types.Field("SellingPlanCheckoutChargeValueInput", graphql_name="value")


class SellingPlanCheckoutChargeValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage", "fixed_value")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")
    fixed_value = sgqlc.types.Field(Decimal, graphql_name="fixedValue")


class SellingPlanDeliveryPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("fixed", "recurring")
    fixed = sgqlc.types.Field("SellingPlanFixedDeliveryPolicyInput", graphql_name="fixed")
    recurring = sgqlc.types.Field("SellingPlanRecurringDeliveryPolicyInput", graphql_name="recurring")


class SellingPlanFixedBillingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "remaining_balance_charge_trigger",
        "remaining_balance_charge_exact_time",
        "remaining_balance_charge_time_after_checkout",
        "checkout_charge",
    )
    remaining_balance_charge_trigger = sgqlc.types.Field(
        SellingPlanRemainingBalanceChargeTrigger, graphql_name="remainingBalanceChargeTrigger"
    )
    remaining_balance_charge_exact_time = sgqlc.types.Field(DateTime, graphql_name="remainingBalanceChargeExactTime")
    remaining_balance_charge_time_after_checkout = sgqlc.types.Field(String, graphql_name="remainingBalanceChargeTimeAfterCheckout")
    checkout_charge = sgqlc.types.Field(SellingPlanCheckoutChargeInput, graphql_name="checkoutCharge")


class SellingPlanFixedDeliveryPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("anchors", "fulfillment_trigger", "fulfillment_exact_time", "cutoff", "intent", "pre_anchor_behavior")
    anchors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchorInput)), graphql_name="anchors")
    fulfillment_trigger = sgqlc.types.Field(SellingPlanFulfillmentTrigger, graphql_name="fulfillmentTrigger")
    fulfillment_exact_time = sgqlc.types.Field(DateTime, graphql_name="fulfillmentExactTime")
    cutoff = sgqlc.types.Field(Int, graphql_name="cutoff")
    intent = sgqlc.types.Field(SellingPlanFixedDeliveryPolicyIntent, graphql_name="intent")
    pre_anchor_behavior = sgqlc.types.Field(SellingPlanFixedDeliveryPolicyPreAnchorBehavior, graphql_name="preAnchorBehavior")


class SellingPlanFixedPricingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "adjustment_type", "adjustment_value")
    id = sgqlc.types.Field(ID, graphql_name="id")
    adjustment_type = sgqlc.types.Field(SellingPlanPricingPolicyAdjustmentType, graphql_name="adjustmentType")
    adjustment_value = sgqlc.types.Field("SellingPlanPricingPolicyValueInput", graphql_name="adjustmentValue")


class SellingPlanGroupInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "name",
        "app_id",
        "merchant_code",
        "description",
        "selling_plans_to_create",
        "selling_plans_to_update",
        "selling_plans_to_delete",
        "options",
        "position",
    )
    name = sgqlc.types.Field(String, graphql_name="name")
    app_id = sgqlc.types.Field(String, graphql_name="appId")
    merchant_code = sgqlc.types.Field(String, graphql_name="merchantCode")
    description = sgqlc.types.Field(String, graphql_name="description")
    selling_plans_to_create = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanInput")), graphql_name="sellingPlansToCreate"
    )
    selling_plans_to_update = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanInput")), graphql_name="sellingPlansToUpdate"
    )
    selling_plans_to_delete = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="sellingPlansToDelete")
    options = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="options")
    position = sgqlc.types.Field(Int, graphql_name="position")


class SellingPlanGroupResourceInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_variant_ids", "product_ids")
    product_variant_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productVariantIds")
    product_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="productIds")


class SellingPlanInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "id",
        "name",
        "description",
        "billing_policy",
        "delivery_policy",
        "inventory_policy",
        "pricing_policies",
        "options",
        "position",
        "category",
    )
    id = sgqlc.types.Field(ID, graphql_name="id")
    name = sgqlc.types.Field(String, graphql_name="name")
    description = sgqlc.types.Field(String, graphql_name="description")
    billing_policy = sgqlc.types.Field(SellingPlanBillingPolicyInput, graphql_name="billingPolicy")
    delivery_policy = sgqlc.types.Field(SellingPlanDeliveryPolicyInput, graphql_name="deliveryPolicy")
    inventory_policy = sgqlc.types.Field("SellingPlanInventoryPolicyInput", graphql_name="inventoryPolicy")
    pricing_policies = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanPricingPolicyInput")), graphql_name="pricingPolicies"
    )
    options = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="options")
    position = sgqlc.types.Field(Int, graphql_name="position")
    category = sgqlc.types.Field(SellingPlanCategory, graphql_name="category")


class SellingPlanInventoryPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("reserve",)
    reserve = sgqlc.types.Field(SellingPlanReserve, graphql_name="reserve")


class SellingPlanPricingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("recurring", "fixed")
    recurring = sgqlc.types.Field("SellingPlanRecurringPricingPolicyInput", graphql_name="recurring")
    fixed = sgqlc.types.Field(SellingPlanFixedPricingPolicyInput, graphql_name="fixed")


class SellingPlanPricingPolicyValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage", "fixed_value")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")
    fixed_value = sgqlc.types.Field(Decimal, graphql_name="fixedValue")


class SellingPlanRecurringBillingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "interval_count", "anchors", "min_cycles", "max_cycles")
    interval = sgqlc.types.Field(SellingPlanInterval, graphql_name="interval")
    interval_count = sgqlc.types.Field(Int, graphql_name="intervalCount")
    anchors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchorInput)), graphql_name="anchors")
    min_cycles = sgqlc.types.Field(Int, graphql_name="minCycles")
    max_cycles = sgqlc.types.Field(Int, graphql_name="maxCycles")


class SellingPlanRecurringDeliveryPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "interval_count", "anchors", "cutoff", "intent", "pre_anchor_behavior")
    interval = sgqlc.types.Field(SellingPlanInterval, graphql_name="interval")
    interval_count = sgqlc.types.Field(Int, graphql_name="intervalCount")
    anchors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchorInput)), graphql_name="anchors")
    cutoff = sgqlc.types.Field(Int, graphql_name="cutoff")
    intent = sgqlc.types.Field(SellingPlanRecurringDeliveryPolicyIntent, graphql_name="intent")
    pre_anchor_behavior = sgqlc.types.Field(SellingPlanRecurringDeliveryPolicyPreAnchorBehavior, graphql_name="preAnchorBehavior")


class SellingPlanRecurringPricingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "adjustment_type", "adjustment_value", "after_cycle")
    id = sgqlc.types.Field(ID, graphql_name="id")
    adjustment_type = sgqlc.types.Field(SellingPlanPricingPolicyAdjustmentType, graphql_name="adjustmentType")
    adjustment_value = sgqlc.types.Field(SellingPlanPricingPolicyValueInput, graphql_name="adjustmentValue")
    after_cycle = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="afterCycle")


class ShippingLineInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("price", "shipping_rate_handle", "title")
    price = sgqlc.types.Field(Money, graphql_name="price")
    shipping_rate_handle = sgqlc.types.Field(String, graphql_name="shippingRateHandle")
    title = sgqlc.types.Field(String, graphql_name="title")


class ShippingRefundInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "full_refund")
    amount = sgqlc.types.Field(Money, graphql_name="amount")
    full_refund = sgqlc.types.Field(Boolean, graphql_name="fullRefund")


class ShopLocaleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("published", "market_web_presence_ids")
    published = sgqlc.types.Field(Boolean, graphql_name="published")
    market_web_presence_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="marketWebPresenceIds")


class ShopPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("type", "body")
    type = sgqlc.types.Field(sgqlc.types.non_null(ShopPolicyType), graphql_name="type")
    body = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="body")


class ShopifyPaymentsDisputeEvidenceUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "customer_email_address",
        "customer_last_name",
        "customer_first_name",
        "shipping_address",
        "uncategorized_text",
        "access_activity_log",
        "cancellation_policy_disclosure",
        "cancellation_rebuttal",
        "refund_policy_disclosure",
        "refund_refusal_explanation",
        "cancellation_policy_file",
        "customer_communication_file",
        "refund_policy_file",
        "shipping_documentation_file",
        "uncategorized_file",
        "service_documentation_file",
        "submit_evidence",
    )
    customer_email_address = sgqlc.types.Field(String, graphql_name="customerEmailAddress")
    customer_last_name = sgqlc.types.Field(String, graphql_name="customerLastName")
    customer_first_name = sgqlc.types.Field(String, graphql_name="customerFirstName")
    shipping_address = sgqlc.types.Field(MailingAddressInput, graphql_name="shippingAddress")
    uncategorized_text = sgqlc.types.Field(String, graphql_name="uncategorizedText")
    access_activity_log = sgqlc.types.Field(String, graphql_name="accessActivityLog")
    cancellation_policy_disclosure = sgqlc.types.Field(String, graphql_name="cancellationPolicyDisclosure")
    cancellation_rebuttal = sgqlc.types.Field(String, graphql_name="cancellationRebuttal")
    refund_policy_disclosure = sgqlc.types.Field(String, graphql_name="refundPolicyDisclosure")
    refund_refusal_explanation = sgqlc.types.Field(String, graphql_name="refundRefusalExplanation")
    cancellation_policy_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="cancellationPolicyFile")
    customer_communication_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="customerCommunicationFile")
    refund_policy_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="refundPolicyFile")
    shipping_documentation_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="shippingDocumentationFile")
    uncategorized_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="uncategorizedFile")
    service_documentation_file = sgqlc.types.Field("ShopifyPaymentsDisputeFileUploadUpdateInput", graphql_name="serviceDocumentationFile")
    submit_evidence = sgqlc.types.Field(Boolean, graphql_name="submitEvidence")


class ShopifyPaymentsDisputeFileUploadUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "destroy")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    destroy = sgqlc.types.Field(Boolean, graphql_name="destroy")


class StageImageInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("resource", "filename", "mime_type", "http_method")
    resource = sgqlc.types.Field(sgqlc.types.non_null(StagedUploadTargetGenerateUploadResource), graphql_name="resource")
    filename = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="filename")
    mime_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mimeType")
    http_method = sgqlc.types.Field(StagedUploadHttpMethodType, graphql_name="httpMethod")


class StagedUploadInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("resource", "filename", "mime_type", "http_method", "file_size")
    resource = sgqlc.types.Field(sgqlc.types.non_null(StagedUploadTargetGenerateUploadResource), graphql_name="resource")
    filename = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="filename")
    mime_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mimeType")
    http_method = sgqlc.types.Field(StagedUploadHttpMethodType, graphql_name="httpMethod")
    file_size = sgqlc.types.Field(UnsignedInt64, graphql_name="fileSize")


class StagedUploadTargetGenerateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("resource", "filename", "mime_type", "http_method", "file_size")
    resource = sgqlc.types.Field(sgqlc.types.non_null(StagedUploadTargetGenerateUploadResource), graphql_name="resource")
    filename = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="filename")
    mime_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mimeType")
    http_method = sgqlc.types.Field(StagedUploadHttpMethodType, graphql_name="httpMethod")
    file_size = sgqlc.types.Field(UnsignedInt64, graphql_name="fileSize")


class StandardizedProductTypeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_taxonomy_node_id",)
    product_taxonomy_node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productTaxonomyNodeId")


class StorefrontAccessTokenDeleteInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class StorefrontAccessTokenInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title",)
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class SubscriptionAtomicLineInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("line", "discounts")
    line = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionLineInput"), graphql_name="line")
    discounts = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionAtomicManualDiscountInput")), graphql_name="discounts"
    )


class SubscriptionAtomicManualDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "value", "recurring_cycle_limit")
    title = sgqlc.types.Field(String, graphql_name="title")
    value = sgqlc.types.Field("SubscriptionManualDiscountValueInput", graphql_name="value")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")


class SubscriptionBillingAttemptInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("idempotency_key", "origin_time", "billing_cycle_selector")
    idempotency_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="idempotencyKey")
    origin_time = sgqlc.types.Field(DateTime, graphql_name="originTime")
    billing_cycle_selector = sgqlc.types.Field("SubscriptionBillingCycleSelector", graphql_name="billingCycleSelector")


class SubscriptionBillingCycleInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("contract_id", "selector")
    contract_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="contractId")
    selector = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionBillingCycleSelector"), graphql_name="selector")


class SubscriptionBillingCycleScheduleEditInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("skip", "billing_date", "reason")
    skip = sgqlc.types.Field(Boolean, graphql_name="skip")
    billing_date = sgqlc.types.Field(DateTime, graphql_name="billingDate")
    reason = sgqlc.types.Field(sgqlc.types.non_null(SubscriptionBillingCycleScheduleEditInputScheduleEditReason), graphql_name="reason")


class SubscriptionBillingCycleSelector(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("index", "date")
    index = sgqlc.types.Field(Int, graphql_name="index")
    date = sgqlc.types.Field(DateTime, graphql_name="date")


class SubscriptionBillingCyclesDateRangeSelector(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("start_date", "end_date")
    start_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startDate")
    end_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="endDate")


class SubscriptionBillingCyclesIndexRangeSelector(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("start_index", "end_index")
    start_index = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="startIndex")
    end_index = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="endIndex")


class SubscriptionBillingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "interval_count", "min_cycles", "max_cycles", "anchors")
    interval = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanInterval), graphql_name="interval")
    interval_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalCount")
    min_cycles = sgqlc.types.Field(Int, graphql_name="minCycles")
    max_cycles = sgqlc.types.Field(Int, graphql_name="maxCycles")
    anchors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchorInput)), graphql_name="anchors")


class SubscriptionContractAtomicCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "next_billing_date", "currency_code", "contract", "lines", "discount_codes")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="customerId")
    next_billing_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="nextBillingDate")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")
    contract = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionDraftInput"), graphql_name="contract")
    lines = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionAtomicLineInput))), graphql_name="lines"
    )
    discount_codes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="discountCodes")


class SubscriptionContractCreateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("customer_id", "next_billing_date", "currency_code", "contract")
    customer_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="customerId")
    next_billing_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="nextBillingDate")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")
    contract = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionDraftInput"), graphql_name="contract")


class SubscriptionContractProductChangeInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("product_variant_id", "current_price")
    product_variant_id = sgqlc.types.Field(ID, graphql_name="productVariantId")
    current_price = sgqlc.types.Field(Decimal, graphql_name="currentPrice")


class SubscriptionDeliveryMethodInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("shipping", "local_delivery", "pickup")
    shipping = sgqlc.types.Field("SubscriptionDeliveryMethodShippingInput", graphql_name="shipping")
    local_delivery = sgqlc.types.Field("SubscriptionDeliveryMethodLocalDeliveryInput", graphql_name="localDelivery")
    pickup = sgqlc.types.Field("SubscriptionDeliveryMethodPickupInput", graphql_name="pickup")


class SubscriptionDeliveryMethodLocalDeliveryInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address", "local_delivery_option")
    address = sgqlc.types.Field(MailingAddressInput, graphql_name="address")
    local_delivery_option = sgqlc.types.Field("SubscriptionDeliveryMethodLocalDeliveryOptionInput", graphql_name="localDeliveryOption")


class SubscriptionDeliveryMethodLocalDeliveryOptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "presentment_title", "description", "code", "phone", "instructions")
    title = sgqlc.types.Field(String, graphql_name="title")
    presentment_title = sgqlc.types.Field(String, graphql_name="presentmentTitle")
    description = sgqlc.types.Field(String, graphql_name="description")
    code = sgqlc.types.Field(String, graphql_name="code")
    phone = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="phone")
    instructions = sgqlc.types.Field(String, graphql_name="instructions")


class SubscriptionDeliveryMethodPickupInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("pickup_option",)
    pickup_option = sgqlc.types.Field("SubscriptionDeliveryMethodPickupOptionInput", graphql_name="pickupOption")


class SubscriptionDeliveryMethodPickupOptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "presentment_title", "description", "code", "location_id")
    title = sgqlc.types.Field(String, graphql_name="title")
    presentment_title = sgqlc.types.Field(String, graphql_name="presentmentTitle")
    description = sgqlc.types.Field(String, graphql_name="description")
    code = sgqlc.types.Field(String, graphql_name="code")
    location_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="locationId")


class SubscriptionDeliveryMethodShippingInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("address", "shipping_option")
    address = sgqlc.types.Field(MailingAddressInput, graphql_name="address")
    shipping_option = sgqlc.types.Field("SubscriptionDeliveryMethodShippingOptionInput", graphql_name="shippingOption")


class SubscriptionDeliveryMethodShippingOptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "presentment_title", "description", "code", "carrier_service_id")
    title = sgqlc.types.Field(String, graphql_name="title")
    presentment_title = sgqlc.types.Field(String, graphql_name="presentmentTitle")
    description = sgqlc.types.Field(String, graphql_name="description")
    code = sgqlc.types.Field(String, graphql_name="code")
    carrier_service_id = sgqlc.types.Field(ID, graphql_name="carrierServiceId")


class SubscriptionDeliveryPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "interval_count", "anchors")
    interval = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanInterval), graphql_name="interval")
    interval_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalCount")
    anchors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchorInput)), graphql_name="anchors")


class SubscriptionDraftInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "status",
        "payment_method_id",
        "next_billing_date",
        "billing_policy",
        "delivery_policy",
        "delivery_price",
        "delivery_method",
        "note",
        "custom_attributes",
    )
    status = sgqlc.types.Field(SubscriptionContractSubscriptionStatus, graphql_name="status")
    payment_method_id = sgqlc.types.Field(ID, graphql_name="paymentMethodId")
    next_billing_date = sgqlc.types.Field(DateTime, graphql_name="nextBillingDate")
    billing_policy = sgqlc.types.Field(SubscriptionBillingPolicyInput, graphql_name="billingPolicy")
    delivery_policy = sgqlc.types.Field(SubscriptionDeliveryPolicyInput, graphql_name="deliveryPolicy")
    delivery_price = sgqlc.types.Field(Decimal, graphql_name="deliveryPrice")
    delivery_method = sgqlc.types.Field(SubscriptionDeliveryMethodInput, graphql_name="deliveryMethod")
    note = sgqlc.types.Field(String, graphql_name="note")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")


class SubscriptionFreeShippingDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "recurring_cycle_limit")
    title = sgqlc.types.Field(String, graphql_name="title")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")


class SubscriptionLineInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "product_variant_id",
        "quantity",
        "current_price",
        "custom_attributes",
        "selling_plan_id",
        "selling_plan_name",
        "pricing_policy",
    )
    product_variant_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productVariantId")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    current_price = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="currentPrice")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")
    selling_plan_id = sgqlc.types.Field(ID, graphql_name="sellingPlanId")
    selling_plan_name = sgqlc.types.Field(String, graphql_name="sellingPlanName")
    pricing_policy = sgqlc.types.Field("SubscriptionPricingPolicyInput", graphql_name="pricingPolicy")


class SubscriptionLineUpdateInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = (
        "product_variant_id",
        "quantity",
        "selling_plan_id",
        "selling_plan_name",
        "current_price",
        "custom_attributes",
        "pricing_policy",
    )
    product_variant_id = sgqlc.types.Field(ID, graphql_name="productVariantId")
    quantity = sgqlc.types.Field(Int, graphql_name="quantity")
    selling_plan_id = sgqlc.types.Field(ID, graphql_name="sellingPlanId")
    selling_plan_name = sgqlc.types.Field(String, graphql_name="sellingPlanName")
    current_price = sgqlc.types.Field(Decimal, graphql_name="currentPrice")
    custom_attributes = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AttributeInput)), graphql_name="customAttributes")
    pricing_policy = sgqlc.types.Field("SubscriptionPricingPolicyInput", graphql_name="pricingPolicy")


class SubscriptionManualDiscountEntitledLinesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("all", "lines")
    all = sgqlc.types.Field(Boolean, graphql_name="all")
    lines = sgqlc.types.Field("SubscriptionManualDiscountLinesInput", graphql_name="lines")


class SubscriptionManualDiscountFixedAmountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "applies_on_each_item")
    amount = sgqlc.types.Field(Float, graphql_name="amount")
    applies_on_each_item = sgqlc.types.Field(Boolean, graphql_name="appliesOnEachItem")


class SubscriptionManualDiscountInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("title", "value", "recurring_cycle_limit", "entitled_lines")
    title = sgqlc.types.Field(String, graphql_name="title")
    value = sgqlc.types.Field("SubscriptionManualDiscountValueInput", graphql_name="value")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")
    entitled_lines = sgqlc.types.Field(SubscriptionManualDiscountEntitledLinesInput, graphql_name="entitledLines")


class SubscriptionManualDiscountLinesInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("add", "remove")
    add = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="add")
    remove = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="remove")


class SubscriptionManualDiscountValueInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("percentage", "fixed_amount")
    percentage = sgqlc.types.Field(Int, graphql_name="percentage")
    fixed_amount = sgqlc.types.Field(SubscriptionManualDiscountFixedAmountInput, graphql_name="fixedAmount")


class SubscriptionPricingPolicyCycleDiscountsInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("after_cycle", "adjustment_type", "adjustment_value", "computed_price")
    after_cycle = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="afterCycle")
    adjustment_type = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanPricingPolicyAdjustmentType), graphql_name="adjustmentType")
    adjustment_value = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanPricingPolicyValueInput), graphql_name="adjustmentValue")
    computed_price = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="computedPrice")


class SubscriptionPricingPolicyInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("base_price", "cycle_discounts")
    base_price = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="basePrice")
    cycle_discounts = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionPricingPolicyCycleDiscountsInput))),
        graphql_name="cycleDiscounts",
    )


class TranslationInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("locale", "key", "value", "translatable_content_digest", "market_id")
    locale = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="locale")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    translatable_content_digest = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="translatableContentDigest")
    market_id = sgqlc.types.Field(ID, graphql_name="marketId")


class UTMInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("campaign", "source", "medium")
    campaign = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="campaign")
    source = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="source")
    medium = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="medium")


class UpdateMediaInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("id", "preview_image_source", "alt")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    preview_image_source = sgqlc.types.Field(String, graphql_name="previewImageSource")
    alt = sgqlc.types.Field(String, graphql_name="alt")


class UrlRedirectInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("path", "target")
    path = sgqlc.types.Field(String, graphql_name="path")
    target = sgqlc.types.Field(String, graphql_name="target")


class WebPixelInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("settings",)
    settings = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name="settings")


class WebhookSubscriptionInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("callback_url", "format", "include_fields", "metafield_namespaces")
    callback_url = sgqlc.types.Field(URL, graphql_name="callbackUrl")
    format = sgqlc.types.Field(WebhookSubscriptionFormat, graphql_name="format")
    include_fields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="includeFields")
    metafield_namespaces = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="metafieldNamespaces")


class WeightInput(sgqlc.types.Input):
    __schema__ = shopify_schema
    __field_names__ = ("value", "unit")
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    unit = sgqlc.types.Field(sgqlc.types.non_null(WeightUnit), graphql_name="unit")


########################################################################
# Output Objects and Interfaces
########################################################################
class AppPurchase(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("created_at", "name", "price", "status", "test")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    price = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="price")
    status = sgqlc.types.Field(sgqlc.types.non_null(AppPurchaseStatus), graphql_name="status")
    test = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="test")


class CalculatedDiscountApplication(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("allocation_method", "applied_to", "description", "id", "target_selection", "target_type", "value")
    allocation_method = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationAllocationMethod), graphql_name="allocationMethod")
    applied_to = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationLevel), graphql_name="appliedTo")
    description = sgqlc.types.Field(String, graphql_name="description")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    target_selection = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationTargetSelection), graphql_name="targetSelection")
    target_type = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationTargetType), graphql_name="targetType")
    value = sgqlc.types.Field(sgqlc.types.non_null("PricingValue"), graphql_name="value")


class CommentEventSubject(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("has_timeline_comment", "id")
    has_timeline_comment = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasTimelineComment")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class CustomerMoment(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("occurred_at",)
    occurred_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="occurredAt")


class DiscountApplication(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("allocation_method", "index", "target_selection", "target_type", "value")
    allocation_method = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationAllocationMethod), graphql_name="allocationMethod")
    index = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="index")
    target_selection = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationTargetSelection), graphql_name="targetSelection")
    target_type = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationTargetType), graphql_name="targetType")
    value = sgqlc.types.Field(sgqlc.types.non_null("PricingValue"), graphql_name="value")


class DisplayableError(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("field", "message")
    field = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="field")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")


class Event(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("app_title", "attribute_to_app", "attribute_to_user", "created_at", "critical_alert", "id", "message")
    app_title = sgqlc.types.Field(String, graphql_name="appTitle")
    attribute_to_app = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="attributeToApp")
    attribute_to_user = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="attributeToUser")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    critical_alert = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="criticalAlert")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    message = sgqlc.types.Field(sgqlc.types.non_null(FormattedString), graphql_name="message")


class File(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("alt", "created_at", "file_errors", "file_status", "id", "preview", "updated_at")
    alt = sgqlc.types.Field(String, graphql_name="alt")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    file_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FileError"))), graphql_name="fileErrors")
    file_status = sgqlc.types.Field(sgqlc.types.non_null(FileStatus), graphql_name="fileStatus")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    preview = sgqlc.types.Field("MediaPreviewImage", graphql_name="preview")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")


class HasEvents(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("events",)
    events = sgqlc.types.Field(
        sgqlc.types.non_null("EventConnection"),
        graphql_name="events",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(EventSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )


class HasLocalizationExtensions(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("localization_extensions",)
    localization_extensions = sgqlc.types.Field(
        sgqlc.types.non_null("LocalizationExtensionConnection"),
        graphql_name="localizationExtensions",
        args=sgqlc.types.ArgDict(
            (
                (
                    "country_codes",
                    sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode)), graphql_name="countryCodes", default=None),
                ),
                (
                    "purposes",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(LocalizationExtensionPurpose)), graphql_name="purposes", default=None
                    ),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class HasMetafieldDefinitions(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("metafield_definitions",)
    metafield_definitions = sgqlc.types.Field(
        sgqlc.types.non_null("MetafieldDefinitionConnection"),
        graphql_name="metafieldDefinitions",
        args=sgqlc.types.ArgDict(
            (
                ("namespace", sgqlc.types.Arg(String, graphql_name="namespace", default=None)),
                ("pinned_status", sgqlc.types.Arg(MetafieldDefinitionPinnedStatus, graphql_name="pinnedStatus", default="ANY")),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(MetafieldDefinitionSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )


class HasMetafields(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("metafield", "metafields")
    metafield = sgqlc.types.Field(
        "Metafield",
        graphql_name="metafield",
        args=sgqlc.types.ArgDict(
            (
                ("namespace", sgqlc.types.Arg(String, graphql_name="namespace", default=None)),
                ("key", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="key", default=None)),
            )
        ),
    )
    metafields = sgqlc.types.Field(
        sgqlc.types.non_null("MetafieldConnection"),
        graphql_name="metafields",
        args=sgqlc.types.ArgDict(
            (
                ("namespace", sgqlc.types.Arg(String, graphql_name="namespace", default=None)),
                ("keys", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="keys", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class HasPublishedTranslations(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("translations",)
    translations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Translation"))),
        graphql_name="translations",
        args=sgqlc.types.ArgDict(
            (
                ("locale", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="locale", default=None)),
                ("market_id", sgqlc.types.Arg(ID, graphql_name="marketId", default=None)),
            )
        ),
    )


class JobResult(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("done", "id")
    done = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="done")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class LegacyInteroperability(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("legacy_resource_id",)
    legacy_resource_id = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="legacyResourceId")


class MarketRegion(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("id", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class Media(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("alt", "id", "media_content_type", "media_errors", "media_warnings", "preview", "status")
    alt = sgqlc.types.Field(String, graphql_name="alt")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    media_content_type = sgqlc.types.Field(sgqlc.types.non_null(MediaContentType), graphql_name="mediaContentType")
    media_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaError"))), graphql_name="mediaErrors"
    )
    media_warnings = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaWarning"))), graphql_name="mediaWarnings"
    )
    preview = sgqlc.types.Field("MediaPreviewImage", graphql_name="preview")
    status = sgqlc.types.Field(sgqlc.types.non_null(MediaStatus), graphql_name="status")


class Navigable(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("default_cursor",)
    default_cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="defaultCursor")


class Node(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class OnlineStorePreviewable(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("online_store_preview_url",)
    online_store_preview_url = sgqlc.types.Field(URL, graphql_name="onlineStorePreviewUrl")


class Publishable(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = (
        "available_publication_count",
        "publication_count",
        "published_on_current_publication",
        "published_on_publication",
        "resource_publications",
        "resource_publications_v2",
        "unpublished_publications",
    )
    available_publication_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="availablePublicationCount")
    publication_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int),
        graphql_name="publicationCount",
        args=sgqlc.types.ArgDict((("only_published", sgqlc.types.Arg(Boolean, graphql_name="onlyPublished", default=True)),)),
    )
    published_on_current_publication = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="publishedOnCurrentPublication")
    published_on_publication = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean),
        graphql_name="publishedOnPublication",
        args=sgqlc.types.ArgDict(
            (("publication_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="publicationId", default=None)),)
        ),
    )
    resource_publications = sgqlc.types.Field(
        sgqlc.types.non_null("ResourcePublicationConnection"),
        graphql_name="resourcePublications",
        args=sgqlc.types.ArgDict(
            (
                ("only_published", sgqlc.types.Arg(Boolean, graphql_name="onlyPublished", default=True)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    resource_publications_v2 = sgqlc.types.Field(
        sgqlc.types.non_null("ResourcePublicationV2Connection"),
        graphql_name="resourcePublicationsV2",
        args=sgqlc.types.ArgDict(
            (
                ("only_published", sgqlc.types.Arg(Boolean, graphql_name="onlyPublished", default=True)),
                ("catalog_type", sgqlc.types.Arg(CatalogType, graphql_name="catalogType", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    unpublished_publications = sgqlc.types.Field(
        sgqlc.types.non_null("PublicationConnection"),
        graphql_name="unpublishedPublications",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class ResourceOperation(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("id", "processed_row_count", "row_count", "status")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    processed_row_count = sgqlc.types.Field(Int, graphql_name="processedRowCount")
    row_count = sgqlc.types.Field("RowCount", graphql_name="rowCount")
    status = sgqlc.types.Field(sgqlc.types.non_null(ResourceOperationStatus), graphql_name="status")


class Sale(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = (
        "action_type",
        "id",
        "line_type",
        "quantity",
        "taxes",
        "total_amount",
        "total_discount_amount_after_taxes",
        "total_discount_amount_before_taxes",
        "total_tax_amount",
    )
    action_type = sgqlc.types.Field(sgqlc.types.non_null(SaleActionType), graphql_name="actionType")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    line_type = sgqlc.types.Field(sgqlc.types.non_null(SaleLineType), graphql_name="lineType")
    quantity = sgqlc.types.Field(Int, graphql_name="quantity")
    taxes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SaleTax"))), graphql_name="taxes")
    total_amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalAmount")
    total_discount_amount_after_taxes = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalDiscountAmountAfterTaxes")
    total_discount_amount_before_taxes = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalDiscountAmountBeforeTaxes")
    total_tax_amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalTaxAmount")


class SalesAgreement(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("app", "happened_at", "id", "reason", "sales", "user")
    app = sgqlc.types.Field("App", graphql_name="app")
    happened_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="happenedAt")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    reason = sgqlc.types.Field(sgqlc.types.non_null(OrderActionType), graphql_name="reason")
    sales = sgqlc.types.Field(
        sgqlc.types.non_null("SaleConnection"),
        graphql_name="sales",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    user = sgqlc.types.Field("StaffMember", graphql_name="user")


class SegmentFilter(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("localized_name", "multi_value", "query_name")
    localized_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="localizedName")
    multi_value = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="multiValue")
    query_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryName")


class SellingPlanPricingPolicyBase(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("adjustment_type", "adjustment_value")
    adjustment_type = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanPricingPolicyAdjustmentType), graphql_name="adjustmentType")
    adjustment_value = sgqlc.types.Field(sgqlc.types.non_null("SellingPlanPricingPolicyAdjustmentValue"), graphql_name="adjustmentValue")


class ShopifyPaymentsChargeStatementDescriptor(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("default", "prefix")
    default = sgqlc.types.Field(String, graphql_name="default")
    prefix = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="prefix")


class ShopifyqlResponse(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("parse_errors", "table_data")
    parse_errors = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ParseError")), graphql_name="parseErrors")
    table_data = sgqlc.types.Field("TableData", graphql_name="tableData")


class SubscriptionContractBase(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = (
        "app",
        "app_admin_url",
        "currency_code",
        "custom_attributes",
        "customer",
        "customer_payment_method",
        "delivery_method",
        "delivery_price",
        "discounts",
        "line_count",
        "lines",
        "note",
        "orders",
        "updated_at",
    )
    app = sgqlc.types.Field("App", graphql_name="app")
    app_admin_url = sgqlc.types.Field(URL, graphql_name="appAdminUrl")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")
    custom_attributes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Attribute"))), graphql_name="customAttributes"
    )
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    customer_payment_method = sgqlc.types.Field(
        "CustomerPaymentMethod",
        graphql_name="customerPaymentMethod",
        args=sgqlc.types.ArgDict((("show_revoked", sgqlc.types.Arg(Boolean, graphql_name="showRevoked", default=False)),)),
    )
    delivery_method = sgqlc.types.Field("SubscriptionDeliveryMethod", graphql_name="deliveryMethod")
    delivery_price = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="deliveryPrice")
    discounts = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionManualDiscountConnection"),
        graphql_name="discounts",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    line_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="lineCount")
    lines = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionLineConnection"),
        graphql_name="lines",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    note = sgqlc.types.Field(String, graphql_name="note")
    orders = sgqlc.types.Field(
        sgqlc.types.non_null("OrderConnection"),
        graphql_name="orders",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")


class Catalog(sgqlc.types.Interface):
    __schema__ = shopify_schema
    __field_names__ = ("id", "operations", "price_list", "publication", "status", "title")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    operations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ResourceOperation))), graphql_name="operations"
    )
    price_list = sgqlc.types.Field("PriceList", graphql_name="priceList")
    publication = sgqlc.types.Field("Publication", graphql_name="publication")
    status = sgqlc.types.Field(sgqlc.types.non_null(CatalogStatus), graphql_name="status")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class AbandonmentEmailStateUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("abandonment", "user_errors")
    abandonment = sgqlc.types.Field("Abandonment", graphql_name="abandonment")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AbandonmentEmailStateUpdateUserError"))), graphql_name="userErrors"
    )


class AbandonmentUpdateActivitiesDeliveryStatusesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("abandonment", "user_errors")
    abandonment = sgqlc.types.Field("Abandonment", graphql_name="abandonment")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AbandonmentUpdateActivitiesDeliveryStatusesUserError"))),
        graphql_name="userErrors",
    )


class AccessScope(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "handle")
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")


class AllDiscountItems(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("all_items",)
    all_items = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="allItems")


class ApiVersion(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("display_name", "handle", "supported")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")
    supported = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="supported")


class AppConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("App"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppCreditConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppCreditEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppCredit"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppCreditEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppCredit"), graphql_name="node")


class AppDiscountType(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app", "app_bridge", "app_key", "description", "discount_class", "function_id", "target_type", "title")
    app = sgqlc.types.Field(sgqlc.types.non_null("App"), graphql_name="app")
    app_bridge = sgqlc.types.Field(sgqlc.types.non_null("FunctionsAppBridge"), graphql_name="appBridge")
    app_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="appKey")
    description = sgqlc.types.Field(String, graphql_name="description")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(DiscountClass), graphql_name="discountClass")
    function_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="functionId")
    target_type = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplicationTargetType), graphql_name="targetType")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class AppEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("App"), graphql_name="node")


class AppFeedback(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app", "link", "messages")
    app = sgqlc.types.Field(sgqlc.types.non_null("App"), graphql_name="app")
    link = sgqlc.types.Field("Link", graphql_name="link")
    messages = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="messages")


class AppInstallationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppInstallationEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppInstallation"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppInstallationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppInstallation"), graphql_name="node")


class AppPlanV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("pricing_details",)
    pricing_details = sgqlc.types.Field(sgqlc.types.non_null("AppPricingDetails"), graphql_name="pricingDetails")


class AppPurchaseOneTimeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppPurchaseOneTimeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppPurchaseOneTime"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppPurchaseOneTimeCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_purchase_one_time", "confirmation_url", "user_errors")
    app_purchase_one_time = sgqlc.types.Field("AppPurchaseOneTime", graphql_name="appPurchaseOneTime")
    confirmation_url = sgqlc.types.Field(URL, graphql_name="confirmationUrl")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class AppPurchaseOneTimeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppPurchaseOneTime"), graphql_name="node")


class AppRecurringPricing(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("discount", "interval", "price")
    discount = sgqlc.types.Field("AppSubscriptionDiscount", graphql_name="discount")
    interval = sgqlc.types.Field(sgqlc.types.non_null(AppPricingInterval), graphql_name="interval")
    price = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="price")


class AppRevenueAttributionRecordConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppRevenueAttributionRecordEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppRevenueAttributionRecord"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppRevenueAttributionRecordCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_revenue_attribution_record", "user_errors")
    app_revenue_attribution_record = sgqlc.types.Field("AppRevenueAttributionRecord", graphql_name="appRevenueAttributionRecord")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppRevenueAttributionRecordCreateUserError"))),
        graphql_name="userErrors",
    )


class AppRevenueAttributionRecordDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppRevenueAttributionRecordDeleteUserError"))),
        graphql_name="userErrors",
    )


class AppRevenueAttributionRecordEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppRevenueAttributionRecord"), graphql_name="node")


class AppSubscriptionCancelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_subscription", "user_errors")
    app_subscription = sgqlc.types.Field("AppSubscription", graphql_name="appSubscription")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class AppSubscriptionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppSubscriptionEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppSubscription"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppSubscriptionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_subscription", "confirmation_url", "user_errors")
    app_subscription = sgqlc.types.Field("AppSubscription", graphql_name="appSubscription")
    confirmation_url = sgqlc.types.Field(URL, graphql_name="confirmationUrl")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class AppSubscriptionDiscount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("duration_limit_in_intervals", "price_after_discount", "remaining_duration_in_intervals", "value")
    duration_limit_in_intervals = sgqlc.types.Field(Int, graphql_name="durationLimitInIntervals")
    price_after_discount = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="priceAfterDiscount")
    remaining_duration_in_intervals = sgqlc.types.Field(Int, graphql_name="remainingDurationInIntervals")
    value = sgqlc.types.Field(sgqlc.types.non_null("AppSubscriptionDiscountValue"), graphql_name="value")


class AppSubscriptionDiscountAmount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount",)
    amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="amount")


class AppSubscriptionDiscountPercentage(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class AppSubscriptionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppSubscription"), graphql_name="node")


class AppSubscriptionLineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("id", "plan", "usage_records")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    plan = sgqlc.types.Field(sgqlc.types.non_null(AppPlanV2), graphql_name="plan")
    usage_records = sgqlc.types.Field(
        sgqlc.types.non_null("AppUsageRecordConnection"),
        graphql_name="usageRecords",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(AppUsageRecordSortKeys, graphql_name="sortKey", default="CREATED_AT")),
            )
        ),
    )


class AppSubscriptionLineItemUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_subscription", "confirmation_url", "user_errors")
    app_subscription = sgqlc.types.Field("AppSubscription", graphql_name="appSubscription")
    confirmation_url = sgqlc.types.Field(URL, graphql_name="confirmationUrl")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class AppSubscriptionTrialExtendPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_subscription", "user_errors")
    app_subscription = sgqlc.types.Field("AppSubscription", graphql_name="appSubscription")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppSubscriptionTrialExtendUserError"))), graphql_name="userErrors"
    )


class AppUsagePricing(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("balance_used", "capped_amount", "interval", "terms")
    balance_used = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="balanceUsed")
    capped_amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="cappedAmount")
    interval = sgqlc.types.Field(sgqlc.types.non_null(AppPricingInterval), graphql_name="interval")
    terms = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="terms")


class AppUsageRecordConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppUsageRecordEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AppUsageRecord"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class AppUsageRecordCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("app_usage_record", "user_errors")
    app_usage_record = sgqlc.types.Field("AppUsageRecord", graphql_name="appUsageRecord")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class AppUsageRecordEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("AppUsageRecord"), graphql_name="node")


class Attribute(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(String, graphql_name="value")


class AvailableChannelDefinitionsByChannel(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("channel_definitions", "channel_name")
    channel_definitions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ChannelDefinition"))), graphql_name="channelDefinitions"
    )
    channel_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="channelName")


class BulkOperationCancelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("bulk_operation", "user_errors")
    bulk_operation = sgqlc.types.Field("BulkOperation", graphql_name="bulkOperation")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class BulkOperationRunMutationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("bulk_operation", "user_errors")
    bulk_operation = sgqlc.types.Field("BulkOperation", graphql_name="bulkOperation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BulkMutationUserError"))), graphql_name="userErrors"
    )


class BulkOperationRunQueryPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("bulk_operation", "user_errors")
    bulk_operation = sgqlc.types.Field("BulkOperation", graphql_name="bulkOperation")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class BulkProductResourceFeedbackCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("feedback", "user_errors")
    feedback = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductResourceFeedback")), graphql_name="feedback")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BulkProductResourceFeedbackCreateUserError"))),
        graphql_name="userErrors",
    )


class BundlesFeature(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("eligible_for_bundles", "ineligibility_reason", "sells_bundles")
    eligible_for_bundles = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="eligibleForBundles")
    ineligibility_reason = sgqlc.types.Field(String, graphql_name="ineligibilityReason")
    sells_bundles = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="sellsBundles")


class BuyerExperienceConfiguration(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("checkout_to_draft", "editable_shipping_address", "pay_now_only", "payment_terms_template")
    checkout_to_draft = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="checkoutToDraft")
    editable_shipping_address = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="editableShippingAddress")
    pay_now_only = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="payNowOnly")
    payment_terms_template = sgqlc.types.Field("PaymentTermsTemplate", graphql_name="paymentTermsTemplate")


class CalculatedDiscountAllocation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("allocated_amount_set", "discount_application")
    allocated_amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="allocatedAmountSet")
    discount_application = sgqlc.types.Field(sgqlc.types.non_null(CalculatedDiscountApplication), graphql_name="discountApplication")


class CalculatedDiscountApplicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CalculatedDiscountApplicationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CalculatedDiscountApplication))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CalculatedDiscountApplicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CalculatedDiscountApplication), graphql_name="node")


class CalculatedDraftOrder(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "applied_discount",
        "available_shipping_rates",
        "billing_address_matches_shipping_address",
        "currency_code",
        "customer",
        "line_items",
        "line_items_subtotal_price",
        "market_name",
        "market_region_country_code",
        "phone",
        "presentment_currency_code",
        "purchasing_entity",
        "shipping_line",
        "subtotal_price",
        "subtotal_price_set",
        "tax_lines",
        "total_discounts_set",
        "total_line_items_price_set",
        "total_price",
        "total_price_set",
        "total_shipping_price",
        "total_shipping_price_set",
        "total_tax",
        "total_tax_set",
    )
    applied_discount = sgqlc.types.Field("DraftOrderAppliedDiscount", graphql_name="appliedDiscount")
    available_shipping_rates = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShippingRate"))), graphql_name="availableShippingRates"
    )
    billing_address_matches_shipping_address = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="billingAddressMatchesShippingAddress"
    )
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CalculatedDraftOrderLineItem"))), graphql_name="lineItems"
    )
    line_items_subtotal_price = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="lineItemsSubtotalPrice")
    market_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="marketName")
    market_region_country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="marketRegionCountryCode")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    presentment_currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="presentmentCurrencyCode")
    purchasing_entity = sgqlc.types.Field("PurchasingEntity", graphql_name="purchasingEntity")
    shipping_line = sgqlc.types.Field("ShippingLine", graphql_name="shippingLine")
    subtotal_price = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="subtotalPrice")
    subtotal_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="subtotalPriceSet")
    tax_lines = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TaxLine"))), graphql_name="taxLines")
    total_discounts_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalDiscountsSet")
    total_line_items_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalLineItemsPriceSet")
    total_price = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="totalPrice")
    total_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalPriceSet")
    total_shipping_price = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="totalShippingPrice")
    total_shipping_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalShippingPriceSet")
    total_tax = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="totalTax")
    total_tax_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalTaxSet")


class CalculatedDraftOrderLineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "applied_discount",
        "custom",
        "custom_attributes",
        "custom_attributes_v2",
        "discounted_total",
        "discounted_total_set",
        "discounted_unit_price",
        "discounted_unit_price_set",
        "fulfillment_service",
        "image",
        "is_gift_card",
        "name",
        "original_total",
        "original_total_set",
        "original_unit_price",
        "original_unit_price_set",
        "product",
        "quantity",
        "requires_shipping",
        "sku",
        "taxable",
        "title",
        "total_discount",
        "total_discount_set",
        "variant",
        "variant_title",
        "vendor",
        "weight",
    )
    applied_discount = sgqlc.types.Field("DraftOrderAppliedDiscount", graphql_name="appliedDiscount")
    custom = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="custom")
    custom_attributes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Attribute))), graphql_name="customAttributes"
    )
    custom_attributes_v2 = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TypedAttribute"))), graphql_name="customAttributesV2"
    )
    discounted_total = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="discountedTotal")
    discounted_total_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="discountedTotalSet")
    discounted_unit_price = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="discountedUnitPrice")
    discounted_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="discountedUnitPriceSet")
    fulfillment_service = sgqlc.types.Field("FulfillmentService", graphql_name="fulfillmentService")
    image = sgqlc.types.Field("Image", graphql_name="image")
    is_gift_card = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isGiftCard")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    original_total = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="originalTotal")
    original_total_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="originalTotalSet")
    original_unit_price = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="originalUnitPrice")
    original_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="originalUnitPriceSet")
    product = sgqlc.types.Field("Product", graphql_name="product")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    requires_shipping = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="requiresShipping")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    taxable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="taxable")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    total_discount = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="totalDiscount")
    total_discount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalDiscountSet")
    variant = sgqlc.types.Field("ProductVariant", graphql_name="variant")
    variant_title = sgqlc.types.Field(String, graphql_name="variantTitle")
    vendor = sgqlc.types.Field(String, graphql_name="vendor")
    weight = sgqlc.types.Field("Weight", graphql_name="weight")


class CalculatedLineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "calculated_discount_allocations",
        "custom_attributes",
        "discounted_unit_price_set",
        "editable_quantity",
        "editable_quantity_before_changes",
        "editable_subtotal_set",
        "has_staged_line_item_discount",
        "id",
        "image",
        "original_unit_price_set",
        "quantity",
        "restockable",
        "restocking",
        "sku",
        "staged_changes",
        "title",
        "uneditable_subtotal_set",
        "variant",
        "variant_title",
    )
    calculated_discount_allocations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CalculatedDiscountAllocation))),
        graphql_name="calculatedDiscountAllocations",
    )
    custom_attributes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Attribute))), graphql_name="customAttributes"
    )
    discounted_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="discountedUnitPriceSet")
    editable_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="editableQuantity")
    editable_quantity_before_changes = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="editableQuantityBeforeChanges")
    editable_subtotal_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="editableSubtotalSet")
    has_staged_line_item_discount = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasStagedLineItemDiscount")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    image = sgqlc.types.Field("Image", graphql_name="image")
    original_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="originalUnitPriceSet")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    restockable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restockable")
    restocking = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restocking")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    staged_changes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderStagedChange"))), graphql_name="stagedChanges"
    )
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    uneditable_subtotal_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="uneditableSubtotalSet")
    variant = sgqlc.types.Field("ProductVariant", graphql_name="variant")
    variant_title = sgqlc.types.Field(String, graphql_name="variantTitle")


class CalculatedLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CalculatedLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CalculatedLineItem))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CalculatedLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CalculatedLineItem), graphql_name="node")


class CardPaymentDetails(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "avs_result_code",
        "bin",
        "company",
        "cvv_result_code",
        "expiration_month",
        "expiration_year",
        "name",
        "number",
        "wallet",
    )
    avs_result_code = sgqlc.types.Field(String, graphql_name="avsResultCode")
    bin = sgqlc.types.Field(String, graphql_name="bin")
    company = sgqlc.types.Field(String, graphql_name="company")
    cvv_result_code = sgqlc.types.Field(String, graphql_name="cvvResultCode")
    expiration_month = sgqlc.types.Field(Int, graphql_name="expirationMonth")
    expiration_year = sgqlc.types.Field(Int, graphql_name="expirationYear")
    name = sgqlc.types.Field(String, graphql_name="name")
    number = sgqlc.types.Field(String, graphql_name="number")
    wallet = sgqlc.types.Field(DigitalWallet, graphql_name="wallet")


class CartTransformConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CartTransformEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CartTransform"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CartTransformCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cart_transform", "user_errors")
    cart_transform = sgqlc.types.Field("CartTransform", graphql_name="cartTransform")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CartTransformCreateUserError"))), graphql_name="userErrors"
    )


class CartTransformDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CartTransformDeleteUserError"))), graphql_name="userErrors"
    )


class CartTransformEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CartTransform"), graphql_name="node")


class CatalogConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info", "total_count")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CatalogEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Catalog))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    total_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="totalCount")


class CatalogContextUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("catalog", "user_errors")
    catalog = sgqlc.types.Field(Catalog, graphql_name="catalog")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CatalogUserError"))), graphql_name="userErrors"
    )


class CatalogCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("catalog", "user_errors")
    catalog = sgqlc.types.Field(Catalog, graphql_name="catalog")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CatalogUserError"))), graphql_name="userErrors"
    )


class CatalogDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CatalogUserError"))), graphql_name="userErrors"
    )


class CatalogEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(Catalog), graphql_name="node")


class CatalogUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("catalog", "user_errors")
    catalog = sgqlc.types.Field(Catalog, graphql_name="catalog")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CatalogUserError"))), graphql_name="userErrors"
    )


class ChannelConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ChannelEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Channel"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class ChannelEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Channel"), graphql_name="node")


class CheckoutProfileConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CheckoutProfileEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CheckoutProfile"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CheckoutProfileEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CheckoutProfile"), graphql_name="node")


class CollectionAddProductsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "user_errors")
    collection = sgqlc.types.Field("Collection", graphql_name="collection")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionAddProductsV2Payload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CollectionAddProductsV2UserError"))), graphql_name="userErrors"
    )


class CollectionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CollectionEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Collection"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CollectionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "user_errors")
    collection = sgqlc.types.Field("Collection", graphql_name="collection")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_collection_id", "shop", "user_errors")
    deleted_collection_id = sgqlc.types.Field(ID, graphql_name="deletedCollectionId")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Collection"), graphql_name="node")


class CollectionPublication(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "is_published", "publication", "publish_date")
    collection = sgqlc.types.Field(sgqlc.types.non_null("Collection"), graphql_name="collection")
    is_published = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPublished")
    publication = sgqlc.types.Field(sgqlc.types.non_null("Publication"), graphql_name="publication")
    publish_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="publishDate")


class CollectionPublicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CollectionPublicationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionPublication))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CollectionPublicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CollectionPublication), graphql_name="node")


class CollectionPublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "collection_publications", "shop", "user_errors")
    collection = sgqlc.types.Field("Collection", graphql_name="collection")
    collection_publications = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(CollectionPublication)), graphql_name="collectionPublications"
    )
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionRemoveProductsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionReorderProductsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionRule(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("column", "condition", "condition_object", "relation")
    column = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleColumn), graphql_name="column")
    condition = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="condition")
    condition_object = sgqlc.types.Field("CollectionRuleConditionObject", graphql_name="conditionObject")
    relation = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleRelation), graphql_name="relation")


class CollectionRuleConditions(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("allowed_relations", "default_relation", "rule_object", "rule_type")
    allowed_relations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionRuleRelation))), graphql_name="allowedRelations"
    )
    default_relation = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleRelation), graphql_name="defaultRelation")
    rule_object = sgqlc.types.Field("CollectionRuleConditionsRuleObject", graphql_name="ruleObject")
    rule_type = sgqlc.types.Field(sgqlc.types.non_null(CollectionRuleColumn), graphql_name="ruleType")


class CollectionRuleMetafieldCondition(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metafield_definition",)
    metafield_definition = sgqlc.types.Field(sgqlc.types.non_null("MetafieldDefinition"), graphql_name="metafieldDefinition")


class CollectionRuleProductCategoryCondition(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(sgqlc.types.non_null("ProductTaxonomyNode"), graphql_name="value")


class CollectionRuleSet(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("applied_disjunctively", "rules")
    applied_disjunctively = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliedDisjunctively")
    rules = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionRule))), graphql_name="rules")


class CollectionRuleTextCondition(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class CollectionUnpublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "shop", "user_errors")
    collection = sgqlc.types.Field("Collection", graphql_name="collection")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CollectionUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collection", "job", "user_errors")
    collection = sgqlc.types.Field("Collection", graphql_name="collection")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CommentEventAttachment(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("file_extension", "id", "image", "name", "size", "url")
    file_extension = sgqlc.types.Field(String, graphql_name="fileExtension")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    image = sgqlc.types.Field("Image", graphql_name="image")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    size = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="size")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class CompaniesDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_ids", "user_errors")
    deleted_company_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedCompanyIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyAddressDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_address_id", "user_errors")
    deleted_address_id = sgqlc.types.Field(ID, graphql_name="deletedAddressId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyAssignCustomerAsContactPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact", "user_errors")
    company_contact = sgqlc.types.Field("CompanyContact", graphql_name="companyContact")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyAssignMainContactPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "user_errors")
    company = sgqlc.types.Field("Company", graphql_name="company")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Company"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CompanyContactAssignRolePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact_role_assignment", "user_errors")
    company_contact_role_assignment = sgqlc.types.Field("CompanyContactRoleAssignment", graphql_name="companyContactRoleAssignment")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactAssignRolesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("role_assignments", "user_errors")
    role_assignments = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRoleAssignment")), graphql_name="roleAssignments"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContact"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CompanyContactCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact", "user_errors")
    company_contact = sgqlc.types.Field("CompanyContact", graphql_name="companyContact")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_contact_id", "user_errors")
    deleted_company_contact_id = sgqlc.types.Field(ID, graphql_name="deletedCompanyContactId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CompanyContact"), graphql_name="node")


class CompanyContactRemoveFromCompanyPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("removed_company_contact_id", "user_errors")
    removed_company_contact_id = sgqlc.types.Field(ID, graphql_name="removedCompanyContactId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactRevokeRolePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("revoked_company_contact_role_assignment_id", "user_errors")
    revoked_company_contact_role_assignment_id = sgqlc.types.Field(ID, graphql_name="revokedCompanyContactRoleAssignmentId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactRevokeRolesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("revoked_role_assignment_ids", "user_errors")
    revoked_role_assignment_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="revokedRoleAssignmentIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactRoleAssignmentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRoleAssignmentEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRoleAssignment"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CompanyContactRoleAssignmentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CompanyContactRoleAssignment"), graphql_name="node")


class CompanyContactRoleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRoleEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRole"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CompanyContactRoleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CompanyContactRole"), graphql_name="node")


class CompanyContactSendWelcomeEmailPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact", "user_errors")
    company_contact = sgqlc.types.Field("CompanyContact", graphql_name="companyContact")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_contact", "user_errors")
    company_contact = sgqlc.types.Field("CompanyContact", graphql_name="companyContact")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyContactsDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_contact_ids", "user_errors")
    deleted_company_contact_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedCompanyContactIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "user_errors")
    company = sgqlc.types.Field("Company", graphql_name="company")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_id", "user_errors")
    deleted_company_id = sgqlc.types.Field(ID, graphql_name="deletedCompanyId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Company"), graphql_name="node")


class CompanyLocationAssignAddressPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("addresses", "user_errors")
    addresses = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("CompanyAddress")), graphql_name="addresses")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationAssignRolesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("role_assignments", "user_errors")
    role_assignments = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("CompanyContactRoleAssignment")), graphql_name="roleAssignments"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationAssignTaxExemptionsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyLocationEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CompanyLocation"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CompanyLocationCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationCreateTaxRegistrationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_location_id", "user_errors")
    deleted_company_location_id = sgqlc.types.Field(ID, graphql_name="deletedCompanyLocationId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CompanyLocation"), graphql_name="node")


class CompanyLocationRevokeRolesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("revoked_role_assignment_ids", "user_errors")
    revoked_role_assignment_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="revokedRoleAssignmentIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationRevokeTaxExemptionsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationRevokeTaxRegistrationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company_location", "user_errors")
    company_location = sgqlc.types.Field("CompanyLocation", graphql_name="companyLocation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyLocationsDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_company_location_ids", "user_errors")
    deleted_company_location_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedCompanyLocationIds"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyRevokeMainContactPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "user_errors")
    company = sgqlc.types.Field("Company", graphql_name="company")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CompanyUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "user_errors")
    company = sgqlc.types.Field("Company", graphql_name="company")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BusinessCustomerUserError"))), graphql_name="userErrors"
    )


class CountriesInShippingZones(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_codes", "include_rest_of_world")
    country_codes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode))), graphql_name="countryCodes"
    )
    include_rest_of_world = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="includeRestOfWorld")


class CountryHarmonizedSystemCode(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_code", "harmonized_system_code")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")
    harmonized_system_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="harmonizedSystemCode")


class CountryHarmonizedSystemCodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CountryHarmonizedSystemCodeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CountryHarmonizedSystemCode))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CountryHarmonizedSystemCodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CountryHarmonizedSystemCode), graphql_name="node")


class CurrencyFormats(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("money_format", "money_in_emails_format", "money_with_currency_format", "money_with_currency_in_emails_format")
    money_format = sgqlc.types.Field(sgqlc.types.non_null(FormattedString), graphql_name="moneyFormat")
    money_in_emails_format = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="moneyInEmailsFormat")
    money_with_currency_format = sgqlc.types.Field(sgqlc.types.non_null(FormattedString), graphql_name="moneyWithCurrencyFormat")
    money_with_currency_in_emails_format = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="moneyWithCurrencyInEmailsFormat")


class CurrencySetting(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("currency_code", "currency_name", "enabled", "rate_updated_at")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")
    currency_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="currencyName")
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")
    rate_updated_at = sgqlc.types.Field(DateTime, graphql_name="rateUpdatedAt")


class CurrencySettingConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CurrencySettingEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CurrencySetting))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CurrencySettingEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CurrencySetting), graphql_name="node")


class CustomerAddTaxExemptionsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Customer"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CustomerCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerCreditCard(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "billing_address",
        "brand",
        "expires_soon",
        "expiry_month",
        "expiry_year",
        "first_digits",
        "is_revocable",
        "last_digits",
        "masked_number",
        "name",
        "source",
        "virtual_last_digits",
    )
    billing_address = sgqlc.types.Field("CustomerCreditCardBillingAddress", graphql_name="billingAddress")
    brand = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="brand")
    expires_soon = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="expiresSoon")
    expiry_month = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="expiryMonth")
    expiry_year = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="expiryYear")
    first_digits = sgqlc.types.Field(String, graphql_name="firstDigits")
    is_revocable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isRevocable")
    last_digits = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="lastDigits")
    masked_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="maskedNumber")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    source = sgqlc.types.Field(String, graphql_name="source")
    virtual_last_digits = sgqlc.types.Field(String, graphql_name="virtualLastDigits")


class CustomerCreditCardBillingAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "city", "country", "country_code", "first_name", "last_name", "province", "province_code", "zip")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    city = sgqlc.types.Field(String, graphql_name="city")
    country = sgqlc.types.Field(String, graphql_name="country")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    province = sgqlc.types.Field(String, graphql_name="province")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class CustomerDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_customer_id", "shop", "user_errors")
    deleted_customer_id = sgqlc.types.Field(ID, graphql_name="deletedCustomerId")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Customer"), graphql_name="node")


class CustomerEmailAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("email_address", "marketing_state", "marketing_unsubscribe_url", "open_tracking_level", "open_tracking_url")
    email_address = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="emailAddress")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerEmailAddressMarketingState), graphql_name="marketingState")
    marketing_unsubscribe_url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="marketingUnsubscribeUrl")
    open_tracking_level = sgqlc.types.Field(sgqlc.types.non_null(CustomerEmailAddressOpenTrackingLevel), graphql_name="openTrackingLevel")
    open_tracking_url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="openTrackingUrl")


class CustomerEmailMarketingConsentState(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("consent_updated_at", "marketing_opt_in_level", "marketing_state")
    consent_updated_at = sgqlc.types.Field(DateTime, graphql_name="consentUpdatedAt")
    marketing_opt_in_level = sgqlc.types.Field(CustomerMarketingOptInLevel, graphql_name="marketingOptInLevel")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerEmailMarketingState), graphql_name="marketingState")


class CustomerEmailMarketingConsentUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerEmailMarketingConsentUpdateUserError"))),
        graphql_name="userErrors",
    )


class CustomerGenerateAccountActivationUrlPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("account_activation_url", "user_errors")
    account_activation_url = sgqlc.types.Field(URL, graphql_name="accountActivationUrl")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerJourney(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_order_index", "days_to_conversion", "first_visit", "last_visit", "moments")
    customer_order_index = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="customerOrderIndex")
    days_to_conversion = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="daysToConversion")
    first_visit = sgqlc.types.Field(sgqlc.types.non_null("CustomerVisit"), graphql_name="firstVisit")
    last_visit = sgqlc.types.Field("CustomerVisit", graphql_name="lastVisit")
    moments = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerMoment))), graphql_name="moments")


class CustomerJourneySummary(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_order_index", "days_to_conversion", "first_visit", "last_visit", "moments", "moments_count", "ready")
    customer_order_index = sgqlc.types.Field(Int, graphql_name="customerOrderIndex")
    days_to_conversion = sgqlc.types.Field(Int, graphql_name="daysToConversion")
    first_visit = sgqlc.types.Field("CustomerVisit", graphql_name="firstVisit")
    last_visit = sgqlc.types.Field("CustomerVisit", graphql_name="lastVisit")
    moments = sgqlc.types.Field(
        "CustomerMomentConnection",
        graphql_name="moments",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    moments_count = sgqlc.types.Field(Int, graphql_name="momentsCount")
    ready = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="ready")


class CustomerMergeError(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("error_fields", "message")
    error_fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerMergeErrorFieldType))), graphql_name="errorFields"
    )
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")


class CustomerMergePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "resulting_customer_id", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    resulting_customer_id = sgqlc.types.Field(ID, graphql_name="resultingCustomerId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerMergeUserError"))), graphql_name="userErrors"
    )


class CustomerMergePreview(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("alternate_fields", "blocking_fields", "customer_merge_errors", "default_fields", "resulting_customer_id")
    alternate_fields = sgqlc.types.Field("CustomerMergePreviewAlternateFields", graphql_name="alternateFields")
    blocking_fields = sgqlc.types.Field("CustomerMergePreviewBlockingFields", graphql_name="blockingFields")
    customer_merge_errors = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(CustomerMergeError)), graphql_name="customerMergeErrors"
    )
    default_fields = sgqlc.types.Field("CustomerMergePreviewDefaultFields", graphql_name="defaultFields")
    resulting_customer_id = sgqlc.types.Field(ID, graphql_name="resultingCustomerId")


class CustomerMergePreviewAlternateFields(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("default_address", "email", "first_name", "last_name", "phone_number")
    default_address = sgqlc.types.Field("MailingAddress", graphql_name="defaultAddress")
    email = sgqlc.types.Field(CustomerEmailAddress, graphql_name="email")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    phone_number = sgqlc.types.Field("CustomerPhoneNumber", graphql_name="phoneNumber")


class CustomerMergePreviewBlockingFields(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("note", "tags")
    note = sgqlc.types.Field(String, graphql_name="note")
    tags = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags")


class CustomerMergePreviewDefaultFields(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "addresses",
        "default_address",
        "discount_node_count",
        "discount_nodes",
        "display_name",
        "draft_order_count",
        "draft_orders",
        "email",
        "first_name",
        "gift_card_count",
        "gift_cards",
        "last_name",
        "metafield_count",
        "note",
        "order_count",
        "orders",
        "phone_number",
        "tags",
    )
    addresses = sgqlc.types.Field(
        sgqlc.types.non_null("MailingAddressConnection"),
        graphql_name="addresses",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    default_address = sgqlc.types.Field("MailingAddress", graphql_name="defaultAddress")
    discount_node_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="discountNodeCount")
    discount_nodes = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountNodeConnection"),
        graphql_name="discountNodes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountSortKeys, graphql_name="sortKey", default="CREATED_AT")),
            )
        ),
    )
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    draft_order_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="draftOrderCount")
    draft_orders = sgqlc.types.Field(
        sgqlc.types.non_null("DraftOrderConnection"),
        graphql_name="draftOrders",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DraftOrderSortKeys, graphql_name="sortKey", default="UPDATED_AT")),
            )
        ),
    )
    email = sgqlc.types.Field(CustomerEmailAddress, graphql_name="email")
    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    gift_card_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="giftCardCount")
    gift_cards = sgqlc.types.Field(
        sgqlc.types.non_null("GiftCardConnection"),
        graphql_name="giftCards",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(GiftCardSortKeys, graphql_name="sortKey", default="CREATED_AT")),
            )
        ),
    )
    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    metafield_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="metafieldCount")
    note = sgqlc.types.Field(String, graphql_name="note")
    order_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="orderCount")
    orders = sgqlc.types.Field(
        sgqlc.types.non_null("OrderConnection"),
        graphql_name="orders",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(OrderSortKeys, graphql_name="sortKey", default="PROCESSED_AT")),
            )
        ),
    )
    phone_number = sgqlc.types.Field("CustomerPhoneNumber", graphql_name="phoneNumber")
    tags = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags")


class CustomerMergeRequest(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_merge_errors", "job_id", "resulting_customer_id", "status")
    customer_merge_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerMergeError))), graphql_name="customerMergeErrors"
    )
    job_id = sgqlc.types.Field(ID, graphql_name="jobId")
    resulting_customer_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="resultingCustomerId")
    status = sgqlc.types.Field(sgqlc.types.non_null(CustomerMergeRequestStatus), graphql_name="status")


class CustomerMergeable(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("error_fields", "is_mergeable", "merge_in_progress", "reason")
    error_fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerMergeErrorFieldType))), graphql_name="errorFields"
    )
    is_mergeable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isMergeable")
    merge_in_progress = sgqlc.types.Field(CustomerMergeRequest, graphql_name="mergeInProgress")
    reason = sgqlc.types.Field(String, graphql_name="reason")


class CustomerMomentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerMomentEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerMoment))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CustomerMomentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CustomerMoment), graphql_name="node")


class CustomerPaymentInstrumentBillingAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "city", "country", "country_code", "name", "province", "province_code", "zip")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    city = sgqlc.types.Field(String, graphql_name="city")
    country = sgqlc.types.Field(String, graphql_name="country")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    name = sgqlc.types.Field(String, graphql_name="name")
    province = sgqlc.types.Field(String, graphql_name="province")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class CustomerPaymentMethodConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethod"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CustomerPaymentMethodCreateFromDuplicationDataPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodCreateFromDuplicationDataUserError"))),
        graphql_name="userErrors",
    )


class CustomerPaymentMethodCreditCardCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerPaymentMethodCreditCardUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerPaymentMethodEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CustomerPaymentMethod"), graphql_name="node")


class CustomerPaymentMethodGetDuplicationDataPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("encrypted_duplication_data", "user_errors")
    encrypted_duplication_data = sgqlc.types.Field(String, graphql_name="encryptedDuplicationData")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodGetDuplicationDataUserError"))),
        graphql_name="userErrors",
    )


class CustomerPaymentMethodGetUpdateUrlPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("update_payment_method_url", "user_errors")
    update_payment_method_url = sgqlc.types.Field(URL, graphql_name="updatePaymentMethodUrl")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodGetUpdateUrlUserError"))),
        graphql_name="userErrors",
    )


class CustomerPaymentMethodPaypalBillingAgreementCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodUserError"))), graphql_name="userErrors"
    )


class CustomerPaymentMethodPaypalBillingAgreementUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodUserError"))), graphql_name="userErrors"
    )


class CustomerPaymentMethodRemoteCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodRemoteUserError"))), graphql_name="userErrors"
    )


class CustomerPaymentMethodRemoteCreditCardCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_payment_method", "user_errors")
    customer_payment_method = sgqlc.types.Field("CustomerPaymentMethod", graphql_name="customerPaymentMethod")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerPaymentMethodUserError"))), graphql_name="userErrors"
    )


class CustomerPaymentMethodRevokePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("revoked_customer_payment_method_id", "user_errors")
    revoked_customer_payment_method_id = sgqlc.types.Field(ID, graphql_name="revokedCustomerPaymentMethodId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerPaymentMethodSendUpdateEmailPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerPaypalBillingAgreement(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("billing_address", "inactive", "is_revocable", "paypal_account_email")
    billing_address = sgqlc.types.Field(CustomerPaymentInstrumentBillingAddress, graphql_name="billingAddress")
    inactive = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="inactive")
    is_revocable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isRevocable")
    paypal_account_email = sgqlc.types.Field(String, graphql_name="paypalAccountEmail")


class CustomerPhoneNumber(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_state", "phone_number")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerSmsMarketingState), graphql_name="marketingState")
    phone_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="phoneNumber")


class CustomerRemoveTaxExemptionsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerReplaceTaxExemptionsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerSegmentMemberConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "page_info", "statistics", "total_count")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerSegmentMemberEdge"))), graphql_name="edges"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    statistics = sgqlc.types.Field(sgqlc.types.non_null("SegmentStatistics"), graphql_name="statistics")
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalCount")


class CustomerSegmentMemberEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("CustomerSegmentMember"), graphql_name="node")


class CustomerSegmentMembersQueryCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer_segment_members_query", "user_errors")
    customer_segment_members_query = sgqlc.types.Field("CustomerSegmentMembersQuery", graphql_name="customerSegmentMembersQuery")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerSegmentMembersQueryUserError"))), graphql_name="userErrors"
    )


class CustomerShopPayAgreement(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "billing_address",
        "expires_soon",
        "expiry_month",
        "expiry_year",
        "inactive",
        "is_revocable",
        "last_digits",
        "masked_number",
        "name",
    )
    billing_address = sgqlc.types.Field(CustomerCreditCardBillingAddress, graphql_name="billingAddress")
    expires_soon = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="expiresSoon")
    expiry_month = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="expiryMonth")
    expiry_year = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="expiryYear")
    inactive = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="inactive")
    is_revocable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isRevocable")
    last_digits = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="lastDigits")
    masked_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="maskedNumber")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class CustomerSmsMarketingConsentState(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("consent_collected_from", "consent_updated_at", "marketing_opt_in_level", "marketing_state")
    consent_collected_from = sgqlc.types.Field(CustomerConsentCollectedFrom, graphql_name="consentCollectedFrom")
    consent_updated_at = sgqlc.types.Field(DateTime, graphql_name="consentUpdatedAt")
    marketing_opt_in_level = sgqlc.types.Field(sgqlc.types.non_null(CustomerMarketingOptInLevel), graphql_name="marketingOptInLevel")
    marketing_state = sgqlc.types.Field(sgqlc.types.non_null(CustomerSmsMarketingState), graphql_name="marketingState")


class CustomerSmsMarketingConsentUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerSmsMarketingConsentError"))), graphql_name="userErrors"
    )


class CustomerStatistics(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("predicted_spend_tier",)
    predicted_spend_tier = sgqlc.types.Field(CustomerPredictedSpendTier, graphql_name="predictedSpendTier")


class CustomerUpdateDefaultAddressPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customer", "user_errors")
    customer = sgqlc.types.Field("Customer", graphql_name="customer")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class CustomerVisitProductInfo(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "quantity", "variant")
    product = sgqlc.types.Field("Product", graphql_name="product")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    variant = sgqlc.types.Field("ProductVariant", graphql_name="variant")


class CustomerVisitProductInfoConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("CustomerVisitProductInfoEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomerVisitProductInfo))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class CustomerVisitProductInfoEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(CustomerVisitProductInfo), graphql_name="node")


class DelegateAccessToken(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("access_scopes", "access_token", "created_at")
    access_scopes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="accessScopes")
    access_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accessToken")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")


class DelegateAccessTokenCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delegate_access_token", "shop", "user_errors")
    delegate_access_token = sgqlc.types.Field(DelegateAccessToken, graphql_name="delegateAccessToken")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DelegateAccessTokenCreateUserError"))), graphql_name="userErrors"
    )


class DelegateAccessTokenDestroyPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("shop", "status", "user_errors")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    status = sgqlc.types.Field(Boolean, graphql_name="status")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DelegateAccessTokenDestroyUserError"))), graphql_name="userErrors"
    )


class DeletionEvent(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("occurred_at", "subject_id", "subject_type")
    occurred_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="occurredAt")
    subject_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="subjectId")
    subject_type = sgqlc.types.Field(sgqlc.types.non_null(DeletionEventSubjectType), graphql_name="subjectType")


class DeletionEventConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeletionEventEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DeletionEvent))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeletionEventEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(DeletionEvent), graphql_name="node")


class DeliveryAvailableService(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("countries", "name")
    countries = sgqlc.types.Field(sgqlc.types.non_null("DeliveryCountryCodesOrRestOfWorld"), graphql_name="countries")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class DeliveryBrandedPromise(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("handle", "name")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class DeliveryCarrierServiceAndLocations(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("carrier_service", "locations")
    carrier_service = sgqlc.types.Field(sgqlc.types.non_null("DeliveryCarrierService"), graphql_name="carrierService")
    locations = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Location"))), graphql_name="locations")


class DeliveryCountryAndZone(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country", "zone")
    country = sgqlc.types.Field(sgqlc.types.non_null("DeliveryCountry"), graphql_name="country")
    zone = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="zone")


class DeliveryCountryCodeOrRestOfWorld(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_code", "rest_of_world")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    rest_of_world = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restOfWorld")


class DeliveryCountryCodesOrRestOfWorld(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_codes", "rest_of_world")
    country_codes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode))), graphql_name="countryCodes"
    )
    rest_of_world = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restOfWorld")


class DeliveryCustomizationActivationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("ids", "user_errors")
    ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="ids")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomizationError"))), graphql_name="userErrors"
    )


class DeliveryCustomizationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomizationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomization"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeliveryCustomizationCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delivery_customization", "user_errors")
    delivery_customization = sgqlc.types.Field("DeliveryCustomization", graphql_name="deliveryCustomization")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomizationError"))), graphql_name="userErrors"
    )


class DeliveryCustomizationDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomizationError"))), graphql_name="userErrors"
    )


class DeliveryCustomizationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DeliveryCustomization"), graphql_name="node")


class DeliveryCustomizationUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delivery_customization", "user_errors")
    delivery_customization = sgqlc.types.Field("DeliveryCustomization", graphql_name="deliveryCustomization")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryCustomizationError"))), graphql_name="userErrors"
    )


class DeliveryLegacyModeBlocked(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("blocked", "reasons")
    blocked = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="blocked")
    reasons = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(DeliveryLegacyModeBlockedReason)), graphql_name="reasons")


class DeliveryLocalPickupSettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("instructions", "pickup_time")
    instructions = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="instructions")
    pickup_time = sgqlc.types.Field(sgqlc.types.non_null(DeliveryLocalPickupTime), graphql_name="pickupTime")


class DeliveryLocationGroupZone(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("method_definition_counts", "method_definitions", "zone")
    method_definition_counts = sgqlc.types.Field(
        sgqlc.types.non_null("DeliveryMethodDefinitionCounts"), graphql_name="methodDefinitionCounts"
    )
    method_definitions = sgqlc.types.Field(
        sgqlc.types.non_null("DeliveryMethodDefinitionConnection"),
        graphql_name="methodDefinitions",
        args=sgqlc.types.ArgDict(
            (
                ("eligible", sgqlc.types.Arg(Boolean, graphql_name="eligible", default=None)),
                ("type", sgqlc.types.Arg(DeliveryMethodDefinitionType, graphql_name="type", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(MethodDefinitionSortKeys, graphql_name="sortKey", default="ID")),
            )
        ),
    )
    zone = sgqlc.types.Field(sgqlc.types.non_null("DeliveryZone"), graphql_name="zone")


class DeliveryLocationGroupZoneConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryLocationGroupZoneEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DeliveryLocationGroupZone))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeliveryLocationGroupZoneEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(DeliveryLocationGroupZone), graphql_name="node")


class DeliveryMethodDefinitionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryMethodDefinitionEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryMethodDefinition"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeliveryMethodDefinitionCounts(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("participant_definitions_count", "rate_definitions_count")
    participant_definitions_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="participantDefinitionsCount")
    rate_definitions_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="rateDefinitionsCount")


class DeliveryMethodDefinitionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DeliveryMethodDefinition"), graphql_name="node")


class DeliveryParticipantService(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("active", "name")
    active = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="active")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class DeliveryProductVariantsCount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("capped", "count")
    capped = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="capped")
    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")


class DeliveryProfileConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfile"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeliveryProfileEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DeliveryProfile"), graphql_name="node")


class DeliveryProfileItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryProfileItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DeliveryProfileItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DeliveryProfileItem"), graphql_name="node")


class DeliveryProfileLocationGroup(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("countries_in_any_zone", "location_group", "location_group_zones")
    countries_in_any_zone = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DeliveryCountryAndZone))), graphql_name="countriesInAnyZone"
    )
    location_group = sgqlc.types.Field(sgqlc.types.non_null("DeliveryLocationGroup"), graphql_name="locationGroup")
    location_group_zones = sgqlc.types.Field(
        sgqlc.types.non_null(DeliveryLocationGroupZoneConnection),
        graphql_name="locationGroupZones",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class DeliverySetting(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("legacy_mode_blocked", "legacy_mode_profiles")
    legacy_mode_blocked = sgqlc.types.Field(sgqlc.types.non_null(DeliveryLegacyModeBlocked), graphql_name="legacyModeBlocked")
    legacy_mode_profiles = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="legacyModeProfiles")


class DeliverySettingUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("setting", "user_errors")
    setting = sgqlc.types.Field(DeliverySetting, graphql_name="setting")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DeliveryShippingOriginAssignPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DiscountAllocation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("allocated_amount_set", "discount_application")
    allocated_amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="allocatedAmountSet")
    discount_application = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplication), graphql_name="discountApplication")


class DiscountAmount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "applies_on_each_item")
    amount = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="amount")
    applies_on_each_item = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOnEachItem")


class DiscountApplicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountApplicationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DiscountApplication))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountApplicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(DiscountApplication), graphql_name="node")


class DiscountAutomaticActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticApp(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "app_discount_type",
        "async_usage_count",
        "combines_with",
        "created_at",
        "discount_class",
        "discount_id",
        "ends_at",
        "error_history",
        "starts_at",
        "status",
        "title",
        "updated_at",
    )
    app_discount_type = sgqlc.types.Field(sgqlc.types.non_null(AppDiscountType), graphql_name="appDiscountType")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(DiscountClass), graphql_name="discountClass")
    discount_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="discountId")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    error_history = sgqlc.types.Field("FunctionsErrorHistory", graphql_name="errorHistory")
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")


class DiscountAutomaticAppCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_app_discount", "user_errors")
    automatic_app_discount = sgqlc.types.Field(DiscountAutomaticApp, graphql_name="automaticAppDiscount")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticAppUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_app_discount", "user_errors")
    automatic_app_discount = sgqlc.types.Field(DiscountAutomaticApp, graphql_name="automaticAppDiscount")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticBasic(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "async_usage_count",
        "combines_with",
        "created_at",
        "customer_gets",
        "discount_class",
        "ends_at",
        "minimum_requirement",
        "short_summary",
        "starts_at",
        "status",
        "summary",
        "title",
        "updated_at",
    )
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    customer_gets = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerGets"), graphql_name="customerGets")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(MerchandiseDiscountClass), graphql_name="discountClass")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    minimum_requirement = sgqlc.types.Field(sgqlc.types.non_null("DiscountMinimumRequirement"), graphql_name="minimumRequirement")
    short_summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="shortSummary")
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summary")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")


class DiscountAutomaticBasicCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticBasicUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticBxgyCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticBxgyUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountAutomaticEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountAutomatic"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountAutomaticDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("automatic_discount_node", "user_errors")
    automatic_discount_node = sgqlc.types.Field("DiscountAutomaticNode", graphql_name="automaticDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_automatic_discount_id", "user_errors")
    deleted_automatic_discount_id = sgqlc.types.Field(ID, graphql_name="deletedAutomaticDiscountId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountAutomaticEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DiscountAutomatic"), graphql_name="node")


class DiscountAutomaticNodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountAutomaticNodeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountAutomaticNode"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountAutomaticNodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DiscountAutomaticNode"), graphql_name="node")


class DiscountCodeActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeApp(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "app_discount_type",
        "applies_once_per_customer",
        "async_usage_count",
        "code_count",
        "codes",
        "combines_with",
        "created_at",
        "customer_selection",
        "discount_class",
        "discount_id",
        "ends_at",
        "error_history",
        "has_timeline_comment",
        "recurring_cycle_limit",
        "shareable_urls",
        "starts_at",
        "status",
        "title",
        "total_sales",
        "updated_at",
        "usage_limit",
    )
    app_discount_type = sgqlc.types.Field(sgqlc.types.non_null(AppDiscountType), graphql_name="appDiscountType")
    applies_once_per_customer = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOncePerCustomer")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    code_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="codeCount")
    codes = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountRedeemCodeConnection"),
        graphql_name="codes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountCodeSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    customer_selection = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerSelection"), graphql_name="customerSelection")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(DiscountClass), graphql_name="discountClass")
    discount_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="discountId")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    error_history = sgqlc.types.Field("FunctionsErrorHistory", graphql_name="errorHistory")
    has_timeline_comment = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasTimelineComment")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")
    shareable_urls = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountShareableUrl"))), graphql_name="shareableUrls"
    )
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    total_sales = sgqlc.types.Field("MoneyV2", graphql_name="totalSales")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")


class DiscountCodeAppCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_app_discount", "user_errors")
    code_app_discount = sgqlc.types.Field(DiscountCodeApp, graphql_name="codeAppDiscount")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeAppUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_app_discount", "user_errors")
    code_app_discount = sgqlc.types.Field(DiscountCodeApp, graphql_name="codeAppDiscount")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBasic(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "applies_once_per_customer",
        "async_usage_count",
        "code_count",
        "codes",
        "combines_with",
        "created_at",
        "customer_gets",
        "customer_selection",
        "discount_class",
        "ends_at",
        "has_timeline_comment",
        "minimum_requirement",
        "recurring_cycle_limit",
        "shareable_urls",
        "short_summary",
        "starts_at",
        "status",
        "summary",
        "title",
        "total_sales",
        "updated_at",
        "usage_limit",
    )
    applies_once_per_customer = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOncePerCustomer")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    code_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="codeCount")
    codes = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountRedeemCodeConnection"),
        graphql_name="codes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountCodeSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    customer_gets = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerGets"), graphql_name="customerGets")
    customer_selection = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerSelection"), graphql_name="customerSelection")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(MerchandiseDiscountClass), graphql_name="discountClass")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    has_timeline_comment = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasTimelineComment")
    minimum_requirement = sgqlc.types.Field("DiscountMinimumRequirement", graphql_name="minimumRequirement")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")
    shareable_urls = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountShareableUrl"))), graphql_name="shareableUrls"
    )
    short_summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="shortSummary")
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summary")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    total_sales = sgqlc.types.Field("MoneyV2", graphql_name="totalSales")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")


class DiscountCodeBasicCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBasicUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBulkActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBulkDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBxgy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "applies_once_per_customer",
        "async_usage_count",
        "code_count",
        "codes",
        "combines_with",
        "created_at",
        "customer_buys",
        "customer_gets",
        "customer_selection",
        "discount_class",
        "ends_at",
        "has_timeline_comment",
        "shareable_urls",
        "starts_at",
        "status",
        "summary",
        "title",
        "total_sales",
        "updated_at",
        "usage_limit",
        "uses_per_order_limit",
    )
    applies_once_per_customer = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOncePerCustomer")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    code_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="codeCount")
    codes = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountRedeemCodeConnection"),
        graphql_name="codes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountCodeSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    customer_buys = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerBuys"), graphql_name="customerBuys")
    customer_gets = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerGets"), graphql_name="customerGets")
    customer_selection = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerSelection"), graphql_name="customerSelection")
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(MerchandiseDiscountClass), graphql_name="discountClass")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    has_timeline_comment = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasTimelineComment")
    shareable_urls = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountShareableUrl"))), graphql_name="shareableUrls"
    )
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summary")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    total_sales = sgqlc.types.Field("MoneyV2", graphql_name="totalSales")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")
    uses_per_order_limit = sgqlc.types.Field(Int, graphql_name="usesPerOrderLimit")


class DiscountCodeBxgyCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeBxgyUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_code_discount_id", "user_errors")
    deleted_code_discount_id = sgqlc.types.Field(ID, graphql_name="deletedCodeDiscountId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeFreeShipping(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "applies_on_one_time_purchase",
        "applies_on_subscription",
        "applies_once_per_customer",
        "async_usage_count",
        "code_count",
        "codes",
        "combines_with",
        "created_at",
        "customer_selection",
        "destination_selection",
        "discount_class",
        "ends_at",
        "has_timeline_comment",
        "maximum_shipping_price",
        "minimum_requirement",
        "recurring_cycle_limit",
        "shareable_urls",
        "short_summary",
        "starts_at",
        "status",
        "summary",
        "title",
        "total_sales",
        "updated_at",
        "usage_limit",
    )
    applies_on_one_time_purchase = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOnOneTimePurchase")
    applies_on_subscription = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOnSubscription")
    applies_once_per_customer = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOncePerCustomer")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    code_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="codeCount")
    codes = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountRedeemCodeConnection"),
        graphql_name="codes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountCodeSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    combines_with = sgqlc.types.Field(sgqlc.types.non_null("DiscountCombinesWith"), graphql_name="combinesWith")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    customer_selection = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerSelection"), graphql_name="customerSelection")
    destination_selection = sgqlc.types.Field(
        sgqlc.types.non_null("DiscountShippingDestinationSelection"), graphql_name="destinationSelection"
    )
    discount_class = sgqlc.types.Field(sgqlc.types.non_null(ShippingDiscountClass), graphql_name="discountClass")
    ends_at = sgqlc.types.Field(DateTime, graphql_name="endsAt")
    has_timeline_comment = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasTimelineComment")
    maximum_shipping_price = sgqlc.types.Field("MoneyV2", graphql_name="maximumShippingPrice")
    minimum_requirement = sgqlc.types.Field("DiscountMinimumRequirement", graphql_name="minimumRequirement")
    recurring_cycle_limit = sgqlc.types.Field(Int, graphql_name="recurringCycleLimit")
    shareable_urls = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountShareableUrl"))), graphql_name="shareableUrls"
    )
    short_summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="shortSummary")
    starts_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startsAt")
    status = sgqlc.types.Field(sgqlc.types.non_null(DiscountStatus), graphql_name="status")
    summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summary")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    total_sales = sgqlc.types.Field("MoneyV2", graphql_name="totalSales")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")
    usage_limit = sgqlc.types.Field(Int, graphql_name="usageLimit")


class DiscountCodeFreeShippingCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeFreeShippingUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code_discount_node", "user_errors")
    code_discount_node = sgqlc.types.Field("DiscountCodeNode", graphql_name="codeDiscountNode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCodeNodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountCodeNodeEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountCodeNode"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountCodeNodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DiscountCodeNode"), graphql_name="node")


class DiscountCodeRedeemCodeBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountCollections(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collections",)
    collections = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionConnection),
        graphql_name="collections",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class DiscountCombinesWith(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order_discounts", "product_discounts", "shipping_discounts")
    order_discounts = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="orderDiscounts")
    product_discounts = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="productDiscounts")
    shipping_discounts = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="shippingDiscounts")


class DiscountCountries(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("countries", "include_rest_of_world")
    countries = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode))), graphql_name="countries")
    include_rest_of_world = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="includeRestOfWorld")


class DiscountCountryAll(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("all_countries",)
    all_countries = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="allCountries")


class DiscountCustomerAll(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("all_customers",)
    all_customers = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="allCustomers")


class DiscountCustomerBuys(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("items", "value")
    items = sgqlc.types.Field(sgqlc.types.non_null("DiscountItems"), graphql_name="items")
    value = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerBuysValue"), graphql_name="value")


class DiscountCustomerGets(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("applies_on_one_time_purchase", "applies_on_subscription", "items", "value")
    applies_on_one_time_purchase = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOnOneTimePurchase")
    applies_on_subscription = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="appliesOnSubscription")
    items = sgqlc.types.Field(sgqlc.types.non_null("DiscountItems"), graphql_name="items")
    value = sgqlc.types.Field(sgqlc.types.non_null("DiscountCustomerGetsValue"), graphql_name="value")


class DiscountCustomerSegments(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("segments",)
    segments = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Segment"))), graphql_name="segments")


class DiscountCustomers(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customers",)
    customers = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Customer"))), graphql_name="customers")


class DiscountMinimumQuantity(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than_or_equal_to_quantity",)
    greater_than_or_equal_to_quantity = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="greaterThanOrEqualToQuantity")


class DiscountMinimumSubtotal(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than_or_equal_to_subtotal",)
    greater_than_or_equal_to_subtotal = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="greaterThanOrEqualToSubtotal")


class DiscountNodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountNodeEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountNode"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountNodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DiscountNode"), graphql_name="node")


class DiscountOnQuantity(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("effect", "quantity")
    effect = sgqlc.types.Field(sgqlc.types.non_null("DiscountEffect"), graphql_name="effect")
    quantity = sgqlc.types.Field(sgqlc.types.non_null("DiscountQuantity"), graphql_name="quantity")


class DiscountPercentage(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class DiscountProducts(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_variants", "products")
    product_variants = sgqlc.types.Field(
        sgqlc.types.non_null("ProductVariantConnection"),
        graphql_name="productVariants",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    products = sgqlc.types.Field(
        sgqlc.types.non_null("ProductConnection"),
        graphql_name="products",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class DiscountPurchaseAmount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount",)
    amount = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="amount")


class DiscountQuantity(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("quantity",)
    quantity = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="quantity")


class DiscountRedeemCode(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("async_usage_count", "code", "created_by", "id")
    async_usage_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="asyncUsageCount")
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")
    created_by = sgqlc.types.Field("App", graphql_name="createdBy")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class DiscountRedeemCodeBulkAddPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("bulk_creation", "user_errors")
    bulk_creation = sgqlc.types.Field("DiscountRedeemCodeBulkCreation", graphql_name="bulkCreation")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="userErrors"
    )


class DiscountRedeemCodeBulkCreationCode(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "discount_redeem_code", "errors")
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")
    discount_redeem_code = sgqlc.types.Field(DiscountRedeemCode, graphql_name="discountRedeemCode")
    errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountUserError"))), graphql_name="errors")


class DiscountRedeemCodeBulkCreationCodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountRedeemCodeBulkCreationCodeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DiscountRedeemCodeBulkCreationCode))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountRedeemCodeBulkCreationCodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(DiscountRedeemCodeBulkCreationCode), graphql_name="node")


class DiscountRedeemCodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DiscountRedeemCodeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DiscountRedeemCode))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DiscountRedeemCodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(DiscountRedeemCode), graphql_name="node")


class DiscountShareableUrl(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("target_item_image", "target_type", "title", "url")
    target_item_image = sgqlc.types.Field("Image", graphql_name="targetItemImage")
    target_type = sgqlc.types.Field(sgqlc.types.non_null(DiscountShareableUrlTargetType), graphql_name="targetType")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class DisputeEvidenceUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("dispute_evidence", "user_errors")
    dispute_evidence = sgqlc.types.Field("ShopifyPaymentsDisputeEvidence", graphql_name="disputeEvidence")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DisputeEvidenceUpdateUserError"))), graphql_name="userErrors"
    )


class DomainLocalization(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("alternate_locales", "country", "default_locale")
    alternate_locales = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="alternateLocales"
    )
    country = sgqlc.types.Field(String, graphql_name="country")
    default_locale = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="defaultLocale")


class DraftOrderAppliedDiscount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount_set", "amount_v2", "description", "title", "value", "value_type")
    amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="amountSet")
    amount_v2 = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="amountV2")
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    title = sgqlc.types.Field(String, graphql_name="title")
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    value_type = sgqlc.types.Field(sgqlc.types.non_null(DraftOrderAppliedDiscountType), graphql_name="valueType")


class DraftOrderBulkAddTagsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderBulkRemoveTagsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderCalculatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_draft_order", "user_errors")
    calculated_draft_order = sgqlc.types.Field(CalculatedDraftOrder, graphql_name="calculatedDraftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderCompletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DraftOrderEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DraftOrder"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DraftOrderCreateFromOrderPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderCreateMerchantCheckoutPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderDuplicatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DraftOrder"), graphql_name="node")


class DraftOrderInvoicePreviewPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("preview_html", "preview_subject", "user_errors")
    preview_html = sgqlc.types.Field(HTML, graphql_name="previewHtml")
    preview_subject = sgqlc.types.Field(HTML, graphql_name="previewSubject")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderInvoiceSendPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class DraftOrderLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DraftOrderLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DraftOrderLineItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class DraftOrderLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("DraftOrderLineItem"), graphql_name="node")


class DraftOrderUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft_order", "user_errors")
    draft_order = sgqlc.types.Field("DraftOrder", graphql_name="draftOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class EditableProperty(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("locked", "reason")
    locked = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="locked")
    reason = sgqlc.types.Field(FormattedString, graphql_name="reason")


class ErrorPosition(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("character", "line")
    character = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="character")
    line = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="line")


class EventBridgeServerPixelUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("server_pixel", "user_errors")
    server_pixel = sgqlc.types.Field("ServerPixel", graphql_name="serverPixel")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ErrorsServerPixelUserError"))), graphql_name="userErrors"
    )


class EventBridgeWebhookSubscriptionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors", "webhook_subscription")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")
    webhook_subscription = sgqlc.types.Field("WebhookSubscription", graphql_name="webhookSubscription")


class EventBridgeWebhookSubscriptionUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors", "webhook_subscription")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")
    webhook_subscription = sgqlc.types.Field("WebhookSubscription", graphql_name="webhookSubscription")


class EventConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("EventEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Event))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class EventEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(Event), graphql_name="node")


class ExchangeV2Additions(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("line_items", "subtotal_price_set", "tax_lines", "total_price_set")
    line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ExchangeV2LineItem"))), graphql_name="lineItems"
    )
    subtotal_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="subtotalPriceSet")
    tax_lines = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TaxLine"))), graphql_name="taxLines")
    total_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalPriceSet")


class ExchangeV2Connection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ExchangeV2Edge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ExchangeV2"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class ExchangeV2Edge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ExchangeV2"), graphql_name="node")


class ExchangeV2LineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "custom_attributes",
        "discounted_total_set",
        "discounted_unit_price_set",
        "fulfillment_service",
        "gift_card",
        "gift_cards",
        "line_item",
        "name",
        "original_total_set",
        "original_unit_price_set",
        "quantity",
        "requires_shipping",
        "sku",
        "tax_lines",
        "taxable",
        "title",
        "variant",
        "variant_title",
        "vendor",
    )
    custom_attributes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Attribute))), graphql_name="customAttributes"
    )
    discounted_total_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="discountedTotalSet")
    discounted_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="discountedUnitPriceSet")
    fulfillment_service = sgqlc.types.Field("FulfillmentService", graphql_name="fulfillmentService")
    gift_card = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="giftCard")
    gift_cards = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("GiftCard"))), graphql_name="giftCards")
    line_item = sgqlc.types.Field("LineItem", graphql_name="lineItem")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    original_total_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="originalTotalSet")
    original_unit_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="originalUnitPriceSet")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    requires_shipping = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="requiresShipping")
    sku = sgqlc.types.Field(String, graphql_name="sku")
    tax_lines = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TaxLine"))), graphql_name="taxLines")
    taxable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="taxable")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    variant = sgqlc.types.Field("ProductVariant", graphql_name="variant")
    variant_title = sgqlc.types.Field(String, graphql_name="variantTitle")
    vendor = sgqlc.types.Field(String, graphql_name="vendor")


class ExchangeV2Returns(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "line_items",
        "order_discount_amount_set",
        "shipping_refund_amount_set",
        "subtotal_price_set",
        "tax_lines",
        "tip_refund_amount_set",
        "total_price_set",
    )
    line_items = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ExchangeV2LineItem))), graphql_name="lineItems"
    )
    order_discount_amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="orderDiscountAmountSet")
    shipping_refund_amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="shippingRefundAmountSet")
    subtotal_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="subtotalPriceSet")
    tax_lines = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TaxLine"))), graphql_name="taxLines")
    tip_refund_amount_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="tipRefundAmountSet")
    total_price_set = sgqlc.types.Field(sgqlc.types.non_null("MoneyBag"), graphql_name="totalPriceSet")


class FailedRequirement(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("action", "message")
    action = sgqlc.types.Field("NavigationItem", graphql_name="action")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")


class FileAcknowledgeUpdateFailedPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("files", "user_errors")
    files = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(File)), graphql_name="files")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FilesUserError"))), graphql_name="userErrors"
    )


class FileConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FileEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(File))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FileCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("files", "user_errors")
    files = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(File)), graphql_name="files")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FilesUserError"))), graphql_name="userErrors"
    )


class FileDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_file_ids", "user_errors")
    deleted_file_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedFileIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FilesUserError"))), graphql_name="userErrors"
    )


class FileEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(File), graphql_name="node")


class FileError(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "details", "message")
    code = sgqlc.types.Field(sgqlc.types.non_null(FileErrorCode), graphql_name="code")
    details = sgqlc.types.Field(String, graphql_name="details")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")


class FileUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("files", "user_errors")
    files = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(File)), graphql_name="files")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FilesUserError"))), graphql_name="userErrors"
    )


class FilterOption(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("label", "value")
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class FlowTriggerReceivePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentCancelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment", "user_errors")
    fulfillment = sgqlc.types.Field("Fulfillment", graphql_name="fulfillment")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Fulfillment"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentCreateV2Payload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment", "user_errors")
    fulfillment = sgqlc.types.Field("Fulfillment", graphql_name="fulfillment")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Fulfillment"), graphql_name="node")


class FulfillmentEventConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentEventEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentEvent"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentEventCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_event", "user_errors")
    fulfillment_event = sgqlc.types.Field("FulfillmentEvent", graphql_name="fulfillmentEvent")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentEventEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentEvent"), graphql_name="node")


class FulfillmentHold(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("held_by", "reason", "reason_notes")
    held_by = sgqlc.types.Field(String, graphql_name="heldBy")
    reason = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentHoldReason), graphql_name="reason")
    reason_notes = sgqlc.types.Field(String, graphql_name="reasonNotes")


class FulfillmentLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentLineItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentLineItem"), graphql_name="node")


class FulfillmentOrderAcceptCancellationRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderAcceptFulfillmentRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderAssignedLocation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "country_code", "location", "name", "phone", "province", "zip")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")
    location = sgqlc.types.Field("Location", graphql_name="location")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    province = sgqlc.types.Field(String, graphql_name="province")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class FulfillmentOrderCancelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "replacement_fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    replacement_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="replacementFulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderClosePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrder"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentOrderEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrder"), graphql_name="node")


class FulfillmentOrderHoldPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "remaining_fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    remaining_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="remainingFulfillmentOrder")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderHoldUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrderInternationalDuties(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("incoterm",)
    incoterm = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="incoterm")


class FulfillmentOrderLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderLineItem"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentOrderLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrderLineItem"), graphql_name="node")


class FulfillmentOrderLineItemWarning(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "title")
    description = sgqlc.types.Field(String, graphql_name="description")
    title = sgqlc.types.Field(String, graphql_name="title")


class FulfillmentOrderLineItemsPreparedForPickupPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderLineItemsPreparedForPickupUserError"))),
        graphql_name="userErrors",
    )


class FulfillmentOrderLocationForMove(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location", "message", "movable")
    location = sgqlc.types.Field(sgqlc.types.non_null("Location"), graphql_name="location")
    message = sgqlc.types.Field(String, graphql_name="message")
    movable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="movable")


class FulfillmentOrderLocationForMoveConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderLocationForMoveEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLocationForMove))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentOrderLocationForMoveEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentOrderLocationForMove), graphql_name="node")


class FulfillmentOrderMerchantRequestConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderMerchantRequestEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderMerchantRequest"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class FulfillmentOrderMerchantRequestEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrderMerchantRequest"), graphql_name="node")


class FulfillmentOrderMergePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_merges", "user_errors")
    fulfillment_order_merges = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderMergeResult")), graphql_name="fulfillmentOrderMerges"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderMergeUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrderMergeResult(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order",)
    fulfillment_order = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrder"), graphql_name="fulfillmentOrder")


class FulfillmentOrderMovePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("moved_fulfillment_order", "original_fulfillment_order", "remaining_fulfillment_order", "user_errors")
    moved_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="movedFulfillmentOrder")
    original_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="originalFulfillmentOrder")
    remaining_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="remainingFulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderOpenPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderRejectCancellationRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderRejectFulfillmentRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderReleaseHoldPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderReleaseHoldUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrderReschedulePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderRescheduleUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrderSplitPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order_splits", "user_errors")
    fulfillment_order_splits = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderSplitResult")), graphql_name="fulfillmentOrderSplits"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrderSplitUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrderSplitResult(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "remaining_fulfillment_order", "replacement_fulfillment_order")
    fulfillment_order = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrder"), graphql_name="fulfillmentOrder")
    remaining_fulfillment_order = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentOrder"), graphql_name="remainingFulfillmentOrder")
    replacement_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="replacementFulfillmentOrder")


class FulfillmentOrderSubmitCancellationRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_order", "user_errors")
    fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="fulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderSubmitFulfillmentRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("original_fulfillment_order", "submitted_fulfillment_order", "unsubmitted_fulfillment_order", "user_errors")
    original_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="originalFulfillmentOrder")
    submitted_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="submittedFulfillmentOrder")
    unsubmitted_fulfillment_order = sgqlc.types.Field("FulfillmentOrder", graphql_name="unsubmittedFulfillmentOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentOrderSupportedAction(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("action", "external_url")
    action = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentOrderAction), graphql_name="action")
    external_url = sgqlc.types.Field(URL, graphql_name="externalUrl")


class FulfillmentOrdersReleaseHoldsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field("Job", graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrdersReleaseHoldsUserError"))), graphql_name="userErrors"
    )


class FulfillmentOrdersSetFulfillmentDeadlinePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("success", "user_errors")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("FulfillmentOrdersSetFulfillmentDeadlineUserError"))),
        graphql_name="userErrors",
    )


class FulfillmentOriginAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "country_code", "province_code", "zip")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="countryCode")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class FulfillmentService(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "callback_url",
        "fulfillment_orders_opt_in",
        "handle",
        "id",
        "inventory_management",
        "location",
        "permits_sku_sharing",
        "product_based",
        "service_name",
        "type",
    )
    callback_url = sgqlc.types.Field(URL, graphql_name="callbackUrl")
    fulfillment_orders_opt_in = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="fulfillmentOrdersOptIn")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    inventory_management = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="inventoryManagement")
    location = sgqlc.types.Field("Location", graphql_name="location")
    permits_sku_sharing = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="permitsSkuSharing")
    product_based = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="productBased")
    service_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="serviceName")
    type = sgqlc.types.Field(sgqlc.types.non_null(FulfillmentServiceType), graphql_name="type")


class FulfillmentServiceCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_service", "user_errors")
    fulfillment_service = sgqlc.types.Field(FulfillmentService, graphql_name="fulfillmentService")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentServiceDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentServiceUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_service", "user_errors")
    fulfillment_service = sgqlc.types.Field(FulfillmentService, graphql_name="fulfillmentService")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FulfillmentTrackingInfo(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "number", "url")
    company = sgqlc.types.Field(String, graphql_name="company")
    number = sgqlc.types.Field(String, graphql_name="number")
    url = sgqlc.types.Field(URL, graphql_name="url")


class FulfillmentTrackingInfoUpdateV2Payload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment", "user_errors")
    fulfillment = sgqlc.types.Field("Fulfillment", graphql_name="fulfillment")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class FunctionsAppBridge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("create_path", "details_path")
    create_path = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="createPath")
    details_path = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="detailsPath")


class FunctionsErrorHistory(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("errors_first_occurred_at", "first_occurred_at", "has_been_shared_since_last_error", "has_shared_recent_errors")
    errors_first_occurred_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="errorsFirstOccurredAt")
    first_occurred_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="firstOccurredAt")
    has_been_shared_since_last_error = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasBeenSharedSinceLastError")
    has_shared_recent_errors = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasSharedRecentErrors")


class GiftCardConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("GiftCardEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("GiftCard"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class GiftCardCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("gift_card", "gift_card_code", "user_errors")
    gift_card = sgqlc.types.Field("GiftCard", graphql_name="giftCard")
    gift_card_code = sgqlc.types.Field(String, graphql_name="giftCardCode")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("GiftCardUserError"))), graphql_name="userErrors"
    )


class GiftCardDisablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("gift_card", "user_errors")
    gift_card = sgqlc.types.Field("GiftCard", graphql_name="giftCard")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class GiftCardEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("GiftCard"), graphql_name="node")


class GiftCardUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("gift_card", "user_errors")
    gift_card = sgqlc.types.Field("GiftCard", graphql_name="giftCard")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ImageConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ImageEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Image"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class ImageEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Image"), graphql_name="node")


class ImageUploadParameter(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class InventoryActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_level", "user_errors")
    inventory_level = sgqlc.types.Field("InventoryLevel", graphql_name="inventoryLevel")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class InventoryAdjustQuantitiesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_adjustment_group", "user_errors")
    inventory_adjustment_group = sgqlc.types.Field("InventoryAdjustmentGroup", graphql_name="inventoryAdjustmentGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryAdjustQuantitiesUserError"))), graphql_name="userErrors"
    )


class InventoryAdjustQuantityPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_level", "user_errors")
    inventory_level = sgqlc.types.Field("InventoryLevel", graphql_name="inventoryLevel")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class InventoryBulkAdjustQuantityAtLocationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_levels", "user_errors")
    inventory_levels = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("InventoryLevel")), graphql_name="inventoryLevels")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class InventoryBulkToggleActivationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_item", "inventory_levels", "user_errors")
    inventory_item = sgqlc.types.Field("InventoryItem", graphql_name="inventoryItem")
    inventory_levels = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("InventoryLevel")), graphql_name="inventoryLevels")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryBulkToggleActivationUserError"))), graphql_name="userErrors"
    )


class InventoryChange(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delta", "item", "ledger_document_uri", "location", "name", "quantity_after_change")
    delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="delta")
    item = sgqlc.types.Field("InventoryItem", graphql_name="item")
    ledger_document_uri = sgqlc.types.Field(String, graphql_name="ledgerDocumentUri")
    location = sgqlc.types.Field("Location", graphql_name="location")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    quantity_after_change = sgqlc.types.Field(Int, graphql_name="quantityAfterChange")


class InventoryDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class InventoryItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryItemEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class InventoryItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("InventoryItem"), graphql_name="node")


class InventoryItemUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_item", "user_errors")
    inventory_item = sgqlc.types.Field("InventoryItem", graphql_name="inventoryItem")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class InventoryLevelConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryLevelEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryLevel"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class InventoryLevelEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("InventoryLevel"), graphql_name="node")


class InventoryMoveQuantitiesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_adjustment_group", "user_errors")
    inventory_adjustment_group = sgqlc.types.Field("InventoryAdjustmentGroup", graphql_name="inventoryAdjustmentGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryMoveQuantitiesUserError"))), graphql_name="userErrors"
    )


class InventoryProperties(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("quantity_names",)
    quantity_names = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventoryQuantityName"))), graphql_name="quantityNames"
    )


class InventoryQuantity(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "quantity", "updated_at")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    updated_at = sgqlc.types.Field(DateTime, graphql_name="updatedAt")


class InventoryQuantityName(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("belongs_to", "comprises", "display_name", "is_in_use", "name")
    belongs_to = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="belongsTo")
    comprises = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="comprises")
    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    is_in_use = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isInUse")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class InventorySetOnHandQuantitiesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("inventory_adjustment_group", "user_errors")
    inventory_adjustment_group = sgqlc.types.Field("InventoryAdjustmentGroup", graphql_name="inventoryAdjustmentGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("InventorySetOnHandQuantitiesUserError"))), graphql_name="userErrors"
    )


class Job(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("done", "id", "query")
    done = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="done")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    query = sgqlc.types.Field("QueryRoot", graphql_name="query")


class LimitedPendingOrderCount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("at_max", "count")
    at_max = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="atMax")
    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")


class LineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LineItemEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LineItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class LineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("LineItem"), graphql_name="node")


class LineItemGroup(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("id", "quantity", "title")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class LineItemMutableConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LineItemMutableEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LineItemMutable"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class LineItemMutableEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("LineItemMutable"), graphql_name="node")


class LineItemSellingPlan(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "selling_plan_id")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    selling_plan_id = sgqlc.types.Field(ID, graphql_name="sellingPlanId")


class Locale(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("iso_code", "name")
    iso_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="isoCode")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class LocalizationExtension(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_code", "key", "purpose", "title", "value")
    country_code = sgqlc.types.Field(sgqlc.types.non_null(CountryCode), graphql_name="countryCode")
    key = sgqlc.types.Field(sgqlc.types.non_null(LocalizationExtensionKey), graphql_name="key")
    purpose = sgqlc.types.Field(sgqlc.types.non_null(LocalizationExtensionPurpose), graphql_name="purpose")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class LocalizationExtensionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocalizationExtensionEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(LocalizationExtension))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class LocalizationExtensionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(LocalizationExtension), graphql_name="node")


class LocationActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location", "location_activate_user_errors")
    location = sgqlc.types.Field("Location", graphql_name="location")
    location_activate_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationActivateUserError"))),
        graphql_name="locationActivateUserErrors",
    )


class LocationAddPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location", "user_errors")
    location = sgqlc.types.Field("Location", graphql_name="location")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationAddUserError"))), graphql_name="userErrors"
    )


class LocationAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "address1",
        "address2",
        "city",
        "country",
        "country_code",
        "formatted",
        "latitude",
        "longitude",
        "phone",
        "province",
        "province_code",
        "zip",
    )
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    country = sgqlc.types.Field(String, graphql_name="country")
    country_code = sgqlc.types.Field(String, graphql_name="countryCode")
    formatted = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="formatted")
    latitude = sgqlc.types.Field(Float, graphql_name="latitude")
    longitude = sgqlc.types.Field(Float, graphql_name="longitude")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    province = sgqlc.types.Field(String, graphql_name="province")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class LocationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Location"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class LocationDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location", "location_deactivate_user_errors")
    location = sgqlc.types.Field("Location", graphql_name="location")
    location_deactivate_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationDeactivateUserError"))),
        graphql_name="locationDeactivateUserErrors",
    )


class LocationDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_location_id", "location_delete_user_errors")
    deleted_location_id = sgqlc.types.Field(ID, graphql_name="deletedLocationId")
    location_delete_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationDeleteUserError"))), graphql_name="locationDeleteUserErrors"
    )


class LocationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Location"), graphql_name="node")


class LocationEditPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location", "user_errors")
    location = sgqlc.types.Field("Location", graphql_name="location")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("LocationEditUserError"))), graphql_name="userErrors"
    )


class LocationLocalPickupDisablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location_id", "user_errors")
    location_id = sgqlc.types.Field(ID, graphql_name="locationId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryLocationLocalPickupSettingsError"))),
        graphql_name="userErrors",
    )


class LocationLocalPickupEnablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("local_pickup_settings", "user_errors")
    local_pickup_settings = sgqlc.types.Field(DeliveryLocalPickupSettings, graphql_name="localPickupSettings")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DeliveryLocationLocalPickupSettingsError"))),
        graphql_name="userErrors",
    )


class LocationSuggestedAddress(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address1", "address2", "city", "country", "country_code", "formatted", "province", "province_code", "zip")
    address1 = sgqlc.types.Field(String, graphql_name="address1")
    address2 = sgqlc.types.Field(String, graphql_name="address2")
    city = sgqlc.types.Field(String, graphql_name="city")
    country = sgqlc.types.Field(String, graphql_name="country")
    country_code = sgqlc.types.Field(CountryCode, graphql_name="countryCode")
    formatted = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="formatted")
    province = sgqlc.types.Field(String, graphql_name="province")
    province_code = sgqlc.types.Field(String, graphql_name="provinceCode")
    zip = sgqlc.types.Field(String, graphql_name="zip")


class MailingAddressConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MailingAddressEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MailingAddress"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MailingAddressEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MailingAddress"), graphql_name="node")


class MarketCatalogConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketCatalogEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketCatalog"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketCatalogEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MarketCatalog"), graphql_name="node")


class MarketConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Market"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketCurrencySettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("base_currency", "local_currencies")
    base_currency = sgqlc.types.Field(sgqlc.types.non_null(CurrencySetting), graphql_name="baseCurrency")
    local_currencies = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="localCurrencies")


class MarketCurrencySettingsUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketCurrencySettingsUserError"))), graphql_name="userErrors"
    )


class MarketDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Market"), graphql_name="node")


class MarketLocalizableContent(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("digest", "key", "value")
    digest = sgqlc.types.Field(String, graphql_name="digest")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(String, graphql_name="value")


class MarketLocalizableResource(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market_localizable_content", "market_localizations", "resource_id")
    market_localizable_content = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MarketLocalizableContent))), graphql_name="marketLocalizableContent"
    )
    market_localizations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketLocalization"))),
        graphql_name="marketLocalizations",
        args=sgqlc.types.ArgDict((("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),)),
    )
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="resourceId")


class MarketLocalizableResourceConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketLocalizableResourceEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MarketLocalizableResource))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketLocalizableResourceEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(MarketLocalizableResource), graphql_name="node")


class MarketLocalization(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("key", "market", "outdated", "updated_at", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    market = sgqlc.types.Field(sgqlc.types.non_null("Market"), graphql_name="market")
    outdated = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="outdated")
    updated_at = sgqlc.types.Field(DateTime, graphql_name="updatedAt")
    value = sgqlc.types.Field(String, graphql_name="value")


class MarketLocalizationsRegisterPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market_localizations", "user_errors")
    market_localizations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(MarketLocalization)), graphql_name="marketLocalizations"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TranslationUserError"))), graphql_name="userErrors"
    )


class MarketLocalizationsRemovePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market_localizations", "user_errors")
    market_localizations = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(MarketLocalization)), graphql_name="marketLocalizations"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TranslationUserError"))), graphql_name="userErrors"
    )


class MarketRegionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketRegionEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MarketRegion))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketRegionDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "market", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketRegionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(MarketRegion), graphql_name="node")


class MarketRegionsCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketWebPresenceCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketWebPresenceDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "market", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketWebPresenceRootUrl(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("locale", "url")
    locale = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="locale")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class MarketWebPresenceUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("market", "user_errors")
    market = sgqlc.types.Field("Market", graphql_name="market")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketUserError"))), graphql_name="userErrors"
    )


class MarketingActivityConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingActivityEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingActivity"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketingActivityCreateExternalPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_activity", "user_errors")
    marketing_activity = sgqlc.types.Field("MarketingActivity", graphql_name="marketingActivity")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingActivityUserError"))), graphql_name="userErrors"
    )


class MarketingActivityCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_activity", "redirect_path", "user_errors")
    marketing_activity = sgqlc.types.Field("MarketingActivity", graphql_name="marketingActivity")
    redirect_path = sgqlc.types.Field(String, graphql_name="redirectPath")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MarketingActivityEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MarketingActivity"), graphql_name="node")


class MarketingActivityExtensionAppErrors(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "user_errors")
    code = sgqlc.types.Field(sgqlc.types.non_null(MarketingActivityExtensionAppErrorCode), graphql_name="code")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MarketingActivityUpdateExternalPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_activity", "user_errors")
    marketing_activity = sgqlc.types.Field("MarketingActivity", graphql_name="marketingActivity")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingActivityUserError"))), graphql_name="userErrors"
    )


class MarketingActivityUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_activity", "redirect_path", "user_errors")
    marketing_activity = sgqlc.types.Field("MarketingActivity", graphql_name="marketingActivity")
    redirect_path = sgqlc.types.Field(String, graphql_name="redirectPath")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MarketingBudget(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("budget_type", "total")
    budget_type = sgqlc.types.Field(sgqlc.types.non_null(MarketingBudgetBudgetType), graphql_name="budgetType")
    total = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="total")


class MarketingEngagement(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "ad_spend",
        "clicks_count",
        "comments_count",
        "complaints_count",
        "fails_count",
        "favorites_count",
        "fetched_at",
        "impressions_count",
        "is_cumulative",
        "marketing_activity",
        "occurred_on",
        "sends_count",
        "shares_count",
        "unique_clicks_count",
        "unique_views_count",
        "unsubscribes_count",
        "utc_offset",
        "views_count",
    )
    ad_spend = sgqlc.types.Field("MoneyV2", graphql_name="adSpend")
    clicks_count = sgqlc.types.Field(Int, graphql_name="clicksCount")
    comments_count = sgqlc.types.Field(Int, graphql_name="commentsCount")
    complaints_count = sgqlc.types.Field(Int, graphql_name="complaintsCount")
    fails_count = sgqlc.types.Field(Int, graphql_name="failsCount")
    favorites_count = sgqlc.types.Field(Int, graphql_name="favoritesCount")
    fetched_at = sgqlc.types.Field(DateTime, graphql_name="fetchedAt")
    impressions_count = sgqlc.types.Field(Int, graphql_name="impressionsCount")
    is_cumulative = sgqlc.types.Field(Boolean, graphql_name="isCumulative")
    marketing_activity = sgqlc.types.Field(sgqlc.types.non_null("MarketingActivity"), graphql_name="marketingActivity")
    occurred_on = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="occurredOn")
    sends_count = sgqlc.types.Field(Int, graphql_name="sendsCount")
    shares_count = sgqlc.types.Field(Int, graphql_name="sharesCount")
    unique_clicks_count = sgqlc.types.Field(Int, graphql_name="uniqueClicksCount")
    unique_views_count = sgqlc.types.Field(Int, graphql_name="uniqueViewsCount")
    unsubscribes_count = sgqlc.types.Field(Int, graphql_name="unsubscribesCount")
    utc_offset = sgqlc.types.Field(UtcOffset, graphql_name="utcOffset")
    views_count = sgqlc.types.Field(Int, graphql_name="viewsCount")


class MarketingEngagementCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("marketing_engagement", "user_errors")
    marketing_engagement = sgqlc.types.Field(MarketingEngagement, graphql_name="marketingEngagement")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MarketingEventConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingEventEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketingEvent"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MarketingEventEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MarketingEvent"), graphql_name="node")


class MediaConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Media))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MediaEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(Media), graphql_name="node")


class MediaError(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "details", "message")
    code = sgqlc.types.Field(sgqlc.types.non_null(MediaErrorCode), graphql_name="code")
    details = sgqlc.types.Field(String, graphql_name="details")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")


class MediaImageOriginalSource(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("file_size",)
    file_size = sgqlc.types.Field(Int, graphql_name="fileSize")


class MediaPreviewImage(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("image", "status")
    image = sgqlc.types.Field("Image", graphql_name="image")
    status = sgqlc.types.Field(sgqlc.types.non_null(MediaPreviewImageStatus), graphql_name="status")


class MediaWarning(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "message")
    code = sgqlc.types.Field(sgqlc.types.non_null(MediaWarningCode), graphql_name="code")
    message = sgqlc.types.Field(String, graphql_name="message")


class MerchantApprovalSignals(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("identity_verified", "verified_by_shopify", "verified_by_shopify_tier")
    identity_verified = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="identityVerified")
    verified_by_shopify = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="verifiedByShopify")
    verified_by_shopify_tier = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="verifiedByShopifyTier")


class MetafieldAccess(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("admin",)
    admin = sgqlc.types.Field(MetafieldAdminAccess, graphql_name="admin")


class MetafieldConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Metafield"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetafieldDefinitionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinition"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetafieldDefinitionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("created_definition", "user_errors")
    created_definition = sgqlc.types.Field("MetafieldDefinition", graphql_name="createdDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionCreateUserError"))), graphql_name="userErrors"
    )


class MetafieldDefinitionDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_definition_id", "user_errors")
    deleted_definition_id = sgqlc.types.Field(ID, graphql_name="deletedDefinitionId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionDeleteUserError"))), graphql_name="userErrors"
    )


class MetafieldDefinitionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MetafieldDefinition"), graphql_name="node")


class MetafieldDefinitionPinPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("pinned_definition", "user_errors")
    pinned_definition = sgqlc.types.Field("MetafieldDefinition", graphql_name="pinnedDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionPinUserError"))), graphql_name="userErrors"
    )


class MetafieldDefinitionSupportedValidation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "type")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")


class MetafieldDefinitionType(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("category", "name", "supported_validations", "supports_definition_migrations")
    category = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="category")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    supported_validations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldDefinitionSupportedValidation))),
        graphql_name="supportedValidations",
    )
    supports_definition_migrations = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="supportsDefinitionMigrations")


class MetafieldDefinitionUnpinPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("unpinned_definition", "user_errors")
    unpinned_definition = sgqlc.types.Field("MetafieldDefinition", graphql_name="unpinnedDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionUnpinUserError"))), graphql_name="userErrors"
    )


class MetafieldDefinitionUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("updated_definition", "user_errors", "validation_job")
    updated_definition = sgqlc.types.Field("MetafieldDefinition", graphql_name="updatedDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldDefinitionUpdateUserError"))), graphql_name="userErrors"
    )
    validation_job = sgqlc.types.Field(Job, graphql_name="validationJob")


class MetafieldDefinitionValidation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "type", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    value = sgqlc.types.Field(String, graphql_name="value")


class MetafieldDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MetafieldEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Metafield"), graphql_name="node")


class MetafieldReferenceConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldReferenceEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of("MetafieldReference")), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetafieldReferenceEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field("MetafieldReference", graphql_name="node")


class MetafieldRelation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("key", "name", "namespace", "referencer", "target")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    referencer = sgqlc.types.Field(sgqlc.types.non_null("MetafieldReferencer"), graphql_name="referencer")
    target = sgqlc.types.Field(sgqlc.types.non_null("MetafieldReference"), graphql_name="target")


class MetafieldRelationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldRelationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldRelation))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetafieldRelationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(MetafieldRelation), graphql_name="node")


class MetafieldStorefrontVisibilityConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldStorefrontVisibilityEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldStorefrontVisibility"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetafieldStorefrontVisibilityCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metafield_storefront_visibility", "user_errors")
    metafield_storefront_visibility = sgqlc.types.Field("MetafieldStorefrontVisibility", graphql_name="metafieldStorefrontVisibility")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MetafieldStorefrontVisibilityDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_metafield_storefront_visibility_id", "user_errors")
    deleted_metafield_storefront_visibility_id = sgqlc.types.Field(ID, graphql_name="deletedMetafieldStorefrontVisibilityId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class MetafieldStorefrontVisibilityEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MetafieldStorefrontVisibility"), graphql_name="node")


class MetafieldsSetPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metafields", "user_errors")
    metafields = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("Metafield")), graphql_name="metafields")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetafieldsSetUserError"))), graphql_name="userErrors"
    )


class MetaobjectAccess(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("admin", "storefront")
    admin = sgqlc.types.Field(sgqlc.types.non_null(MetaobjectAdminAccess), graphql_name="admin")
    storefront = sgqlc.types.Field(sgqlc.types.non_null(MetaobjectStorefrontAccess), graphql_name="storefront")


class MetaobjectBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field(Job, graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectCapabilities(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "translatable")
    publishable = sgqlc.types.Field(sgqlc.types.non_null("MetaobjectCapabilitiesPublishable"), graphql_name="publishable")
    translatable = sgqlc.types.Field(sgqlc.types.non_null("MetaobjectCapabilitiesTranslatable"), graphql_name="translatable")


class MetaobjectCapabilitiesPublishable(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("enabled",)
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")


class MetaobjectCapabilitiesTranslatable(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("enabled",)
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")


class MetaobjectCapabilityData(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable",)
    publishable = sgqlc.types.Field("MetaobjectCapabilityDataPublishable", graphql_name="publishable")


class MetaobjectCapabilityDataPublishable(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("status",)
    status = sgqlc.types.Field(sgqlc.types.non_null(MetaobjectStatus), graphql_name="status")


class MetaobjectConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Metaobject"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetaobjectCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject", "user_errors")
    metaobject = sgqlc.types.Field("Metaobject", graphql_name="metaobject")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectDefinitionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectDefinitionEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectDefinition"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class MetaobjectDefinitionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject_definition", "user_errors")
    metaobject_definition = sgqlc.types.Field("MetaobjectDefinition", graphql_name="metaobjectDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectDefinitionDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectDefinitionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("MetaobjectDefinition"), graphql_name="node")


class MetaobjectDefinitionUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject_definition", "user_errors")
    metaobject_definition = sgqlc.types.Field("MetaobjectDefinition", graphql_name="metaobjectDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Metaobject"), graphql_name="node")


class MetaobjectField(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("definition", "key", "reference", "references", "type", "value")
    definition = sgqlc.types.Field(sgqlc.types.non_null("MetaobjectFieldDefinition"), graphql_name="definition")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    reference = sgqlc.types.Field("MetafieldReference", graphql_name="reference")
    references = sgqlc.types.Field(
        MetafieldReferenceConnection,
        graphql_name="references",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
            )
        ),
    )
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    value = sgqlc.types.Field(String, graphql_name="value")


class MetaobjectFieldDefinition(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "key", "name", "required", "type", "validations")
    description = sgqlc.types.Field(String, graphql_name="description")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    required = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="required")
    type = sgqlc.types.Field(sgqlc.types.non_null(MetafieldDefinitionType), graphql_name="type")
    validations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldDefinitionValidation))), graphql_name="validations"
    )


class MetaobjectUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject", "user_errors")
    metaobject = sgqlc.types.Field("Metaobject", graphql_name="metaobject")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class MetaobjectUpsertPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject", "user_errors")
    metaobject = sgqlc.types.Field("Metaobject", graphql_name="metaobject")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class Model3dBoundingBox(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("size",)
    size = sgqlc.types.Field(sgqlc.types.non_null("Vector3"), graphql_name="size")


class Model3dSource(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("filesize", "format", "mime_type", "url")
    filesize = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="filesize")
    format = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="format")
    mime_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mimeType")
    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")


class MoneyBag(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("presentment_money", "shop_money")
    presentment_money = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="presentmentMoney")
    shop_money = sgqlc.types.Field(sgqlc.types.non_null("MoneyV2"), graphql_name="shopMoney")


class MoneyV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "currency_code")
    amount = sgqlc.types.Field(sgqlc.types.non_null(Decimal), graphql_name="amount")
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currencyCode")


class Mutation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "abandonment_update_activities_delivery_statuses",
        "app_purchase_one_time_create",
        "app_subscription_cancel",
        "app_subscription_create",
        "app_subscription_line_item_update",
        "app_subscription_trial_extend",
        "app_usage_record_create",
        "bulk_operation_cancel",
        "bulk_operation_run_mutation",
        "bulk_operation_run_query",
        "bulk_product_resource_feedback_create",
        "cart_transform_create",
        "cart_transform_delete",
        "catalog_context_update",
        "catalog_create",
        "catalog_delete",
        "catalog_update",
        "collection_add_products",
        "collection_add_products_v2",
        "collection_create",
        "collection_delete",
        "collection_remove_products",
        "collection_reorder_products",
        "collection_update",
        "companies_delete",
        "company_address_delete",
        "company_assign_customer_as_contact",
        "company_assign_main_contact",
        "company_contact_assign_role",
        "company_contact_assign_roles",
        "company_contact_create",
        "company_contact_delete",
        "company_contact_remove_from_company",
        "company_contact_revoke_role",
        "company_contact_revoke_roles",
        "company_contact_send_welcome_email",
        "company_contact_update",
        "company_contacts_delete",
        "company_create",
        "company_delete",
        "company_location_assign_address",
        "company_location_assign_roles",
        "company_location_assign_tax_exemptions",
        "company_location_create",
        "company_location_create_tax_registration",
        "company_location_delete",
        "company_location_revoke_roles",
        "company_location_revoke_tax_exemptions",
        "company_location_revoke_tax_registration",
        "company_location_update",
        "company_locations_delete",
        "company_revoke_main_contact",
        "company_update",
        "customer_add_tax_exemptions",
        "customer_create",
        "customer_delete",
        "customer_email_marketing_consent_update",
        "customer_generate_account_activation_url",
        "customer_merge",
        "customer_payment_method_create_from_duplication_data",
        "customer_payment_method_credit_card_create",
        "customer_payment_method_credit_card_update",
        "customer_payment_method_get_duplication_data",
        "customer_payment_method_get_update_url",
        "customer_payment_method_paypal_billing_agreement_create",
        "customer_payment_method_paypal_billing_agreement_update",
        "customer_payment_method_remote_create",
        "customer_payment_method_revoke",
        "customer_payment_method_send_update_email",
        "customer_remove_tax_exemptions",
        "customer_replace_tax_exemptions",
        "customer_segment_members_query_create",
        "customer_sms_marketing_consent_update",
        "customer_update",
        "customer_update_default_address",
        "delegate_access_token_create",
        "delegate_access_token_destroy",
        "delivery_customization_activation",
        "delivery_customization_create",
        "delivery_customization_delete",
        "delivery_customization_update",
        "delivery_profile_create",
        "delivery_profile_remove",
        "delivery_profile_update",
        "delivery_setting_update",
        "delivery_shipping_origin_assign",
        "discount_automatic_activate",
        "discount_automatic_app_create",
        "discount_automatic_app_update",
        "discount_automatic_basic_create",
        "discount_automatic_basic_update",
        "discount_automatic_bulk_delete",
        "discount_automatic_bxgy_create",
        "discount_automatic_bxgy_update",
        "discount_automatic_deactivate",
        "discount_automatic_delete",
        "discount_code_activate",
        "discount_code_app_create",
        "discount_code_app_update",
        "discount_code_basic_create",
        "discount_code_basic_update",
        "discount_code_bulk_activate",
        "discount_code_bulk_deactivate",
        "discount_code_bulk_delete",
        "discount_code_bxgy_create",
        "discount_code_bxgy_update",
        "discount_code_deactivate",
        "discount_code_delete",
        "discount_code_free_shipping_create",
        "discount_code_free_shipping_update",
        "discount_code_redeem_code_bulk_delete",
        "discount_redeem_code_bulk_add",
        "dispute_evidence_update",
        "draft_order_bulk_add_tags",
        "draft_order_bulk_delete",
        "draft_order_bulk_remove_tags",
        "draft_order_calculate",
        "draft_order_complete",
        "draft_order_create",
        "draft_order_create_from_order",
        "draft_order_create_merchant_checkout",
        "draft_order_delete",
        "draft_order_duplicate",
        "draft_order_invoice_preview",
        "draft_order_invoice_send",
        "draft_order_update",
        "event_bridge_server_pixel_update",
        "event_bridge_webhook_subscription_create",
        "event_bridge_webhook_subscription_update",
        "file_acknowledge_update_failed",
        "file_create",
        "file_delete",
        "file_update",
        "flow_trigger_receive",
        "fulfillment_cancel",
        "fulfillment_create_v2",
        "fulfillment_event_create",
        "fulfillment_order_accept_cancellation_request",
        "fulfillment_order_accept_fulfillment_request",
        "fulfillment_order_cancel",
        "fulfillment_order_close",
        "fulfillment_order_hold",
        "fulfillment_order_line_items_prepared_for_pickup",
        "fulfillment_order_merge",
        "fulfillment_order_move",
        "fulfillment_order_open",
        "fulfillment_order_reject_cancellation_request",
        "fulfillment_order_reject_fulfillment_request",
        "fulfillment_order_release_hold",
        "fulfillment_order_reschedule",
        "fulfillment_order_split",
        "fulfillment_order_submit_cancellation_request",
        "fulfillment_order_submit_fulfillment_request",
        "fulfillment_orders_release_holds",
        "fulfillment_orders_set_fulfillment_deadline",
        "fulfillment_service_create",
        "fulfillment_service_delete",
        "fulfillment_service_update",
        "fulfillment_tracking_info_update_v2",
        "gift_card_create",
        "gift_card_disable",
        "gift_card_update",
        "inventory_activate",
        "inventory_adjust_quantities",
        "inventory_bulk_toggle_activation",
        "inventory_deactivate",
        "inventory_item_update",
        "inventory_move_quantities",
        "inventory_set_on_hand_quantities",
        "location_activate",
        "location_add",
        "location_deactivate",
        "location_delete",
        "location_edit",
        "location_local_pickup_disable",
        "location_local_pickup_enable",
        "market_create",
        "market_currency_settings_update",
        "market_delete",
        "market_localizations_register",
        "market_localizations_remove",
        "market_region_delete",
        "market_regions_create",
        "market_update",
        "market_web_presence_create",
        "market_web_presence_delete",
        "market_web_presence_update",
        "marketing_activity_create",
        "marketing_activity_create_external",
        "marketing_activity_update",
        "marketing_activity_update_external",
        "marketing_engagement_create",
        "metafield_definition_create",
        "metafield_definition_delete",
        "metafield_definition_pin",
        "metafield_definition_unpin",
        "metafield_definition_update",
        "metafield_delete",
        "metafields_set",
        "metaobject_bulk_delete",
        "metaobject_create",
        "metaobject_definition_create",
        "metaobject_definition_delete",
        "metaobject_definition_update",
        "metaobject_delete",
        "metaobject_update",
        "metaobject_upsert",
        "order_capture",
        "order_close",
        "order_create_mandate_payment",
        "order_edit_add_custom_item",
        "order_edit_add_line_item_discount",
        "order_edit_add_variant",
        "order_edit_begin",
        "order_edit_commit",
        "order_edit_remove_line_item_discount",
        "order_edit_set_quantity",
        "order_invoice_send",
        "order_mark_as_paid",
        "order_open",
        "order_update",
        "payment_customization_activation",
        "payment_customization_create",
        "payment_customization_delete",
        "payment_customization_update",
        "payment_reminder_send",
        "payment_terms_create",
        "payment_terms_delete",
        "payment_terms_update",
        "price_list_create",
        "price_list_delete",
        "price_list_fixed_prices_add",
        "price_list_fixed_prices_by_product_update",
        "price_list_fixed_prices_delete",
        "price_list_fixed_prices_update",
        "price_list_update",
        "product_change_status",
        "product_create",
        "product_create_media",
        "product_delete",
        "product_delete_async",
        "product_delete_media",
        "product_duplicate",
        "product_duplicate_async_v2",
        "product_feed_create",
        "product_feed_delete",
        "product_full_sync",
        "product_join_selling_plan_groups",
        "product_leave_selling_plan_groups",
        "product_reorder_media",
        "product_update",
        "product_update_media",
        "product_variant_append_media",
        "product_variant_create",
        "product_variant_delete",
        "product_variant_detach_media",
        "product_variant_join_selling_plan_groups",
        "product_variant_leave_selling_plan_groups",
        "product_variant_relationship_bulk_update",
        "product_variant_update",
        "product_variants_bulk_create",
        "product_variants_bulk_delete",
        "product_variants_bulk_reorder",
        "product_variants_bulk_update",
        "pub_sub_server_pixel_update",
        "pub_sub_webhook_subscription_create",
        "pub_sub_webhook_subscription_update",
        "publication_create",
        "publication_delete",
        "publication_update",
        "publishable_publish",
        "publishable_publish_to_current_channel",
        "publishable_unpublish",
        "publishable_unpublish_to_current_channel",
        "quantity_rules_add",
        "quantity_rules_delete",
        "refund_create",
        "return_approve_request",
        "return_cancel",
        "return_close",
        "return_create",
        "return_decline_request",
        "return_refund",
        "return_reopen",
        "return_request",
        "reverse_delivery_create_with_shipping",
        "reverse_delivery_shipping_update",
        "reverse_fulfillment_order_dispose",
        "saved_search_create",
        "saved_search_delete",
        "saved_search_update",
        "script_tag_create",
        "script_tag_delete",
        "script_tag_update",
        "segment_create",
        "segment_delete",
        "segment_update",
        "selling_plan_group_add_product_variants",
        "selling_plan_group_add_products",
        "selling_plan_group_create",
        "selling_plan_group_delete",
        "selling_plan_group_remove_product_variants",
        "selling_plan_group_remove_products",
        "selling_plan_group_update",
        "server_pixel_create",
        "server_pixel_delete",
        "shipping_package_delete",
        "shipping_package_make_default",
        "shipping_package_update",
        "shop_locale_disable",
        "shop_locale_enable",
        "shop_locale_update",
        "shop_policy_update",
        "shop_resource_feedback_create",
        "staged_uploads_create",
        "standard_metafield_definition_enable",
        "standard_metaobject_definition_enable",
        "storefront_access_token_create",
        "storefront_access_token_delete",
        "subscription_billing_attempt_create",
        "subscription_billing_cycle_contract_draft_commit",
        "subscription_billing_cycle_contract_draft_concatenate",
        "subscription_billing_cycle_contract_edit",
        "subscription_billing_cycle_edit_delete",
        "subscription_billing_cycle_edits_delete",
        "subscription_billing_cycle_schedule_edit",
        "subscription_contract_atomic_create",
        "subscription_contract_create",
        "subscription_contract_product_change",
        "subscription_contract_set_next_billing_date",
        "subscription_contract_update",
        "subscription_draft_commit",
        "subscription_draft_discount_add",
        "subscription_draft_discount_code_apply",
        "subscription_draft_discount_remove",
        "subscription_draft_discount_update",
        "subscription_draft_free_shipping_discount_add",
        "subscription_draft_free_shipping_discount_update",
        "subscription_draft_line_add",
        "subscription_draft_line_remove",
        "subscription_draft_line_update",
        "subscription_draft_update",
        "tags_add",
        "tags_remove",
        "tax_app_configure",
        "translations_register",
        "translations_remove",
        "url_redirect_bulk_delete_all",
        "url_redirect_bulk_delete_by_ids",
        "url_redirect_bulk_delete_by_saved_search",
        "url_redirect_bulk_delete_by_search",
        "url_redirect_create",
        "url_redirect_delete",
        "url_redirect_import_create",
        "url_redirect_import_submit",
        "url_redirect_update",
        "web_pixel_create",
        "web_pixel_delete",
        "web_pixel_update",
        "webhook_subscription_create",
        "webhook_subscription_delete",
        "webhook_subscription_update",
    )
    abandonment_update_activities_delivery_statuses = sgqlc.types.Field(
        AbandonmentUpdateActivitiesDeliveryStatusesPayload,
        graphql_name="abandonmentUpdateActivitiesDeliveryStatuses",
        args=sgqlc.types.ArgDict(
            (
                ("abandonment_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="abandonmentId", default=None)),
                ("marketing_activity_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketingActivityId", default=None)),
                (
                    "delivery_status",
                    sgqlc.types.Arg(sgqlc.types.non_null(AbandonmentDeliveryState), graphql_name="deliveryStatus", default=None),
                ),
                ("delivered_at", sgqlc.types.Arg(DateTime, graphql_name="deliveredAt", default=None)),
                ("delivery_status_change_reason", sgqlc.types.Arg(String, graphql_name="deliveryStatusChangeReason", default=None)),
            )
        ),
    )
    app_purchase_one_time_create = sgqlc.types.Field(
        AppPurchaseOneTimeCreatePayload,
        graphql_name="appPurchaseOneTimeCreate",
        args=sgqlc.types.ArgDict(
            (
                ("name", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="name", default=None)),
                ("price", sgqlc.types.Arg(sgqlc.types.non_null(MoneyInput), graphql_name="price", default=None)),
                ("return_url", sgqlc.types.Arg(sgqlc.types.non_null(URL), graphql_name="returnUrl", default=None)),
                ("test", sgqlc.types.Arg(Boolean, graphql_name="test", default=False)),
            )
        ),
    )
    app_subscription_cancel = sgqlc.types.Field(
        AppSubscriptionCancelPayload,
        graphql_name="appSubscriptionCancel",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("prorate", sgqlc.types.Arg(Boolean, graphql_name="prorate", default=False)),
            )
        ),
    )
    app_subscription_create = sgqlc.types.Field(
        AppSubscriptionCreatePayload,
        graphql_name="appSubscriptionCreate",
        args=sgqlc.types.ArgDict(
            (
                ("name", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="name", default=None)),
                (
                    "line_items",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AppSubscriptionLineItemInput))),
                        graphql_name="lineItems",
                        default=None,
                    ),
                ),
                ("test", sgqlc.types.Arg(Boolean, graphql_name="test", default=None)),
                ("trial_days", sgqlc.types.Arg(Int, graphql_name="trialDays", default=None)),
                ("return_url", sgqlc.types.Arg(sgqlc.types.non_null(URL), graphql_name="returnUrl", default=None)),
                (
                    "replacement_behavior",
                    sgqlc.types.Arg(AppSubscriptionReplacementBehavior, graphql_name="replacementBehavior", default="STANDARD"),
                ),
            )
        ),
    )
    app_subscription_line_item_update = sgqlc.types.Field(
        AppSubscriptionLineItemUpdatePayload,
        graphql_name="appSubscriptionLineItemUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("capped_amount", sgqlc.types.Arg(sgqlc.types.non_null(MoneyInput), graphql_name="cappedAmount", default=None)),
            )
        ),
    )
    app_subscription_trial_extend = sgqlc.types.Field(
        AppSubscriptionTrialExtendPayload,
        graphql_name="appSubscriptionTrialExtend",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("days", sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name="days", default=None)),
            )
        ),
    )
    app_usage_record_create = sgqlc.types.Field(
        AppUsageRecordCreatePayload,
        graphql_name="appUsageRecordCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "subscription_line_item_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="subscriptionLineItemId", default=None),
                ),
                ("price", sgqlc.types.Arg(sgqlc.types.non_null(MoneyInput), graphql_name="price", default=None)),
                ("description", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="description", default=None)),
                ("idempotency_key", sgqlc.types.Arg(String, graphql_name="idempotencyKey", default=None)),
            )
        ),
    )
    bulk_operation_cancel = sgqlc.types.Field(
        BulkOperationCancelPayload,
        graphql_name="bulkOperationCancel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    bulk_operation_run_mutation = sgqlc.types.Field(
        BulkOperationRunMutationPayload,
        graphql_name="bulkOperationRunMutation",
        args=sgqlc.types.ArgDict(
            (
                ("mutation", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="mutation", default=None)),
                ("staged_upload_path", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="stagedUploadPath", default=None)),
                ("client_identifier", sgqlc.types.Arg(String, graphql_name="clientIdentifier", default=None)),
            )
        ),
    )
    bulk_operation_run_query = sgqlc.types.Field(
        BulkOperationRunQueryPayload,
        graphql_name="bulkOperationRunQuery",
        args=sgqlc.types.ArgDict((("query", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="query", default=None)),)),
    )
    bulk_product_resource_feedback_create = sgqlc.types.Field(
        BulkProductResourceFeedbackCreatePayload,
        graphql_name="bulkProductResourceFeedbackCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "feedback_input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductResourceFeedbackInput))),
                        graphql_name="feedbackInput",
                        default=None,
                    ),
                ),
            )
        ),
    )
    cart_transform_create = sgqlc.types.Field(
        CartTransformCreatePayload,
        graphql_name="cartTransformCreate",
        args=sgqlc.types.ArgDict(
            (("function_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="functionId", default=None)),)
        ),
    )
    cart_transform_delete = sgqlc.types.Field(
        CartTransformDeletePayload,
        graphql_name="cartTransformDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    catalog_context_update = sgqlc.types.Field(
        CatalogContextUpdatePayload,
        graphql_name="catalogContextUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("catalog_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="catalogId", default=None)),
                ("contexts_to_add", sgqlc.types.Arg(CatalogContextInput, graphql_name="contextsToAdd", default=None)),
                ("contexts_to_remove", sgqlc.types.Arg(CatalogContextInput, graphql_name="contextsToRemove", default=None)),
            )
        ),
    )
    catalog_create = sgqlc.types.Field(
        CatalogCreatePayload,
        graphql_name="catalogCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CatalogCreateInput), graphql_name="input", default=None)),)
        ),
    )
    catalog_delete = sgqlc.types.Field(
        CatalogDeletePayload,
        graphql_name="catalogDelete",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("delete_dependent_resources", sgqlc.types.Arg(Boolean, graphql_name="deleteDependentResources", default=False)),
            )
        ),
    )
    catalog_update = sgqlc.types.Field(
        CatalogUpdatePayload,
        graphql_name="catalogUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CatalogUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    collection_add_products = sgqlc.types.Field(
        CollectionAddProductsPayload,
        graphql_name="collectionAddProducts",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productIds", default=None
                    ),
                ),
            )
        ),
    )
    collection_add_products_v2 = sgqlc.types.Field(
        CollectionAddProductsV2Payload,
        graphql_name="collectionAddProductsV2",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productIds", default=None
                    ),
                ),
            )
        ),
    )
    collection_create = sgqlc.types.Field(
        CollectionCreatePayload,
        graphql_name="collectionCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(CollectionInput), graphql_name="input", default=None)),)),
    )
    collection_delete = sgqlc.types.Field(
        CollectionDeletePayload,
        graphql_name="collectionDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CollectionDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    collection_remove_products = sgqlc.types.Field(
        CollectionRemoveProductsPayload,
        graphql_name="collectionRemoveProducts",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productIds", default=None
                    ),
                ),
            )
        ),
    )
    collection_reorder_products = sgqlc.types.Field(
        CollectionReorderProductsPayload,
        graphql_name="collectionReorderProducts",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "moves",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MoveInput))), graphql_name="moves", default=None
                    ),
                ),
            )
        ),
    )
    collection_update = sgqlc.types.Field(
        CollectionUpdatePayload,
        graphql_name="collectionUpdate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(CollectionInput), graphql_name="input", default=None)),)),
    )
    companies_delete = sgqlc.types.Field(
        CompaniesDeletePayload,
        graphql_name="companiesDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "company_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="companyIds", default=None
                    ),
                ),
            )
        ),
    )
    company_address_delete = sgqlc.types.Field(
        CompanyAddressDeletePayload,
        graphql_name="companyAddressDelete",
        args=sgqlc.types.ArgDict((("address_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="addressId", default=None)),)),
    )
    company_assign_customer_as_contact = sgqlc.types.Field(
        CompanyAssignCustomerAsContactPayload,
        graphql_name="companyAssignCustomerAsContact",
        args=sgqlc.types.ArgDict(
            (
                ("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
            )
        ),
    )
    company_assign_main_contact = sgqlc.types.Field(
        CompanyAssignMainContactPayload,
        graphql_name="companyAssignMainContact",
        args=sgqlc.types.ArgDict(
            (
                ("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
            )
        ),
    )
    company_contact_assign_role = sgqlc.types.Field(
        CompanyContactAssignRolePayload,
        graphql_name="companyContactAssignRole",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                ("company_contact_role_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactRoleId", default=None)),
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
            )
        ),
    )
    company_contact_assign_roles = sgqlc.types.Field(
        CompanyContactAssignRolesPayload,
        graphql_name="companyContactAssignRoles",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                (
                    "roles_to_assign",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CompanyContactRoleAssign))),
                        graphql_name="rolesToAssign",
                        default=None,
                    ),
                ),
            )
        ),
    )
    company_contact_create = sgqlc.types.Field(
        CompanyContactCreatePayload,
        graphql_name="companyContactCreate",
        args=sgqlc.types.ArgDict(
            (
                ("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyContactInput), graphql_name="input", default=None)),
            )
        ),
    )
    company_contact_delete = sgqlc.types.Field(
        CompanyContactDeletePayload,
        graphql_name="companyContactDelete",
        args=sgqlc.types.ArgDict(
            (("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),)
        ),
    )
    company_contact_remove_from_company = sgqlc.types.Field(
        CompanyContactRemoveFromCompanyPayload,
        graphql_name="companyContactRemoveFromCompany",
        args=sgqlc.types.ArgDict(
            (("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),)
        ),
    )
    company_contact_revoke_role = sgqlc.types.Field(
        CompanyContactRevokeRolePayload,
        graphql_name="companyContactRevokeRole",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                (
                    "company_contact_role_assignment_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactRoleAssignmentId", default=None),
                ),
            )
        ),
    )
    company_contact_revoke_roles = sgqlc.types.Field(
        CompanyContactRevokeRolesPayload,
        graphql_name="companyContactRevokeRoles",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                (
                    "role_assignment_ids",
                    sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="roleAssignmentIds", default=None),
                ),
                ("revoke_all", sgqlc.types.Arg(Boolean, graphql_name="revokeAll", default=False)),
            )
        ),
    )
    company_contact_send_welcome_email = sgqlc.types.Field(
        CompanyContactSendWelcomeEmailPayload,
        graphql_name="companyContactSendWelcomeEmail",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                ("email", sgqlc.types.Arg(EmailInput, graphql_name="email", default=None)),
            )
        ),
    )
    company_contact_update = sgqlc.types.Field(
        CompanyContactUpdatePayload,
        graphql_name="companyContactUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("company_contact_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyContactId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyContactInput), graphql_name="input", default=None)),
            )
        ),
    )
    company_contacts_delete = sgqlc.types.Field(
        CompanyContactsDeletePayload,
        graphql_name="companyContactsDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "company_contact_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="companyContactIds", default=None
                    ),
                ),
            )
        ),
    )
    company_create = sgqlc.types.Field(
        CompanyCreatePayload,
        graphql_name="companyCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyCreateInput), graphql_name="input", default=None)),)
        ),
    )
    company_delete = sgqlc.types.Field(
        CompanyDeletePayload,
        graphql_name="companyDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    company_location_assign_address = sgqlc.types.Field(
        CompanyLocationAssignAddressPayload,
        graphql_name="companyLocationAssignAddress",
        args=sgqlc.types.ArgDict(
            (
                ("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),
                ("address", sgqlc.types.Arg(sgqlc.types.non_null(CompanyAddressInput), graphql_name="address", default=None)),
                (
                    "address_types",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CompanyAddressType))),
                        graphql_name="addressTypes",
                        default=None,
                    ),
                ),
            )
        ),
    )
    company_location_assign_roles = sgqlc.types.Field(
        CompanyLocationAssignRolesPayload,
        graphql_name="companyLocationAssignRoles",
        args=sgqlc.types.ArgDict(
            (
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
                (
                    "roles_to_assign",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CompanyLocationRoleAssign))),
                        graphql_name="rolesToAssign",
                        default=None,
                    ),
                ),
            )
        ),
    )
    company_location_assign_tax_exemptions = sgqlc.types.Field(
        CompanyLocationAssignTaxExemptionsPayload,
        graphql_name="companyLocationAssignTaxExemptions",
        args=sgqlc.types.ArgDict(
            (
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
                (
                    "tax_exemptions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption))),
                        graphql_name="taxExemptions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    company_location_create = sgqlc.types.Field(
        CompanyLocationCreatePayload,
        graphql_name="companyLocationCreate",
        args=sgqlc.types.ArgDict(
            (
                ("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyLocationInput), graphql_name="input", default=None)),
            )
        ),
    )
    company_location_create_tax_registration = sgqlc.types.Field(
        CompanyLocationCreateTaxRegistrationPayload,
        graphql_name="companyLocationCreateTaxRegistration",
        args=sgqlc.types.ArgDict(
            (
                ("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),
                ("tax_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="taxId", default=None)),
            )
        ),
    )
    company_location_delete = sgqlc.types.Field(
        CompanyLocationDeletePayload,
        graphql_name="companyLocationDelete",
        args=sgqlc.types.ArgDict(
            (("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),)
        ),
    )
    company_location_revoke_roles = sgqlc.types.Field(
        CompanyLocationRevokeRolesPayload,
        graphql_name="companyLocationRevokeRoles",
        args=sgqlc.types.ArgDict(
            (
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
                (
                    "roles_to_revoke",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="rolesToRevoke", default=None
                    ),
                ),
            )
        ),
    )
    company_location_revoke_tax_exemptions = sgqlc.types.Field(
        CompanyLocationRevokeTaxExemptionsPayload,
        graphql_name="companyLocationRevokeTaxExemptions",
        args=sgqlc.types.ArgDict(
            (
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
                (
                    "tax_exemptions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption))),
                        graphql_name="taxExemptions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    company_location_revoke_tax_registration = sgqlc.types.Field(
        CompanyLocationRevokeTaxRegistrationPayload,
        graphql_name="companyLocationRevokeTaxRegistration",
        args=sgqlc.types.ArgDict(
            (("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),)
        ),
    )
    company_location_update = sgqlc.types.Field(
        CompanyLocationUpdatePayload,
        graphql_name="companyLocationUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("company_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyLocationId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyLocationUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    company_locations_delete = sgqlc.types.Field(
        CompanyLocationsDeletePayload,
        graphql_name="companyLocationsDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "company_location_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="companyLocationIds", default=None
                    ),
                ),
            )
        ),
    )
    company_revoke_main_contact = sgqlc.types.Field(
        CompanyRevokeMainContactPayload,
        graphql_name="companyRevokeMainContact",
        args=sgqlc.types.ArgDict((("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),)),
    )
    company_update = sgqlc.types.Field(
        CompanyUpdatePayload,
        graphql_name="companyUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("company_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="companyId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(CompanyInput), graphql_name="input", default=None)),
            )
        ),
    )
    customer_add_tax_exemptions = sgqlc.types.Field(
        CustomerAddTaxExemptionsPayload,
        graphql_name="customerAddTaxExemptions",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "tax_exemptions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption))),
                        graphql_name="taxExemptions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    customer_create = sgqlc.types.Field(
        CustomerCreatePayload,
        graphql_name="customerCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(CustomerInput), graphql_name="input", default=None)),)),
    )
    customer_delete = sgqlc.types.Field(
        CustomerDeletePayload,
        graphql_name="customerDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CustomerDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    customer_email_marketing_consent_update = sgqlc.types.Field(
        CustomerEmailMarketingConsentUpdatePayload,
        graphql_name="customerEmailMarketingConsentUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(sgqlc.types.non_null(CustomerEmailMarketingConsentUpdateInput), graphql_name="input", default=None),
                ),
            )
        ),
    )
    customer_generate_account_activation_url = sgqlc.types.Field(
        CustomerGenerateAccountActivationUrlPayload,
        graphql_name="customerGenerateAccountActivationUrl",
        args=sgqlc.types.ArgDict((("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),)),
    )
    customer_merge = sgqlc.types.Field(
        CustomerMergePayload,
        graphql_name="customerMerge",
        args=sgqlc.types.ArgDict(
            (
                ("customer_one_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerOneId", default=None)),
                ("customer_two_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerTwoId", default=None)),
                ("override_fields", sgqlc.types.Arg(CustomerMergeOverrideFields, graphql_name="overrideFields", default=None)),
            )
        ),
    )
    customer_payment_method_create_from_duplication_data = sgqlc.types.Field(
        CustomerPaymentMethodCreateFromDuplicationDataPayload,
        graphql_name="customerPaymentMethodCreateFromDuplicationData",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "billing_address",
                    sgqlc.types.Arg(sgqlc.types.non_null(MailingAddressInput), graphql_name="billingAddress", default=None),
                ),
                (
                    "encrypted_duplication_data",
                    sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="encryptedDuplicationData", default=None),
                ),
            )
        ),
    )
    customer_payment_method_credit_card_create = sgqlc.types.Field(
        CustomerPaymentMethodCreditCardCreatePayload,
        graphql_name="customerPaymentMethodCreditCardCreate",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "billing_address",
                    sgqlc.types.Arg(sgqlc.types.non_null(MailingAddressInput), graphql_name="billingAddress", default=None),
                ),
                ("session_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="sessionId", default=None)),
            )
        ),
    )
    customer_payment_method_credit_card_update = sgqlc.types.Field(
        CustomerPaymentMethodCreditCardUpdatePayload,
        graphql_name="customerPaymentMethodCreditCardUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "billing_address",
                    sgqlc.types.Arg(sgqlc.types.non_null(MailingAddressInput), graphql_name="billingAddress", default=None),
                ),
                ("session_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="sessionId", default=None)),
            )
        ),
    )
    customer_payment_method_get_duplication_data = sgqlc.types.Field(
        CustomerPaymentMethodGetDuplicationDataPayload,
        graphql_name="customerPaymentMethodGetDuplicationData",
        args=sgqlc.types.ArgDict(
            (
                (
                    "customer_payment_method_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerPaymentMethodId", default=None),
                ),
                ("target_shop_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="targetShopId", default=None)),
                ("target_customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="targetCustomerId", default=None)),
            )
        ),
    )
    customer_payment_method_get_update_url = sgqlc.types.Field(
        CustomerPaymentMethodGetUpdateUrlPayload,
        graphql_name="customerPaymentMethodGetUpdateUrl",
        args=sgqlc.types.ArgDict(
            (
                (
                    "customer_payment_method_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerPaymentMethodId", default=None),
                ),
            )
        ),
    )
    customer_payment_method_paypal_billing_agreement_create = sgqlc.types.Field(
        CustomerPaymentMethodPaypalBillingAgreementCreatePayload,
        graphql_name="customerPaymentMethodPaypalBillingAgreementCreate",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                ("billing_address", sgqlc.types.Arg(MailingAddressInput, graphql_name="billingAddress", default=None)),
                ("billing_agreement_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="billingAgreementId", default=None)),
                ("inactive", sgqlc.types.Arg(Boolean, graphql_name="inactive", default=False)),
            )
        ),
    )
    customer_payment_method_paypal_billing_agreement_update = sgqlc.types.Field(
        CustomerPaymentMethodPaypalBillingAgreementUpdatePayload,
        graphql_name="customerPaymentMethodPaypalBillingAgreementUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "billing_address",
                    sgqlc.types.Arg(sgqlc.types.non_null(MailingAddressInput), graphql_name="billingAddress", default=None),
                ),
            )
        ),
    )
    customer_payment_method_remote_create = sgqlc.types.Field(
        CustomerPaymentMethodRemoteCreatePayload,
        graphql_name="customerPaymentMethodRemoteCreate",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "remote_reference",
                    sgqlc.types.Arg(sgqlc.types.non_null(CustomerPaymentMethodRemoteInput), graphql_name="remoteReference", default=None),
                ),
            )
        ),
    )
    customer_payment_method_revoke = sgqlc.types.Field(
        CustomerPaymentMethodRevokePayload,
        graphql_name="customerPaymentMethodRevoke",
        args=sgqlc.types.ArgDict(
            (
                (
                    "customer_payment_method_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerPaymentMethodId", default=None),
                ),
            )
        ),
    )
    customer_payment_method_send_update_email = sgqlc.types.Field(
        CustomerPaymentMethodSendUpdateEmailPayload,
        graphql_name="customerPaymentMethodSendUpdateEmail",
        args=sgqlc.types.ArgDict(
            (
                (
                    "customer_payment_method_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerPaymentMethodId", default=None),
                ),
                ("email", sgqlc.types.Arg(EmailInput, graphql_name="email", default=None)),
            )
        ),
    )
    customer_remove_tax_exemptions = sgqlc.types.Field(
        CustomerRemoveTaxExemptionsPayload,
        graphql_name="customerRemoveTaxExemptions",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "tax_exemptions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption))),
                        graphql_name="taxExemptions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    customer_replace_tax_exemptions = sgqlc.types.Field(
        CustomerReplaceTaxExemptionsPayload,
        graphql_name="customerReplaceTaxExemptions",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                (
                    "tax_exemptions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TaxExemption))),
                        graphql_name="taxExemptions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    customer_segment_members_query_create = sgqlc.types.Field(
        CustomerSegmentMembersQueryCreatePayload,
        graphql_name="customerSegmentMembersQueryCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CustomerSegmentMembersQueryInput), graphql_name="input", default=None)),)
        ),
    )
    customer_sms_marketing_consent_update = sgqlc.types.Field(
        CustomerSmsMarketingConsentUpdatePayload,
        graphql_name="customerSmsMarketingConsentUpdate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(CustomerSmsMarketingConsentUpdateInput), graphql_name="input", default=None)),)
        ),
    )
    customer_update = sgqlc.types.Field(
        CustomerUpdatePayload,
        graphql_name="customerUpdate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(CustomerInput), graphql_name="input", default=None)),)),
    )
    customer_update_default_address = sgqlc.types.Field(
        CustomerUpdateDefaultAddressPayload,
        graphql_name="customerUpdateDefaultAddress",
        args=sgqlc.types.ArgDict(
            (
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
                ("address_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="addressId", default=None)),
            )
        ),
    )
    delegate_access_token_create = sgqlc.types.Field(
        DelegateAccessTokenCreatePayload,
        graphql_name="delegateAccessTokenCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(DelegateAccessTokenInput), graphql_name="input", default=None)),)
        ),
    )
    delegate_access_token_destroy = sgqlc.types.Field(
        DelegateAccessTokenDestroyPayload,
        graphql_name="delegateAccessTokenDestroy",
        args=sgqlc.types.ArgDict(
            (("access_token", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="accessToken", default=None)),)
        ),
    )
    delivery_customization_activation = sgqlc.types.Field(
        DeliveryCustomizationActivationPayload,
        graphql_name="deliveryCustomizationActivation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "ids",
                    sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="ids", default=None),
                ),
                ("enabled", sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name="enabled", default=None)),
            )
        ),
    )
    delivery_customization_create = sgqlc.types.Field(
        DeliveryCustomizationCreatePayload,
        graphql_name="deliveryCustomizationCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "delivery_customization",
                    sgqlc.types.Arg(sgqlc.types.non_null(DeliveryCustomizationInput), graphql_name="deliveryCustomization", default=None),
                ),
            )
        ),
    )
    delivery_customization_delete = sgqlc.types.Field(
        DeliveryCustomizationDeletePayload,
        graphql_name="deliveryCustomizationDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    delivery_customization_update = sgqlc.types.Field(
        DeliveryCustomizationUpdatePayload,
        graphql_name="deliveryCustomizationUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "delivery_customization",
                    sgqlc.types.Arg(sgqlc.types.non_null(DeliveryCustomizationInput), graphql_name="deliveryCustomization", default=None),
                ),
            )
        ),
    )
    delivery_profile_create = sgqlc.types.Field(
        "deliveryProfileCreatePayload",
        graphql_name="deliveryProfileCreate",
        args=sgqlc.types.ArgDict(
            (("profile", sgqlc.types.Arg(sgqlc.types.non_null(DeliveryProfileInput), graphql_name="profile", default=None)),)
        ),
    )
    delivery_profile_remove = sgqlc.types.Field(
        "deliveryProfileRemovePayload",
        graphql_name="deliveryProfileRemove",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    delivery_profile_update = sgqlc.types.Field(
        "deliveryProfileUpdatePayload",
        graphql_name="deliveryProfileUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("profile", sgqlc.types.Arg(sgqlc.types.non_null(DeliveryProfileInput), graphql_name="profile", default=None)),
                ("leave_legacy_mode_profiles", sgqlc.types.Arg(Boolean, graphql_name="leaveLegacyModeProfiles", default=None)),
            )
        ),
    )
    delivery_setting_update = sgqlc.types.Field(
        DeliverySettingUpdatePayload,
        graphql_name="deliverySettingUpdate",
        args=sgqlc.types.ArgDict(
            (("setting", sgqlc.types.Arg(sgqlc.types.non_null(DeliverySettingInput), graphql_name="setting", default=None)),)
        ),
    )
    delivery_shipping_origin_assign = sgqlc.types.Field(
        DeliveryShippingOriginAssignPayload,
        graphql_name="deliveryShippingOriginAssign",
        args=sgqlc.types.ArgDict((("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),)),
    )
    discount_automatic_activate = sgqlc.types.Field(
        DiscountAutomaticActivatePayload,
        graphql_name="discountAutomaticActivate",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_automatic_app_create = sgqlc.types.Field(
        DiscountAutomaticAppCreatePayload,
        graphql_name="discountAutomaticAppCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "automatic_app_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticAppInput), graphql_name="automaticAppDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_app_update = sgqlc.types.Field(
        DiscountAutomaticAppUpdatePayload,
        graphql_name="discountAutomaticAppUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "automatic_app_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticAppInput), graphql_name="automaticAppDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_basic_create = sgqlc.types.Field(
        DiscountAutomaticBasicCreatePayload,
        graphql_name="discountAutomaticBasicCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "automatic_basic_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticBasicInput), graphql_name="automaticBasicDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_basic_update = sgqlc.types.Field(
        DiscountAutomaticBasicUpdatePayload,
        graphql_name="discountAutomaticBasicUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "automatic_basic_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticBasicInput), graphql_name="automaticBasicDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_bulk_delete = sgqlc.types.Field(
        DiscountAutomaticBulkDeletePayload,
        graphql_name="discountAutomaticBulkDelete",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    discount_automatic_bxgy_create = sgqlc.types.Field(
        DiscountAutomaticBxgyCreatePayload,
        graphql_name="discountAutomaticBxgyCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "automatic_bxgy_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticBxgyInput), graphql_name="automaticBxgyDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_bxgy_update = sgqlc.types.Field(
        DiscountAutomaticBxgyUpdatePayload,
        graphql_name="discountAutomaticBxgyUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "automatic_bxgy_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountAutomaticBxgyInput), graphql_name="automaticBxgyDiscount", default=None),
                ),
            )
        ),
    )
    discount_automatic_deactivate = sgqlc.types.Field(
        DiscountAutomaticDeactivatePayload,
        graphql_name="discountAutomaticDeactivate",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_automatic_delete = sgqlc.types.Field(
        DiscountAutomaticDeletePayload,
        graphql_name="discountAutomaticDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_code_activate = sgqlc.types.Field(
        DiscountCodeActivatePayload,
        graphql_name="discountCodeActivate",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_code_app_create = sgqlc.types.Field(
        DiscountCodeAppCreatePayload,
        graphql_name="discountCodeAppCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code_app_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeAppInput), graphql_name="codeAppDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_app_update = sgqlc.types.Field(
        DiscountCodeAppUpdatePayload,
        graphql_name="discountCodeAppUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "code_app_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeAppInput), graphql_name="codeAppDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_basic_create = sgqlc.types.Field(
        DiscountCodeBasicCreatePayload,
        graphql_name="discountCodeBasicCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "basic_code_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeBasicInput), graphql_name="basicCodeDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_basic_update = sgqlc.types.Field(
        DiscountCodeBasicUpdatePayload,
        graphql_name="discountCodeBasicUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "basic_code_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeBasicInput), graphql_name="basicCodeDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_bulk_activate = sgqlc.types.Field(
        DiscountCodeBulkActivatePayload,
        graphql_name="discountCodeBulkActivate",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    discount_code_bulk_deactivate = sgqlc.types.Field(
        DiscountCodeBulkDeactivatePayload,
        graphql_name="discountCodeBulkDeactivate",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    discount_code_bulk_delete = sgqlc.types.Field(
        DiscountCodeBulkDeletePayload,
        graphql_name="discountCodeBulkDelete",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    discount_code_bxgy_create = sgqlc.types.Field(
        DiscountCodeBxgyCreatePayload,
        graphql_name="discountCodeBxgyCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "bxgy_code_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeBxgyInput), graphql_name="bxgyCodeDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_bxgy_update = sgqlc.types.Field(
        DiscountCodeBxgyUpdatePayload,
        graphql_name="discountCodeBxgyUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "bxgy_code_discount",
                    sgqlc.types.Arg(sgqlc.types.non_null(DiscountCodeBxgyInput), graphql_name="bxgyCodeDiscount", default=None),
                ),
            )
        ),
    )
    discount_code_deactivate = sgqlc.types.Field(
        DiscountCodeDeactivatePayload,
        graphql_name="discountCodeDeactivate",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_code_delete = sgqlc.types.Field(
        DiscountCodeDeletePayload,
        graphql_name="discountCodeDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_code_free_shipping_create = sgqlc.types.Field(
        DiscountCodeFreeShippingCreatePayload,
        graphql_name="discountCodeFreeShippingCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "free_shipping_code_discount",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DiscountCodeFreeShippingInput), graphql_name="freeShippingCodeDiscount", default=None
                    ),
                ),
            )
        ),
    )
    discount_code_free_shipping_update = sgqlc.types.Field(
        DiscountCodeFreeShippingUpdatePayload,
        graphql_name="discountCodeFreeShippingUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "free_shipping_code_discount",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DiscountCodeFreeShippingInput), graphql_name="freeShippingCodeDiscount", default=None
                    ),
                ),
            )
        ),
    )
    discount_code_redeem_code_bulk_delete = sgqlc.types.Field(
        DiscountCodeRedeemCodeBulkDeletePayload,
        graphql_name="discountCodeRedeemCodeBulkDelete",
        args=sgqlc.types.ArgDict(
            (
                ("discount_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountId", default=None)),
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    discount_redeem_code_bulk_add = sgqlc.types.Field(
        DiscountRedeemCodeBulkAddPayload,
        graphql_name="discountRedeemCodeBulkAdd",
        args=sgqlc.types.ArgDict(
            (
                ("discount_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountId", default=None)),
                (
                    "codes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DiscountRedeemCodeInput))),
                        graphql_name="codes",
                        default=None,
                    ),
                ),
            )
        ),
    )
    dispute_evidence_update = sgqlc.types.Field(
        DisputeEvidenceUpdatePayload,
        graphql_name="disputeEvidenceUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "input",
                    sgqlc.types.Arg(sgqlc.types.non_null(ShopifyPaymentsDisputeEvidenceUpdateInput), graphql_name="input", default=None),
                ),
            )
        ),
    )
    draft_order_bulk_add_tags = sgqlc.types.Field(
        DraftOrderBulkAddTagsPayload,
        graphql_name="draftOrderBulkAddTags",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags", default=None
                    ),
                ),
            )
        ),
    )
    draft_order_bulk_delete = sgqlc.types.Field(
        DraftOrderBulkDeletePayload,
        graphql_name="draftOrderBulkDelete",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
            )
        ),
    )
    draft_order_bulk_remove_tags = sgqlc.types.Field(
        DraftOrderBulkRemoveTagsPayload,
        graphql_name="draftOrderBulkRemoveTags",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(String, graphql_name="search", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="ids", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags", default=None
                    ),
                ),
            )
        ),
    )
    draft_order_calculate = sgqlc.types.Field(
        DraftOrderCalculatePayload,
        graphql_name="draftOrderCalculate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(DraftOrderInput), graphql_name="input", default=None)),)),
    )
    draft_order_complete = sgqlc.types.Field(
        DraftOrderCompletePayload,
        graphql_name="draftOrderComplete",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("payment_pending", sgqlc.types.Arg(Boolean, graphql_name="paymentPending", default=False)),
                ("payment_gateway_id", sgqlc.types.Arg(ID, graphql_name="paymentGatewayId", default=None)),
                ("source_name", sgqlc.types.Arg(String, graphql_name="sourceName", default=None)),
            )
        ),
    )
    draft_order_create = sgqlc.types.Field(
        DraftOrderCreatePayload,
        graphql_name="draftOrderCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(DraftOrderInput), graphql_name="input", default=None)),)),
    )
    draft_order_create_from_order = sgqlc.types.Field(
        DraftOrderCreateFromOrderPayload,
        graphql_name="draftOrderCreateFromOrder",
        args=sgqlc.types.ArgDict((("order_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="orderId", default=None)),)),
    )
    draft_order_create_merchant_checkout = sgqlc.types.Field(
        DraftOrderCreateMerchantCheckoutPayload,
        graphql_name="draftOrderCreateMerchantCheckout",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    draft_order_delete = sgqlc.types.Field(
        DraftOrderDeletePayload,
        graphql_name="draftOrderDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(DraftOrderDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    draft_order_duplicate = sgqlc.types.Field(
        DraftOrderDuplicatePayload,
        graphql_name="draftOrderDuplicate",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),)),
    )
    draft_order_invoice_preview = sgqlc.types.Field(
        DraftOrderInvoicePreviewPayload,
        graphql_name="draftOrderInvoicePreview",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("email", sgqlc.types.Arg(EmailInput, graphql_name="email", default=None)),
            )
        ),
    )
    draft_order_invoice_send = sgqlc.types.Field(
        DraftOrderInvoiceSendPayload,
        graphql_name="draftOrderInvoiceSend",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("email", sgqlc.types.Arg(EmailInput, graphql_name="email", default=None)),
            )
        ),
    )
    draft_order_update = sgqlc.types.Field(
        DraftOrderUpdatePayload,
        graphql_name="draftOrderUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(DraftOrderInput), graphql_name="input", default=None)),
            )
        ),
    )
    event_bridge_server_pixel_update = sgqlc.types.Field(
        EventBridgeServerPixelUpdatePayload,
        graphql_name="eventBridgeServerPixelUpdate",
        args=sgqlc.types.ArgDict((("arn", sgqlc.types.Arg(sgqlc.types.non_null(ARN), graphql_name="arn", default=None)),)),
    )
    event_bridge_webhook_subscription_create = sgqlc.types.Field(
        EventBridgeWebhookSubscriptionCreatePayload,
        graphql_name="eventBridgeWebhookSubscriptionCreate",
        args=sgqlc.types.ArgDict(
            (
                ("topic", sgqlc.types.Arg(sgqlc.types.non_null(WebhookSubscriptionTopic), graphql_name="topic", default=None)),
                (
                    "webhook_subscription",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(EventBridgeWebhookSubscriptionInput), graphql_name="webhookSubscription", default=None
                    ),
                ),
            )
        ),
    )
    event_bridge_webhook_subscription_update = sgqlc.types.Field(
        EventBridgeWebhookSubscriptionUpdatePayload,
        graphql_name="eventBridgeWebhookSubscriptionUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "webhook_subscription",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(EventBridgeWebhookSubscriptionInput), graphql_name="webhookSubscription", default=None
                    ),
                ),
            )
        ),
    )
    file_acknowledge_update_failed = sgqlc.types.Field(
        FileAcknowledgeUpdateFailedPayload,
        graphql_name="fileAcknowledgeUpdateFailed",
        args=sgqlc.types.ArgDict(
            (
                (
                    "file_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="fileIds", default=None
                    ),
                ),
            )
        ),
    )
    file_create = sgqlc.types.Field(
        FileCreatePayload,
        graphql_name="fileCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "files",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FileCreateInput))), graphql_name="files", default=None
                    ),
                ),
            )
        ),
    )
    file_delete = sgqlc.types.Field(
        FileDeletePayload,
        graphql_name="fileDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "file_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="fileIds", default=None
                    ),
                ),
            )
        ),
    )
    file_update = sgqlc.types.Field(
        FileUpdatePayload,
        graphql_name="fileUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "files",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FileUpdateInput))), graphql_name="files", default=None
                    ),
                ),
            )
        ),
    )
    flow_trigger_receive = sgqlc.types.Field(
        FlowTriggerReceivePayload,
        graphql_name="flowTriggerReceive",
        args=sgqlc.types.ArgDict((("body", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="body", default=None)),)),
    )
    fulfillment_cancel = sgqlc.types.Field(
        FulfillmentCancelPayload,
        graphql_name="fulfillmentCancel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    fulfillment_create_v2 = sgqlc.types.Field(
        FulfillmentCreateV2Payload,
        graphql_name="fulfillmentCreateV2",
        args=sgqlc.types.ArgDict(
            (
                ("fulfillment", sgqlc.types.Arg(sgqlc.types.non_null(FulfillmentV2Input), graphql_name="fulfillment", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_event_create = sgqlc.types.Field(
        FulfillmentEventCreatePayload,
        graphql_name="fulfillmentEventCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "fulfillment_event",
                    sgqlc.types.Arg(sgqlc.types.non_null(FulfillmentEventInput), graphql_name="fulfillmentEvent", default=None),
                ),
            )
        ),
    )
    fulfillment_order_accept_cancellation_request = sgqlc.types.Field(
        FulfillmentOrderAcceptCancellationRequestPayload,
        graphql_name="fulfillmentOrderAcceptCancellationRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_order_accept_fulfillment_request = sgqlc.types.Field(
        FulfillmentOrderAcceptFulfillmentRequestPayload,
        graphql_name="fulfillmentOrderAcceptFulfillmentRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_order_cancel = sgqlc.types.Field(
        FulfillmentOrderCancelPayload,
        graphql_name="fulfillmentOrderCancel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    fulfillment_order_close = sgqlc.types.Field(
        FulfillmentOrderClosePayload,
        graphql_name="fulfillmentOrderClose",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_order_hold = sgqlc.types.Field(
        FulfillmentOrderHoldPayload,
        graphql_name="fulfillmentOrderHold",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "fulfillment_hold",
                    sgqlc.types.Arg(sgqlc.types.non_null(FulfillmentOrderHoldInput), graphql_name="fulfillmentHold", default=None),
                ),
            )
        ),
    )
    fulfillment_order_line_items_prepared_for_pickup = sgqlc.types.Field(
        FulfillmentOrderLineItemsPreparedForPickupPayload,
        graphql_name="fulfillmentOrderLineItemsPreparedForPickup",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(FulfillmentOrderLineItemsPreparedForPickupInput), graphql_name="input", default=None
                    ),
                ),
            )
        ),
    )
    fulfillment_order_merge = sgqlc.types.Field(
        FulfillmentOrderMergePayload,
        graphql_name="fulfillmentOrderMerge",
        args=sgqlc.types.ArgDict(
            (
                (
                    "fulfillment_order_merge_inputs",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderMergeInput))),
                        graphql_name="fulfillmentOrderMergeInputs",
                        default=None,
                    ),
                ),
            )
        ),
    )
    fulfillment_order_move = sgqlc.types.Field(
        FulfillmentOrderMovePayload,
        graphql_name="fulfillmentOrderMove",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("new_location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="newLocationId", default=None)),
                (
                    "fulfillment_order_line_items",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemInput)),
                        graphql_name="fulfillmentOrderLineItems",
                        default=None,
                    ),
                ),
            )
        ),
    )
    fulfillment_order_open = sgqlc.types.Field(
        FulfillmentOrderOpenPayload,
        graphql_name="fulfillmentOrderOpen",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    fulfillment_order_reject_cancellation_request = sgqlc.types.Field(
        FulfillmentOrderRejectCancellationRequestPayload,
        graphql_name="fulfillmentOrderRejectCancellationRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_order_reject_fulfillment_request = sgqlc.types.Field(
        FulfillmentOrderRejectFulfillmentRequestPayload,
        graphql_name="fulfillmentOrderRejectFulfillmentRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("reason", sgqlc.types.Arg(FulfillmentOrderRejectionReason, graphql_name="reason", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
                (
                    "line_items",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(IncomingRequestLineItemInput)), graphql_name="lineItems", default=None
                    ),
                ),
            )
        ),
    )
    fulfillment_order_release_hold = sgqlc.types.Field(
        FulfillmentOrderReleaseHoldPayload,
        graphql_name="fulfillmentOrderReleaseHold",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("external_id", sgqlc.types.Arg(String, graphql_name="externalId", default=None)),
            )
        ),
    )
    fulfillment_order_reschedule = sgqlc.types.Field(
        FulfillmentOrderReschedulePayload,
        graphql_name="fulfillmentOrderReschedule",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("fulfill_at", sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name="fulfillAt", default=None)),
            )
        ),
    )
    fulfillment_order_split = sgqlc.types.Field(
        FulfillmentOrderSplitPayload,
        graphql_name="fulfillmentOrderSplit",
        args=sgqlc.types.ArgDict(
            (
                (
                    "fulfillment_order_splits",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderSplitInput))),
                        graphql_name="fulfillmentOrderSplits",
                        default=None,
                    ),
                ),
            )
        ),
    )
    fulfillment_order_submit_cancellation_request = sgqlc.types.Field(
        FulfillmentOrderSubmitCancellationRequestPayload,
        graphql_name="fulfillmentOrderSubmitCancellationRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
            )
        ),
    )
    fulfillment_order_submit_fulfillment_request = sgqlc.types.Field(
        FulfillmentOrderSubmitFulfillmentRequestPayload,
        graphql_name="fulfillmentOrderSubmitFulfillmentRequest",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("message", sgqlc.types.Arg(String, graphql_name="message", default=None)),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=None)),
                (
                    "fulfillment_order_line_items",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(FulfillmentOrderLineItemInput)),
                        graphql_name="fulfillmentOrderLineItems",
                        default=None,
                    ),
                ),
                ("shipping_method", sgqlc.types.Arg(String, graphql_name="shippingMethod", default=None)),
            )
        ),
    )
    fulfillment_orders_release_holds = sgqlc.types.Field(
        FulfillmentOrdersReleaseHoldsPayload,
        graphql_name="fulfillmentOrdersReleaseHolds",
        args=sgqlc.types.ArgDict(
            (
                (
                    "ids",
                    sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="ids", default=None),
                ),
                ("external_id", sgqlc.types.Arg(String, graphql_name="externalId", default=None)),
            )
        ),
    )
    fulfillment_orders_set_fulfillment_deadline = sgqlc.types.Field(
        FulfillmentOrdersSetFulfillmentDeadlinePayload,
        graphql_name="fulfillmentOrdersSetFulfillmentDeadline",
        args=sgqlc.types.ArgDict(
            (
                (
                    "fulfillment_order_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))),
                        graphql_name="fulfillmentOrderIds",
                        default=None,
                    ),
                ),
                ("fulfillment_deadline", sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name="fulfillmentDeadline", default=None)),
            )
        ),
    )
    fulfillment_service_create = sgqlc.types.Field(
        FulfillmentServiceCreatePayload,
        graphql_name="fulfillmentServiceCreate",
        args=sgqlc.types.ArgDict(
            (
                ("name", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="name", default=None)),
                ("callback_url", sgqlc.types.Arg(sgqlc.types.non_null(URL), graphql_name="callbackUrl", default=None)),
                ("tracking_support", sgqlc.types.Arg(Boolean, graphql_name="trackingSupport", default=False)),
                (
                    "fulfillment_orders_opt_in",
                    sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name="fulfillmentOrdersOptIn", default=None),
                ),
                ("permits_sku_sharing", sgqlc.types.Arg(Boolean, graphql_name="permitsSkuSharing", default=False)),
                ("inventory_management", sgqlc.types.Arg(Boolean, graphql_name="inventoryManagement", default=False)),
            )
        ),
    )
    fulfillment_service_delete = sgqlc.types.Field(
        FulfillmentServiceDeletePayload,
        graphql_name="fulfillmentServiceDelete",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("destination_location_id", sgqlc.types.Arg(ID, graphql_name="destinationLocationId", default=None)),
            )
        ),
    )
    fulfillment_service_update = sgqlc.types.Field(
        FulfillmentServiceUpdatePayload,
        graphql_name="fulfillmentServiceUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("callback_url", sgqlc.types.Arg(URL, graphql_name="callbackUrl", default=None)),
                ("tracking_support", sgqlc.types.Arg(Boolean, graphql_name="trackingSupport", default=None)),
                ("fulfillment_orders_opt_in", sgqlc.types.Arg(Boolean, graphql_name="fulfillmentOrdersOptIn", default=None)),
                ("permits_sku_sharing", sgqlc.types.Arg(Boolean, graphql_name="permitsSkuSharing", default=None)),
            )
        ),
    )
    fulfillment_tracking_info_update_v2 = sgqlc.types.Field(
        FulfillmentTrackingInfoUpdateV2Payload,
        graphql_name="fulfillmentTrackingInfoUpdateV2",
        args=sgqlc.types.ArgDict(
            (
                ("fulfillment_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="fulfillmentId", default=None)),
                (
                    "tracking_info_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(FulfillmentTrackingInput), graphql_name="trackingInfoInput", default=None),
                ),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=None)),
            )
        ),
    )
    gift_card_create = sgqlc.types.Field(
        GiftCardCreatePayload,
        graphql_name="giftCardCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(GiftCardCreateInput), graphql_name="input", default=None)),)
        ),
    )
    gift_card_disable = sgqlc.types.Field(
        GiftCardDisablePayload,
        graphql_name="giftCardDisable",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    gift_card_update = sgqlc.types.Field(
        GiftCardUpdatePayload,
        graphql_name="giftCardUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(GiftCardUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    inventory_activate = sgqlc.types.Field(
        InventoryActivatePayload,
        graphql_name="inventoryActivate",
        args=sgqlc.types.ArgDict(
            (
                ("inventory_item_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="inventoryItemId", default=None)),
                ("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),
                ("available", sgqlc.types.Arg(Int, graphql_name="available", default=None)),
                ("on_hand", sgqlc.types.Arg(Int, graphql_name="onHand", default=None)),
            )
        ),
    )
    inventory_adjust_quantities = sgqlc.types.Field(
        InventoryAdjustQuantitiesPayload,
        graphql_name="inventoryAdjustQuantities",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(InventoryAdjustQuantitiesInput), graphql_name="input", default=None)),)
        ),
    )
    inventory_bulk_toggle_activation = sgqlc.types.Field(
        InventoryBulkToggleActivationPayload,
        graphql_name="inventoryBulkToggleActivation",
        args=sgqlc.types.ArgDict(
            (
                ("inventory_item_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="inventoryItemId", default=None)),
                (
                    "inventory_item_updates",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(InventoryBulkToggleActivationInput))),
                        graphql_name="inventoryItemUpdates",
                        default=None,
                    ),
                ),
            )
        ),
    )
    inventory_deactivate = sgqlc.types.Field(
        InventoryDeactivatePayload,
        graphql_name="inventoryDeactivate",
        args=sgqlc.types.ArgDict(
            (("inventory_level_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="inventoryLevelId", default=None)),)
        ),
    )
    inventory_item_update = sgqlc.types.Field(
        InventoryItemUpdatePayload,
        graphql_name="inventoryItemUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(InventoryItemUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    inventory_move_quantities = sgqlc.types.Field(
        InventoryMoveQuantitiesPayload,
        graphql_name="inventoryMoveQuantities",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(InventoryMoveQuantitiesInput), graphql_name="input", default=None)),)
        ),
    )
    inventory_set_on_hand_quantities = sgqlc.types.Field(
        InventorySetOnHandQuantitiesPayload,
        graphql_name="inventorySetOnHandQuantities",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(InventorySetOnHandQuantitiesInput), graphql_name="input", default=None)),)
        ),
    )
    location_activate = sgqlc.types.Field(
        LocationActivatePayload,
        graphql_name="locationActivate",
        args=sgqlc.types.ArgDict((("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),)),
    )
    location_add = sgqlc.types.Field(
        LocationAddPayload,
        graphql_name="locationAdd",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(LocationAddInput), graphql_name="input", default=None)),)),
    )
    location_deactivate = sgqlc.types.Field(
        LocationDeactivatePayload,
        graphql_name="locationDeactivate",
        args=sgqlc.types.ArgDict(
            (
                ("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),
                ("destination_location_id", sgqlc.types.Arg(ID, graphql_name="destinationLocationId", default=None)),
            )
        ),
    )
    location_delete = sgqlc.types.Field(
        LocationDeletePayload,
        graphql_name="locationDelete",
        args=sgqlc.types.ArgDict((("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),)),
    )
    location_edit = sgqlc.types.Field(
        LocationEditPayload,
        graphql_name="locationEdit",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(LocationEditInput), graphql_name="input", default=None)),
            )
        ),
    )
    location_local_pickup_disable = sgqlc.types.Field(
        LocationLocalPickupDisablePayload,
        graphql_name="locationLocalPickupDisable",
        args=sgqlc.types.ArgDict((("location_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="locationId", default=None)),)),
    )
    location_local_pickup_enable = sgqlc.types.Field(
        LocationLocalPickupEnablePayload,
        graphql_name="locationLocalPickupEnable",
        args=sgqlc.types.ArgDict(
            (
                (
                    "local_pickup_settings",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DeliveryLocationLocalPickupEnableInput), graphql_name="localPickupSettings", default=None
                    ),
                ),
            )
        ),
    )
    market_create = sgqlc.types.Field(
        MarketCreatePayload,
        graphql_name="marketCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketCreateInput), graphql_name="input", default=None)),)
        ),
    )
    market_currency_settings_update = sgqlc.types.Field(
        MarketCurrencySettingsUpdatePayload,
        graphql_name="marketCurrencySettingsUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketCurrencySettingsUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    market_delete = sgqlc.types.Field(
        MarketDeletePayload,
        graphql_name="marketDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    market_localizations_register = sgqlc.types.Field(
        MarketLocalizationsRegisterPayload,
        graphql_name="marketLocalizationsRegister",
        args=sgqlc.types.ArgDict(
            (
                ("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),
                (
                    "market_localizations",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MarketLocalizationRegisterInput))),
                        graphql_name="marketLocalizations",
                        default=None,
                    ),
                ),
            )
        ),
    )
    market_localizations_remove = sgqlc.types.Field(
        MarketLocalizationsRemovePayload,
        graphql_name="marketLocalizationsRemove",
        args=sgqlc.types.ArgDict(
            (
                ("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),
                (
                    "market_localization_keys",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
                        graphql_name="marketLocalizationKeys",
                        default=None,
                    ),
                ),
                (
                    "market_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="marketIds", default=None
                    ),
                ),
            )
        ),
    )
    market_region_delete = sgqlc.types.Field(
        MarketRegionDeletePayload,
        graphql_name="marketRegionDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    market_regions_create = sgqlc.types.Field(
        MarketRegionsCreatePayload,
        graphql_name="marketRegionsCreate",
        args=sgqlc.types.ArgDict(
            (
                ("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),
                (
                    "regions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MarketRegionCreateInput))),
                        graphql_name="regions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    market_update = sgqlc.types.Field(
        MarketUpdatePayload,
        graphql_name="marketUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    market_web_presence_create = sgqlc.types.Field(
        MarketWebPresenceCreatePayload,
        graphql_name="marketWebPresenceCreate",
        args=sgqlc.types.ArgDict(
            (
                ("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),
                (
                    "web_presence",
                    sgqlc.types.Arg(sgqlc.types.non_null(MarketWebPresenceCreateInput), graphql_name="webPresence", default=None),
                ),
            )
        ),
    )
    market_web_presence_delete = sgqlc.types.Field(
        MarketWebPresenceDeletePayload,
        graphql_name="marketWebPresenceDelete",
        args=sgqlc.types.ArgDict((("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),)),
    )
    market_web_presence_update = sgqlc.types.Field(
        MarketWebPresenceUpdatePayload,
        graphql_name="marketWebPresenceUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("market_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketId", default=None)),
                (
                    "web_presence",
                    sgqlc.types.Arg(sgqlc.types.non_null(MarketWebPresenceUpdateInput), graphql_name="webPresence", default=None),
                ),
            )
        ),
    )
    marketing_activity_create = sgqlc.types.Field(
        MarketingActivityCreatePayload,
        graphql_name="marketingActivityCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketingActivityCreateInput), graphql_name="input", default=None)),)
        ),
    )
    marketing_activity_create_external = sgqlc.types.Field(
        MarketingActivityCreateExternalPayload,
        graphql_name="marketingActivityCreateExternal",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketingActivityCreateExternalInput), graphql_name="input", default=None)),)
        ),
    )
    marketing_activity_update = sgqlc.types.Field(
        MarketingActivityUpdatePayload,
        graphql_name="marketingActivityUpdate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketingActivityUpdateInput), graphql_name="input", default=None)),)
        ),
    )
    marketing_activity_update_external = sgqlc.types.Field(
        MarketingActivityUpdateExternalPayload,
        graphql_name="marketingActivityUpdateExternal",
        args=sgqlc.types.ArgDict(
            (
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(MarketingActivityUpdateExternalInput), graphql_name="input", default=None)),
                ("marketing_activity_id", sgqlc.types.Arg(ID, graphql_name="marketingActivityId", default=None)),
                ("remote_id", sgqlc.types.Arg(String, graphql_name="remoteId", default=None)),
                ("utm", sgqlc.types.Arg(UTMInput, graphql_name="utm", default=None)),
            )
        ),
    )
    marketing_engagement_create = sgqlc.types.Field(
        MarketingEngagementCreatePayload,
        graphql_name="marketingEngagementCreate",
        args=sgqlc.types.ArgDict(
            (
                ("marketing_activity_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="marketingActivityId", default=None)),
                (
                    "marketing_engagement",
                    sgqlc.types.Arg(sgqlc.types.non_null(MarketingEngagementInput), graphql_name="marketingEngagement", default=None),
                ),
            )
        ),
    )
    metafield_definition_create = sgqlc.types.Field(
        MetafieldDefinitionCreatePayload,
        graphql_name="metafieldDefinitionCreate",
        args=sgqlc.types.ArgDict(
            (("definition", sgqlc.types.Arg(sgqlc.types.non_null(MetafieldDefinitionInput), graphql_name="definition", default=None)),)
        ),
    )
    metafield_definition_delete = sgqlc.types.Field(
        MetafieldDefinitionDeletePayload,
        graphql_name="metafieldDefinitionDelete",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("delete_all_associated_metafields", sgqlc.types.Arg(Boolean, graphql_name="deleteAllAssociatedMetafields", default=False)),
            )
        ),
    )
    metafield_definition_pin = sgqlc.types.Field(
        MetafieldDefinitionPinPayload,
        graphql_name="metafieldDefinitionPin",
        args=sgqlc.types.ArgDict(
            (("definition_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="definitionId", default=None)),)
        ),
    )
    metafield_definition_unpin = sgqlc.types.Field(
        MetafieldDefinitionUnpinPayload,
        graphql_name="metafieldDefinitionUnpin",
        args=sgqlc.types.ArgDict(
            (("definition_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="definitionId", default=None)),)
        ),
    )
    metafield_definition_update = sgqlc.types.Field(
        MetafieldDefinitionUpdatePayload,
        graphql_name="metafieldDefinitionUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "definition",
                    sgqlc.types.Arg(sgqlc.types.non_null(MetafieldDefinitionUpdateInput), graphql_name="definition", default=None),
                ),
            )
        ),
    )
    metafield_delete = sgqlc.types.Field(
        MetafieldDeletePayload,
        graphql_name="metafieldDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(MetafieldDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    metafields_set = sgqlc.types.Field(
        MetafieldsSetPayload,
        graphql_name="metafieldsSet",
        args=sgqlc.types.ArgDict(
            (
                (
                    "metafields",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldsSetInput))),
                        graphql_name="metafields",
                        default=None,
                    ),
                ),
            )
        ),
    )
    metaobject_bulk_delete = sgqlc.types.Field(
        MetaobjectBulkDeletePayload,
        graphql_name="metaobjectBulkDelete",
        args=sgqlc.types.ArgDict(
            (("where", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectBulkDeleteWhereCondition), graphql_name="where", default=None)),)
        ),
    )
    metaobject_create = sgqlc.types.Field(
        MetaobjectCreatePayload,
        graphql_name="metaobjectCreate",
        args=sgqlc.types.ArgDict(
            (("metaobject", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectCreateInput), graphql_name="metaobject", default=None)),)
        ),
    )
    metaobject_definition_create = sgqlc.types.Field(
        MetaobjectDefinitionCreatePayload,
        graphql_name="metaobjectDefinitionCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "definition",
                    sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectDefinitionCreateInput), graphql_name="definition", default=None),
                ),
            )
        ),
    )
    metaobject_definition_delete = sgqlc.types.Field(
        MetaobjectDefinitionDeletePayload,
        graphql_name="metaobjectDefinitionDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metaobject_definition_update = sgqlc.types.Field(
        MetaobjectDefinitionUpdatePayload,
        graphql_name="metaobjectDefinitionUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "definition",
                    sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectDefinitionUpdateInput), graphql_name="definition", default=None),
                ),
            )
        ),
    )
    metaobject_delete = sgqlc.types.Field(
        MetaobjectDeletePayload,
        graphql_name="metaobjectDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metaobject_update = sgqlc.types.Field(
        MetaobjectUpdatePayload,
        graphql_name="metaobjectUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("metaobject", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectUpdateInput), graphql_name="metaobject", default=None)),
            )
        ),
    )
    metaobject_upsert = sgqlc.types.Field(
        MetaobjectUpsertPayload,
        graphql_name="metaobjectUpsert",
        args=sgqlc.types.ArgDict(
            (
                ("handle", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectHandleInput), graphql_name="handle", default=None)),
                ("metaobject", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectUpsertInput), graphql_name="metaobject", default=None)),
            )
        ),
    )
    order_capture = sgqlc.types.Field(
        "OrderCapturePayload",
        graphql_name="orderCapture",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(OrderCaptureInput), graphql_name="input", default=None)),)
        ),
    )
    order_close = sgqlc.types.Field(
        "OrderClosePayload",
        graphql_name="orderClose",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(OrderCloseInput), graphql_name="input", default=None)),)),
    )
    order_create_mandate_payment = sgqlc.types.Field(
        "OrderCreateMandatePaymentPayload",
        graphql_name="orderCreateMandatePayment",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("payment_schedule_id", sgqlc.types.Arg(ID, graphql_name="paymentScheduleId", default=None)),
                ("idempotency_key", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="idempotencyKey", default=None)),
                ("mandate_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="mandateId", default=None)),
                ("auto_capture", sgqlc.types.Arg(Boolean, graphql_name="autoCapture", default=True)),
            )
        ),
    )
    order_edit_add_custom_item = sgqlc.types.Field(
        "OrderEditAddCustomItemPayload",
        graphql_name="orderEditAddCustomItem",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("title", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="title", default=None)),
                ("location_id", sgqlc.types.Arg(ID, graphql_name="locationId", default=None)),
                ("price", sgqlc.types.Arg(sgqlc.types.non_null(MoneyInput), graphql_name="price", default=None)),
                ("quantity", sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name="quantity", default=None)),
                ("taxable", sgqlc.types.Arg(Boolean, graphql_name="taxable", default=None)),
                ("requires_shipping", sgqlc.types.Arg(Boolean, graphql_name="requiresShipping", default=None)),
            )
        ),
    )
    order_edit_add_line_item_discount = sgqlc.types.Field(
        "OrderEditAddLineItemDiscountPayload",
        graphql_name="orderEditAddLineItemDiscount",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("line_item_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="lineItemId", default=None)),
                ("discount", sgqlc.types.Arg(sgqlc.types.non_null(OrderEditAppliedDiscountInput), graphql_name="discount", default=None)),
            )
        ),
    )
    order_edit_add_variant = sgqlc.types.Field(
        "OrderEditAddVariantPayload",
        graphql_name="orderEditAddVariant",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("variant_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="variantId", default=None)),
                ("location_id", sgqlc.types.Arg(ID, graphql_name="locationId", default=None)),
                ("quantity", sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name="quantity", default=None)),
                ("allow_duplicates", sgqlc.types.Arg(Boolean, graphql_name="allowDuplicates", default=False)),
            )
        ),
    )
    order_edit_begin = sgqlc.types.Field(
        "OrderEditBeginPayload",
        graphql_name="orderEditBegin",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    order_edit_commit = sgqlc.types.Field(
        "OrderEditCommitPayload",
        graphql_name="orderEditCommit",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=None)),
                ("staff_note", sgqlc.types.Arg(String, graphql_name="staffNote", default=None)),
            )
        ),
    )
    order_edit_remove_line_item_discount = sgqlc.types.Field(
        "OrderEditRemoveLineItemDiscountPayload",
        graphql_name="orderEditRemoveLineItemDiscount",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("discount_application_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountApplicationId", default=None)),
            )
        ),
    )
    order_edit_set_quantity = sgqlc.types.Field(
        "OrderEditSetQuantityPayload",
        graphql_name="orderEditSetQuantity",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("line_item_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="lineItemId", default=None)),
                ("quantity", sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name="quantity", default=None)),
                ("restock", sgqlc.types.Arg(Boolean, graphql_name="restock", default=None)),
            )
        ),
    )
    order_invoice_send = sgqlc.types.Field(
        "OrderInvoiceSendPayload",
        graphql_name="orderInvoiceSend",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("email", sgqlc.types.Arg(EmailInput, graphql_name="email", default=None)),
            )
        ),
    )
    order_mark_as_paid = sgqlc.types.Field(
        "OrderMarkAsPaidPayload",
        graphql_name="orderMarkAsPaid",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(OrderMarkAsPaidInput), graphql_name="input", default=None)),)
        ),
    )
    order_open = sgqlc.types.Field(
        "OrderOpenPayload",
        graphql_name="orderOpen",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(OrderOpenInput), graphql_name="input", default=None)),)),
    )
    order_update = sgqlc.types.Field(
        "OrderUpdatePayload",
        graphql_name="orderUpdate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(OrderInput), graphql_name="input", default=None)),)),
    )
    payment_customization_activation = sgqlc.types.Field(
        "PaymentCustomizationActivationPayload",
        graphql_name="paymentCustomizationActivation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "ids",
                    sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="ids", default=None),
                ),
                ("enabled", sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name="enabled", default=None)),
            )
        ),
    )
    payment_customization_create = sgqlc.types.Field(
        "PaymentCustomizationCreatePayload",
        graphql_name="paymentCustomizationCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "payment_customization",
                    sgqlc.types.Arg(sgqlc.types.non_null(PaymentCustomizationInput), graphql_name="paymentCustomization", default=None),
                ),
            )
        ),
    )
    payment_customization_delete = sgqlc.types.Field(
        "PaymentCustomizationDeletePayload",
        graphql_name="paymentCustomizationDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    payment_customization_update = sgqlc.types.Field(
        "PaymentCustomizationUpdatePayload",
        graphql_name="paymentCustomizationUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "payment_customization",
                    sgqlc.types.Arg(sgqlc.types.non_null(PaymentCustomizationInput), graphql_name="paymentCustomization", default=None),
                ),
            )
        ),
    )
    payment_reminder_send = sgqlc.types.Field(
        "PaymentReminderSendPayload",
        graphql_name="paymentReminderSend",
        args=sgqlc.types.ArgDict(
            (("payment_schedule_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="paymentScheduleId", default=None)),)
        ),
    )
    payment_terms_create = sgqlc.types.Field(
        "PaymentTermsCreatePayload",
        graphql_name="paymentTermsCreate",
        args=sgqlc.types.ArgDict(
            (
                ("reference_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="referenceId", default=None)),
                (
                    "payment_terms_attributes",
                    sgqlc.types.Arg(sgqlc.types.non_null(PaymentTermsCreateInput), graphql_name="paymentTermsAttributes", default=None),
                ),
            )
        ),
    )
    payment_terms_delete = sgqlc.types.Field(
        "PaymentTermsDeletePayload",
        graphql_name="paymentTermsDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(PaymentTermsDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    payment_terms_update = sgqlc.types.Field(
        "PaymentTermsUpdatePayload",
        graphql_name="paymentTermsUpdate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(PaymentTermsUpdateInput), graphql_name="input", default=None)),)
        ),
    )
    price_list_create = sgqlc.types.Field(
        "PriceListCreatePayload",
        graphql_name="priceListCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(PriceListCreateInput), graphql_name="input", default=None)),)
        ),
    )
    price_list_delete = sgqlc.types.Field(
        "PriceListDeletePayload",
        graphql_name="priceListDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    price_list_fixed_prices_add = sgqlc.types.Field(
        "PriceListFixedPricesAddPayload",
        graphql_name="priceListFixedPricesAdd",
        args=sgqlc.types.ArgDict(
            (
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
                (
                    "prices",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PriceListPriceInput))),
                        graphql_name="prices",
                        default=None,
                    ),
                ),
            )
        ),
    )
    price_list_fixed_prices_by_product_update = sgqlc.types.Field(
        "PriceListFixedPricesByProductUpdatePayload",
        graphql_name="priceListFixedPricesByProductUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "prices_to_add",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(PriceListProductPriceInput)), graphql_name="pricesToAdd", default=None
                    ),
                ),
                (
                    "prices_to_delete_by_product_ids",
                    sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="pricesToDeleteByProductIds", default=None),
                ),
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
            )
        ),
    )
    price_list_fixed_prices_delete = sgqlc.types.Field(
        "PriceListFixedPricesDeletePayload",
        graphql_name="priceListFixedPricesDelete",
        args=sgqlc.types.ArgDict(
            (
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
                (
                    "variant_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="variantIds", default=None
                    ),
                ),
            )
        ),
    )
    price_list_fixed_prices_update = sgqlc.types.Field(
        "PriceListFixedPricesUpdatePayload",
        graphql_name="priceListFixedPricesUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
                (
                    "prices_to_add",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PriceListPriceInput))),
                        graphql_name="pricesToAdd",
                        default=None,
                    ),
                ),
                (
                    "variant_ids_to_delete",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="variantIdsToDelete", default=None
                    ),
                ),
            )
        ),
    )
    price_list_update = sgqlc.types.Field(
        "PriceListUpdatePayload",
        graphql_name="priceListUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(PriceListUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    product_change_status = sgqlc.types.Field(
        "ProductChangeStatusPayload",
        graphql_name="productChangeStatus",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                ("status", sgqlc.types.Arg(sgqlc.types.non_null(ProductStatus), graphql_name="status", default=None)),
            )
        ),
    )
    product_create = sgqlc.types.Field(
        "ProductCreatePayload",
        graphql_name="productCreate",
        args=sgqlc.types.ArgDict(
            (
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductInput), graphql_name="input", default=None)),
                ("media", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(CreateMediaInput)), graphql_name="media", default=None)),
            )
        ),
    )
    product_create_media = sgqlc.types.Field(
        "ProductCreateMediaPayload",
        graphql_name="productCreateMedia",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "media",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CreateMediaInput))),
                        graphql_name="media",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_delete = sgqlc.types.Field(
        "ProductDeletePayload",
        graphql_name="productDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    product_delete_async = sgqlc.types.Field(
        "ProductDeleteAsyncPayload",
        graphql_name="productDeleteAsync",
        args=sgqlc.types.ArgDict((("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),)),
    )
    product_delete_media = sgqlc.types.Field(
        "ProductDeleteMediaPayload",
        graphql_name="productDeleteMedia",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "media_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="mediaIds", default=None
                    ),
                ),
            )
        ),
    )
    product_duplicate = sgqlc.types.Field(
        "ProductDuplicatePayload",
        graphql_name="productDuplicate",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                ("new_title", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="newTitle", default=None)),
                ("new_status", sgqlc.types.Arg(ProductStatus, graphql_name="newStatus", default=None)),
                ("include_images", sgqlc.types.Arg(Boolean, graphql_name="includeImages", default=False)),
            )
        ),
    )
    product_duplicate_async_v2 = sgqlc.types.Field(
        "ProductDuplicateAsyncV2Payload",
        graphql_name="productDuplicateAsyncV2",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductDuplicateAsyncInput), graphql_name="input", default=None)),)
        ),
    )
    product_feed_create = sgqlc.types.Field(
        "ProductFeedCreatePayload",
        graphql_name="productFeedCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(ProductFeedInput, graphql_name="input", default=None)),)),
    )
    product_feed_delete = sgqlc.types.Field(
        "ProductFeedDeletePayload",
        graphql_name="productFeedDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_full_sync = sgqlc.types.Field(
        "ProductFullSyncPayload",
        graphql_name="productFullSync",
        args=sgqlc.types.ArgDict(
            (
                ("before_updated_at", sgqlc.types.Arg(DateTime, graphql_name="beforeUpdatedAt", default=None)),
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("updated_at_since", sgqlc.types.Arg(DateTime, graphql_name="updatedAtSince", default=None)),
            )
        ),
    )
    product_join_selling_plan_groups = sgqlc.types.Field(
        "ProductJoinSellingPlanGroupsPayload",
        graphql_name="productJoinSellingPlanGroups",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "selling_plan_group_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))),
                        graphql_name="sellingPlanGroupIds",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_leave_selling_plan_groups = sgqlc.types.Field(
        "ProductLeaveSellingPlanGroupsPayload",
        graphql_name="productLeaveSellingPlanGroups",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "selling_plan_group_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))),
                        graphql_name="sellingPlanGroupIds",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_reorder_media = sgqlc.types.Field(
        "ProductReorderMediaPayload",
        graphql_name="productReorderMedia",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "moves",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MoveInput))), graphql_name="moves", default=None
                    ),
                ),
            )
        ),
    )
    product_update = sgqlc.types.Field(
        "ProductUpdatePayload",
        graphql_name="productUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductInput), graphql_name="input", default=None)),
                ("media", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(CreateMediaInput)), graphql_name="media", default=None)),
            )
        ),
    )
    product_update_media = sgqlc.types.Field(
        "ProductUpdateMediaPayload",
        graphql_name="productUpdateMedia",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "media",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(UpdateMediaInput))),
                        graphql_name="media",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_append_media = sgqlc.types.Field(
        "ProductVariantAppendMediaPayload",
        graphql_name="productVariantAppendMedia",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "variant_media",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantAppendMediaInput))),
                        graphql_name="variantMedia",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_create = sgqlc.types.Field(
        "ProductVariantCreatePayload",
        graphql_name="productVariantCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductVariantInput), graphql_name="input", default=None)),)
        ),
    )
    product_variant_delete = sgqlc.types.Field(
        "ProductVariantDeletePayload",
        graphql_name="productVariantDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_variant_detach_media = sgqlc.types.Field(
        "ProductVariantDetachMediaPayload",
        graphql_name="productVariantDetachMedia",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "variant_media",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantDetachMediaInput))),
                        graphql_name="variantMedia",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_join_selling_plan_groups = sgqlc.types.Field(
        "ProductVariantJoinSellingPlanGroupsPayload",
        graphql_name="productVariantJoinSellingPlanGroups",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "selling_plan_group_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))),
                        graphql_name="sellingPlanGroupIds",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_leave_selling_plan_groups = sgqlc.types.Field(
        "ProductVariantLeaveSellingPlanGroupsPayload",
        graphql_name="productVariantLeaveSellingPlanGroups",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "selling_plan_group_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))),
                        graphql_name="sellingPlanGroupIds",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_relationship_bulk_update = sgqlc.types.Field(
        "ProductVariantRelationshipBulkUpdatePayload",
        graphql_name="productVariantRelationshipBulkUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantRelationshipUpdateInput))),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variant_update = sgqlc.types.Field(
        "ProductVariantUpdatePayload",
        graphql_name="productVariantUpdate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ProductVariantInput), graphql_name="input", default=None)),)
        ),
    )
    product_variants_bulk_create = sgqlc.types.Field(
        "ProductVariantsBulkCreatePayload",
        graphql_name="productVariantsBulkCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "variants",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantsBulkInput))),
                        graphql_name="variants",
                        default=None,
                    ),
                ),
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                ("media", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(CreateMediaInput)), graphql_name="media", default=None)),
            )
        ),
    )
    product_variants_bulk_delete = sgqlc.types.Field(
        "ProductVariantsBulkDeletePayload",
        graphql_name="productVariantsBulkDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "variants_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="variantsIds", default=None
                    ),
                ),
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
            )
        ),
    )
    product_variants_bulk_reorder = sgqlc.types.Field(
        "ProductVariantsBulkReorderPayload",
        graphql_name="productVariantsBulkReorder",
        args=sgqlc.types.ArgDict(
            (
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                (
                    "positions",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantPositionInput))),
                        graphql_name="positions",
                        default=None,
                    ),
                ),
            )
        ),
    )
    product_variants_bulk_update = sgqlc.types.Field(
        "ProductVariantsBulkUpdatePayload",
        graphql_name="productVariantsBulkUpdate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "variants",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantsBulkInput))),
                        graphql_name="variants",
                        default=None,
                    ),
                ),
                ("product_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="productId", default=None)),
                ("media", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(CreateMediaInput)), graphql_name="media", default=None)),
                ("allow_partial_updates", sgqlc.types.Arg(Boolean, graphql_name="allowPartialUpdates", default=False)),
            )
        ),
    )
    pub_sub_server_pixel_update = sgqlc.types.Field(
        "PubSubServerPixelUpdatePayload",
        graphql_name="pubSubServerPixelUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("pub_sub_project", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="pubSubProject", default=None)),
                ("pub_sub_topic", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="pubSubTopic", default=None)),
            )
        ),
    )
    pub_sub_webhook_subscription_create = sgqlc.types.Field(
        "PubSubWebhookSubscriptionCreatePayload",
        graphql_name="pubSubWebhookSubscriptionCreate",
        args=sgqlc.types.ArgDict(
            (
                ("topic", sgqlc.types.Arg(sgqlc.types.non_null(WebhookSubscriptionTopic), graphql_name="topic", default=None)),
                (
                    "webhook_subscription",
                    sgqlc.types.Arg(sgqlc.types.non_null(PubSubWebhookSubscriptionInput), graphql_name="webhookSubscription", default=None),
                ),
            )
        ),
    )
    pub_sub_webhook_subscription_update = sgqlc.types.Field(
        "PubSubWebhookSubscriptionUpdatePayload",
        graphql_name="pubSubWebhookSubscriptionUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("webhook_subscription", sgqlc.types.Arg(PubSubWebhookSubscriptionInput, graphql_name="webhookSubscription", default=None)),
            )
        ),
    )
    publication_create = sgqlc.types.Field(
        "PublicationCreatePayload",
        graphql_name="publicationCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(PublicationCreateInput), graphql_name="input", default=None)),)
        ),
    )
    publication_delete = sgqlc.types.Field(
        "PublicationDeletePayload",
        graphql_name="publicationDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    publication_update = sgqlc.types.Field(
        "PublicationUpdatePayload",
        graphql_name="publicationUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(PublicationUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    publishable_publish = sgqlc.types.Field(
        "PublishablePublishPayload",
        graphql_name="publishablePublish",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PublicationInput))),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    publishable_publish_to_current_channel = sgqlc.types.Field(
        "PublishablePublishToCurrentChannelPayload",
        graphql_name="publishablePublishToCurrentChannel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    publishable_unpublish = sgqlc.types.Field(
        "PublishableUnpublishPayload",
        graphql_name="publishableUnpublish",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PublicationInput))),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    publishable_unpublish_to_current_channel = sgqlc.types.Field(
        "PublishableUnpublishToCurrentChannelPayload",
        graphql_name="publishableUnpublishToCurrentChannel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    quantity_rules_add = sgqlc.types.Field(
        "QuantityRulesAddPayload",
        graphql_name="quantityRulesAdd",
        args=sgqlc.types.ArgDict(
            (
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
                (
                    "quantity_rules",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(QuantityRuleInput))),
                        graphql_name="quantityRules",
                        default=None,
                    ),
                ),
            )
        ),
    )
    quantity_rules_delete = sgqlc.types.Field(
        "QuantityRulesDeletePayload",
        graphql_name="quantityRulesDelete",
        args=sgqlc.types.ArgDict(
            (
                ("price_list_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="priceListId", default=None)),
                (
                    "variant_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="variantIds", default=None
                    ),
                ),
            )
        ),
    )
    refund_create = sgqlc.types.Field(
        "RefundCreatePayload",
        graphql_name="refundCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(RefundInput), graphql_name="input", default=None)),)),
    )
    return_approve_request = sgqlc.types.Field(
        "ReturnApproveRequestPayload",
        graphql_name="returnApproveRequest",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ReturnApproveRequestInput), graphql_name="input", default=None)),)
        ),
    )
    return_cancel = sgqlc.types.Field(
        "ReturnCancelPayload",
        graphql_name="returnCancel",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=False)),
            )
        ),
    )
    return_close = sgqlc.types.Field(
        "ReturnClosePayload",
        graphql_name="returnClose",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    return_create = sgqlc.types.Field(
        "ReturnCreatePayload",
        graphql_name="returnCreate",
        args=sgqlc.types.ArgDict(
            (("return_input", sgqlc.types.Arg(sgqlc.types.non_null(ReturnInput), graphql_name="returnInput", default=None)),)
        ),
    )
    return_decline_request = sgqlc.types.Field(
        "ReturnDeclineRequestPayload",
        graphql_name="returnDeclineRequest",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ReturnDeclineRequestInput), graphql_name="input", default=None)),)
        ),
    )
    return_refund = sgqlc.types.Field(
        "ReturnRefundPayload",
        graphql_name="returnRefund",
        args=sgqlc.types.ArgDict(
            (
                (
                    "return_refund_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(ReturnRefundInput), graphql_name="returnRefundInput", default=None),
                ),
            )
        ),
    )
    return_reopen = sgqlc.types.Field(
        "ReturnReopenPayload",
        graphql_name="returnReopen",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    return_request = sgqlc.types.Field(
        "ReturnRequestPayload",
        graphql_name="returnRequest",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ReturnRequestInput), graphql_name="input", default=None)),)
        ),
    )
    reverse_delivery_create_with_shipping = sgqlc.types.Field(
        "ReverseDeliveryCreateWithShippingPayload",
        graphql_name="reverseDeliveryCreateWithShipping",
        args=sgqlc.types.ArgDict(
            (
                (
                    "reverse_fulfillment_order_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="reverseFulfillmentOrderId", default=None),
                ),
                (
                    "reverse_delivery_line_items",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ReverseDeliveryLineItemInput))),
                        graphql_name="reverseDeliveryLineItems",
                        default=None,
                    ),
                ),
                ("tracking_input", sgqlc.types.Arg(ReverseDeliveryTrackingInput, graphql_name="trackingInput", default=None)),
                ("label_input", sgqlc.types.Arg(ReverseDeliveryLabelInput, graphql_name="labelInput", default=None)),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=True)),
            )
        ),
    )
    reverse_delivery_shipping_update = sgqlc.types.Field(
        "ReverseDeliveryShippingUpdatePayload",
        graphql_name="reverseDeliveryShippingUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("reverse_delivery_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="reverseDeliveryId", default=None)),
                ("tracking_input", sgqlc.types.Arg(ReverseDeliveryTrackingInput, graphql_name="trackingInput", default=None)),
                ("label_input", sgqlc.types.Arg(ReverseDeliveryLabelInput, graphql_name="labelInput", default=None)),
                ("notify_customer", sgqlc.types.Arg(Boolean, graphql_name="notifyCustomer", default=True)),
            )
        ),
    )
    reverse_fulfillment_order_dispose = sgqlc.types.Field(
        "ReverseFulfillmentOrderDisposePayload",
        graphql_name="reverseFulfillmentOrderDispose",
        args=sgqlc.types.ArgDict(
            (
                (
                    "disposition_inputs",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ReverseFulfillmentOrderDisposeInput))),
                        graphql_name="dispositionInputs",
                        default=None,
                    ),
                ),
            )
        ),
    )
    saved_search_create = sgqlc.types.Field(
        "SavedSearchCreatePayload",
        graphql_name="savedSearchCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(SavedSearchCreateInput), graphql_name="input", default=None)),)
        ),
    )
    saved_search_delete = sgqlc.types.Field(
        "SavedSearchDeletePayload",
        graphql_name="savedSearchDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(SavedSearchDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    saved_search_update = sgqlc.types.Field(
        "SavedSearchUpdatePayload",
        graphql_name="savedSearchUpdate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(SavedSearchUpdateInput), graphql_name="input", default=None)),)
        ),
    )
    script_tag_create = sgqlc.types.Field(
        "ScriptTagCreatePayload",
        graphql_name="scriptTagCreate",
        args=sgqlc.types.ArgDict((("input", sgqlc.types.Arg(sgqlc.types.non_null(ScriptTagInput), graphql_name="input", default=None)),)),
    )
    script_tag_delete = sgqlc.types.Field(
        "ScriptTagDeletePayload",
        graphql_name="scriptTagDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    script_tag_update = sgqlc.types.Field(
        "ScriptTagUpdatePayload",
        graphql_name="scriptTagUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(ScriptTagInput), graphql_name="input", default=None)),
            )
        ),
    )
    segment_create = sgqlc.types.Field(
        "SegmentCreatePayload",
        graphql_name="segmentCreate",
        args=sgqlc.types.ArgDict(
            (
                ("name", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="name", default=None)),
                ("query", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="query", default=None)),
            )
        ),
    )
    segment_delete = sgqlc.types.Field(
        "SegmentDeletePayload",
        graphql_name="segmentDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    segment_update = sgqlc.types.Field(
        "SegmentUpdatePayload",
        graphql_name="segmentUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    selling_plan_group_add_product_variants = sgqlc.types.Field(
        "SellingPlanGroupAddProductVariantsPayload",
        graphql_name="sellingPlanGroupAddProductVariants",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_variant_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productVariantIds", default=None
                    ),
                ),
            )
        ),
    )
    selling_plan_group_add_products = sgqlc.types.Field(
        "SellingPlanGroupAddProductsPayload",
        graphql_name="sellingPlanGroupAddProducts",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productIds", default=None
                    ),
                ),
            )
        ),
    )
    selling_plan_group_create = sgqlc.types.Field(
        "SellingPlanGroupCreatePayload",
        graphql_name="sellingPlanGroupCreate",
        args=sgqlc.types.ArgDict(
            (
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SellingPlanGroupInput), graphql_name="input", default=None)),
                ("resources", sgqlc.types.Arg(SellingPlanGroupResourceInput, graphql_name="resources", default=None)),
            )
        ),
    )
    selling_plan_group_delete = sgqlc.types.Field(
        "SellingPlanGroupDeletePayload",
        graphql_name="sellingPlanGroupDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    selling_plan_group_remove_product_variants = sgqlc.types.Field(
        "SellingPlanGroupRemoveProductVariantsPayload",
        graphql_name="sellingPlanGroupRemoveProductVariants",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_variant_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productVariantIds", default=None
                    ),
                ),
            )
        ),
    )
    selling_plan_group_remove_products = sgqlc.types.Field(
        "SellingPlanGroupRemoveProductsPayload",
        graphql_name="sellingPlanGroupRemoveProducts",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="productIds", default=None
                    ),
                ),
            )
        ),
    )
    selling_plan_group_update = sgqlc.types.Field(
        "SellingPlanGroupUpdatePayload",
        graphql_name="sellingPlanGroupUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SellingPlanGroupInput), graphql_name="input", default=None)),
            )
        ),
    )
    server_pixel_create = sgqlc.types.Field("ServerPixelCreatePayload", graphql_name="serverPixelCreate")
    server_pixel_delete = sgqlc.types.Field("ServerPixelDeletePayload", graphql_name="serverPixelDelete")
    shipping_package_delete = sgqlc.types.Field(
        "ShippingPackageDeletePayload",
        graphql_name="shippingPackageDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    shipping_package_make_default = sgqlc.types.Field(
        "ShippingPackageMakeDefaultPayload",
        graphql_name="shippingPackageMakeDefault",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    shipping_package_update = sgqlc.types.Field(
        "ShippingPackageUpdatePayload",
        graphql_name="shippingPackageUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "shipping_package",
                    sgqlc.types.Arg(sgqlc.types.non_null(CustomShippingPackageInput), graphql_name="shippingPackage", default=None),
                ),
            )
        ),
    )
    shop_locale_disable = sgqlc.types.Field(
        "ShopLocaleDisablePayload",
        graphql_name="shopLocaleDisable",
        args=sgqlc.types.ArgDict((("locale", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="locale", default=None)),)),
    )
    shop_locale_enable = sgqlc.types.Field(
        "ShopLocaleEnablePayload",
        graphql_name="shopLocaleEnable",
        args=sgqlc.types.ArgDict(
            (
                ("locale", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="locale", default=None)),
                (
                    "market_web_presence_ids",
                    sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="marketWebPresenceIds", default=None),
                ),
            )
        ),
    )
    shop_locale_update = sgqlc.types.Field(
        "ShopLocaleUpdatePayload",
        graphql_name="shopLocaleUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("locale", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="locale", default=None)),
                ("shop_locale", sgqlc.types.Arg(sgqlc.types.non_null(ShopLocaleInput), graphql_name="shopLocale", default=None)),
            )
        ),
    )
    shop_policy_update = sgqlc.types.Field(
        "ShopPolicyUpdatePayload",
        graphql_name="shopPolicyUpdate",
        args=sgqlc.types.ArgDict(
            (("shop_policy", sgqlc.types.Arg(sgqlc.types.non_null(ShopPolicyInput), graphql_name="shopPolicy", default=None)),)
        ),
    )
    shop_resource_feedback_create = sgqlc.types.Field(
        "ShopResourceFeedbackCreatePayload",
        graphql_name="shopResourceFeedbackCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(ResourceFeedbackCreateInput), graphql_name="input", default=None)),)
        ),
    )
    staged_uploads_create = sgqlc.types.Field(
        "StagedUploadsCreatePayload",
        graphql_name="stagedUploadsCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(StagedUploadInput))),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    standard_metafield_definition_enable = sgqlc.types.Field(
        "StandardMetafieldDefinitionEnablePayload",
        graphql_name="standardMetafieldDefinitionEnable",
        args=sgqlc.types.ArgDict(
            (
                ("owner_type", sgqlc.types.Arg(sgqlc.types.non_null(MetafieldOwnerType), graphql_name="ownerType", default=None)),
                ("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),
                ("namespace", sgqlc.types.Arg(String, graphql_name="namespace", default=None)),
                ("key", sgqlc.types.Arg(String, graphql_name="key", default=None)),
                ("pin", sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name="pin", default=False)),
                ("visible_to_storefront_api", sgqlc.types.Arg(Boolean, graphql_name="visibleToStorefrontApi", default=None)),
                ("use_as_collection_condition", sgqlc.types.Arg(Boolean, graphql_name="useAsCollectionCondition", default=False)),
            )
        ),
    )
    standard_metaobject_definition_enable = sgqlc.types.Field(
        "StandardMetaobjectDefinitionEnablePayload",
        graphql_name="standardMetaobjectDefinitionEnable",
        args=sgqlc.types.ArgDict((("type", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="type", default=None)),)),
    )
    storefront_access_token_create = sgqlc.types.Field(
        "StorefrontAccessTokenCreatePayload",
        graphql_name="storefrontAccessTokenCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(StorefrontAccessTokenInput), graphql_name="input", default=None)),)
        ),
    )
    storefront_access_token_delete = sgqlc.types.Field(
        "StorefrontAccessTokenDeletePayload",
        graphql_name="storefrontAccessTokenDelete",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(StorefrontAccessTokenDeleteInput), graphql_name="input", default=None)),)
        ),
    )
    subscription_billing_attempt_create = sgqlc.types.Field(
        "SubscriptionBillingAttemptCreatePayload",
        graphql_name="subscriptionBillingAttemptCreate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "subscription_contract_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="subscriptionContractId", default=None),
                ),
                (
                    "subscription_billing_attempt_input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SubscriptionBillingAttemptInput), graphql_name="subscriptionBillingAttemptInput", default=None
                    ),
                ),
            )
        ),
    )
    subscription_billing_cycle_contract_draft_commit = sgqlc.types.Field(
        "SubscriptionBillingCycleContractDraftCommitPayload",
        graphql_name="subscriptionBillingCycleContractDraftCommit",
        args=sgqlc.types.ArgDict((("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),)),
    )
    subscription_billing_cycle_contract_draft_concatenate = sgqlc.types.Field(
        "SubscriptionBillingCycleContractDraftConcatenatePayload",
        graphql_name="subscriptionBillingCycleContractDraftConcatenate",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                (
                    "concatenated_billing_cycle_contracts",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionBillingCycleInput))),
                        graphql_name="concatenatedBillingCycleContracts",
                        default=None,
                    ),
                ),
            )
        ),
    )
    subscription_billing_cycle_contract_edit = sgqlc.types.Field(
        "SubscriptionBillingCycleContractEditPayload",
        graphql_name="subscriptionBillingCycleContractEdit",
        args=sgqlc.types.ArgDict(
            (
                (
                    "billing_cycle_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionBillingCycleInput), graphql_name="billingCycleInput", default=None),
                ),
            )
        ),
    )
    subscription_billing_cycle_edit_delete = sgqlc.types.Field(
        "SubscriptionBillingCycleEditDeletePayload",
        graphql_name="subscriptionBillingCycleEditDelete",
        args=sgqlc.types.ArgDict(
            (
                (
                    "billing_cycle_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionBillingCycleInput), graphql_name="billingCycleInput", default=None),
                ),
            )
        ),
    )
    subscription_billing_cycle_edits_delete = sgqlc.types.Field(
        "SubscriptionBillingCycleEditsDeletePayload",
        graphql_name="subscriptionBillingCycleEditsDelete",
        args=sgqlc.types.ArgDict(
            (
                ("contract_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="contractId", default=None)),
                (
                    "target_selection",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SubscriptionBillingCyclesTargetSelection), graphql_name="targetSelection", default=None
                    ),
                ),
            )
        ),
    )
    subscription_billing_cycle_schedule_edit = sgqlc.types.Field(
        "SubscriptionBillingCycleScheduleEditPayload",
        graphql_name="subscriptionBillingCycleScheduleEdit",
        args=sgqlc.types.ArgDict(
            (
                (
                    "billing_cycle_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionBillingCycleInput), graphql_name="billingCycleInput", default=None),
                ),
                (
                    "input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionBillingCycleScheduleEditInput), graphql_name="input", default=None),
                ),
            )
        ),
    )
    subscription_contract_atomic_create = sgqlc.types.Field(
        "SubscriptionContractAtomicCreatePayload",
        graphql_name="subscriptionContractAtomicCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionContractAtomicCreateInput), graphql_name="input", default=None)),)
        ),
    )
    subscription_contract_create = sgqlc.types.Field(
        "SubscriptionContractCreatePayload",
        graphql_name="subscriptionContractCreate",
        args=sgqlc.types.ArgDict(
            (("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionContractCreateInput), graphql_name="input", default=None)),)
        ),
    )
    subscription_contract_product_change = sgqlc.types.Field(
        "SubscriptionContractProductChangePayload",
        graphql_name="subscriptionContractProductChange",
        args=sgqlc.types.ArgDict(
            (
                (
                    "subscription_contract_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="subscriptionContractId", default=None),
                ),
                ("line_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="lineId", default=None)),
                (
                    "input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionContractProductChangeInput), graphql_name="input", default=None),
                ),
            )
        ),
    )
    subscription_contract_set_next_billing_date = sgqlc.types.Field(
        "SubscriptionContractSetNextBillingDatePayload",
        graphql_name="subscriptionContractSetNextBillingDate",
        args=sgqlc.types.ArgDict(
            (
                ("contract_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="contractId", default=None)),
                ("date", sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name="date", default=None)),
            )
        ),
    )
    subscription_contract_update = sgqlc.types.Field(
        "SubscriptionContractUpdatePayload",
        graphql_name="subscriptionContractUpdate",
        args=sgqlc.types.ArgDict((("contract_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="contractId", default=None)),)),
    )
    subscription_draft_commit = sgqlc.types.Field(
        "SubscriptionDraftCommitPayload",
        graphql_name="subscriptionDraftCommit",
        args=sgqlc.types.ArgDict((("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),)),
    )
    subscription_draft_discount_add = sgqlc.types.Field(
        "SubscriptionDraftDiscountAddPayload",
        graphql_name="subscriptionDraftDiscountAdd",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionManualDiscountInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_discount_code_apply = sgqlc.types.Field(
        "SubscriptionDraftDiscountCodeApplyPayload",
        graphql_name="subscriptionDraftDiscountCodeApply",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("redeem_code", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="redeemCode", default=None)),
            )
        ),
    )
    subscription_draft_discount_remove = sgqlc.types.Field(
        "SubscriptionDraftDiscountRemovePayload",
        graphql_name="subscriptionDraftDiscountRemove",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("discount_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountId", default=None)),
            )
        ),
    )
    subscription_draft_discount_update = sgqlc.types.Field(
        "SubscriptionDraftDiscountUpdatePayload",
        graphql_name="subscriptionDraftDiscountUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("discount_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionManualDiscountInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_free_shipping_discount_add = sgqlc.types.Field(
        "SubscriptionDraftFreeShippingDiscountAddPayload",
        graphql_name="subscriptionDraftFreeShippingDiscountAdd",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionFreeShippingDiscountInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_free_shipping_discount_update = sgqlc.types.Field(
        "SubscriptionDraftFreeShippingDiscountUpdatePayload",
        graphql_name="subscriptionDraftFreeShippingDiscountUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("discount_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="discountId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionFreeShippingDiscountInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_line_add = sgqlc.types.Field(
        "SubscriptionDraftLineAddPayload",
        graphql_name="subscriptionDraftLineAdd",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionLineInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_line_remove = sgqlc.types.Field(
        "SubscriptionDraftLineRemovePayload",
        graphql_name="subscriptionDraftLineRemove",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("line_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="lineId", default=None)),
            )
        ),
    )
    subscription_draft_line_update = sgqlc.types.Field(
        "SubscriptionDraftLineUpdatePayload",
        graphql_name="subscriptionDraftLineUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("line_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="lineId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionLineUpdateInput), graphql_name="input", default=None)),
            )
        ),
    )
    subscription_draft_update = sgqlc.types.Field(
        "SubscriptionDraftUpdatePayload",
        graphql_name="subscriptionDraftUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("draft_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="draftId", default=None)),
                ("input", sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionDraftInput), graphql_name="input", default=None)),
            )
        ),
    )
    tags_add = sgqlc.types.Field(
        "TagsAddPayload",
        graphql_name="tagsAdd",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags", default=None
                    ),
                ),
            )
        ),
    )
    tags_remove = sgqlc.types.Field(
        "TagsRemovePayload",
        graphql_name="tagsRemove",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="tags", default=None
                    ),
                ),
            )
        ),
    )
    tax_app_configure = sgqlc.types.Field(
        "TaxAppConfigurePayload",
        graphql_name="taxAppConfigure",
        args=sgqlc.types.ArgDict((("ready", sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name="ready", default=None)),)),
    )
    translations_register = sgqlc.types.Field(
        "TranslationsRegisterPayload",
        graphql_name="translationsRegister",
        args=sgqlc.types.ArgDict(
            (
                ("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),
                (
                    "translations",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(TranslationInput))),
                        graphql_name="translations",
                        default=None,
                    ),
                ),
            )
        ),
    )
    translations_remove = sgqlc.types.Field(
        "TranslationsRemovePayload",
        graphql_name="translationsRemove",
        args=sgqlc.types.ArgDict(
            (
                ("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),
                (
                    "translation_keys",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
                        graphql_name="translationKeys",
                        default=None,
                    ),
                ),
                (
                    "locales",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="locales", default=None
                    ),
                ),
                ("market_ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="marketIds", default=None)),
            )
        ),
    )
    url_redirect_bulk_delete_all = sgqlc.types.Field("UrlRedirectBulkDeleteAllPayload", graphql_name="urlRedirectBulkDeleteAll")
    url_redirect_bulk_delete_by_ids = sgqlc.types.Field(
        "UrlRedirectBulkDeleteByIdsPayload",
        graphql_name="urlRedirectBulkDeleteByIds",
        args=sgqlc.types.ArgDict(
            (
                (
                    "ids",
                    sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="ids", default=None),
                ),
            )
        ),
    )
    url_redirect_bulk_delete_by_saved_search = sgqlc.types.Field(
        "UrlRedirectBulkDeleteBySavedSearchPayload",
        graphql_name="urlRedirectBulkDeleteBySavedSearch",
        args=sgqlc.types.ArgDict(
            (("saved_search_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="savedSearchId", default=None)),)
        ),
    )
    url_redirect_bulk_delete_by_search = sgqlc.types.Field(
        "UrlRedirectBulkDeleteBySearchPayload",
        graphql_name="urlRedirectBulkDeleteBySearch",
        args=sgqlc.types.ArgDict((("search", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="search", default=None)),)),
    )
    url_redirect_create = sgqlc.types.Field(
        "UrlRedirectCreatePayload",
        graphql_name="urlRedirectCreate",
        args=sgqlc.types.ArgDict(
            (("url_redirect", sgqlc.types.Arg(sgqlc.types.non_null(UrlRedirectInput), graphql_name="urlRedirect", default=None)),)
        ),
    )
    url_redirect_delete = sgqlc.types.Field(
        "UrlRedirectDeletePayload",
        graphql_name="urlRedirectDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    url_redirect_import_create = sgqlc.types.Field(
        "UrlRedirectImportCreatePayload",
        graphql_name="urlRedirectImportCreate",
        args=sgqlc.types.ArgDict((("url", sgqlc.types.Arg(sgqlc.types.non_null(URL), graphql_name="url", default=None)),)),
    )
    url_redirect_import_submit = sgqlc.types.Field(
        "UrlRedirectImportSubmitPayload",
        graphql_name="urlRedirectImportSubmit",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    url_redirect_update = sgqlc.types.Field(
        "UrlRedirectUpdatePayload",
        graphql_name="urlRedirectUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("url_redirect", sgqlc.types.Arg(sgqlc.types.non_null(UrlRedirectInput), graphql_name="urlRedirect", default=None)),
            )
        ),
    )
    web_pixel_create = sgqlc.types.Field(
        "WebPixelCreatePayload",
        graphql_name="webPixelCreate",
        args=sgqlc.types.ArgDict(
            (("web_pixel", sgqlc.types.Arg(sgqlc.types.non_null(WebPixelInput), graphql_name="webPixel", default=None)),)
        ),
    )
    web_pixel_delete = sgqlc.types.Field(
        "WebPixelDeletePayload",
        graphql_name="webPixelDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    web_pixel_update = sgqlc.types.Field(
        "WebPixelUpdatePayload",
        graphql_name="webPixelUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("web_pixel", sgqlc.types.Arg(sgqlc.types.non_null(WebPixelInput), graphql_name="webPixel", default=None)),
            )
        ),
    )
    webhook_subscription_create = sgqlc.types.Field(
        "WebhookSubscriptionCreatePayload",
        graphql_name="webhookSubscriptionCreate",
        args=sgqlc.types.ArgDict(
            (
                ("topic", sgqlc.types.Arg(sgqlc.types.non_null(WebhookSubscriptionTopic), graphql_name="topic", default=None)),
                (
                    "webhook_subscription",
                    sgqlc.types.Arg(sgqlc.types.non_null(WebhookSubscriptionInput), graphql_name="webhookSubscription", default=None),
                ),
            )
        ),
    )
    webhook_subscription_delete = sgqlc.types.Field(
        "WebhookSubscriptionDeletePayload",
        graphql_name="webhookSubscriptionDelete",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    webhook_subscription_update = sgqlc.types.Field(
        "WebhookSubscriptionUpdatePayload",
        graphql_name="webhookSubscriptionUpdate",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                (
                    "webhook_subscription",
                    sgqlc.types.Arg(sgqlc.types.non_null(WebhookSubscriptionInput), graphql_name="webhookSubscription", default=None),
                ),
            )
        ),
    )


class MutationsStagedUploadTargetGenerateUploadParameter(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class NavigationItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("id", "title", "url")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class OrderApp(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("icon", "id", "name")
    icon = sgqlc.types.Field(sgqlc.types.non_null("Image"), graphql_name="icon")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class OrderCapturePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("transaction", "user_errors")
    transaction = sgqlc.types.Field("OrderTransaction", graphql_name="transaction")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderClosePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Order"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class OrderCreateMandatePaymentPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "payment_reference_id", "user_errors")
    job = sgqlc.types.Field(Job, graphql_name="job")
    payment_reference_id = sgqlc.types.Field(String, graphql_name="paymentReferenceId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderCreateMandatePaymentUserError"))), graphql_name="userErrors"
    )


class OrderEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Order"), graphql_name="node")


class OrderEditAddCustomItemPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_line_item", "calculated_order", "user_errors")
    calculated_line_item = sgqlc.types.Field(CalculatedLineItem, graphql_name="calculatedLineItem")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditAddLineItemDiscountPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("added_discount_staged_change", "calculated_line_item", "calculated_order", "user_errors")
    added_discount_staged_change = sgqlc.types.Field("OrderStagedChangeAddLineItemDiscount", graphql_name="addedDiscountStagedChange")
    calculated_line_item = sgqlc.types.Field(CalculatedLineItem, graphql_name="calculatedLineItem")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditAddVariantPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_line_item", "calculated_order", "user_errors")
    calculated_line_item = sgqlc.types.Field(CalculatedLineItem, graphql_name="calculatedLineItem")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditBeginPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_order", "user_errors")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditCommitPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditRemoveLineItemDiscountPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_line_item", "calculated_order", "user_errors")
    calculated_line_item = sgqlc.types.Field(CalculatedLineItem, graphql_name="calculatedLineItem")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderEditSetQuantityPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("calculated_line_item", "calculated_order", "user_errors")
    calculated_line_item = sgqlc.types.Field(CalculatedLineItem, graphql_name="calculatedLineItem")
    calculated_order = sgqlc.types.Field("CalculatedOrder", graphql_name="calculatedOrder")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderInvoiceSendPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderInvoiceSendUserError"))), graphql_name="userErrors"
    )


class OrderMarkAsPaidPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderOpenPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class OrderPaymentCollectionDetails(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("additional_payment_collection_url", "vaulted_payment_methods")
    additional_payment_collection_url = sgqlc.types.Field(URL, graphql_name="additionalPaymentCollectionUrl")
    vaulted_payment_methods = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("PaymentMandate")), graphql_name="vaultedPaymentMethods"
    )


class OrderPaymentStatus(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("error_message", "payment_reference_id", "status", "translated_error_message")
    error_message = sgqlc.types.Field(String, graphql_name="errorMessage")
    payment_reference_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="paymentReferenceId")
    status = sgqlc.types.Field(sgqlc.types.non_null(OrderPaymentStatusResult), graphql_name="status")
    translated_error_message = sgqlc.types.Field(String, graphql_name="translatedErrorMessage")


class OrderRisk(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("display", "level", "message")
    display = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="display")
    level = sgqlc.types.Field(OrderRiskLevel, graphql_name="level")
    message = sgqlc.types.Field(String, graphql_name="message")


class OrderStagedChangeAddCustomItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("original_unit_price", "quantity", "title")
    original_unit_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="originalUnitPrice")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class OrderStagedChangeAddLineItemDiscount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "id", "value")
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    value = sgqlc.types.Field(sgqlc.types.non_null("PricingValue"), graphql_name="value")


class OrderStagedChangeAddShippingLine(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("phone", "presentment_title", "price", "title")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    presentment_title = sgqlc.types.Field(String, graphql_name="presentmentTitle")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="price")
    title = sgqlc.types.Field(String, graphql_name="title")


class OrderStagedChangeAddVariant(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("quantity", "variant")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    variant = sgqlc.types.Field(sgqlc.types.non_null("ProductVariant"), graphql_name="variant")


class OrderStagedChangeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderStagedChangeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderStagedChange"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class OrderStagedChangeDecrementItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delta", "line_item", "restock")
    delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="delta")
    line_item = sgqlc.types.Field(sgqlc.types.non_null("LineItem"), graphql_name="lineItem")
    restock = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restock")


class OrderStagedChangeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("OrderStagedChange"), graphql_name="node")


class OrderStagedChangeIncrementItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delta", "line_item")
    delta = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="delta")
    line_item = sgqlc.types.Field(sgqlc.types.non_null("LineItem"), graphql_name="lineItem")


class OrderTransactionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderTransactionEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("OrderTransaction"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")


class OrderTransactionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("OrderTransaction"), graphql_name="node")


class OrderUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PageInfo(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("end_cursor", "has_next_page", "has_previous_page", "start_cursor")
    end_cursor = sgqlc.types.Field(String, graphql_name="endCursor")
    has_next_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasNextPage")
    has_previous_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasPreviousPage")
    start_cursor = sgqlc.types.Field(String, graphql_name="startCursor")


class ParseError(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "message", "range")
    code = sgqlc.types.Field(sgqlc.types.non_null(ParseErrorCode), graphql_name="code")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")
    range = sgqlc.types.Field("ParseErrorRange", graphql_name="range")


class ParseErrorRange(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("end", "start")
    end = sgqlc.types.Field(sgqlc.types.non_null(ErrorPosition), graphql_name="end")
    start = sgqlc.types.Field(sgqlc.types.non_null(ErrorPosition), graphql_name="start")


class PaymentCustomizationActivationPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("ids", "user_errors")
    ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="ids")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomizationError"))), graphql_name="userErrors"
    )


class PaymentCustomizationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomizationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomization"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PaymentCustomizationCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("payment_customization", "user_errors")
    payment_customization = sgqlc.types.Field("PaymentCustomization", graphql_name="paymentCustomization")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomizationError"))), graphql_name="userErrors"
    )


class PaymentCustomizationDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomizationError"))), graphql_name="userErrors"
    )


class PaymentCustomizationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PaymentCustomization"), graphql_name="node")


class PaymentCustomizationUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("payment_customization", "user_errors")
    payment_customization = sgqlc.types.Field("PaymentCustomization", graphql_name="paymentCustomization")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentCustomizationError"))), graphql_name="userErrors"
    )


class PaymentReminderSendPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("success", "user_errors")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentReminderSendUserError"))), graphql_name="userErrors"
    )


class PaymentScheduleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentScheduleEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentSchedule"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PaymentScheduleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PaymentSchedule"), graphql_name="node")


class PaymentSettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("supported_digital_wallets",)
    supported_digital_wallets = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DigitalWallet))), graphql_name="supportedDigitalWallets"
    )


class PaymentTermsCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms", "user_errors")
    payment_terms = sgqlc.types.Field("PaymentTerms", graphql_name="paymentTerms")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentTermsCreateUserError"))), graphql_name="userErrors"
    )


class PaymentTermsDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentTermsDeleteUserError"))), graphql_name="userErrors"
    )


class PaymentTermsUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("payment_terms", "user_errors")
    payment_terms = sgqlc.types.Field("PaymentTerms", graphql_name="paymentTerms")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentTermsUpdateUserError"))), graphql_name="userErrors"
    )


class PolarisVizDataPoint(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(String, graphql_name="value")


class PolarisVizDataSeries(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("data", "is_comparison", "name")
    data = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PolarisVizDataPoint))), graphql_name="data")
    is_comparison = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isComparison")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class PriceListAdjustment(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("type", "value")
    type = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustmentType), graphql_name="type")
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")


class PriceListAdjustmentSettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("compare_at_mode",)
    compare_at_mode = sgqlc.types.Field(sgqlc.types.non_null(PriceListCompareAtMode), graphql_name="compareAtMode")


class PriceListConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceList"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PriceListCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_list", "user_errors")
    price_list = sgqlc.types.Field("PriceList", graphql_name="priceList")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListUserError"))), graphql_name="userErrors"
    )


class PriceListDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListUserError"))), graphql_name="userErrors"
    )


class PriceListEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PriceList"), graphql_name="node")


class PriceListFixedPricesAddPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("prices", "user_errors")
    prices = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPrice")), graphql_name="prices")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPriceUserError"))), graphql_name="userErrors"
    )


class PriceListFixedPricesByProductUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_list", "prices_to_add_products", "prices_to_delete_products", "user_errors")
    price_list = sgqlc.types.Field("PriceList", graphql_name="priceList")
    prices_to_add_products = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("Product")), graphql_name="pricesToAddProducts")
    prices_to_delete_products = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("Product")), graphql_name="pricesToDeleteProducts"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListFixedPricesByProductBulkUpdateUserError"))),
        graphql_name="userErrors",
    )


class PriceListFixedPricesDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_fixed_price_variant_ids", "user_errors")
    deleted_fixed_price_variant_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedFixedPriceVariantIds"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPriceUserError"))), graphql_name="userErrors"
    )


class PriceListFixedPricesUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_fixed_price_variant_ids", "price_list", "prices_added", "user_errors")
    deleted_fixed_price_variant_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedFixedPriceVariantIds"
    )
    price_list = sgqlc.types.Field("PriceList", graphql_name="priceList")
    prices_added = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPrice")), graphql_name="pricesAdded")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPriceUserError"))), graphql_name="userErrors"
    )


class PriceListParent(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("adjustment", "settings")
    adjustment = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustment), graphql_name="adjustment")
    settings = sgqlc.types.Field(sgqlc.types.non_null(PriceListAdjustmentSettings), graphql_name="settings")


class PriceListPrice(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("compare_at_price", "origin_type", "price", "variant")
    compare_at_price = sgqlc.types.Field(MoneyV2, graphql_name="compareAtPrice")
    origin_type = sgqlc.types.Field(sgqlc.types.non_null(PriceListPriceOriginType), graphql_name="originType")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="price")
    variant = sgqlc.types.Field(sgqlc.types.non_null("ProductVariant"), graphql_name="variant")


class PriceListPriceConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListPriceEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PriceListPrice))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PriceListPriceEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(PriceListPrice), graphql_name="node")


class PriceListUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_list", "user_errors")
    price_list = sgqlc.types.Field("PriceList", graphql_name="priceList")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceListUserError"))), graphql_name="userErrors"
    )


class PriceRuleActivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRule"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PriceRuleCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_discount_code", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_discount_code = sgqlc.types.Field("PriceRuleDiscountCode", graphql_name="priceRuleDiscountCode")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleCustomerSelection(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("customers", "for_all_customers", "segments")
    customers = sgqlc.types.Field(
        sgqlc.types.non_null(CustomerConnection),
        graphql_name="customers",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CustomerSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    for_all_customers = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="forAllCustomers")
    segments = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Segment"))), graphql_name="segments")


class PriceRuleDeactivatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_price_rule_id", "price_rule_user_errors", "shop")
    deleted_price_rule_id = sgqlc.types.Field(ID, graphql_name="deletedPriceRuleId")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")


class PriceRuleDiscountCodeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleDiscountCodeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleDiscountCode"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PriceRuleDiscountCodeCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_discount_code", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_discount_code = sgqlc.types.Field("PriceRuleDiscountCode", graphql_name="priceRuleDiscountCode")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleDiscountCodeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PriceRuleDiscountCode"), graphql_name="node")


class PriceRuleDiscountCodeUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_discount_code", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_discount_code = sgqlc.types.Field("PriceRuleDiscountCode", graphql_name="priceRuleDiscountCode")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PriceRule"), graphql_name="node")


class PriceRuleEntitlementToPrerequisiteQuantityRatio(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("entitlement_quantity", "prerequisite_quantity")
    entitlement_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="entitlementQuantity")
    prerequisite_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="prerequisiteQuantity")


class PriceRuleFixedAmountValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount",)
    amount = sgqlc.types.Field(sgqlc.types.non_null(Money), graphql_name="amount")


class PriceRuleItemEntitlements(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collections", "product_variants", "products", "target_all_line_items")
    collections = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionConnection),
        graphql_name="collections",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    product_variants = sgqlc.types.Field(
        sgqlc.types.non_null("ProductVariantConnection"),
        graphql_name="productVariants",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    products = sgqlc.types.Field(
        sgqlc.types.non_null("ProductConnection"),
        graphql_name="products",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    target_all_line_items = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="targetAllLineItems")


class PriceRuleLineItemPrerequisites(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("collections", "product_variants", "products")
    collections = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionConnection),
        graphql_name="collections",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    product_variants = sgqlc.types.Field(
        sgqlc.types.non_null("ProductVariantConnection"),
        graphql_name="productVariants",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    products = sgqlc.types.Field(
        sgqlc.types.non_null("ProductConnection"),
        graphql_name="products",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )


class PriceRuleMoneyRange(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than", "greater_than_or_equal_to", "less_than", "less_than_or_equal_to")
    greater_than = sgqlc.types.Field(Money, graphql_name="greaterThan")
    greater_than_or_equal_to = sgqlc.types.Field(Money, graphql_name="greaterThanOrEqualTo")
    less_than = sgqlc.types.Field(Money, graphql_name="lessThan")
    less_than_or_equal_to = sgqlc.types.Field(Money, graphql_name="lessThanOrEqualTo")


class PriceRulePercentValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class PriceRulePrerequisiteToEntitlementQuantityRatio(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("entitlement_quantity", "prerequisite_quantity")
    entitlement_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="entitlementQuantity")
    prerequisite_quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="prerequisiteQuantity")


class PriceRuleQuantityRange(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("greater_than", "greater_than_or_equal_to", "less_than", "less_than_or_equal_to")
    greater_than = sgqlc.types.Field(Int, graphql_name="greaterThan")
    greater_than_or_equal_to = sgqlc.types.Field(Int, graphql_name="greaterThanOrEqualTo")
    less_than = sgqlc.types.Field(Int, graphql_name="lessThan")
    less_than_or_equal_to = sgqlc.types.Field(Int, graphql_name="lessThanOrEqualTo")


class PriceRuleShareableUrl(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("target_item_image", "target_type", "title", "url")
    target_item_image = sgqlc.types.Field("Image", graphql_name="targetItemImage")
    target_type = sgqlc.types.Field(sgqlc.types.non_null(PriceRuleShareableUrlTargetType), graphql_name="targetType")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class PriceRuleShippingLineEntitlements(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("country_codes", "include_rest_of_world", "target_all_shipping_lines")
    country_codes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CountryCode))), graphql_name="countryCodes"
    )
    include_rest_of_world = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="includeRestOfWorld")
    target_all_shipping_lines = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="targetAllShippingLines")


class PriceRuleUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("price_rule", "price_rule_discount_code", "price_rule_user_errors")
    price_rule = sgqlc.types.Field("PriceRule", graphql_name="priceRule")
    price_rule_discount_code = sgqlc.types.Field("PriceRuleDiscountCode", graphql_name="priceRuleDiscountCode")
    price_rule_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PriceRuleUserError"))), graphql_name="priceRuleUserErrors"
    )


class PriceRuleValidityPeriod(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("end", "start")
    end = sgqlc.types.Field(DateTime, graphql_name="end")
    start = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="start")


class PricingPercentageValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class PrivateMetafieldConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PrivateMetafieldEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PrivateMetafield"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PrivateMetafieldDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_private_metafield_id", "user_errors")
    deleted_private_metafield_id = sgqlc.types.Field(ID, graphql_name="deletedPrivateMetafieldId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PrivateMetafieldEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("PrivateMetafield"), graphql_name="node")


class PrivateMetafieldUpsertPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("private_metafield", "user_errors")
    private_metafield = sgqlc.types.Field("PrivateMetafield", graphql_name="privateMetafield")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductAppendImagesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("new_images", "product", "user_errors")
    new_images = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("Image")), graphql_name="newImages")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductCategory(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_taxonomy_node",)
    product_taxonomy_node = sgqlc.types.Field("ProductTaxonomyNode", graphql_name="productTaxonomyNode")


class ProductChangeStatusPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductChangeStatusUserError"))), graphql_name="userErrors"
    )


class ProductConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Product"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductContextualPricing(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fixed_quantity_rules_count", "max_variant_pricing", "min_variant_pricing", "price_range")
    fixed_quantity_rules_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="fixedQuantityRulesCount")
    max_variant_pricing = sgqlc.types.Field("ProductVariantContextualPricing", graphql_name="maxVariantPricing")
    min_variant_pricing = sgqlc.types.Field("ProductVariantContextualPricing", graphql_name="minVariantPricing")
    price_range = sgqlc.types.Field(sgqlc.types.non_null("ProductPriceRangeV2"), graphql_name="priceRange")


class ProductCreateMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("media", "media_user_errors", "product")
    media = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Media)), graphql_name="media")
    media_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="mediaUserErrors"
    )
    product = sgqlc.types.Field("Product", graphql_name="product")


class ProductCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "shop", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductDeleteAsyncPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("delete_product_id", "job", "user_errors")
    delete_product_id = sgqlc.types.Field(ID, graphql_name="deleteProductId")
    job = sgqlc.types.Field(Job, graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductDeleteUserError"))), graphql_name="userErrors"
    )


class ProductDeleteImagesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_image_ids", "product", "user_errors")
    deleted_image_ids = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="deletedImageIds"
    )
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductDeleteMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_media_ids", "deleted_product_image_ids", "media_user_errors", "product")
    deleted_media_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedMediaIds")
    deleted_product_image_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedProductImageIds")
    media_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="mediaUserErrors"
    )
    product = sgqlc.types.Field("Product", graphql_name="product")


class ProductDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_product_id", "shop", "user_errors")
    deleted_product_id = sgqlc.types.Field(ID, graphql_name="deletedProductId")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductDuplicateAsyncPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("duplicated_product_id", "job", "user_errors")
    duplicated_product_id = sgqlc.types.Field(ID, graphql_name="duplicatedProductId")
    job = sgqlc.types.Field(Job, graphql_name="job")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductDuplicateUserError"))), graphql_name="userErrors"
    )


class ProductDuplicateAsyncV2Payload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("duplicated_product_id", "product_duplicate_job_id", "user_errors")
    duplicated_product_id = sgqlc.types.Field(ID, graphql_name="duplicatedProductId")
    product_duplicate_job_id = sgqlc.types.Field(ID, graphql_name="productDuplicateJobId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductDuplicateUserError"))), graphql_name="userErrors"
    )


class ProductDuplicateJob(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("done", "id")
    done = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="done")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")


class ProductDuplicatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("image_job", "new_product", "shop", "user_errors")
    image_job = sgqlc.types.Field(Job, graphql_name="imageJob")
    new_product = sgqlc.types.Field("Product", graphql_name="newProduct")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Product"), graphql_name="node")


class ProductFeedConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductFeedEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductFeed"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductFeedCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_feed", "user_errors")
    product_feed = sgqlc.types.Field("ProductFeed", graphql_name="productFeed")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductFeedCreateUserError"))), graphql_name="userErrors"
    )


class ProductFeedDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductFeedDeleteUserError"))), graphql_name="userErrors"
    )


class ProductFeedEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ProductFeed"), graphql_name="node")


class ProductFullSyncPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductFullSyncUserError"))), graphql_name="userErrors"
    )


class ProductImageUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("image", "user_errors")
    image = sgqlc.types.Field("Image", graphql_name="image")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductJoinSellingPlanGroupsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class ProductLeaveSellingPlanGroupsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class ProductPriceRange(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("max_variant_price", "min_variant_price")
    max_variant_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="maxVariantPrice")
    min_variant_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="minVariantPrice")


class ProductPriceRangeV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("max_variant_price", "min_variant_price")
    max_variant_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="maxVariantPrice")
    min_variant_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="minVariantPrice")


class ProductPublication(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("channel", "is_published", "product", "publish_date")
    channel = sgqlc.types.Field(sgqlc.types.non_null("Channel"), graphql_name="channel")
    is_published = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPublished")
    product = sgqlc.types.Field(sgqlc.types.non_null("Product"), graphql_name="product")
    publish_date = sgqlc.types.Field(DateTime, graphql_name="publishDate")


class ProductPublicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductPublicationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductPublication))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductPublicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ProductPublication), graphql_name="node")


class ProductPublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "shop", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductReorderImagesPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "user_errors")
    job = sgqlc.types.Field(Job, graphql_name="job")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductReorderMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("job", "media_user_errors")
    job = sgqlc.types.Field(Job, graphql_name="job")
    media_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="mediaUserErrors"
    )


class ProductResourceFeedback(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("feedback_generated_at", "messages", "product_id", "product_updated_at", "state")
    feedback_generated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="feedbackGeneratedAt")
    messages = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name="messages")
    product_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="productId")
    product_updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="productUpdatedAt")
    state = sgqlc.types.Field(sgqlc.types.non_null(ResourceFeedbackState), graphql_name="state")


class ProductUnpublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "shop", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductUpdateMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("media", "media_user_errors", "product")
    media = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Media)), graphql_name="media")
    media_user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="mediaUserErrors"
    )
    product = sgqlc.types.Field("Product", graphql_name="product")


class ProductUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductVariantAppendMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variants", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variants = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant")), graphql_name="productVariants")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="userErrors"
    )


class ProductVariantComponentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantComponentEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantComponent"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductVariantComponentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ProductVariantComponent"), graphql_name="node")


class ProductVariantConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductVariantContextualPricing(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("compare_at_price", "price", "quantity_rule")
    compare_at_price = sgqlc.types.Field(MoneyV2, graphql_name="compareAtPrice")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="price")
    quantity_rule = sgqlc.types.Field(sgqlc.types.non_null("QuantityRule"), graphql_name="quantityRule")


class ProductVariantCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variant", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variant = sgqlc.types.Field("ProductVariant", graphql_name="productVariant")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductVariantDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_product_variant_id", "product", "user_errors")
    deleted_product_variant_id = sgqlc.types.Field(ID, graphql_name="deletedProductVariantId")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductVariantDetachMediaPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variants", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variants = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant")), graphql_name="productVariants")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MediaUserError"))), graphql_name="userErrors"
    )


class ProductVariantEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ProductVariant"), graphql_name="node")


class ProductVariantJoinSellingPlanGroupsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_variant", "user_errors")
    product_variant = sgqlc.types.Field("ProductVariant", graphql_name="productVariant")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class ProductVariantLeaveSellingPlanGroupsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_variant", "user_errors")
    product_variant = sgqlc.types.Field("ProductVariant", graphql_name="productVariant")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class ProductVariantPricePair(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("compare_at_price", "price")
    compare_at_price = sgqlc.types.Field(MoneyV2, graphql_name="compareAtPrice")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="price")


class ProductVariantPricePairConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantPricePairEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ProductVariantPricePair))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ProductVariantPricePairEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ProductVariantPricePair), graphql_name="node")


class ProductVariantRelationshipBulkUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("parent_product_variants", "user_errors")
    parent_product_variants = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant")), graphql_name="parentProductVariants"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantRelationshipBulkUpdateUserError"))),
        graphql_name="userErrors",
    )


class ProductVariantUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variant", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variant = sgqlc.types.Field("ProductVariant", graphql_name="productVariant")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ProductVariantsBulkCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variants", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variants = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant")), graphql_name="productVariants")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantsBulkCreateUserError"))), graphql_name="userErrors"
    )


class ProductVariantsBulkDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantsBulkDeleteUserError"))), graphql_name="userErrors"
    )


class ProductVariantsBulkReorderPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantsBulkReorderUserError"))), graphql_name="userErrors"
    )


class ProductVariantsBulkUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product", "product_variants", "user_errors")
    product = sgqlc.types.Field("Product", graphql_name="product")
    product_variants = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariant")), graphql_name="productVariants")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ProductVariantsBulkUpdateUserError"))), graphql_name="userErrors"
    )


class PubSubServerPixelUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("server_pixel", "user_errors")
    server_pixel = sgqlc.types.Field("ServerPixel", graphql_name="serverPixel")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ErrorsServerPixelUserError"))), graphql_name="userErrors"
    )


class PubSubWebhookSubscriptionCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors", "webhook_subscription")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PubSubWebhookSubscriptionCreateUserError"))),
        graphql_name="userErrors",
    )
    webhook_subscription = sgqlc.types.Field("WebhookSubscription", graphql_name="webhookSubscription")


class PubSubWebhookSubscriptionUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors", "webhook_subscription")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PubSubWebhookSubscriptionUpdateUserError"))),
        graphql_name="userErrors",
    )
    webhook_subscription = sgqlc.types.Field("WebhookSubscription", graphql_name="webhookSubscription")


class PublicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PublicationEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Publication"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class PublicationCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publication", "user_errors")
    publication = sgqlc.types.Field("Publication", graphql_name="publication")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PublicationUserError"))), graphql_name="userErrors"
    )


class PublicationDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PublicationUserError"))), graphql_name="userErrors"
    )


class PublicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Publication"), graphql_name="node")


class PublicationUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publication", "user_errors")
    publication = sgqlc.types.Field("Publication", graphql_name="publication")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PublicationUserError"))), graphql_name="userErrors"
    )


class PublishablePublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "shop", "user_errors")
    publishable = sgqlc.types.Field(Publishable, graphql_name="publishable")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PublishablePublishToCurrentChannelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "shop", "user_errors")
    publishable = sgqlc.types.Field(Publishable, graphql_name="publishable")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PublishableUnpublishPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "shop", "user_errors")
    publishable = sgqlc.types.Field(Publishable, graphql_name="publishable")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PublishableUnpublishToCurrentChannelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("publishable", "shop", "user_errors")
    publishable = sgqlc.types.Field(Publishable, graphql_name="publishable")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class PurchasingCompany(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("company", "contact", "location")
    company = sgqlc.types.Field(sgqlc.types.non_null("Company"), graphql_name="company")
    contact = sgqlc.types.Field("CompanyContact", graphql_name="contact")
    location = sgqlc.types.Field(sgqlc.types.non_null("CompanyLocation"), graphql_name="location")


class QuantityRule(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("increment", "is_default", "maximum", "minimum", "origin_type", "product_variant")
    increment = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="increment")
    is_default = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isDefault")
    maximum = sgqlc.types.Field(Int, graphql_name="maximum")
    minimum = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="minimum")
    origin_type = sgqlc.types.Field(sgqlc.types.non_null(QuantityRuleOriginType), graphql_name="originType")
    product_variant = sgqlc.types.Field(sgqlc.types.non_null("ProductVariant"), graphql_name="productVariant")


class QuantityRuleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info", "total_count")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("QuantityRuleEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(QuantityRule))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")
    total_count = sgqlc.types.Field(sgqlc.types.non_null(UnsignedInt64), graphql_name="totalCount")


class QuantityRuleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(QuantityRule), graphql_name="node")


class QuantityRulesAddPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("quantity_rules", "user_errors")
    quantity_rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(QuantityRule)), graphql_name="quantityRules")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("QuantityRuleUserError"))), graphql_name="userErrors"
    )


class QuantityRulesDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_quantity_rules_variant_ids", "user_errors")
    deleted_quantity_rules_variant_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedQuantityRulesVariantIds"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("QuantityRuleUserError"))), graphql_name="userErrors"
    )


class QueryRoot(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "abandonment",
        "abandonment_by_abandoned_checkout_id",
        "app",
        "app_by_handle",
        "app_by_key",
        "app_discount_type",
        "app_discount_types",
        "app_installation",
        "app_installations",
        "automatic_discount_node",
        "automatic_discount_nodes",
        "automatic_discount_saved_searches",
        "available_carrier_services",
        "available_locales",
        "carrier_service",
        "cart_transforms",
        "catalog",
        "catalog_operations",
        "catalogs",
        "checkout_profile",
        "checkout_profiles",
        "code_discount_node",
        "code_discount_node_by_code",
        "code_discount_nodes",
        "code_discount_saved_searches",
        "collection",
        "collection_by_handle",
        "collection_rules_conditions",
        "collection_saved_searches",
        "collections",
        "companies",
        "company",
        "company_contact",
        "company_contact_role",
        "company_count",
        "company_location",
        "company_locations",
        "current_app_installation",
        "current_bulk_operation",
        "customer",
        "customer_merge_job_status",
        "customer_merge_preview",
        "customer_payment_method",
        "customer_segment_members",
        "customer_segment_members_query",
        "customer_segment_membership",
        "customers",
        "deletion_events",
        "delivery_customization",
        "delivery_customizations",
        "delivery_profile",
        "delivery_profiles",
        "delivery_settings",
        "discount_code_count",
        "discount_node",
        "discount_nodes",
        "discount_redeem_code_bulk_creation",
        "discount_redeem_code_saved_searches",
        "dispute",
        "dispute_evidence",
        "domain",
        "draft_order",
        "draft_order_saved_searches",
        "draft_order_tag",
        "draft_orders",
        "file_saved_searches",
        "files",
        "fulfillment",
        "fulfillment_order",
        "fulfillment_orders",
        "fulfillment_service",
        "gift_card",
        "gift_cards",
        "gift_cards_count",
        "inventory_item",
        "inventory_items",
        "inventory_level",
        "inventory_properties",
        "job",
        "location",
        "locations",
        "locations_available_for_delivery_profiles_connection",
        "manual_holds_fulfillment_orders",
        "market",
        "market_by_geography",
        "market_localizable_resource",
        "market_localizable_resources",
        "market_localizable_resources_by_ids",
        "marketing_activities",
        "marketing_activity",
        "marketing_event",
        "marketing_events",
        "markets",
        "metafield",
        "metafield_definition",
        "metafield_definition_types",
        "metafield_definitions",
        "metaobject",
        "metaobject_by_handle",
        "metaobject_definition",
        "metaobject_definition_by_type",
        "metaobject_definitions",
        "metaobjects",
        "node",
        "nodes",
        "order",
        "order_payment_status",
        "order_saved_searches",
        "orders",
        "payment_customization",
        "payment_customizations",
        "payment_terms_templates",
        "price_list",
        "price_lists",
        "price_rule_saved_searches",
        "primary_market",
        "product",
        "product_by_handle",
        "product_duplicate_job",
        "product_feed",
        "product_feeds",
        "product_resource_feedback",
        "product_saved_searches",
        "product_variant",
        "product_variants",
        "products",
        "public_api_versions",
        "publication",
        "publications",
        "refund",
        "return_",
        "returnable_fulfillment",
        "returnable_fulfillments",
        "reverse_delivery",
        "reverse_fulfillment_order",
        "script_tag",
        "script_tags",
        "segment",
        "segment_count",
        "segment_filter_suggestions",
        "segment_filters",
        "segment_migrations",
        "segment_value_suggestions",
        "segments",
        "selling_plan_group",
        "selling_plan_groups",
        "server_pixel",
        "shop",
        "shop_billing_preferences",
        "shop_locales",
        "shopify_function",
        "shopify_functions",
        "shopify_payments_account",
        "shopifyql_query",
        "staff_member",
        "standard_metafield_definition_templates",
        "subscription_billing_attempt",
        "subscription_billing_attempts",
        "subscription_billing_cycle",
        "subscription_billing_cycles",
        "subscription_contract",
        "subscription_contracts",
        "subscription_draft",
        "tender_transactions",
        "translatable_resource",
        "translatable_resources",
        "translatable_resources_by_ids",
        "url_redirect",
        "url_redirect_import",
        "url_redirect_saved_searches",
        "url_redirects",
        "web_pixel",
        "webhook_subscription",
        "webhook_subscriptions",
    )
    abandonment = sgqlc.types.Field(
        "Abandonment",
        graphql_name="abandonment",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    abandonment_by_abandoned_checkout_id = sgqlc.types.Field(
        "Abandonment",
        graphql_name="abandonmentByAbandonedCheckoutId",
        args=sgqlc.types.ArgDict(
            (("abandoned_checkout_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="abandonedCheckoutId", default=None)),)
        ),
    )
    app = sgqlc.types.Field(
        "App", graphql_name="app", args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),))
    )
    app_by_handle = sgqlc.types.Field(
        "App",
        graphql_name="appByHandle",
        args=sgqlc.types.ArgDict((("handle", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="handle", default=None)),)),
    )
    app_by_key = sgqlc.types.Field(
        "App",
        graphql_name="appByKey",
        args=sgqlc.types.ArgDict((("api_key", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="apiKey", default=None)),)),
    )
    app_discount_type = sgqlc.types.Field(
        AppDiscountType,
        graphql_name="appDiscountType",
        args=sgqlc.types.ArgDict(
            (("function_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="functionId", default=None)),)
        ),
    )
    app_discount_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AppDiscountType))), graphql_name="appDiscountTypes"
    )
    app_installation = sgqlc.types.Field(
        "AppInstallation",
        graphql_name="appInstallation",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),)),
    )
    app_installations = sgqlc.types.Field(
        sgqlc.types.non_null(AppInstallationConnection),
        graphql_name="appInstallations",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(AppInstallationSortKeys, graphql_name="sortKey", default="INSTALLED_AT")),
                ("category", sgqlc.types.Arg(AppInstallationCategory, graphql_name="category", default=None)),
                ("privacy", sgqlc.types.Arg(AppInstallationPrivacy, graphql_name="privacy", default="PUBLIC")),
            )
        ),
    )
    automatic_discount_node = sgqlc.types.Field(
        "DiscountAutomaticNode",
        graphql_name="automaticDiscountNode",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    automatic_discount_nodes = sgqlc.types.Field(
        sgqlc.types.non_null(DiscountAutomaticNodeConnection),
        graphql_name="automaticDiscountNodes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(AutomaticDiscountSortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    automatic_discount_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="automaticDiscountSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    available_carrier_services = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DeliveryCarrierServiceAndLocations))),
        graphql_name="availableCarrierServices",
    )
    available_locales = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Locale))), graphql_name="availableLocales"
    )
    carrier_service = sgqlc.types.Field(
        "DeliveryCarrierService",
        graphql_name="carrierService",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    cart_transforms = sgqlc.types.Field(
        sgqlc.types.non_null(CartTransformConnection),
        graphql_name="cartTransforms",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    catalog = sgqlc.types.Field(
        Catalog,
        graphql_name="catalog",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    catalog_operations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ResourceOperation))), graphql_name="catalogOperations"
    )
    catalogs = sgqlc.types.Field(
        sgqlc.types.non_null(CatalogConnection),
        graphql_name="catalogs",
        args=sgqlc.types.ArgDict(
            (
                ("type", sgqlc.types.Arg(CatalogType, graphql_name="type", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CatalogSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    checkout_profile = sgqlc.types.Field(
        "CheckoutProfile",
        graphql_name="checkoutProfile",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    checkout_profiles = sgqlc.types.Field(
        sgqlc.types.non_null(CheckoutProfileConnection),
        graphql_name="checkoutProfiles",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CheckoutProfileSortKeys, graphql_name="sortKey", default="UPDATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    code_discount_node = sgqlc.types.Field(
        "DiscountCodeNode",
        graphql_name="codeDiscountNode",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    code_discount_node_by_code = sgqlc.types.Field(
        "DiscountCodeNode",
        graphql_name="codeDiscountNodeByCode",
        args=sgqlc.types.ArgDict((("code", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="code", default=None)),)),
    )
    code_discount_nodes = sgqlc.types.Field(
        sgqlc.types.non_null(DiscountCodeNodeConnection),
        graphql_name="codeDiscountNodes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CodeDiscountSortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    code_discount_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="codeDiscountSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    collection = sgqlc.types.Field(
        "Collection",
        graphql_name="collection",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    collection_by_handle = sgqlc.types.Field(
        "Collection",
        graphql_name="collectionByHandle",
        args=sgqlc.types.ArgDict((("handle", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="handle", default=None)),)),
    )
    collection_rules_conditions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CollectionRuleConditions))), graphql_name="collectionRulesConditions"
    )
    collection_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="collectionSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    collections = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionConnection),
        graphql_name="collections",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CollectionSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    companies = sgqlc.types.Field(
        sgqlc.types.non_null(CompanyConnection),
        graphql_name="companies",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CompanySortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    company = sgqlc.types.Field(
        "Company",
        graphql_name="company",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    company_contact = sgqlc.types.Field(
        "CompanyContact",
        graphql_name="companyContact",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    company_contact_role = sgqlc.types.Field(
        "CompanyContactRole",
        graphql_name="companyContactRole",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    company_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="companyCount")
    company_location = sgqlc.types.Field(
        "CompanyLocation",
        graphql_name="companyLocation",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    company_locations = sgqlc.types.Field(
        sgqlc.types.non_null(CompanyLocationConnection),
        graphql_name="companyLocations",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CompanyLocationSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    current_app_installation = sgqlc.types.Field(sgqlc.types.non_null("AppInstallation"), graphql_name="currentAppInstallation")
    current_bulk_operation = sgqlc.types.Field(
        "BulkOperation",
        graphql_name="currentBulkOperation",
        args=sgqlc.types.ArgDict((("type", sgqlc.types.Arg(BulkOperationType, graphql_name="type", default="QUERY")),)),
    )
    customer = sgqlc.types.Field(
        "Customer",
        graphql_name="customer",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    customer_merge_job_status = sgqlc.types.Field(
        CustomerMergeRequest,
        graphql_name="customerMergeJobStatus",
        args=sgqlc.types.ArgDict((("job_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="jobId", default=None)),)),
    )
    customer_merge_preview = sgqlc.types.Field(
        sgqlc.types.non_null(CustomerMergePreview),
        graphql_name="customerMergePreview",
        args=sgqlc.types.ArgDict(
            (
                ("customer_one_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerOneId", default=None)),
                ("customer_two_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerTwoId", default=None)),
                ("override_fields", sgqlc.types.Arg(CustomerMergeOverrideFields, graphql_name="overrideFields", default=None)),
            )
        ),
    )
    customer_payment_method = sgqlc.types.Field(
        "CustomerPaymentMethod",
        graphql_name="customerPaymentMethod",
        args=sgqlc.types.ArgDict(
            (
                ("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),
                ("show_revoked", sgqlc.types.Arg(Boolean, graphql_name="showRevoked", default=False)),
            )
        ),
    )
    customer_segment_members = sgqlc.types.Field(
        sgqlc.types.non_null(CustomerSegmentMemberConnection),
        graphql_name="customerSegmentMembers",
        args=sgqlc.types.ArgDict(
            (
                ("segment_id", sgqlc.types.Arg(ID, graphql_name="segmentId", default=None)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("query_id", sgqlc.types.Arg(ID, graphql_name="queryId", default=None)),
                ("timezone", sgqlc.types.Arg(String, graphql_name="timezone", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(String, graphql_name="sortKey", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
            )
        ),
    )
    customer_segment_members_query = sgqlc.types.Field(
        "CustomerSegmentMembersQuery",
        graphql_name="customerSegmentMembersQuery",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    customer_segment_membership = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentMembershipResponse"),
        graphql_name="customerSegmentMembership",
        args=sgqlc.types.ArgDict(
            (
                (
                    "segment_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="segmentIds", default=None
                    ),
                ),
                ("customer_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="customerId", default=None)),
            )
        ),
    )
    customers = sgqlc.types.Field(
        sgqlc.types.non_null(CustomerConnection),
        graphql_name="customers",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(CustomerSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    deletion_events = sgqlc.types.Field(
        sgqlc.types.non_null(DeletionEventConnection),
        graphql_name="deletionEvents",
        args=sgqlc.types.ArgDict(
            (
                (
                    "subject_types",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(DeletionEventSubjectType)), graphql_name="subjectTypes", default=None
                    ),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DeletionEventSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    delivery_customization = sgqlc.types.Field(
        "DeliveryCustomization",
        graphql_name="deliveryCustomization",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    delivery_customizations = sgqlc.types.Field(
        sgqlc.types.non_null(DeliveryCustomizationConnection),
        graphql_name="deliveryCustomizations",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    delivery_profile = sgqlc.types.Field(
        "DeliveryProfile",
        graphql_name="deliveryProfile",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    delivery_profiles = sgqlc.types.Field(
        sgqlc.types.non_null(DeliveryProfileConnection),
        graphql_name="deliveryProfiles",
        args=sgqlc.types.ArgDict(
            (
                ("merchant_owned_only", sgqlc.types.Arg(Boolean, graphql_name="merchantOwnedOnly", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    delivery_settings = sgqlc.types.Field(DeliverySetting, graphql_name="deliverySettings")
    discount_code_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int),
        graphql_name="discountCodeCount",
        args=sgqlc.types.ArgDict((("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),)),
    )
    discount_node = sgqlc.types.Field(
        "DiscountNode",
        graphql_name="discountNode",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_nodes = sgqlc.types.Field(
        sgqlc.types.non_null(DiscountNodeConnection),
        graphql_name="discountNodes",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountSortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    discount_redeem_code_bulk_creation = sgqlc.types.Field(
        "DiscountRedeemCodeBulkCreation",
        graphql_name="discountRedeemCodeBulkCreation",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    discount_redeem_code_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="discountRedeemCodeSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DiscountCodeSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    dispute = sgqlc.types.Field(
        "ShopifyPaymentsDispute",
        graphql_name="dispute",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    dispute_evidence = sgqlc.types.Field(
        "ShopifyPaymentsDisputeEvidence",
        graphql_name="disputeEvidence",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    domain = sgqlc.types.Field(
        "Domain",
        graphql_name="domain",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    draft_order = sgqlc.types.Field(
        "DraftOrder",
        graphql_name="draftOrder",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    draft_order_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="draftOrderSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    draft_order_tag = sgqlc.types.Field(
        "DraftOrderTag",
        graphql_name="draftOrderTag",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    draft_orders = sgqlc.types.Field(
        sgqlc.types.non_null(DraftOrderConnection),
        graphql_name="draftOrders",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(DraftOrderSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    file_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="fileSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    files = sgqlc.types.Field(
        sgqlc.types.non_null(FileConnection),
        graphql_name="files",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(FileSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    fulfillment = sgqlc.types.Field(
        "Fulfillment",
        graphql_name="fulfillment",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    fulfillment_order = sgqlc.types.Field(
        "FulfillmentOrder",
        graphql_name="fulfillmentOrder",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    fulfillment_orders = sgqlc.types.Field(
        sgqlc.types.non_null(FulfillmentOrderConnection),
        graphql_name="fulfillmentOrders",
        args=sgqlc.types.ArgDict(
            (
                ("include_closed", sgqlc.types.Arg(Boolean, graphql_name="includeClosed", default=False)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(FulfillmentOrderSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    fulfillment_service = sgqlc.types.Field(
        FulfillmentService,
        graphql_name="fulfillmentService",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    gift_card = sgqlc.types.Field(
        "GiftCard",
        graphql_name="giftCard",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    gift_cards = sgqlc.types.Field(
        sgqlc.types.non_null(GiftCardConnection),
        graphql_name="giftCards",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(GiftCardSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    gift_cards_count = sgqlc.types.Field(
        sgqlc.types.non_null(UnsignedInt64),
        graphql_name="giftCardsCount",
        args=sgqlc.types.ArgDict((("enabled", sgqlc.types.Arg(Boolean, graphql_name="enabled", default=None)),)),
    )
    inventory_item = sgqlc.types.Field(
        "InventoryItem",
        graphql_name="inventoryItem",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    inventory_items = sgqlc.types.Field(
        sgqlc.types.non_null(InventoryItemConnection),
        graphql_name="inventoryItems",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    inventory_level = sgqlc.types.Field(
        "InventoryLevel",
        graphql_name="inventoryLevel",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    inventory_properties = sgqlc.types.Field(sgqlc.types.non_null(InventoryProperties), graphql_name="inventoryProperties")
    job = sgqlc.types.Field(
        Job,
        graphql_name="job",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    location = sgqlc.types.Field(
        "Location", graphql_name="location", args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),))
    )
    locations = sgqlc.types.Field(
        sgqlc.types.non_null(LocationConnection),
        graphql_name="locations",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(LocationSortKeys, graphql_name="sortKey", default="NAME")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("include_legacy", sgqlc.types.Arg(Boolean, graphql_name="includeLegacy", default=False)),
                ("include_inactive", sgqlc.types.Arg(Boolean, graphql_name="includeInactive", default=False)),
            )
        ),
    )
    locations_available_for_delivery_profiles_connection = sgqlc.types.Field(
        sgqlc.types.non_null(LocationConnection),
        graphql_name="locationsAvailableForDeliveryProfilesConnection",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    manual_holds_fulfillment_orders = sgqlc.types.Field(
        sgqlc.types.non_null(FulfillmentOrderConnection),
        graphql_name="manualHoldsFulfillmentOrders",
        args=sgqlc.types.ArgDict(
            (
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    market = sgqlc.types.Field(
        "Market",
        graphql_name="market",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    market_by_geography = sgqlc.types.Field(
        "Market",
        graphql_name="marketByGeography",
        args=sgqlc.types.ArgDict(
            (("country_code", sgqlc.types.Arg(sgqlc.types.non_null(CountryCode), graphql_name="countryCode", default=None)),)
        ),
    )
    market_localizable_resource = sgqlc.types.Field(
        MarketLocalizableResource,
        graphql_name="marketLocalizableResource",
        args=sgqlc.types.ArgDict((("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),)),
    )
    market_localizable_resources = sgqlc.types.Field(
        sgqlc.types.non_null(MarketLocalizableResourceConnection),
        graphql_name="marketLocalizableResources",
        args=sgqlc.types.ArgDict(
            (
                (
                    "resource_type",
                    sgqlc.types.Arg(sgqlc.types.non_null(MarketLocalizableResourceType), graphql_name="resourceType", default=None),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    market_localizable_resources_by_ids = sgqlc.types.Field(
        sgqlc.types.non_null(MarketLocalizableResourceConnection),
        graphql_name="marketLocalizableResourcesByIds",
        args=sgqlc.types.ArgDict(
            (
                (
                    "resource_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="resourceIds", default=None
                    ),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    marketing_activities = sgqlc.types.Field(
        sgqlc.types.non_null(MarketingActivityConnection),
        graphql_name="marketingActivities",
        args=sgqlc.types.ArgDict(
            (
                (
                    "marketing_activity_ids",
                    sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="marketingActivityIds", default=()),
                ),
                ("remote_ids", sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="remoteIds", default=())),
                ("utm", sgqlc.types.Arg(UTMInput, graphql_name="utm", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(MarketingActivitySortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    marketing_activity = sgqlc.types.Field(
        "MarketingActivity",
        graphql_name="marketingActivity",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    marketing_event = sgqlc.types.Field(
        "MarketingEvent",
        graphql_name="marketingEvent",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    marketing_events = sgqlc.types.Field(
        sgqlc.types.non_null(MarketingEventConnection),
        graphql_name="marketingEvents",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(MarketingEventSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    markets = sgqlc.types.Field(
        sgqlc.types.non_null(MarketConnection),
        graphql_name="markets",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    metafield = sgqlc.types.Field(
        "Metafield",
        graphql_name="metafield",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metafield_definition = sgqlc.types.Field(
        "MetafieldDefinition",
        graphql_name="metafieldDefinition",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metafield_definition_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MetafieldDefinitionType))), graphql_name="metafieldDefinitionTypes"
    )
    metafield_definitions = sgqlc.types.Field(
        sgqlc.types.non_null(MetafieldDefinitionConnection),
        graphql_name="metafieldDefinitions",
        args=sgqlc.types.ArgDict(
            (
                ("key", sgqlc.types.Arg(String, graphql_name="key", default=None)),
                ("namespace", sgqlc.types.Arg(String, graphql_name="namespace", default=None)),
                ("owner_type", sgqlc.types.Arg(sgqlc.types.non_null(MetafieldOwnerType), graphql_name="ownerType", default=None)),
                ("pinned_status", sgqlc.types.Arg(MetafieldDefinitionPinnedStatus, graphql_name="pinnedStatus", default="ANY")),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(MetafieldDefinitionSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    metaobject = sgqlc.types.Field(
        "Metaobject",
        graphql_name="metaobject",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metaobject_by_handle = sgqlc.types.Field(
        "Metaobject",
        graphql_name="metaobjectByHandle",
        args=sgqlc.types.ArgDict(
            (("handle", sgqlc.types.Arg(sgqlc.types.non_null(MetaobjectHandleInput), graphql_name="handle", default=None)),)
        ),
    )
    metaobject_definition = sgqlc.types.Field(
        "MetaobjectDefinition",
        graphql_name="metaobjectDefinition",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    metaobject_definition_by_type = sgqlc.types.Field(
        "MetaobjectDefinition",
        graphql_name="metaobjectDefinitionByType",
        args=sgqlc.types.ArgDict((("type", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="type", default=None)),)),
    )
    metaobject_definitions = sgqlc.types.Field(
        sgqlc.types.non_null(MetaobjectDefinitionConnection),
        graphql_name="metaobjectDefinitions",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    metaobjects = sgqlc.types.Field(
        sgqlc.types.non_null(MetaobjectConnection),
        graphql_name="metaobjects",
        args=sgqlc.types.ArgDict(
            (
                ("type", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="type", default=None)),
                ("sort_key", sgqlc.types.Arg(String, graphql_name="sortKey", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    node = sgqlc.types.Field(
        Node,
        graphql_name="node",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(Node)),
        graphql_name="nodes",
        args=sgqlc.types.ArgDict(
            (
                (
                    "ids",
                    sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="ids", default=None),
                ),
            )
        ),
    )
    order = sgqlc.types.Field(
        "Order",
        graphql_name="order",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    order_payment_status = sgqlc.types.Field(
        OrderPaymentStatus,
        graphql_name="orderPaymentStatus",
        args=sgqlc.types.ArgDict(
            (
                ("payment_reference_id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="paymentReferenceId", default=None)),
                ("order_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="orderId", default=None)),
            )
        ),
    )
    order_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="orderSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    orders = sgqlc.types.Field(
        sgqlc.types.non_null(OrderConnection),
        graphql_name="orders",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(OrderSortKeys, graphql_name="sortKey", default="PROCESSED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    payment_customization = sgqlc.types.Field(
        "PaymentCustomization",
        graphql_name="paymentCustomization",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    payment_customizations = sgqlc.types.Field(
        sgqlc.types.non_null(PaymentCustomizationConnection),
        graphql_name="paymentCustomizations",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    payment_terms_templates = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("PaymentTermsTemplate"))),
        graphql_name="paymentTermsTemplates",
        args=sgqlc.types.ArgDict(
            (("payment_terms_type", sgqlc.types.Arg(PaymentTermsType, graphql_name="paymentTermsType", default=None)),)
        ),
    )
    price_list = sgqlc.types.Field(
        "PriceList",
        graphql_name="priceList",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    price_lists = sgqlc.types.Field(
        sgqlc.types.non_null(PriceListConnection),
        graphql_name="priceLists",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(PriceListSortKeys, graphql_name="sortKey", default="ID")),
            )
        ),
    )
    price_rule_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="priceRuleSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    primary_market = sgqlc.types.Field(sgqlc.types.non_null("Market"), graphql_name="primaryMarket")
    product = sgqlc.types.Field(
        "Product",
        graphql_name="product",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_by_handle = sgqlc.types.Field(
        "Product",
        graphql_name="productByHandle",
        args=sgqlc.types.ArgDict((("handle", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="handle", default=None)),)),
    )
    product_duplicate_job = sgqlc.types.Field(
        sgqlc.types.non_null(ProductDuplicateJob),
        graphql_name="productDuplicateJob",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_feed = sgqlc.types.Field(
        "ProductFeed",
        graphql_name="productFeed",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_feeds = sgqlc.types.Field(
        sgqlc.types.non_null(ProductFeedConnection),
        graphql_name="productFeeds",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    product_resource_feedback = sgqlc.types.Field(
        ProductResourceFeedback,
        graphql_name="productResourceFeedback",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="productSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    product_variant = sgqlc.types.Field(
        "ProductVariant",
        graphql_name="productVariant",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    product_variants = sgqlc.types.Field(
        sgqlc.types.non_null(ProductVariantConnection),
        graphql_name="productVariants",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(ProductVariantSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    products = sgqlc.types.Field(
        sgqlc.types.non_null(ProductConnection),
        graphql_name="products",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(ProductSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    public_api_versions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ApiVersion))), graphql_name="publicApiVersions"
    )
    publication = sgqlc.types.Field(
        "Publication",
        graphql_name="publication",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    publications = sgqlc.types.Field(
        sgqlc.types.non_null(PublicationConnection),
        graphql_name="publications",
        args=sgqlc.types.ArgDict(
            (
                ("catalog_type", sgqlc.types.Arg(CatalogType, graphql_name="catalogType", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    refund = sgqlc.types.Field(
        "Refund",
        graphql_name="refund",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    return_ = sgqlc.types.Field(
        "Return",
        graphql_name="return",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    returnable_fulfillment = sgqlc.types.Field(
        "ReturnableFulfillment",
        graphql_name="returnableFulfillment",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    returnable_fulfillments = sgqlc.types.Field(
        sgqlc.types.non_null("ReturnableFulfillmentConnection"),
        graphql_name="returnableFulfillments",
        args=sgqlc.types.ArgDict(
            (
                ("order_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="orderId", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    reverse_delivery = sgqlc.types.Field(
        "ReverseDelivery",
        graphql_name="reverseDelivery",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    reverse_fulfillment_order = sgqlc.types.Field(
        "ReverseFulfillmentOrder",
        graphql_name="reverseFulfillmentOrder",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    script_tag = sgqlc.types.Field(
        "ScriptTag",
        graphql_name="scriptTag",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    script_tags = sgqlc.types.Field(
        sgqlc.types.non_null("ScriptTagConnection"),
        graphql_name="scriptTags",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("src", sgqlc.types.Arg(URL, graphql_name="src", default=None)),
            )
        ),
    )
    segment = sgqlc.types.Field(
        "Segment",
        graphql_name="segment",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    segment_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="segmentCount")
    segment_filter_suggestions = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentFilterConnection"),
        graphql_name="segmentFilterSuggestions",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="search", default=None)),
                ("first", sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
            )
        ),
    )
    segment_filters = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentFilterConnection"),
        graphql_name="segmentFilters",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
            )
        ),
    )
    segment_migrations = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentMigrationConnection"),
        graphql_name="segmentMigrations",
        args=sgqlc.types.ArgDict(
            (
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
            )
        ),
    )
    segment_value_suggestions = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentValueConnection"),
        graphql_name="segmentValueSuggestions",
        args=sgqlc.types.ArgDict(
            (
                ("search", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="search", default=None)),
                ("filter_query_name", sgqlc.types.Arg(String, graphql_name="filterQueryName", default=None)),
                ("function_parameter_query_name", sgqlc.types.Arg(String, graphql_name="functionParameterQueryName", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
            )
        ),
    )
    segments = sgqlc.types.Field(
        sgqlc.types.non_null("SegmentConnection"),
        graphql_name="segments",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(SegmentSortKeys, graphql_name="sortKey", default="CREATION_DATE")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    selling_plan_group = sgqlc.types.Field(
        "SellingPlanGroup",
        graphql_name="sellingPlanGroup",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    selling_plan_groups = sgqlc.types.Field(
        sgqlc.types.non_null("SellingPlanGroupConnection"),
        graphql_name="sellingPlanGroups",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(SellingPlanGroupSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    server_pixel = sgqlc.types.Field("ServerPixel", graphql_name="serverPixel")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    shop_billing_preferences = sgqlc.types.Field(sgqlc.types.non_null("ShopBillingPreferences"), graphql_name="shopBillingPreferences")
    shop_locales = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopLocale"))),
        graphql_name="shopLocales",
        args=sgqlc.types.ArgDict((("published", sgqlc.types.Arg(Boolean, graphql_name="published", default=False)),)),
    )
    shopify_function = sgqlc.types.Field(
        "ShopifyFunction",
        graphql_name="shopifyFunction",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="id", default=None)),)),
    )
    shopify_functions = sgqlc.types.Field(
        sgqlc.types.non_null("ShopifyFunctionConnection"),
        graphql_name="shopifyFunctions",
        args=sgqlc.types.ArgDict(
            (
                ("api_type", sgqlc.types.Arg(String, graphql_name="apiType", default=None)),
                ("use_creation_ui", sgqlc.types.Arg(Boolean, graphql_name="useCreationUi", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    shopify_payments_account = sgqlc.types.Field("ShopifyPaymentsAccount", graphql_name="shopifyPaymentsAccount")
    shopifyql_query = sgqlc.types.Field(
        ShopifyqlResponse,
        graphql_name="shopifyqlQuery",
        args=sgqlc.types.ArgDict((("query", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="query", default=None)),)),
    )
    staff_member = sgqlc.types.Field(
        "StaffMember", graphql_name="staffMember", args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),))
    )
    standard_metafield_definition_templates = sgqlc.types.Field(
        sgqlc.types.non_null("StandardMetafieldDefinitionTemplateConnection"),
        graphql_name="standardMetafieldDefinitionTemplates",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    subscription_billing_attempt = sgqlc.types.Field(
        "SubscriptionBillingAttempt",
        graphql_name="subscriptionBillingAttempt",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    subscription_billing_attempts = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionBillingAttemptConnection"),
        graphql_name="subscriptionBillingAttempts",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(SubscriptionBillingAttemptsSortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    subscription_billing_cycle = sgqlc.types.Field(
        "SubscriptionBillingCycle",
        graphql_name="subscriptionBillingCycle",
        args=sgqlc.types.ArgDict(
            (
                (
                    "billing_cycle_input",
                    sgqlc.types.Arg(sgqlc.types.non_null(SubscriptionBillingCycleInput), graphql_name="billingCycleInput", default=None),
                ),
            )
        ),
    )
    subscription_billing_cycles = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionBillingCycleConnection"),
        graphql_name="subscriptionBillingCycles",
        args=sgqlc.types.ArgDict(
            (
                ("contract_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="contractId", default=None)),
                (
                    "billing_cycles_date_range_selector",
                    sgqlc.types.Arg(
                        SubscriptionBillingCyclesDateRangeSelector, graphql_name="billingCyclesDateRangeSelector", default=None
                    ),
                ),
                (
                    "billing_cycles_index_range_selector",
                    sgqlc.types.Arg(
                        SubscriptionBillingCyclesIndexRangeSelector, graphql_name="billingCyclesIndexRangeSelector", default=None
                    ),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(SubscriptionBillingCyclesSortKeys, graphql_name="sortKey", default="CYCLE_INDEX")),
            )
        ),
    )
    subscription_contract = sgqlc.types.Field(
        "SubscriptionContract",
        graphql_name="subscriptionContract",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    subscription_contracts = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionContractConnection"),
        graphql_name="subscriptionContracts",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    subscription_draft = sgqlc.types.Field(
        "SubscriptionDraft",
        graphql_name="subscriptionDraft",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    tender_transactions = sgqlc.types.Field(
        sgqlc.types.non_null("TenderTransactionConnection"),
        graphql_name="tenderTransactions",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
            )
        ),
    )
    translatable_resource = sgqlc.types.Field(
        "TranslatableResource",
        graphql_name="translatableResource",
        args=sgqlc.types.ArgDict((("resource_id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="resourceId", default=None)),)),
    )
    translatable_resources = sgqlc.types.Field(
        sgqlc.types.non_null("TranslatableResourceConnection"),
        graphql_name="translatableResources",
        args=sgqlc.types.ArgDict(
            (
                (
                    "resource_type",
                    sgqlc.types.Arg(sgqlc.types.non_null(TranslatableResourceType), graphql_name="resourceType", default=None),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    translatable_resources_by_ids = sgqlc.types.Field(
        sgqlc.types.non_null("TranslatableResourceConnection"),
        graphql_name="translatableResourcesByIds",
        args=sgqlc.types.ArgDict(
            (
                (
                    "resource_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ID))), graphql_name="resourceIds", default=None
                    ),
                ),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    url_redirect = sgqlc.types.Field(
        "UrlRedirect",
        graphql_name="urlRedirect",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    url_redirect_import = sgqlc.types.Field(
        "UrlRedirectImport",
        graphql_name="urlRedirectImport",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    url_redirect_saved_searches = sgqlc.types.Field(
        sgqlc.types.non_null("SavedSearchConnection"),
        graphql_name="urlRedirectSavedSearches",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    url_redirects = sgqlc.types.Field(
        sgqlc.types.non_null("UrlRedirectConnection"),
        graphql_name="urlRedirects",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(UrlRedirectSortKeys, graphql_name="sortKey", default="ID")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("saved_search_id", sgqlc.types.Arg(ID, graphql_name="savedSearchId", default=None)),
            )
        ),
    )
    web_pixel = sgqlc.types.Field(
        "WebPixel", graphql_name="webPixel", args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(ID, graphql_name="id", default=None)),))
    )
    webhook_subscription = sgqlc.types.Field(
        "WebhookSubscription",
        graphql_name="webhookSubscription",
        args=sgqlc.types.ArgDict((("id", sgqlc.types.Arg(sgqlc.types.non_null(ID), graphql_name="id", default=None)),)),
    )
    webhook_subscriptions = sgqlc.types.Field(
        sgqlc.types.non_null("WebhookSubscriptionConnection"),
        graphql_name="webhookSubscriptions",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
                ("sort_key", sgqlc.types.Arg(WebhookSubscriptionSortKeys, graphql_name="sortKey", default="CREATED_AT")),
                ("query", sgqlc.types.Arg(String, graphql_name="query", default=None)),
                ("callback_url", sgqlc.types.Arg(URL, graphql_name="callbackUrl", default=None)),
                ("format", sgqlc.types.Arg(WebhookSubscriptionFormat, graphql_name="format", default=None)),
                (
                    "topics",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(WebhookSubscriptionTopic)), graphql_name="topics", default=None
                    ),
                ),
            )
        ),
    )


class RefundConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("RefundEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Refund"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class RefundCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("order", "refund", "user_errors")
    order = sgqlc.types.Field("Order", graphql_name="order")
    refund = sgqlc.types.Field("Refund", graphql_name="refund")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class RefundDuty(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount_set", "original_duty")
    amount_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="amountSet")
    original_duty = sgqlc.types.Field("Duty", graphql_name="originalDuty")


class RefundEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Refund"), graphql_name="node")


class RefundLineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("line_item", "location", "price_set", "quantity", "restock_type", "restocked", "subtotal_set", "total_tax_set")
    line_item = sgqlc.types.Field(sgqlc.types.non_null("LineItem"), graphql_name="lineItem")
    location = sgqlc.types.Field("Location", graphql_name="location")
    price_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="priceSet")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")
    restock_type = sgqlc.types.Field(sgqlc.types.non_null(RefundLineItemRestockType), graphql_name="restockType")
    restocked = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="restocked")
    subtotal_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="subtotalSet")
    total_tax_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="totalTaxSet")


class RefundLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("RefundLineItemEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(RefundLineItem))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class RefundLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(RefundLineItem), graphql_name="node")


class ResourceAlert(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("actions", "content", "dismissible_handle", "icon", "severity", "title")
    actions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ResourceAlertAction"))), graphql_name="actions"
    )
    content = sgqlc.types.Field(sgqlc.types.non_null(HTML), graphql_name="content")
    dismissible_handle = sgqlc.types.Field(String, graphql_name="dismissibleHandle")
    icon = sgqlc.types.Field(ResourceAlertIcon, graphql_name="icon")
    severity = sgqlc.types.Field(sgqlc.types.non_null(ResourceAlertSeverity), graphql_name="severity")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class ResourceAlertAction(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("primary", "show", "title", "url")
    primary = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="primary")
    show = sgqlc.types.Field(String, graphql_name="show")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class ResourceFeedback(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("details", "summary")
    details = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AppFeedback))), graphql_name="details")
    summary = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summary")


class ResourceLimit(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("available", "quantity_available", "quantity_limit", "quantity_used")
    available = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="available")
    quantity_available = sgqlc.types.Field(Int, graphql_name="quantityAvailable")
    quantity_limit = sgqlc.types.Field(Int, graphql_name="quantityLimit")
    quantity_used = sgqlc.types.Field(Int, graphql_name="quantityUsed")


class ResourcePublication(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("is_published", "publication", "publish_date", "publishable")
    is_published = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPublished")
    publication = sgqlc.types.Field(sgqlc.types.non_null("Publication"), graphql_name="publication")
    publish_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="publishDate")
    publishable = sgqlc.types.Field(sgqlc.types.non_null(Publishable), graphql_name="publishable")


class ResourcePublicationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ResourcePublicationEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ResourcePublication))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ResourcePublicationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ResourcePublication), graphql_name="node")


class ResourcePublicationV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("is_published", "publication", "publish_date", "publishable")
    is_published = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPublished")
    publication = sgqlc.types.Field(sgqlc.types.non_null("Publication"), graphql_name="publication")
    publish_date = sgqlc.types.Field(DateTime, graphql_name="publishDate")
    publishable = sgqlc.types.Field(sgqlc.types.non_null(Publishable), graphql_name="publishable")


class ResourcePublicationV2Connection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ResourcePublicationV2Edge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ResourcePublicationV2))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ResourcePublicationV2Edge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ResourcePublicationV2), graphql_name="node")


class ReturnApproveRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnCancelPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnClosePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Return"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReturnCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnDecline(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("note", "reason")
    note = sgqlc.types.Field(String, graphql_name="note")
    reason = sgqlc.types.Field(sgqlc.types.non_null(ReturnDeclineReason), graphql_name="reason")


class ReturnDeclineRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Return"), graphql_name="node")


class ReturnLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnLineItemEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnLineItem"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReturnLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReturnLineItem"), graphql_name="node")


class ReturnRefundPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("refund", "user_errors")
    refund = sgqlc.types.Field("Refund", graphql_name="refund")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnReopenPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnRequestPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("return_", "user_errors")
    return_ = sgqlc.types.Field("Return", graphql_name="return")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReturnableFulfillmentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnableFulfillmentEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnableFulfillment"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReturnableFulfillmentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReturnableFulfillment"), graphql_name="node")


class ReturnableFulfillmentLineItem(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("fulfillment_line_item", "quantity")
    fulfillment_line_item = sgqlc.types.Field(sgqlc.types.non_null("FulfillmentLineItem"), graphql_name="fulfillmentLineItem")
    quantity = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="quantity")


class ReturnableFulfillmentLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnableFulfillmentLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ReturnableFulfillmentLineItem))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReturnableFulfillmentLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ReturnableFulfillmentLineItem), graphql_name="node")


class ReverseDeliveryConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseDeliveryEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseDelivery"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReverseDeliveryCreateWithShippingPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_delivery", "user_errors")
    reverse_delivery = sgqlc.types.Field("ReverseDelivery", graphql_name="reverseDelivery")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReverseDeliveryDisposePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_delivery_line_items", "user_errors")
    reverse_delivery_line_items = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("ReverseDeliveryLineItem")), graphql_name="reverseDeliveryLineItems"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReverseDeliveryEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReverseDelivery"), graphql_name="node")


class ReverseDeliveryLabelV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("created_at", "public_file_url", "updated_at")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    public_file_url = sgqlc.types.Field(URL, graphql_name="publicFileUrl")
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedAt")


class ReverseDeliveryLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseDeliveryLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseDeliveryLineItem"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReverseDeliveryLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReverseDeliveryLineItem"), graphql_name="node")


class ReverseDeliveryShippingDeliverable(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("label", "tracking")
    label = sgqlc.types.Field(ReverseDeliveryLabelV2, graphql_name="label")
    tracking = sgqlc.types.Field("ReverseDeliveryTrackingV2", graphql_name="tracking")


class ReverseDeliveryShippingUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_delivery", "user_errors")
    reverse_delivery = sgqlc.types.Field("ReverseDelivery", graphql_name="reverseDelivery")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReverseDeliveryTrackingV2(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("carrier_name", "number", "url")
    carrier_name = sgqlc.types.Field(String, graphql_name="carrierName")
    number = sgqlc.types.Field(String, graphql_name="number")
    url = sgqlc.types.Field(URL, graphql_name="url")


class ReverseFulfillmentOrderConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseFulfillmentOrderEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseFulfillmentOrder"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReverseFulfillmentOrderDisposePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("reverse_fulfillment_order_line_items", "user_errors")
    reverse_fulfillment_order_line_items = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("ReverseFulfillmentOrderLineItem")), graphql_name="reverseFulfillmentOrderLineItems"
    )
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReturnUserError"))), graphql_name="userErrors"
    )


class ReverseFulfillmentOrderEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReverseFulfillmentOrder"), graphql_name="node")


class ReverseFulfillmentOrderLineItemConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseFulfillmentOrderLineItemEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ReverseFulfillmentOrderLineItem"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ReverseFulfillmentOrderLineItemEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ReverseFulfillmentOrderLineItem"), graphql_name="node")


class ReverseFulfillmentOrderThirdPartyConfirmation(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("status",)
    status = sgqlc.types.Field(sgqlc.types.non_null(ReverseFulfillmentOrderThirdPartyConfirmationStatus), graphql_name="status")


class RowCount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("count", "exceeds_max")
    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")
    exceeds_max = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="exceedsMax")


class SEO(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "title")
    description = sgqlc.types.Field(String, graphql_name="description")
    title = sgqlc.types.Field(String, graphql_name="title")


class SaleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SaleEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Sale))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SaleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(Sale), graphql_name="node")


class SaleTax(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount", "id", "tax_line")
    amount = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="amount")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    tax_line = sgqlc.types.Field(sgqlc.types.non_null("TaxLine"), graphql_name="taxLine")


class SalesAgreementConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SalesAgreementEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SalesAgreement))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SalesAgreementEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SalesAgreement), graphql_name="node")


class SavedSearchConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SavedSearchEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SavedSearch"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SavedSearchCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("saved_search", "user_errors")
    saved_search = sgqlc.types.Field("SavedSearch", graphql_name="savedSearch")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SavedSearchDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_saved_search_id", "shop", "user_errors")
    deleted_saved_search_id = sgqlc.types.Field(ID, graphql_name="deletedSavedSearchId")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SavedSearchEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("SavedSearch"), graphql_name="node")


class SavedSearchUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("saved_search", "user_errors")
    saved_search = sgqlc.types.Field("SavedSearch", graphql_name="savedSearch")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ScriptTagConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ScriptTagEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ScriptTag"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ScriptTagCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("script_tag", "user_errors")
    script_tag = sgqlc.types.Field("ScriptTag", graphql_name="scriptTag")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ScriptTagDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_script_tag_id", "user_errors")
    deleted_script_tag_id = sgqlc.types.Field(ID, graphql_name="deletedScriptTagId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ScriptTagEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ScriptTag"), graphql_name="node")


class ScriptTagUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("script_tag", "user_errors")
    script_tag = sgqlc.types.Field("ScriptTag", graphql_name="scriptTag")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SearchFilter(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class SearchFilterOptions(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_availability",)
    product_availability = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FilterOption))), graphql_name="productAvailability"
    )


class SearchResult(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("description", "image", "reference", "title", "url")
    description = sgqlc.types.Field(String, graphql_name="description")
    image = sgqlc.types.Field("Image", graphql_name="image")
    reference = sgqlc.types.Field(sgqlc.types.non_null(Node), graphql_name="reference")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class SearchResultConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SearchResultEdge"))), graphql_name="edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SearchResultEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SearchResult), graphql_name="node")


class SegmentAttributeStatistics(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("average", "sum")
    average = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="average")
    sum = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="sum")


class SegmentConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SegmentEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Segment"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SegmentCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("segment", "user_errors")
    segment = sgqlc.types.Field("Segment", graphql_name="segment")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SegmentDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_segment_id", "user_errors")
    deleted_segment_id = sgqlc.types.Field(ID, graphql_name="deletedSegmentId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SegmentEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("Segment"), graphql_name="node")


class SegmentEventFilterParameter(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("accepts_multiple_values", "localized_description", "localized_name", "optional", "parameter_type", "query_name")
    accepts_multiple_values = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="acceptsMultipleValues")
    localized_description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="localizedDescription")
    localized_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="localizedName")
    optional = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="optional")
    parameter_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="parameterType")
    query_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryName")


class SegmentFilterConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SegmentFilterEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SegmentFilter))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SegmentFilterEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SegmentFilter), graphql_name="node")


class SegmentMembership(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("is_member", "segment_id")
    is_member = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isMember")
    segment_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="segmentId")


class SegmentMembershipResponse(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("memberships",)
    memberships = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SegmentMembership))), graphql_name="memberships"
    )


class SegmentMigration(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("id", "saved_search_id", "segment_id")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    saved_search_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="savedSearchId")
    segment_id = sgqlc.types.Field(ID, graphql_name="segmentId")


class SegmentMigrationConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SegmentMigrationEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SegmentMigration))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SegmentMigrationEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SegmentMigration), graphql_name="node")


class SegmentStatistics(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("attribute_statistics",)
    attribute_statistics = sgqlc.types.Field(
        sgqlc.types.non_null(SegmentAttributeStatistics),
        graphql_name="attributeStatistics",
        args=sgqlc.types.ArgDict(
            (("attribute_name", sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name="attributeName", default=None)),)
        ),
    )


class SegmentUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("segment", "user_errors")
    segment = sgqlc.types.Field("Segment", graphql_name="segment")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class SegmentValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("localized_value", "query_name")
    localized_value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="localizedValue")
    query_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryName")


class SegmentValueConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SegmentValueEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SegmentValue))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SegmentValueEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SegmentValue), graphql_name="node")


class SelectedOption(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class SellingPlanAnchor(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cutoff_day", "day", "month", "type")
    cutoff_day = sgqlc.types.Field(Int, graphql_name="cutoffDay")
    day = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="day")
    month = sgqlc.types.Field(Int, graphql_name="month")
    type = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanAnchorType), graphql_name="type")


class SellingPlanCheckoutCharge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("type", "value")
    type = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanCheckoutChargeType), graphql_name="type")
    value = sgqlc.types.Field(sgqlc.types.non_null("SellingPlanCheckoutChargeValue"), graphql_name="value")


class SellingPlanCheckoutChargePercentageValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class SellingPlanConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlan"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SellingPlanEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("SellingPlan"), graphql_name="node")


class SellingPlanFixedBillingPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "checkout_charge",
        "remaining_balance_charge_exact_time",
        "remaining_balance_charge_time_after_checkout",
        "remaining_balance_charge_trigger",
    )
    checkout_charge = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanCheckoutCharge), graphql_name="checkoutCharge")
    remaining_balance_charge_exact_time = sgqlc.types.Field(DateTime, graphql_name="remainingBalanceChargeExactTime")
    remaining_balance_charge_time_after_checkout = sgqlc.types.Field(String, graphql_name="remainingBalanceChargeTimeAfterCheckout")
    remaining_balance_charge_trigger = sgqlc.types.Field(
        sgqlc.types.non_null(SellingPlanRemainingBalanceChargeTrigger), graphql_name="remainingBalanceChargeTrigger"
    )


class SellingPlanFixedDeliveryPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("anchors", "cutoff", "fulfillment_exact_time", "fulfillment_trigger", "intent", "pre_anchor_behavior")
    anchors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchor))), graphql_name="anchors")
    cutoff = sgqlc.types.Field(Int, graphql_name="cutoff")
    fulfillment_exact_time = sgqlc.types.Field(DateTime, graphql_name="fulfillmentExactTime")
    fulfillment_trigger = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanFulfillmentTrigger), graphql_name="fulfillmentTrigger")
    intent = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanFixedDeliveryPolicyIntent), graphql_name="intent")
    pre_anchor_behavior = sgqlc.types.Field(
        sgqlc.types.non_null(SellingPlanFixedDeliveryPolicyPreAnchorBehavior), graphql_name="preAnchorBehavior"
    )


class SellingPlanGroupAddProductVariantsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("selling_plan_group", "user_errors")
    selling_plan_group = sgqlc.types.Field("SellingPlanGroup", graphql_name="sellingPlanGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupAddProductsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("selling_plan_group", "user_errors")
    selling_plan_group = sgqlc.types.Field("SellingPlanGroup", graphql_name="sellingPlanGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroup"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SellingPlanGroupCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("selling_plan_group", "user_errors")
    selling_plan_group = sgqlc.types.Field("SellingPlanGroup", graphql_name="sellingPlanGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_selling_plan_group_id", "user_errors")
    deleted_selling_plan_group_id = sgqlc.types.Field(ID, graphql_name="deletedSellingPlanGroupId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("SellingPlanGroup"), graphql_name="node")


class SellingPlanGroupRemoveProductVariantsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("removed_product_variant_ids", "user_errors")
    removed_product_variant_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="removedProductVariantIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupRemoveProductsPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("removed_product_ids", "user_errors")
    removed_product_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="removedProductIds")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanGroupUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_selling_plan_ids", "selling_plan_group", "user_errors")
    deleted_selling_plan_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ID)), graphql_name="deletedSellingPlanIds")
    selling_plan_group = sgqlc.types.Field("SellingPlanGroup", graphql_name="sellingPlanGroup")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SellingPlanGroupUserError"))), graphql_name="userErrors"
    )


class SellingPlanInventoryPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("reserve",)
    reserve = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanReserve), graphql_name="reserve")


class SellingPlanPricingPolicyPercentageValue(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("percentage",)
    percentage = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="percentage")


class SellingPlanRecurringBillingPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("anchors", "created_at", "interval", "interval_count", "max_cycles", "min_cycles")
    anchors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchor))), graphql_name="anchors")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    interval = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanInterval), graphql_name="interval")
    interval_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalCount")
    max_cycles = sgqlc.types.Field(Int, graphql_name="maxCycles")
    min_cycles = sgqlc.types.Field(Int, graphql_name="minCycles")


class SellingPlanRecurringDeliveryPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("anchors", "created_at", "cutoff", "intent", "interval", "interval_count", "pre_anchor_behavior")
    anchors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchor))), graphql_name="anchors")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    cutoff = sgqlc.types.Field(Int, graphql_name="cutoff")
    intent = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanRecurringDeliveryPolicyIntent), graphql_name="intent")
    interval = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanInterval), graphql_name="interval")
    interval_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalCount")
    pre_anchor_behavior = sgqlc.types.Field(
        sgqlc.types.non_null(SellingPlanRecurringDeliveryPolicyPreAnchorBehavior), graphql_name="preAnchorBehavior"
    )


class ServerPixelCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("server_pixel", "user_errors")
    server_pixel = sgqlc.types.Field("ServerPixel", graphql_name="serverPixel")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ErrorsServerPixelUserError"))), graphql_name="userErrors"
    )


class ServerPixelDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_server_pixel_id", "user_errors")
    deleted_server_pixel_id = sgqlc.types.Field(ID, graphql_name="deletedServerPixelId")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ErrorsServerPixelUserError"))), graphql_name="userErrors"
    )


class ShippingLine(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "carrier_identifier",
        "code",
        "custom",
        "delivery_category",
        "discount_allocations",
        "discounted_price_set",
        "id",
        "original_price_set",
        "phone",
        "requested_fulfillment_service",
        "shipping_rate_handle",
        "source",
        "tax_lines",
        "title",
    )
    carrier_identifier = sgqlc.types.Field(String, graphql_name="carrierIdentifier")
    code = sgqlc.types.Field(String, graphql_name="code")
    custom = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="custom")
    delivery_category = sgqlc.types.Field(String, graphql_name="deliveryCategory")
    discount_allocations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(DiscountAllocation))), graphql_name="discountAllocations"
    )
    discounted_price_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="discountedPriceSet")
    id = sgqlc.types.Field(ID, graphql_name="id")
    original_price_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="originalPriceSet")
    phone = sgqlc.types.Field(String, graphql_name="phone")
    requested_fulfillment_service = sgqlc.types.Field(FulfillmentService, graphql_name="requestedFulfillmentService")
    shipping_rate_handle = sgqlc.types.Field(String, graphql_name="shippingRateHandle")
    source = sgqlc.types.Field(String, graphql_name="source")
    tax_lines = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TaxLine"))), graphql_name="taxLines")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class ShippingLineConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShippingLineEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ShippingLine))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ShippingLineEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ShippingLine), graphql_name="node")


class ShippingMethod(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "label")
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")


class ShippingPackageDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_id", "user_errors")
    deleted_id = sgqlc.types.Field(ID, graphql_name="deletedId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShippingPackageMakeDefaultPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShippingPackageUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("user_errors",)
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShippingRate(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("handle", "price", "title")
    handle = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="handle")
    price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="price")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")


class ShippingRefund(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("amount_set", "maximum_refundable_set", "tax_set")
    amount_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="amountSet")
    maximum_refundable_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="maximumRefundableSet")
    tax_set = sgqlc.types.Field(sgqlc.types.non_null(MoneyBag), graphql_name="taxSet")


class ShopAlert(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("action", "description")
    action = sgqlc.types.Field(sgqlc.types.non_null("ShopAlertAction"), graphql_name="action")
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")


class ShopAlertAction(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("title", "url")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="url")


class ShopBillingPreferences(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("currency",)
    currency = sgqlc.types.Field(sgqlc.types.non_null(CurrencyCode), graphql_name="currency")


class ShopFeatures(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "avalara_avatax",
        "branding",
        "bundles",
        "captcha",
        "captcha_external_domains",
        "dynamic_remarketing",
        "eligible_for_subscription_migration",
        "eligible_for_subscriptions",
        "gift_cards",
        "harmonized_system_code",
        "international_domains",
        "international_price_overrides",
        "international_price_rules",
        "legacy_subscription_gateway_enabled",
        "live_view",
        "onboarding_visual",
        "paypal_express_subscription_gateway_status",
        "reports",
        "sells_subscriptions",
        "show_metrics",
        "storefront",
        "using_shopify_balance",
    )
    avalara_avatax = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="avalaraAvatax")
    branding = sgqlc.types.Field(sgqlc.types.non_null(ShopBranding), graphql_name="branding")
    bundles = sgqlc.types.Field(sgqlc.types.non_null(BundlesFeature), graphql_name="bundles")
    captcha = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="captcha")
    captcha_external_domains = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="captchaExternalDomains")
    dynamic_remarketing = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="dynamicRemarketing")
    eligible_for_subscription_migration = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="eligibleForSubscriptionMigration")
    eligible_for_subscriptions = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="eligibleForSubscriptions")
    gift_cards = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="giftCards")
    harmonized_system_code = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="harmonizedSystemCode")
    international_domains = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="internationalDomains")
    international_price_overrides = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="internationalPriceOverrides")
    international_price_rules = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="internationalPriceRules")
    legacy_subscription_gateway_enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="legacySubscriptionGatewayEnabled")
    live_view = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="liveView")
    onboarding_visual = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="onboardingVisual")
    paypal_express_subscription_gateway_status = sgqlc.types.Field(
        sgqlc.types.non_null(PaypalExpressSubscriptionsGatewayStatus), graphql_name="paypalExpressSubscriptionGatewayStatus"
    )
    reports = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="reports")
    sells_subscriptions = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="sellsSubscriptions")
    show_metrics = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="showMetrics")
    storefront = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="storefront")
    using_shopify_balance = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="usingShopifyBalance")


class ShopLocale(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("locale", "market_web_presences", "name", "primary", "published")
    locale = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="locale")
    market_web_presences = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MarketWebPresence"))), graphql_name="marketWebPresences"
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    primary = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="primary")
    published = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="published")


class ShopLocaleDisablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("locale", "user_errors")
    locale = sgqlc.types.Field(String, graphql_name="locale")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShopLocaleEnablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("shop_locale", "user_errors")
    shop_locale = sgqlc.types.Field(ShopLocale, graphql_name="shopLocale")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShopLocaleUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("shop_locale", "user_errors")
    shop_locale = sgqlc.types.Field(ShopLocale, graphql_name="shopLocale")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class ShopPlan(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("display_name", "partner_development", "shopify_plus")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    partner_development = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="partnerDevelopment")
    shopify_plus = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="shopifyPlus")


class ShopPolicyUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("shop_policy", "user_errors")
    shop_policy = sgqlc.types.Field("ShopPolicy", graphql_name="shopPolicy")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopPolicyUserError"))), graphql_name="userErrors"
    )


class ShopResourceFeedbackCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("feedback", "user_errors")
    feedback = sgqlc.types.Field(AppFeedback, graphql_name="feedback")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopResourceFeedbackCreateUserError"))), graphql_name="userErrors"
    )


class ShopResourceLimits(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("location_limit", "max_product_options", "max_product_variants", "redirect_limit_reached")
    location_limit = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="locationLimit")
    max_product_options = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="maxProductOptions")
    max_product_variants = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="maxProductVariants")
    redirect_limit_reached = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="redirectLimitReached")


class ShopifyFunction(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "api_type",
        "api_version",
        "app",
        "app_bridge",
        "app_key",
        "description",
        "id",
        "input_query",
        "title",
        "use_creation_ui",
    )
    api_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="apiType")
    api_version = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="apiVersion")
    app = sgqlc.types.Field(sgqlc.types.non_null("App"), graphql_name="app")
    app_bridge = sgqlc.types.Field(sgqlc.types.non_null(FunctionsAppBridge), graphql_name="appBridge")
    app_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="appKey")
    description = sgqlc.types.Field(String, graphql_name="description")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    input_query = sgqlc.types.Field(String, graphql_name="inputQuery")
    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    use_creation_ui = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="useCreationUi")


class ShopifyFunctionConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyFunctionEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ShopifyFunction))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ShopifyFunctionEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(ShopifyFunction), graphql_name="node")


class ShopifyPaymentsBankAccountConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsBankAccountEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsBankAccount"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ShopifyPaymentsBankAccountEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ShopifyPaymentsBankAccount"), graphql_name="node")


class ShopifyPaymentsDisputeConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsDisputeEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsDispute"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ShopifyPaymentsDisputeEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ShopifyPaymentsDispute"), graphql_name="node")


class ShopifyPaymentsDisputeReasonDetails(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("network_reason_code", "reason")
    network_reason_code = sgqlc.types.Field(String, graphql_name="networkReasonCode")
    reason = sgqlc.types.Field(sgqlc.types.non_null(ShopifyPaymentsDisputeReason), graphql_name="reason")


class ShopifyPaymentsExtendedAuthorization(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("extended_authorization_expires_at", "standard_authorization_expires_at")
    extended_authorization_expires_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="extendedAuthorizationExpiresAt")
    standard_authorization_expires_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="standardAuthorizationExpiresAt")


class ShopifyPaymentsFraudSettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("decline_charge_on_avs_failure", "decline_charge_on_cvc_failure")
    decline_charge_on_avs_failure = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="declineChargeOnAvsFailure")
    decline_charge_on_cvc_failure = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="declineChargeOnCvcFailure")


class ShopifyPaymentsNotificationSettings(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("payouts",)
    payouts = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="payouts")


class ShopifyPaymentsPayoutConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsPayoutEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ShopifyPaymentsPayout"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class ShopifyPaymentsPayoutEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("ShopifyPaymentsPayout"), graphql_name="node")


class ShopifyPaymentsPayoutSchedule(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("interval", "monthly_anchor", "weekly_anchor")
    interval = sgqlc.types.Field(sgqlc.types.non_null(ShopifyPaymentsPayoutInterval), graphql_name="interval")
    monthly_anchor = sgqlc.types.Field(Int, graphql_name="monthlyAnchor")
    weekly_anchor = sgqlc.types.Field(DayOfTheWeek, graphql_name="weeklyAnchor")


class ShopifyPaymentsPayoutSummary(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "adjustments_fee",
        "adjustments_gross",
        "charges_fee",
        "charges_gross",
        "refunds_fee",
        "refunds_fee_gross",
        "reserved_funds_fee",
        "reserved_funds_gross",
        "retried_payouts_fee",
        "retried_payouts_gross",
    )
    adjustments_fee = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="adjustmentsFee")
    adjustments_gross = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="adjustmentsGross")
    charges_fee = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="chargesFee")
    charges_gross = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="chargesGross")
    refunds_fee = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="refundsFee")
    refunds_fee_gross = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="refundsFeeGross")
    reserved_funds_fee = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="reservedFundsFee")
    reserved_funds_gross = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="reservedFundsGross")
    retried_payouts_fee = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="retriedPayoutsFee")
    retried_payouts_gross = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="retriedPayoutsGross")


class ShopifyPaymentsRefundSet(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("acquirer_reference_number",)
    acquirer_reference_number = sgqlc.types.Field(String, graphql_name="acquirerReferenceNumber")


class ShopifyPaymentsTransactionSet(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("extended_authorization_set", "refund_set")
    extended_authorization_set = sgqlc.types.Field(ShopifyPaymentsExtendedAuthorization, graphql_name="extendedAuthorizationSet")
    refund_set = sgqlc.types.Field(ShopifyPaymentsRefundSet, graphql_name="refundSet")


class ShopifyPaymentsVerificationDocument(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("back_required", "front_required", "type")
    back_required = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="backRequired")
    front_required = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="frontRequired")
    type = sgqlc.types.Field(sgqlc.types.non_null(ShopifyPaymentsVerificationDocumentType), graphql_name="type")


class ShopifyPaymentsVerificationSubject(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("family_name", "given_name")
    family_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="familyName")
    given_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="givenName")


class StaffMemberConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StaffMemberEdge"))), graphql_name="edges")
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StaffMember"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class StaffMemberEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("StaffMember"), graphql_name="node")


class StaffMemberPrivateData(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("account_settings_url", "created_at")
    account_settings_url = sgqlc.types.Field(sgqlc.types.non_null(URL), graphql_name="accountSettingsUrl")
    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")


class StagedMediaUploadTarget(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("parameters", "resource_url", "url")
    parameters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StagedUploadParameter"))), graphql_name="parameters"
    )
    resource_url = sgqlc.types.Field(URL, graphql_name="resourceUrl")
    url = sgqlc.types.Field(URL, graphql_name="url")


class StagedUploadParameter(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class StagedUploadTarget(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("parameters", "url")
    parameters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ImageUploadParameter))), graphql_name="parameters"
    )
    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")


class StagedUploadTargetGeneratePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("parameters", "url", "user_errors")
    parameters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(MutationsStagedUploadTargetGenerateUploadParameter))),
        graphql_name="parameters",
    )
    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class StagedUploadTargetsGeneratePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("urls", "user_errors")
    urls = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(StagedUploadTarget)), graphql_name="urls")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class StagedUploadsCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("staged_targets", "user_errors")
    staged_targets = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(StagedMediaUploadTarget)), graphql_name="stagedTargets")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class StandardMetafieldDefinitionEnablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("created_definition", "user_errors")
    created_definition = sgqlc.types.Field("MetafieldDefinition", graphql_name="createdDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StandardMetafieldDefinitionEnableUserError"))),
        graphql_name="userErrors",
    )


class StandardMetafieldDefinitionTemplateConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StandardMetafieldDefinitionTemplateEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StandardMetafieldDefinitionTemplate"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class StandardMetafieldDefinitionTemplateEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("StandardMetafieldDefinitionTemplate"), graphql_name="node")


class StandardMetaobjectDefinitionEnablePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("metaobject_definition", "user_errors")
    metaobject_definition = sgqlc.types.Field("MetaobjectDefinition", graphql_name="metaobjectDefinition")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetaobjectUserError"))), graphql_name="userErrors"
    )


class StandardizedProductType(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("product_taxonomy_node",)
    product_taxonomy_node = sgqlc.types.Field("ProductTaxonomyNode", graphql_name="productTaxonomyNode")


class StorefrontAccessTokenConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StorefrontAccessTokenEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StorefrontAccessToken"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class StorefrontAccessTokenCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("shop", "storefront_access_token", "user_errors")
    shop = sgqlc.types.Field(sgqlc.types.non_null("Shop"), graphql_name="shop")
    storefront_access_token = sgqlc.types.Field("StorefrontAccessToken", graphql_name="storefrontAccessToken")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class StorefrontAccessTokenDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("deleted_storefront_access_token_id", "user_errors")
    deleted_storefront_access_token_id = sgqlc.types.Field(ID, graphql_name="deletedStorefrontAccessTokenId")
    user_errors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("UserError"))), graphql_name="userErrors")


class StorefrontAccessTokenEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("StorefrontAccessToken"), graphql_name="node")


class StringConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "page_info")
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("StringEdge"))), graphql_name="edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class StringEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="node")


class SubscriptionAppliedCodeDiscount(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("id", "redeem_code", "rejection_reason")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    redeem_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="redeemCode")
    rejection_reason = sgqlc.types.Field(SubscriptionDiscountRejectionReason, graphql_name="rejectionReason")


class SubscriptionBillingAttemptConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingAttemptEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingAttempt"))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SubscriptionBillingAttemptCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("subscription_billing_attempt", "user_errors")
    subscription_billing_attempt = sgqlc.types.Field("SubscriptionBillingAttempt", graphql_name="subscriptionBillingAttempt")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BillingAttemptUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingAttemptEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionBillingAttempt"), graphql_name="node")


class SubscriptionBillingCycle(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = (
        "billing_attempt_expected_date",
        "billing_attempts",
        "cycle_end_at",
        "cycle_index",
        "cycle_start_at",
        "edited",
        "edited_contract",
        "skipped",
        "source_contract",
        "status",
    )
    billing_attempt_expected_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="billingAttemptExpectedDate")
    billing_attempts = sgqlc.types.Field(
        sgqlc.types.non_null(SubscriptionBillingAttemptConnection),
        graphql_name="billingAttempts",
        args=sgqlc.types.ArgDict(
            (
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("reverse", sgqlc.types.Arg(Boolean, graphql_name="reverse", default=False)),
            )
        ),
    )
    cycle_end_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="cycleEndAt")
    cycle_index = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="cycleIndex")
    cycle_start_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="cycleStartAt")
    edited = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="edited")
    edited_contract = sgqlc.types.Field("SubscriptionBillingCycleEditedContract", graphql_name="editedContract")
    skipped = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="skipped")
    source_contract = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionContract"), graphql_name="sourceContract")
    status = sgqlc.types.Field(sgqlc.types.non_null(SubscriptionBillingCycleBillingCycleStatus), graphql_name="status")


class SubscriptionBillingCycleConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingCycleEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionBillingCycle))), graphql_name="nodes"
    )
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SubscriptionBillingCycleContractDraftCommitPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("contract", "user_errors")
    contract = sgqlc.types.Field("SubscriptionBillingCycleEditedContract", graphql_name="contract")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingCycleContractDraftConcatenatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft", "user_errors")
    draft = sgqlc.types.Field("SubscriptionDraft", graphql_name="draft")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingCycleContractEditPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft", "user_errors")
    draft = sgqlc.types.Field("SubscriptionDraft", graphql_name="draft")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingCycleEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null(SubscriptionBillingCycle), graphql_name="node")


class SubscriptionBillingCycleEditDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("billing_cycles", "user_errors")
    billing_cycles = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionBillingCycle)), graphql_name="billingCycles")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingCycleUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingCycleEditsDeletePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("billing_cycles", "user_errors")
    billing_cycles = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SubscriptionBillingCycle)), graphql_name="billingCycles")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingCycleUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingCycleScheduleEditPayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("billing_cycle", "user_errors")
    billing_cycle = sgqlc.types.Field(SubscriptionBillingCycle, graphql_name="billingCycle")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionBillingCycleUserError"))), graphql_name="userErrors"
    )


class SubscriptionBillingPolicy(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("anchors", "interval", "interval_count", "max_cycles", "min_cycles")
    anchors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(SellingPlanAnchor))), graphql_name="anchors")
    interval = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanInterval), graphql_name="interval")
    interval_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalCount")
    max_cycles = sgqlc.types.Field(Int, graphql_name="maxCycles")
    min_cycles = sgqlc.types.Field(Int, graphql_name="minCycles")


class SubscriptionContractAtomicCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("contract", "user_errors")
    contract = sgqlc.types.Field("SubscriptionContract", graphql_name="contract")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionContractConnection(sgqlc.types.relay.Connection):
    __schema__ = shopify_schema
    __field_names__ = ("edges", "nodes", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionContractEdge"))), graphql_name="edges"
    )
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionContract"))), graphql_name="nodes")
    page_info = sgqlc.types.Field(sgqlc.types.non_null(PageInfo), graphql_name="pageInfo")


class SubscriptionContractCreatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft", "user_errors")
    draft = sgqlc.types.Field("SubscriptionDraft", graphql_name="draft")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionContractEdge(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    node = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionContract"), graphql_name="node")


class SubscriptionContractProductChangePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("contract", "line_updated", "user_errors")
    contract = sgqlc.types.Field("SubscriptionContract", graphql_name="contract")
    line_updated = sgqlc.types.Field("SubscriptionLine", graphql_name="lineUpdated")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionContractSetNextBillingDatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("contract", "user_errors")
    contract = sgqlc.types.Field("SubscriptionContract", graphql_name="contract")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionContractUserError"))), graphql_name="userErrors"
    )


class SubscriptionContractUpdatePayload(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("draft", "user_errors")
    draft = sgqlc.types.Field("SubscriptionDraft", graphql_name="draft")
    user_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SubscriptionDraftUserError"))), graphql_name="userErrors"
    )


class SubscriptionCyclePriceAdjustment(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("adjustment_type", "adjustment_value", "after_cycle", "computed_price")
    adjustment_type = sgqlc.types.Field(sgqlc.types.non_null(SellingPlanPricingPolicyAdjustmentType), graphql_name="adjustmentType")
    adjustment_value = sgqlc.types.Field(sgqlc.types.non_null("SellingPlanPricingPolicyAdjustmentValue"), graphql_name="adjustmentValue")
    after_cycle = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="afterCycle")
    computed_price = sgqlc.types.Field(sgqlc.types.non_null(MoneyV2), graphql_name="computedPrice")


class SubscriptionDeliveryMethodLocalDelivery(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("address", "local_delivery_option")
    address = sgqlc.types.Field(sgqlc.types.non_null("SubscriptionMailingAddress"), graphql_name="address")
    local_delivery_option = sgqlc.types.Field(
        sgqlc.types.non_null("SubscriptionDeliveryMethodLocalDeliveryOption"), graphql_name="localDeliveryOption"
    )


class SubscriptionDeliveryMethodLocalDeliveryOption(sgqlc.types.Type):
    __schema__ = shopify_schema
    __field_names__ = ("code", "description", "instructions", "phone", "presentment_title", "title")
    code = sgqlc.types.Field(String, graphql_name="code")
    description = sgqlc.types.Field(String, graphql_name="description")
    instructions = sgqlc.types.Field(String, graphql_name="instructions")
    phone = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="phone")
    presentment_title = sgqlc.types.Field(String, graphql_name="presentmentTitle")
    title = sgqlc.types.Field(String, graphql_name="title")


class SubscriptionDeliveryMethodPickup(sgqlc.types.Type):
    __schema__ = shopify_schema
    __f