import numpy as np


def write_poscar(axis, positions, elements, filename="POSCAR"):
    """Write the generated structure to a VASP POSCAR file."""
    _elements = np.array(elements)
    unique_elements, first_indices = np.unique(_elements, return_index=True)
    sorted_elements = unique_elements[np.argsort(first_indices)]
    atom_counts = np.array([np.count_nonzero(_elements == el) for el in sorted_elements])

    with open(filename, "w") as f:
        print("Generated by rsspolymlp", file=f)
        print("1.0", file=f)
        for n in axis.T:
            print(
                "  ",
                "{0:15.15f}".format(n[0]),
                "{0:15.15f}".format(n[1]),
                "{0:15.15f}".format(n[2]),
                file=f,
            )
        for idx, n in enumerate(atom_counts):
            if n > 0:
                print(sorted_elements[idx], " ", end="", file=f)
        print("", file=f)
        for n in atom_counts:
            if n > 0:
                print(n, " ", end="", file=f)
        print("", file=f)
        print("Direct", file=f)
        for n in positions.T:
            print(
                "  ",
                "{0:15.15f}".format(float(n[0])),
                "{0:15.15f}".format(float(n[1])),
                "{0:15.15f}".format(float(n[2])),
                file=f,
            )
