"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eks = require("@aws-cdk/aws-eks");
const kms = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const kong_core_1 = require("kong-core");
const index_1 = require("./resources/helm-charts/kong/index");
const index_2 = require("./resources/helm-charts/private-ca/index");
/**
 * @stability stable
 * @summary The KongEks class.
 */
class KongEks extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @stability stable
     * @summary Constructs a new instance of the KongEks class.
     * @since 0.1.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // this.cluster_dns = 'cluster.kong-cp.internal';
        // this.telemetry_dns = 'telemetry.kong-cp.internal';
        // const kong_control_plane_namespace = 'kong';
        //TODO : Modularize this further
        const control_plane_secretskey = new kms.Key(this, 'CPSecretsKey');
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        this.controlPlane = new eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addAutoScalingGroupCapacity('CpASG', props.controlPlaneNodeProps);
        core_1.Tags.of(cp_nodegroup).add('aws-node-termination-handler/managed', 'true');
        core_1.Tags.of(cp_nodegroup).add('k8s.io/cluster-autoscaler/enabled', 'TRUE');
        core_1.Tags.of(cp_nodegroup).add(`k8s.io/cluster-autoscaler/${this.controlPlane.clusterName}`, 'owned');
        new kong_core_1.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core_1.EksNodeHandler(this, 'NodeHandler', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
        });
        new kong_core_1.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        new kong_core_1.Telemetry(this, 'KongLogging', {
            cluster: this.controlPlane,
            namespace: 'telemetry',
        });
        const kong_rds_instance = new kong_core_1.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const private_ca = new index_2.PrivateCA(this, 'KongPCA', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: props.namespace,
            cacertname: 'kong-cp-ca-cert',
            clusterIssuerName: 'kong-cp-cluster-issuer',
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                'kong-cp.internal',
                'admin.kong-cp.internal',
                props.clusterDns,
                props.telemetryDns,
                'manager.kong-cp.internal',
            ],
        });
        this.privateCaArn = private_ca.private_ca_arn;
        // const secrets_manager_provider = new SecretsManager(this, 'KongSMProvider', {
        //   cluster: this.control_plane,
        //   namespace: kong_control_plane_namespace,
        //   nodegroup: cp_nodegroup,
        // });
        const kong_helm = new index_1.KongControlPlane(this, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            nodegroup: cp_nodegroup,
        });
        kong_helm.node.addDependency(private_ca);
        // new CfnOutput(this, 'NodeHandlerSAOutput', { value: node_termination_handler.service_account.role.roleArn });
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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