import * as eks from '@aws-cdk/aws-eks';
import { Construct } from '@aws-cdk/core';
import { KongEksControlPlaneProps } from 'kong-core';
/**
 * @stability stable
 * @summary The KongEks class.
 */
export declare class KongEks extends Construct {
    /**
     * @stability stable
     */
    readonly controlPlane: eks.Cluster;
    /**
     * @stability stable
     */
    privateCaArn: string;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @stability stable
     * @summary Constructs a new instance of the KongEks class.
     * @since 0.1.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: KongEksControlPlaneProps);
}
