# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_python_api.api_client import ApiClient


class ClientsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, body, **kwargs):  # noqa: E501
        """Creates a new person.  # noqa: E501

        Creates a new person. Required fields are presented in the example. Other fields (from PUT) may also be specified here.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerPersonDTO body: Brand new person. (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new person.  # noqa: E501

        Creates a new person. Required fields are presented in the example. Other fields (from PUT) may also be specified here.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerPersonDTO body: Brand new person. (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerPersonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create1(self, body, **kwargs):  # noqa: E501
        """Creates a new client.  # noqa: E501

        Creates a new client. Required fields are presented in the example. Other fields (from PUT) may also be specified here.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerDTO body: Created user object (required)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create1_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create1_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create1_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new client.  # noqa: E501

        Creates a new client. Required fields are presented in the example. Other fields (from PUT) may also be specified here.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerDTO body: Created user object (required)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete1(self, person_id, **kwargs):  # noqa: E501
        """Removes a person.  # noqa: E501

        Removes a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete1_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete1_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def delete1_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Removes a person.  # noqa: E501

        Removes a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `delete1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete1_0(self, price_list_id, **kwargs):  # noqa: E501
        """Removes a customer price list.  # noqa: E501

        Removes a customer price list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1_0(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: customer price list's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete1_0_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete1_0_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def delete1_0_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Removes a customer price list.  # noqa: E501

        Removes a customer price list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1_0_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: customer price list's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete1_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `delete1_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/priceLists/{priceListId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete2(self, customer_id, **kwargs):  # noqa: E501
        """Removes a client.  # noqa: E501

        Removes a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete2_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete2_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def delete2_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Removes a client.  # noqa: E501

        Removes a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_single_use_sign_in_token(self, body, **kwargs):  # noqa: E501
        """Generates a single use sign-in token.  # noqa: E501

        Generates a single use sign-in token for the customer person found for given login or e-mail. Returns 'url' and 'token' which allows to sign-in to customer portal as this person. Token is valid for two minutes and can be used only once. To sign-in to customer portal you should post 'token' provided as the 'accessToken' form param to the 'url' using POST method.Detailed description is available in the Customer API <a href=\"/api-doc/customer-api/authentication\">authentication</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_single_use_sign_in_token(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessTokenRequestDTO body: Generated sign-in token. (required)
        :return: AccessTokenDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_single_use_sign_in_token_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_single_use_sign_in_token_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def generate_single_use_sign_in_token_with_http_info(self, body, **kwargs):  # noqa: E501
        """Generates a single use sign-in token.  # noqa: E501

        Generates a single use sign-in token for the customer person found for given login or e-mail. Returns 'url' and 'token' which allows to sign-in to customer portal as this person. Token is valid for two minutes and can be used only once. To sign-in to customer portal you should post 'token' provided as the 'accessToken' form param to the 'url' using POST method.Detailed description is available in the Customer API <a href=\"/api-doc/customer-api/authentication\">authentication</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_single_use_sign_in_token_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessTokenRequestDTO body: Generated sign-in token. (required)
        :return: AccessTokenDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_single_use_sign_in_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `generate_single_use_sign_in_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/accessToken', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessTokenDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address(self, customer_id, **kwargs):  # noqa: E501
        """Returns address of a given client.  # noqa: E501

        Returns address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_address_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns address of a given client.  # noqa: E501

        Returns address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/address', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids1(self, **kwargs):  # noqa: E501
        """Returns persons' internal identifiers.  # noqa: E501

        Returns persons' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only persons modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids1_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids1_with_http_info(self, **kwargs):  # noqa: E501
        """Returns persons' internal identifiers.  # noqa: E501

        Returns persons' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only persons modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids1" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids2(self, **kwargs):  # noqa: E501
        """Returns clients' internal identifiers.  # noqa: E501

        Returns clients' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids2(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only clients modified since this timestamp
        :param str name_equals: exact name of client
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids2_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids2_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids2_with_http_info(self, **kwargs):  # noqa: E501
        """Returns clients' internal identifiers.  # noqa: E501

        Returns clients' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only clients modified since this timestamp
        :param str name_equals: exact name of client
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since', 'name_equals']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids2" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501
        if 'name_equals' in params:
            query_params.append(('nameEquals', params['name_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_names_with_ids(self, **kwargs):  # noqa: E501
        """Returns list of simple clients representations  # noqa: E501

        Returns list of simple clients representations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_names_with_ids(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only clients modified since this timestamp
        :return: list[EntityWithNameDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_names_with_ids_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_names_with_ids_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_names_with_ids_with_http_info(self, **kwargs):  # noqa: E501
        """Returns list of simple clients representations  # noqa: E501

        Returns list of simple clients representations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_names_with_ids_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only clients modified since this timestamp
        :return: list[EntityWithNameDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_names_with_ids" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityWithNameDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id1(self, person_id, **kwargs):  # noqa: E501
        """Returns person details.  # noqa: E501

        Returns person details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id1(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id1_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id1_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_by_id1_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns person details.  # noqa: E501

        Returns person details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id1_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_by_id1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerPersonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id2(self, customer_id, **kwargs):  # noqa: E501
        """Returns client details.  # noqa: E501

        Returns client details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id2(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. persons)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id2_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id2_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_by_id2_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns client details.  # noqa: E501

        Returns client details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id2_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. persons)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'embed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_by_id2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_categories(self, customer_id, **kwargs):  # noqa: E501
        """Returns categories of a given client.  # noqa: E501

        Returns categories of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: CategoriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_categories_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_categories_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_categories_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns categories of a given client.  # noqa: E501

        Returns categories of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: CategoriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoriesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contact(self, person_id, **kwargs):  # noqa: E501
        """Returns contact of a given person.  # noqa: E501

        Returns contact of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contact_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contact_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_contact_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns contact of a given person.  # noqa: E501

        Returns contact of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_contact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}/contact', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contact1(self, customer_id, **kwargs):  # noqa: E501
        """Returns contact of a given client.  # noqa: E501

        Returns contact of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact1(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contact1_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contact1_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_contact1_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns contact of a given client.  # noqa: E501

        Returns contact of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact1_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contact1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_contact1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/contact', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_correspondence_address(self, customer_id, **kwargs):  # noqa: E501
        """Returns correspondence address of a given client.  # noqa: E501

        Returns correspondence address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correspondence_address(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_correspondence_address_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_correspondence_address_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_correspondence_address_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns correspondence address of a given client.  # noqa: E501

        Returns correspondence address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correspondence_address_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_correspondence_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_correspondence_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/correspondenceAddress', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_field(self, customer_id, custom_field_key, **kwargs):  # noqa: E501
        """Returns custom field of a given client.  # noqa: E501

        Returns custom field of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_field(customer_id, custom_field_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :param str custom_field_key: custom field's key (required)
        :return: CustomFieldDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_field_with_http_info(customer_id, custom_field_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_field_with_http_info(customer_id, custom_field_key, **kwargs)  # noqa: E501
            return data

    def get_custom_field_with_http_info(self, customer_id, custom_field_key, **kwargs):  # noqa: E501
        """Returns custom field of a given client.  # noqa: E501

        Returns custom field of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_field_with_http_info(customer_id, custom_field_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :param str custom_field_key: custom field's key (required)
        :return: CustomFieldDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'custom_field_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_custom_field`")  # noqa: E501
        # verify the required parameter 'custom_field_key' is set
        if ('custom_field_key' not in params or
                params['custom_field_key'] is None):
            raise ValueError("Missing the required parameter `custom_field_key` when calling `get_custom_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'custom_field_key' in params:
            path_params['customFieldKey'] = params['custom_field_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/customFields/{customFieldKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields(self, person_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given person.  # noqa: E501

        Returns custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given person.  # noqa: E501

        Returns custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields1(self, customer_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given client.  # noqa: E501

        Returns custom fields of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields1(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields1_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields1_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields1_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given client.  # noqa: E501

        Returns custom fields of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields1_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_custom_fields1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_industries(self, customer_id, **kwargs):  # noqa: E501
        """Returns industries of a given client.  # noqa: E501

        Returns industries of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_industries(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: IndustriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_industries_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_industries_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_industries_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Returns industries of a given client.  # noqa: E501

        Returns industries of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_industries_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: client's internal identifier (required)
        :return: IndustriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_industries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_industries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/industries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndustriesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, body, person_id, **kwargs):  # noqa: E501
        """Updates an existing person.  # noqa: E501

        Only specified fields will be changed. One may not specify embeddable fields here - use separate API calls for updating them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerPersonDTO body: Updated existing person. (required)
        :param int person_id: person's internal identifier (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(body, person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(body, person_id, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, body, person_id, **kwargs):  # noqa: E501
        """Updates an existing person.  # noqa: E501

        Only specified fields will be changed. One may not specify embeddable fields here - use separate API calls for updating them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerPersonDTO body: Updated existing person. (required)
        :param int person_id: person's internal identifier (required)
        :return: CustomerPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerPersonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_0(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates an existing client.  # noqa: E501

        Only specified fields will be changed (id is required). One may not specify embeddable fields here - use separate API calls for updating them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_0(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerDTO body: Updated client (required)
        :param int customer_id: client's internal identifier (required)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_0_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates an existing client.  # noqa: E501

        Only specified fields will be changed (id is required). One may not specify embeddable fields here - use separate API calls for updating them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_0_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerDTO body: Updated client (required)
        :param int customer_id: client's internal identifier (required)
        :return: CustomerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_0`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_address(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates address of a given client.  # noqa: E501

        Updates address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_address(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressDTO body: Updated address of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_address_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_address_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_address_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates address of a given client.  # noqa: E501

        Updates address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_address_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressDTO body: Updated address of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/address', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_categories(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates categories of a given client.  # noqa: E501

        Updates categories of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_categories(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: Updated categories of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: CategoriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_categories_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_categories_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_categories_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates categories of a given client.  # noqa: E501

        Updates categories of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_categories_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: Updated categories of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: CategoriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_categories`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/categories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoriesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_contact(self, body, person_id, **kwargs):  # noqa: E501
        """Updates contact of a given person.  # noqa: E501

        Updates contact of a given person. Sets that this person uses specific address and contact (not the one from customer).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contact(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonContactDTO body: Updated contact of a given person. (required)
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_contact_with_http_info(body, person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_contact_with_http_info(body, person_id, **kwargs)  # noqa: E501
            return data

    def update_contact_with_http_info(self, body, person_id, **kwargs):  # noqa: E501
        """Updates contact of a given person.  # noqa: E501

        Updates contact of a given person. Sets that this person uses specific address and contact (not the one from customer).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contact_with_http_info(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonContactDTO body: Updated contact of a given person. (required)
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_contact`")  # noqa: E501
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `update_contact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}/contact', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_contact_0(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates contact of a given client.  # noqa: E501

        Updates contact of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contact_0(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactDTO body: Updated contact of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_contact_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_contact_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_contact_0_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates contact of a given client.  # noqa: E501

        Updates contact of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contact_0_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactDTO body: Updated contact of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contact_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_contact_0`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_contact_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/contact', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_correspondence_address(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates correspondence address of a given client.  # noqa: E501

        Updates correspondence address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_correspondence_address(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressDTO body: Updated address of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_correspondence_address_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_correspondence_address_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_correspondence_address_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates correspondence address of a given client.  # noqa: E501

        Updates correspondence address of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_correspondence_address_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressDTO body: Updated address of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_correspondence_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_correspondence_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_correspondence_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/correspondenceAddress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_field(self, body, customer_id, custom_field_key, **kwargs):  # noqa: E501
        """Updates given custom field of a given client.  # noqa: E501

        Updates given custom field of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_field(body, customer_id, custom_field_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFieldDTO body: Updated custom field of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :param str custom_field_key: custom field's key (required)
        :return: CustomFieldDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_field_with_http_info(body, customer_id, custom_field_key, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_field_with_http_info(body, customer_id, custom_field_key, **kwargs)  # noqa: E501
            return data

    def update_custom_field_with_http_info(self, body, customer_id, custom_field_key, **kwargs):  # noqa: E501
        """Updates given custom field of a given client.  # noqa: E501

        Updates given custom field of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_field_with_http_info(body, customer_id, custom_field_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFieldDTO body: Updated custom field of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :param str custom_field_key: custom field's key (required)
        :return: CustomFieldDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'custom_field_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_field`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_custom_field`")  # noqa: E501
        # verify the required parameter 'custom_field_key' is set
        if ('custom_field_key' not in params or
                params['custom_field_key'] is None):
            raise ValueError("Missing the required parameter `custom_field_key` when calling `update_custom_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'custom_field_key' in params:
            path_params['customFieldKey'] = params['custom_field_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/customFields/{customFieldKey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_fields(self, body, person_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given person.  # noqa: E501

        Updates custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given person. (required)
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_fields_with_http_info(body, person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_fields_with_http_info(body, person_id, **kwargs)  # noqa: E501
            return data

    def update_custom_fields_with_http_info(self, body, person_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given person.  # noqa: E501

        Updates custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields_with_http_info(body, person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given person. (required)
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_fields`")  # noqa: E501
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `update_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/persons/{personId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_fields_0(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given client.  # noqa: E501

        Updates custom fields of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields_0(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_fields_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_fields_0_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_custom_fields_0_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given client.  # noqa: E501

        Updates custom fields of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields_0_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_fields_0`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_custom_fields_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_industries(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates industries of a given client.  # noqa: E501

        Updates industries of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_industries(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: Updated industries of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: IndustriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_industries_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_industries_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def update_industries_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Updates industries of a given client.  # noqa: E501

        Updates industries of a given client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_industries_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: Updated industries of a given client. (required)
        :param int customer_id: client's internal identifier (required)
        :return: IndustriesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_industries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_industries`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_industries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/industries', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndustriesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
