# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-10-13 22:13
from __future__ import unicode_literals

from django.db import migrations, models
from filebrowser.fields import FileBrowseField


def fill_subscription_type_backup_table(apps, schema_editor):
    Subscription = apps.get_model("subscriptions", "Subscription")
    SubscriptionType = apps.get_model("subscriptions", "SubscriptionType")
    SubscriptionTypeBackup = apps.get_model("subscriptions", "SubscriptionTypeBackup")
    db_alias = schema_editor.connection.alias
    all_subscription_types = SubscriptionType.objects.using(db_alias).all()
    for subscription_type in all_subscription_types:
        subscription_type_backup = SubscriptionTypeBackup.objects.using(db_alias).create(
            cancellation_period=subscription_type.cancelationPeriod,
            automatic_contract_extension=subscription_type.automaticContractExtension,
            automatic_contract_extension_reminder=subscription_type.automaticContractExtensionReminder,
            minimum_duration=subscription_type.minimumDuration,
            payment_interval=subscription_type.paymentIntervall,
            contract_document=subscription_type.contractDocument,
            description=subscription_type.description,
            title=subscription_type.title,
            product_number=subscription_type.product_number,
            default_unit=subscription_type.default_unit,
            date_of_creation=subscription_type.date_of_creation,
            last_modification=subscription_type.last_modification,
            last_modified_by=subscription_type.last_modified_by,
            tax=subscription_type.tax,
            old_id=subscription_type.id)
        subscription_type_backup.save()
        subscriptions = Subscription.objects.using(db_alias).all()
        if len(subscriptions) > 0:
            for subscription in subscriptions:
                if subscription.subscriptiontype is not None:
                    subscription.subscription_type_backup = subscription.subscriptiontype.id
                    subscription.save()


def reverse_func(apps, schema_editor):
    return 1


class Migration(migrations.Migration):

    dependencies = [
        ('crm', '0047_work_worked_hours'),
        ('subscriptions', '0003_auto_20171110_1732'),
    ]

    operations = [
        migrations.RenameField(
            model_name='subscriptionevent',
            old_name='eventdate',
            new_name='event_date',
        ),
        migrations.AddField(
            model_name='Subscription',
            name='subscription_type_backup',
            field=models.IntegerField(blank=True, null=True, verbose_name='Subscription Type Backup'),
        ),
        migrations.CreateModel(
            name='SubscriptionTypeBackup',
            fields=[
                ('cancellation_period', models.IntegerField(verbose_name="Cancellation Period (months)",
                                                            blank=True,
                                                            null=True)),
                ('automatic_contract_extension', models.IntegerField(
                    verbose_name="Automatic Contract Extension (months)",
                    blank=True,
                    null=True)),
                ('automatic_contract_extension_reminder', models.IntegerField(
                    verbose_name="Automatic Contract Extension Reminder (days)",
                    blank=True,
                    null=True)),
                ('minimum_duration', models.IntegerField(verbose_name="Minimum Contract Duration",
                                                         blank=True,
                                                         null=True)),
                ('payment_interval', models.IntegerField(verbose_name="Payment Interval (days)",
                                                         blank=True,
                                                         null=True)),
                ('contract_document', FileBrowseField(verbose_name="Contract Documents",
                                                      blank=True,
                                                      null=True,
                                                      max_length=200)),
                ('description', models.TextField(verbose_name="Description",
                                                 null=True,
                                                 blank=True)),
                ('title', models.CharField(verbose_name="Title",
                                           max_length=200)),
                ('product_number', models.IntegerField(verbose_name="Product Number")),
                ('default_unit', models.ForeignKey("crm.Unit", on_delete=models.deletion.CASCADE,
                                                   verbose_name="Unit")),
                ('date_of_creation', models.DateTimeField(verbose_name="Created at",
                                                          auto_now_add=True)),
                ('last_modification', models.DateTimeField(verbose_name="Last modified",
                                                           auto_now=True)),
                ('last_modified_by', models.ForeignKey('auth.User',
                                                       on_delete=models.deletion.CASCADE,
                                                       limit_choices_to={'is_staff': True},
                                                       verbose_name="Last modified by",
                                                       null=True,
                                                       blank="True")),
                ('tax', models.ForeignKey("crm.Tax",
                                          on_delete=models.deletion.CASCADE,
                                          blank=False)),
                ('old_id', models.IntegerField(blank=True,
                                               null=True,
                                               verbose_name='Subscription Type Backup')),
            ],
            options={
                'verbose_name': 'SubscriptionTypeBackup',
                'verbose_name_plural': 'SubscriptionTypeBackups',
            },
        ),
        migrations.RunPython(fill_subscription_type_backup_table, reverse_func),
        migrations.RemoveField(
            model_name='subscription',
            name='subscriptiontype',
        ),
        migrations.DeleteModel('SubscriptionType'),
    ]
