# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-10-12 20:56
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def initiate_human_resource(apps, schema_editor):
    Work = apps.get_model("crm", "Work")
    HumanResource = apps.get_model("crm", "HumanResource")
    db_alias = schema_editor.connection.alias
    all_works = Work.objects.using(db_alias).all()
    for work in all_works:
        all_human_resources = HumanResource.objects.using(db_alias).all()
        human_resource_found = False
        for human_resource in all_human_resources:
            if work.employee == human_resource.user:
                human_resource_found = True
                work.human_resource = human_resource
                break
        if not human_resource_found:
            new_human_resource = HumanResource.objects.using(db_alias).create(user=work.employee)
            new_human_resource.save()
            work.human_resource = new_human_resource
        work.save()


def reverse_func(apps, schema_editor):
    return 1


class Migration(migrations.Migration):

    dependencies = [
        ('crm', '0052_auto_20181014_2304'),
    ]

    operations = [
        migrations.AlterField(
            model_name='customergrouptransform',
            name='product_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product Type'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='unittransform',
            name='product_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product Type'),
            preserve_default=False,
        ),
        migrations.RemoveField(
            model_name='customergrouptransform',
            name='product_backup',
        ),
        migrations.RemoveField(
            model_name='position',
            name='product_backup',
        ),
        migrations.RemoveField(
            model_name='price',
            name='product_backup',
        ),
        migrations.RemoveField(
            model_name='unittransform',
            name='product_backup',
        ),

        migrations.AddField(
            model_name='producttype',
            name='accounting_product_category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.ProductCategory', verbose_name='Accounting Product Category'),
            preserve_default=False,
        ),
        migrations.RemoveField(model_name='producttype',
                               name='accounting_product_categorie'),
        migrations.AlterModelOptions(
            name='producttype',
            options={'verbose_name': 'Product Type', 'verbose_name_plural': 'Product Types'},
        ),
        migrations.RemoveField(
            model_name='producttype',
            name='product_number',
        ),
        migrations.AddField(
            model_name='producttype',
            name='product_type_identifier',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Product Number'),
        ),
        migrations.AlterField(
            model_name='position',
            name='product_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product'),
        ),
        migrations.AlterField(
            model_name='productprice',
            name='product_type',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product Type'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='producttype',
            name='last_modified_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Last modified by'),
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(verbose_name="Product Number",
                                                max_length=200,
                                                null=True,
                                                blank=True)),
                ('product_type', models.ForeignKey("ProductType", on_delete=django.db.models.deletion.CASCADE, verbose_name='Product Type')),
            ],
            options={
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
            },
        ),
        migrations.CreateModel(
            name='Agreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_from', models.DateField(verbose_name='Agreement From')),
                ('date_until', models.DateField(verbose_name='Agreement To')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True, verbose_name='Amount')),
            ],
            options={
                'verbose_name': 'Agreement',
                'verbose_name_plural': 'Agreements',
            },
        ),
        migrations.CreateModel(
            name='AgreementStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('is_agreed', models.BooleanField(verbose_name='Status represents agreement exists')),
            ],
            options={
                'verbose_name': 'Agreement Status',
                'verbose_name_plural': 'Agreement Status',
            },
        ),
        migrations.CreateModel(
            name='AgreementType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=300, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
            ],
            options={
                'verbose_name': 'Agreement Type',
                'verbose_name_plural': 'Agreement Type',
            },
        ),
        migrations.CreateModel(
            name='CurrencyTransform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('factor', models.IntegerField(blank=True, null=True, verbose_name='Factor between From and To Currency')),
                ('from_currency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransformfromcurrency', to='crm.Currency', verbose_name='From Currency')),
            ],
            options={
                'verbose_name': 'Currency Transform',
                'verbose_name_plural': 'Currency Transforms',
            },
        ),
        migrations.CreateModel(
            name='Estimation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_from', models.DateField(verbose_name='Estimation From')),
                ('date_until', models.DateField(verbose_name='Estimation To')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True, verbose_name='Amount')),
                ('reporting_period', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ReportingPeriod', verbose_name='Reporting Period based on which the estimation was done')),
            ],
            options={
                'verbose_name': 'Estimation of Resource Consumption',
                'verbose_name_plural': 'Estimation of Resource Consumptions',
            },
        ),
        migrations.CreateModel(
            name='EstimationStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('is_obsolete', models.BooleanField(verbose_name='Status represents estimation is obsolete')),
            ],
            options={
                'verbose_name': 'Estimation Status',
                'verbose_name_plural': 'Estimation Status',
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='ResourceManager',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.UserExtension', verbose_name='User')),
            ],
        ),
        migrations.CreateModel(
            name='ResourcePrice',
            fields=[
                ('price_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.Price')),
            ],
            bases=('crm.price',),
        ),
        migrations.CreateModel(
            name='ResourceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=300, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
            ],
            options={
                'verbose_name': 'Resource Link Type',
                'verbose_name_plural': 'Resource Link Type',
            },
        ),
        migrations.RemoveField(
            model_name='employeeassignmenttotask',
            name='employee',
        ),
        migrations.RemoveField(
            model_name='employeeassignmenttotask',
            name='task',
        ),
        migrations.AlterModelOptions(
            name='customergrouptransform',
            options={'verbose_name': 'Customer Group Price Transform', 'verbose_name_plural': 'Customer Group Price Transforms'},
        ),
        migrations.AlterModelOptions(
            name='product',
            options={},
        ),
        migrations.AlterModelOptions(
            name='unittransform',
            options={'verbose_name': 'Unit Transform', 'verbose_name_plural': 'Unit Transforms'},
        ),
        migrations.RenameField(
            model_name='genericprojectlink',
            old_name='task',
            new_name='project',
        ),
        migrations.RemoveField(
            model_name='task',
            name='planned_end_date',
        ),
        migrations.RemoveField(
            model_name='task',
            name='planned_start_date',
        ),
        migrations.AddField(
            model_name='project',
            name='default_currency',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='crm.Currency', verbose_name='Default Currency'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='customergrouptransform',
            name='from_customer_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransfromfromcustomergroup', to='crm.CustomerGroup', verbose_name='From Customer Group'),
        ),
        migrations.AlterField(
            model_name='customergrouptransform',
            name='to_customer_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransfromtocustomergroup', to='crm.CustomerGroup', verbose_name='To Customer Group'),
        ),
        migrations.AlterField(
            model_name='salesdocument',
            name='custom_date_field',
            field=models.DateField(blank=True, null=True, verbose_name='Custom Date'),
        ),
        migrations.CreateModel(
            name='HumanResource',
            fields=[
                ('resource_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.Resource')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.UserExtension', verbose_name='User')),
            ],
            bases=('crm.resource',),
        ),
        migrations.DeleteModel(
            name='EmployeeAssignmentToTask',
        ),
        migrations.AddField(
            model_name='resourceprice',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Resource', verbose_name='Resource'),
        ),
        migrations.AddField(
            model_name='resource',
            name='resource_manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.ResourceManager', verbose_name='Manager'),
        ),
        migrations.AddField(
            model_name='resource',
            name='resource_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.ResourceType', verbose_name='Resource Type'),
        ),
        migrations.AddField(
            model_name='estimation',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Resource'),
        ),
        migrations.AddField(
            model_name='estimation',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.EstimationStatus', verbose_name='Status of the estimation'),
        ),
        migrations.AddField(
            model_name='estimation',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Task', verbose_name='Task'),
        ),
        migrations.AddField(
            model_name='currencytransform',
            name='to_currency',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransformtocurrency', to='crm.Currency', verbose_name='To Currency'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='costs',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ResourcePrice'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Resource'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.AgreementStatus'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Task', verbose_name='Task'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.AgreementType'),
        ),
        migrations.AddField(
            model_name='agreement',
            name='unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Unit'),
        ),
        migrations.AddField(
            model_name='work',
            name='human_resource',
            field=models.ForeignKey(null=True, to='crm.HumanResource', on_delete=django.db.models.deletion.SET_NULL),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='currencytransform',
            name='product_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product'),
        ),
        migrations.RunPython(initiate_human_resource, reverse_func),
        migrations.RemoveField(
            model_name='work',
            name='employee',
        ),
        migrations.AlterField(
            model_name='product',
            name='product_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.ProductType', verbose_name='Product Type'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='work',
            name='human_resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.HumanResource'),
        ),
    ]
