# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-10-12 20:56
from __future__ import unicode_literals
from django.db import migrations


def reverse_func(apps, schema_editor):
    return 1


def backup_identifiers(apps, schema_editor):
    Position = apps.get_model("crm", "Position")
    CustomerGroupTransform = apps.get_model("crm", "CustomerGroupTransform")
    Price = apps.get_model("crm", "Price")
    UnitTransform = apps.get_model("crm", "UnitTransform")
    db_alias = schema_editor.connection.alias
    all_positions = Position.objects.using(db_alias).all()
    for position in all_positions:
        position.product_backup = position.product.id
        position.save()
    all_customer_group_transforms = CustomerGroupTransform.objects.using(db_alias).all()
    for customer_group_transform in all_customer_group_transforms:
        customer_group_transform.product_backup = customer_group_transform.product.id
        customer_group_transform.save()
    all_prices = Price.objects.using(db_alias).all()
    for price in all_prices:
        price.product_backup = price.product.id
        price.save()
    all_unit_transforms = UnitTransform.objects.using(db_alias).all()
    for unit_transform in all_unit_transforms:
        unit_transform.product_backup = unit_transform.product.id
        unit_transform.save()


class Migration(migrations.Migration):

    dependencies = [
        ('crm', '0048_auto_20181012_2056'),
    ]

    operations = [
        migrations.RunPython(backup_identifiers, reverse_func),
    ]
