# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-06-06 20:34
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('crm', '0026_auto_20180507_1957'),
    ]

    operations = [
        migrations.CreateModel(
            name='Call',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(verbose_name='Description')),
                ('date_of_creation', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('date_due', models.DateTimeField(blank=True, default=datetime.datetime.now, verbose_name='Date due')),
                ('last_modification', models.DateTimeField(auto_now=True, verbose_name='Last modified')),
                ('status', models.CharField(choices=[('P', 'Planned'), ('D', 'Delayed'), ('R', 'ToRecall'), ('F', 'Failed'), ('S', 'Success')], default='P', max_length=1, verbose_name='Status')),
            ],
        ),
        migrations.CreateModel(
            name='ContactPersonAssociation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='person_association', to='crm.Contact')),
            ],
            options={
                'verbose_name': 'Contacts',
                'verbose_name_plural': 'Contacts',
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prefix', models.CharField(blank=True, choices=[('F', 'Company'), ('W', 'Mrs'), ('H', 'Mr'), ('G', 'Ms')], max_length=1, null=True, verbose_name='Prefix')),
                ('name', models.CharField(blank=True, max_length=100, null=True, verbose_name='Name')),
                ('prename', models.CharField(blank=True, max_length=100, null=True, verbose_name='Prename')),
                ('email', models.EmailField(max_length=200, verbose_name='Email Address')),
                ('phone', models.CharField(max_length=20, verbose_name='Phone Number')),
                ('role', models.CharField(blank=True, max_length=100, null=True, verbose_name='Role')),
                ('companies', models.ManyToManyField(blank=True, through='crm.ContactPersonAssociation', to='crm.Contact', verbose_name='Works at')),
            ],
            options={
                'verbose_name': 'Person',
                'verbose_name_plural': 'People',
            },
        ),
        migrations.AddField(
            model_name='customer',
            name='is_lead',
            field=models.BooleanField(default=True),
        ),
        migrations.CreateModel(
            name='CallForContact',
            fields=[
                ('call_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.Call')),
                ('purpose', models.CharField(choices=[('F', 'First commercial call'), ('S', 'Planned commercial call'), ('A', 'Assistance call')], max_length=1, verbose_name='Purpose')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contact')),
                ('cperson', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Person', verbose_name='Person')),
            ],
            options={
                'verbose_name': 'Call',
                'verbose_name_plural': 'Calls',
            },
            bases=('crm.call',),
        ),
        migrations.CreateModel(
            name='VisitForContact',
            fields=[
                ('call_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.Call')),
                ('purpose', models.CharField(choices=[('F', 'First commercial visit'), ('S', 'Installation')], max_length=1, verbose_name='Purpose')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contact')),
                ('cperson', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Person', verbose_name='Person')),
                ('ref_call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.CallForContact', verbose_name='Reference Call')),
            ],
            options={
                'verbose_name': 'Visit',
                'verbose_name_plural': 'Visits',
            },
            bases=('crm.call',),
        ),
        migrations.AddField(
            model_name='contactpersonassociation',
            name='person',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contact_association', to='crm.Person'),
        ),
        migrations.AddField(
            model_name='call',
            name='last_modified_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='db_calllstmodified', to=settings.AUTH_USER_MODEL, verbose_name='Last modified by'),
        ),
        migrations.AddField(
            model_name='call',
            name='staff',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='db_relcallstaff', to=settings.AUTH_USER_MODEL, verbose_name='Staff'),
        ),
    ]
