# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-04-13 19:37
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('djangoUserExtension', '0004_auto_20171210_2126'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('crm', '0024_auto_20180122_2121'),
    ]

    operations = [
        migrations.CreateModel(
            name='EmployeeAssignmentToTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('planned_effort', models.DecimalField(decimal_places=2, max_digits=10, verbose_name='Effort')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.UserExtension')),
            ],
            options={
                'verbose_name': 'Employee Assignment',
                'verbose_name_plural': 'Employee Assignments',
            },
        ),
        migrations.CreateModel(
            name='GenericTaskLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'Task Link',
                'verbose_name_plural': 'Task Links',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('short_description', models.CharField(blank=True, max_length=100, null=True, verbose_name='Description')),
                ('planned_start_date', models.DateField(verbose_name='Planned Start Date')),
                ('planned_end_date', models.DateField(verbose_name='Planned End Date')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('last_status_change', models.DateField(blank=True, verbose_name='Last Status Change')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract', verbose_name='Contract')),
            ],
            options={
                'verbose_name': 'Task',
                'verbose_name_plural': 'Tasks',
            },
        ),
        migrations.CreateModel(
            name='TaskLinkType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=300, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
            ],
            options={
                'verbose_name': 'Task Link Type',
                'verbose_name_plural': 'Task Link Type',
            },
        ),
        migrations.CreateModel(
            name='TaskStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('is_done', models.BooleanField(verbose_name='Status represents task done')),
            ],
            options={
                'verbose_name': 'Task Status',
                'verbose_name_plural': 'Task Status',
            },
        ),
        migrations.CreateModel(
            name='Work',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Date')),
                ('start_time', models.DateTimeField(verbose_name='Start Time')),
                ('stop_time', models.DateTimeField(verbose_name='Stop Time')),
                ('short_description', models.CharField(max_length=300, verbose_name='Short Description')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.UserExtension')),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Task', verbose_name='Task')),
            ],
            options={
                'verbose_name': 'Work',
                'verbose_name_plural': 'Work',
            },
        ),
        migrations.AlterField(
            model_name='position',
            name='position_number',
            field=models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1)], verbose_name='Position Number'),
        ),
        migrations.AddField(
            model_name='task',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.TaskStatus', verbose_name='Task Status'),
        ),
        migrations.AddField(
            model_name='generictasklink',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Task', verbose_name='Task'),
        ),
        migrations.AddField(
            model_name='generictasklink',
            name='task_link_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.TaskLinkType', verbose_name='Task Link Type'),
        ),
        migrations.AddField(
            model_name='employeeassignmenttotask',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Task', verbose_name='Task'),
        ),
    ]
