# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-05 17:02
from __future__ import unicode_literals

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('accounting', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300, verbose_name='Name')),
                ('dateofcreation', models.DateTimeField(auto_now=True, verbose_name='Created at')),
                ('lastmodification', models.DateTimeField(auto_now_add=True, verbose_name='Last modified')),
            ],
            options={
                'verbose_name': 'Contact',
                'verbose_name_plural': 'Contact',
            },
        ),
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(verbose_name='Description')),
                ('dateofcreation', models.DateTimeField(auto_now=True, verbose_name='Created at')),
                ('lastmodification', models.DateTimeField(auto_now_add=True, verbose_name='Last modified')),
            ],
            options={
                'verbose_name': 'Contract',
                'verbose_name_plural': 'Contracts',
            },
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=100, verbose_name='Description')),
                (
                'shortName', models.CharField(max_length=3, verbose_name='Displayed Name After Price In The Position')),
                ('rounding',
                 models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True, verbose_name='Rounding')),
            ],
            options={
                'verbose_name': 'Currency',
                'verbose_name_plural': 'Currency',
            },
        ),
        migrations.CreateModel(
            name='CustomerBillingCycle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300, verbose_name='Name')),
                ('timeToPaymentDate', models.IntegerField(verbose_name='Days To Payment Date')),
            ],
            options={
                'verbose_name': 'Customer Billing Cycle',
                'verbose_name_plural': 'Customer Billing Cycle',
            },
        ),
        migrations.CreateModel(
            name='CustomerGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
            ],
            options={
                'verbose_name': 'Customer Group',
                'verbose_name_plural': 'Customer Groups',
            },
        ),
        migrations.CreateModel(
            name='CustomerGroupTransform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('factor',
                 models.IntegerField(blank=True, null=True, verbose_name='Factor between From and To Customer Group')),
                ('fromCustomerGroup', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                        related_name='db_reltransfromfromcustomergroup',
                                                        to='crm.CustomerGroup', verbose_name='From Unit')),
            ],
            options={
                'verbose_name': 'Customer Group Price Transfrom',
                'verbose_name_plural': 'Customer Group Price Transfroms',
            },
        ),
        migrations.CreateModel(
            name='EmailAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=200, verbose_name='Email Address')),
            ],
            options={
                'verbose_name': 'Email Address',
                'verbose_name_plural': 'Email Address',
            },
        ),
        migrations.CreateModel(
            name='PhoneAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(max_length=20, verbose_name='Phone Number')),
            ],
            options={
                'verbose_name': 'Phone Address',
                'verbose_name_plural': 'Phone Address',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('positionNumber', models.IntegerField(verbose_name='Position Number')),
                ('quantity', models.DecimalField(decimal_places=3, max_digits=10, verbose_name='Quantity')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('discount',
                 models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True, verbose_name='Discount')),
                ('sentOn', models.DateField(blank=True, null=True, verbose_name='Shipment on')),
                ('shipmentID', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipment ID')),
                ('overwriteProductPrice', models.BooleanField(verbose_name='Overwrite Product Price')),
                ('positionPricePerUnit', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                             verbose_name='Price Per Unit')),
                ('lastPricingDate', models.DateField(blank=True, null=True, verbose_name='Last Pricing Date')),
                ('lastCalculatedPrice', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                            verbose_name='Last Calculted Price')),
                ('lastCalculatedTax', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                          verbose_name='Last Calculted Tax')),
            ],
            options={
                'verbose_name': 'Position',
                'verbose_name_plural': 'Positions',
            },
        ),
        migrations.CreateModel(
            name='PostalAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prefix',
                 models.CharField(blank=True, choices=[('F', 'Company'), ('W', 'Mrs'), ('H', 'Mr'), ('G', 'Ms')],
                                  max_length=1, null=True, verbose_name='Prefix')),
                ('name', models.CharField(blank=True, max_length=100, null=True, verbose_name='Name')),
                ('prename', models.CharField(blank=True, max_length=100, null=True, verbose_name='Prename')),
                ('addressline1', models.CharField(blank=True, max_length=200, null=True, verbose_name='Addressline 1')),
                ('addressline2', models.CharField(blank=True, max_length=200, null=True, verbose_name='Addressline 2')),
                ('addressline3', models.CharField(blank=True, max_length=200, null=True, verbose_name='Addressline 3')),
                ('addressline4', models.CharField(blank=True, max_length=200, null=True, verbose_name='Addressline 4')),
                ('zipcode', models.IntegerField(blank=True, null=True, verbose_name='Zipcode')),
                ('town', models.CharField(blank=True, max_length=100, null=True, verbose_name='City')),
                ('state', models.CharField(blank=True, max_length=100, null=True, verbose_name='State')),
                ('country', models.CharField(blank=True,
                                             choices=[('AF', 'Afghanistan'), ('AX', 'Aland Islands'), ('AL', 'Albania'),
                                                      ('DZ', 'Algeria'), ('AS', 'American Samoa'), ('AD', 'Andorra'),
                                                      ('AO', 'Angola'), ('AI', 'Anguilla'), ('AQ', 'Antarctica'),
                                                      ('AG', 'Antigua and Barbuda'), ('AR', 'Argentina'),
                                                      ('AM', 'Armenia'), ('AW', 'Aruba'), ('AU', 'Australia'),
                                                      ('AT', 'Austria'), ('AZ', 'Azerbaijan'), ('BS', 'the Bahamas'),
                                                      ('BH', 'Bahrain'), ('BD', 'Bangladesh'), ('BB', 'Barbados'),
                                                      ('BY', 'Belarus'), ('BE', 'Belgium'), ('BZ', 'Belize'),
                                                      ('BJ', 'Benin'), ('BM', 'Bermuda'), ('BT', 'Bhutan'),
                                                      ('BO', 'Bolivia'), ('BA', 'Bosnia and Herzegovina'),
                                                      ('BW', 'Botswana'), ('BV', 'Bouvet Island'), ('BR', 'Brazil'),
                                                      ('IO', 'British Indian Ocean Territory'),
                                                      ('BN', 'Brunei Darussalam'), ('BG', 'Bulgaria'),
                                                      ('BF', 'Burkina Faso'), ('BI', 'Burundi'), ('KH', 'Cambodia'),
                                                      ('CM', 'Cameroon'), ('CA', 'Canada'), ('CV', 'Cape Verde'),
                                                      ('KY', 'Cayman Islands'), ('CF', 'Central African Republic'),
                                                      ('TD', 'Chad'), ('CL', 'Chile'), ('CN', 'China'),
                                                      ('CX', 'Christmas Island'), ('CC', 'Cocos (Keeling) Islands'),
                                                      ('CO', 'Colombia'), ('KM', 'Comoros'), ('CG', 'Congo'),
                                                      ('CD', 'Democratic Republic of the Congo'),
                                                      ('CK', 'Cook Islands'), ('CR', 'Costa Rica'),
                                                      ('CI', "Cote d'Ivoire"), ('HR', 'Croatia'), ('CU', 'Cuba'),
                                                      ('CY', 'Cyprus'), ('CZ', 'Czech Republic'), ('DK', 'Denmark'),
                                                      ('DJ', 'Djibouti'), ('DM', 'Dominica'),
                                                      ('DO', 'Dominican Republic'), ('EC', 'Ecuador'), ('EG', 'Egypt'),
                                                      ('SV', 'El Salvador'), ('GQ', 'Equatorial Guinea'),
                                                      ('ER', 'Eritrea'), ('EE', 'Estonia'), ('ET', 'Ethiopia'),
                                                      ('FK', 'Falkland Islands (Malvinas)'), ('FO', 'Faroe Islands'),
                                                      ('FJ', 'Fiji'), ('FI', 'Finland'), ('FR', 'France'),
                                                      ('GF', 'French Guiana'), ('PF', 'French Polynesia'),
                                                      ('TF', 'French Southern and Antarctic Lands'), ('GA', 'Gabon'),
                                                      ('GM', 'Gambia'), ('GE', 'Georgia'), ('DE', 'Germany'),
                                                      ('GH', 'Ghana'), ('GI', 'Gibraltar'), ('GR', 'Greece'),
                                                      ('GL', 'Greenland'), ('GD', 'Grenada'), ('GP', 'Guadeloupe'),
                                                      ('GU', 'Guam'), ('GT', 'Guatemala'), ('GG', 'Guernsey'),
                                                      ('GN', 'Guinea'), ('GW', 'Guinea-Bissau'), ('GY', 'Guyana'),
                                                      ('HT', 'Haiti'), ('HM', 'Heard Island and McDonald Islands'),
                                                      ('VA', 'Vatican City Holy See'), ('HN', 'Honduras'),
                                                      ('HK', 'Hong Kong'), ('HU', 'Hungary'), ('IS', 'Iceland'),
                                                      ('IN', 'India'), ('ID', 'Indonesia'), ('IR', 'Iran'),
                                                      ('IQ', 'Iraq'), ('IE', 'Ireland'), ('IM', 'Isle of Man'),
                                                      ('IL', 'Israel'), ('IT', 'Italy'), ('JM', 'Jamaica'),
                                                      ('JP', 'Japan'), ('JE', 'Jersey'), ('JO', 'Jordan'),
                                                      ('KZ', 'Kazakhstan'), ('KE', 'Kenya'), ('KI', 'Kiribati'),
                                                      ('KP', 'North Korea'), ('KR', 'South Korea'), ('KW', 'Kuwait'),
                                                      ('KG', 'Kyrgyzstan'), ('LA', 'Laos Lao'), ('LV', 'Latvia'),
                                                      ('LB', 'Lebanon'), ('LS', 'Lesotho'), ('LR', 'Liberia'),
                                                      ('LY', 'Libya Libyan Arab Jamahiriya'), ('LI', 'Liechtenstein'),
                                                      ('LT', 'Lithuania'), ('LU', 'Luxembourg'), ('MO', 'Macau Macao'),
                                                      ('MK', 'Macedonia'), ('MG', 'Madagascar'), ('MW', 'Malawi'),
                                                      ('MY', 'Malaysia'), ('MV', 'Maldives'), ('ML', 'Mali'),
                                                      ('MT', 'Malta'), ('MH', 'Marshall Islands'), ('MQ', 'Martinique'),
                                                      ('MR', 'Mauritania'), ('MU', 'Mauritius'), ('YT', 'Mayotte'),
                                                      ('MX', 'Mexico'), ('FM', 'Micronesia'), ('MD', 'Moldova'),
                                                      ('MC', 'Monaco'), ('MN', 'Mongolia'), ('ME', 'Montenegro'),
                                                      ('MS', 'Montserrat'), ('MA', 'Morocco'), ('MZ', 'Mozambique'),
                                                      ('MM', 'Myanmar'), ('NA', 'Namibia'), ('NR', 'Nauru'),
                                                      ('NP', 'Nepal'), ('NL', 'Netherlands'),
                                                      ('AN', 'Netherlands Antilles'), ('NC', 'New Caledonia'),
                                                      ('NZ', 'New Zealand'), ('NI', 'Nicaragua'), ('NE', 'Niger'),
                                                      ('NG', 'Nigeria'), ('NU', 'Niue'),
                                                      ('NF', 'Norfolk Island Norfolk Island'),
                                                      ('MP', 'Northern Mariana Islands'), ('NO', 'Norway'),
                                                      ('OM', 'Oman'), ('PK', 'Pakistan'), ('PW', 'Palau'),
                                                      ('PS', 'Palestinian Territory'), ('PA', 'Panama'),
                                                      ('PG', 'Papua New Guinea'), ('PY', 'Paraguay'), ('PE', 'Peru'),
                                                      ('PH', 'Philippines'), ('PN', 'Pitcairn Islands'),
                                                      ('PL', 'Poland'), ('PT', 'Portugal'), ('PR', 'Puerto Rico'),
                                                      ('QA', 'Qatar'), ('RE', 'Reunion'), ('RO', 'Romania'),
                                                      ('RU', 'Russia'), ('RW', 'Rwanda'), ('SH', 'Saint Helena'),
                                                      ('KN', 'Saint Kitts and Nevis'), ('LC', 'Saint Lucia'),
                                                      ('PM', 'Saint Pierre and Miquelon'),
                                                      ('VC', 'Saint Vincent and the Grenadines'), ('WS', 'Samoa'),
                                                      ('SM', 'San Marino'), ('ST', 'Sao Tome and Principe'),
                                                      ('SA', 'Saudi Arabia'), ('SN', 'Senegal'), ('RS', 'Serbia'),
                                                      ('SC', 'Seychelles'), ('SL', 'Sierra Leone'), ('SG', 'Singapore'),
                                                      ('SK', 'Slovakia'), ('SI', 'Slovenia'), ('SB', 'Solomon Islands'),
                                                      ('SO', 'Somalia'), ('ZA', 'South Africa'),
                                                      ('GS', 'South Georgia and the South Sandwich Islands'),
                                                      ('ES', 'Spain'), ('LK', 'Sri Lanka'), ('SD', 'Sudan'),
                                                      ('SR', 'Suriname'), ('SJ', 'Svalbard and Jan Mayen'),
                                                      ('SZ', 'Swaziland'), ('SE', 'Sweden'), ('CH', 'Switzerland'),
                                                      ('SY', 'Syria'), ('TW', 'Taiwan'), ('TJ', 'Tajikistan'),
                                                      ('TZ', 'Tanzania'), ('TH', 'Thailand'), ('TL', 'East Timor'),
                                                      ('TG', 'Togo'), ('TK', 'Tokelau'), ('TO', 'Tonga'),
                                                      ('TT', 'Trinidad and Tobago'), ('TN', 'Tunisia'),
                                                      ('TR', 'Turkey'), ('TM', 'Turkmenistan'),
                                                      ('TC', 'Turks and Caicos Islands'), ('TV', 'Tuvalu'),
                                                      ('UG', 'Uganda'), ('UA', 'Ukraine'),
                                                      ('AE', 'United Arab Emirates'), ('GB', 'United Kingdom'),
                                                      ('US', 'United States'),
                                                      ('UM', 'United States Minor Outlying Islands'), ('UY', 'Uruguay'),
                                                      ('UZ', 'Uzbekistan'), ('VU', 'Vanuatu'), ('VE', 'Venezuela'),
                                                      ('VN', 'Vietnam Viet Nam'), ('VG', 'British Virgin Islands'),
                                                      ('VI', 'United States Virgin Islands'),
                                                      ('WF', 'Wallis and Futuna'), ('EH', 'Western Sahara'),
                                                      ('YE', 'Yemen'), ('ZM', 'Zambia'), ('ZW', 'Zimbabwe')],
                                             max_length=2, null=True, verbose_name='Country')),
            ],
            options={
                'verbose_name': 'Postal Address',
                'verbose_name_plural': 'Postal Address',
            },
        ),
        migrations.CreateModel(
            name='Price',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price', models.DecimalField(decimal_places=2, max_digits=17, verbose_name='Price Per Unit')),
                ('validfrom', models.DateField(blank=True, null=True, verbose_name='Valid from')),
                ('validuntil', models.DateField(blank=True, null=True, verbose_name='Valid until')),
                ('currency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Currency',
                                               verbose_name='Currency')),
                ('customerGroup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                                    to='crm.CustomerGroup', verbose_name='Customer Group')),
            ],
            options={
                'verbose_name': 'Price',
                'verbose_name_plural': 'Prices',
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('title', models.CharField(max_length=200, verbose_name='Title')),
                ('productNumber', models.IntegerField(verbose_name='Product Number')),
                ('dateofcreation', models.DateTimeField(auto_now=True, verbose_name='Created at')),
                ('lastmodification', models.DateTimeField(auto_now_add=True, verbose_name='Last modified')),
                ('accoutingProductCategorie',
                 models.ForeignKey(blank='True', null=True, on_delete=django.db.models.deletion.CASCADE,
                                   to='accounting.ProductCategorie', verbose_name='Accounting Product Categorie')),
            ],
            options={
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
            },
        ),
        migrations.CreateModel(
            name='PurchaseOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('externalReference',
                 models.CharField(blank=True, max_length=100, null=True, verbose_name='External Reference')),
                ('description', models.CharField(blank=True, max_length=100, null=True, verbose_name='Description')),
                ('lastPricingDate', models.DateField(blank=True, null=True, verbose_name='Last Pricing Date')),
                ('lastCalculatedPrice', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                            verbose_name='Last Calculted Price With Tax')),
                ('lastCalculatedTax', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                          verbose_name='Last Calculted Tax')),
                ('status', models.CharField(
                    choices=[('O', 'Ordered'), ('D', 'Delayed'), ('Y', 'Delivered'), ('I', 'Invoice registered'),
                             ('P', 'Invoice payed')], max_length=1)),
                ('dateofcreation', models.DateTimeField(auto_now=True, verbose_name='Created at')),
                ('lastmodification', models.DateTimeField(auto_now_add=True, verbose_name='Last modified')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract',
                                               verbose_name='Contract')),
                ('currency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Currency',
                                               verbose_name='Currency')),
                ('lastmodifiedby',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_polstmodified',
                                   to=settings.AUTH_USER_MODEL, verbose_name='Last modified by')),
                ('staff', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                            related_name='db_relpostaff', to=settings.AUTH_USER_MODEL,
                                            verbose_name='Staff')),
            ],
            options={
                'verbose_name': 'Purchase Order',
                'verbose_name_plural': 'Purchase Order',
            },
        ),
        migrations.CreateModel(
            name='SalesContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('externalReference', models.CharField(blank=True, max_length=100, verbose_name='External Reference')),
                ('discount',
                 models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True, verbose_name='Discount')),
                ('description', models.CharField(blank=True, max_length=100, null=True, verbose_name='Description')),
                ('lastPricingDate', models.DateField(blank=True, null=True, verbose_name='Last Pricing Date')),
                ('lastCalculatedPrice', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                            verbose_name='Last Calculted Price With Tax')),
                ('lastCalculatedTax', models.DecimalField(blank=True, decimal_places=2, max_digits=17, null=True,
                                                          verbose_name='Last Calculted Tax')),
                ('dateofcreation', models.DateTimeField(auto_now=True, verbose_name='Created at')),
                ('lastmodification', models.DateTimeField(auto_now_add=True, verbose_name='Last modified')),
            ],
            options={
                'verbose_name': 'Sales Contract',
                'verbose_name_plural': 'Sales Contracts',
            },
        ),
        migrations.CreateModel(
            name='Tax',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxrate', models.DecimalField(decimal_places=2, max_digits=5, verbose_name='Taxrate in Percentage')),
                ('name', models.CharField(max_length=100, verbose_name='Taxname')),
                ('accountActiva', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                                    related_name='db_relaccountactiva', to='accounting.Account',
                                                    verbose_name='Activa Account')),
                ('accountPassiva', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                                     related_name='db_relaccountpassiva', to='accounting.Account',
                                                     verbose_name='Passiva Account')),
            ],
            options={
                'verbose_name': 'Tax',
                'verbose_name_plural': 'Taxes',
            },
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=100, verbose_name='Description')),
                ('shortName',
                 models.CharField(max_length=3, verbose_name='Displayed Name After Quantity In The Position')),
                ('fractionFactorToNextHigherUnit',
                 models.IntegerField(blank=True, null=True, verbose_name='Factor Between This And Next Higher Unit')),
                ('isAFractionOf',
                 models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Unit',
                                   verbose_name='Is A Fraction Of')),
            ],
            options={
                'verbose_name': 'Unit',
                'verbose_name_plural': 'Units',
            },
        ),
        migrations.CreateModel(
            name='UnitTransform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('factor', models.IntegerField(blank=True, null=True, verbose_name='Factor between From and To Unit')),
                ('fromUnit',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransfromfromunit',
                                   to='crm.Unit', verbose_name='From Unit')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Product',
                                              verbose_name='Product')),
                ('toUnit',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltransfromtounit',
                                   to='crm.Unit', verbose_name='To Unit')),
            ],
            options={
                'verbose_name': 'Unit Transfrom',
                'verbose_name_plural': 'Unit Transfroms',
            },
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('contact_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.Contact')),
                ('defaultCustomerBillingCycle',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.CustomerBillingCycle',
                                   verbose_name='Default Billing Cycle')),
                ('ismemberof', models.ManyToManyField(blank=True, to='crm.CustomerGroup', verbose_name='Is member of')),
            ],
            options={
                'verbose_name': 'Customer',
                'verbose_name_plural': 'Customers',
            },
            bases=('crm.contact',),
        ),
        migrations.CreateModel(
            name='EmailAddressForContact',
            fields=[
                ('emailaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.EmailAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Email Address For Contact',
                'verbose_name_plural': 'Email Address For Contact',
            },
            bases=('crm.emailaddress',),
        ),
        migrations.CreateModel(
            name='EmailAddressForContract',
            fields=[
                ('emailaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.EmailAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Email Address For Contracts',
                'verbose_name_plural': 'Email Address For Contracts',
            },
            bases=('crm.emailaddress',),
        ),
        migrations.CreateModel(
            name='EmailAddressForPurchaseOrder',
            fields=[
                ('emailaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.EmailAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Email Address For Contracts',
                'verbose_name_plural': 'Email Address For Contracts',
            },
            bases=('crm.emailaddress',),
        ),
        migrations.CreateModel(
            name='EmailAddressForSalesContract',
            fields=[
                ('emailaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.EmailAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Email Address For Contracts',
                'verbose_name_plural': 'Email Address For Contracts',
            },
            bases=('crm.emailaddress',),
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('salescontract_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.SalesContract')),
                ('payableuntil', models.DateField(verbose_name='To pay until')),
                ('paymentBankReference',
                 models.CharField(blank=True, max_length=100, null=True, verbose_name='Payment Bank Reference')),
                ('status', models.CharField(choices=[('P', 'Payed'), ('C', 'Invoice created'), ('I', 'Invoice sent'),
                                                     ('F', 'First reminder sent'), ('R', 'Second reminder sent'),
                                                     ('U', 'Customer cant pay'), ('D', 'Deleted')], max_length=1)),
            ],
            options={
                'verbose_name': 'Invoice',
                'verbose_name_plural': 'Invoices',
            },
            bases=('crm.salescontract',),
        ),
        migrations.CreateModel(
            name='PhoneAddressForContact',
            fields=[
                ('phoneaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PhoneAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Phone Address For Contact',
                'verbose_name_plural': 'Phone Address For Contact',
            },
            bases=('crm.phoneaddress',),
        ),
        migrations.CreateModel(
            name='PhoneAddressForContract',
            fields=[
                ('phoneaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PhoneAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Phone Address For Contracts',
                'verbose_name_plural': 'Phone Address For Contracts',
            },
            bases=('crm.phoneaddress',),
        ),
        migrations.CreateModel(
            name='PhoneAddressForPurchaseOrder',
            fields=[
                ('phoneaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PhoneAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Phone Address For Contracts',
                'verbose_name_plural': 'Phone Address For Contracts',
            },
            bases=('crm.phoneaddress',),
        ),
        migrations.CreateModel(
            name='PhoneAddressForSalesContract',
            fields=[
                ('phoneaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PhoneAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Phone Address For Contracts',
                'verbose_name_plural': 'Phone Address For Contracts',
            },
            bases=('crm.phoneaddress',),
        ),
        migrations.CreateModel(
            name='PostalAddressForContact',
            fields=[
                ('postaladdress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PostalAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Postal Address For Contact',
                'verbose_name_plural': 'Postal Address For Contact',
            },
            bases=('crm.postaladdress',),
        ),
        migrations.CreateModel(
            name='PostalAddressForContract',
            fields=[
                ('postaladdress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PostalAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Postal Address For Contracts',
                'verbose_name_plural': 'Postal Address For Contracts',
            },
            bases=('crm.postaladdress',),
        ),
        migrations.CreateModel(
            name='PostalAddressForPurchaseOrder',
            fields=[
                ('postaladdress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PostalAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Postal Address For Contracts',
                'verbose_name_plural': 'Postal Address For Contracts',
            },
            bases=('crm.postaladdress',),
        ),
        migrations.CreateModel(
            name='PostalAddressForSalesContract',
            fields=[
                ('postaladdress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PostalAddress')),
                ('purpose', models.CharField(
                    choices=[('D', 'Delivery Address'), ('B', 'Billing Address'), ('C', 'Contact Address')],
                    max_length=1, verbose_name='Purpose')),
            ],
            options={
                'verbose_name': 'Postal Address For Contracts',
                'verbose_name_plural': 'Postal Address For Contracts',
            },
            bases=('crm.postaladdress',),
        ),
        migrations.CreateModel(
            name='PurchaseOrderPosition',
            fields=[
                ('position_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.Position')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.PurchaseOrder',
                                               verbose_name='Contract')),
            ],
            options={
                'verbose_name': 'Purchaseorder Position',
                'verbose_name_plural': 'Purchaseorder Positions',
            },
            bases=('crm.position',),
        ),
        migrations.CreateModel(
            name='Quote',
            fields=[
                ('salescontract_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.SalesContract')),
                ('validuntil', models.DateField(verbose_name='Valid until')),
                ('status', models.CharField(choices=[('S', 'Success'), ('I', 'Quote created'), ('Q', 'Quote sent'),
                                                     ('F', 'First reminder sent'), ('R', 'Second reminder sent'),
                                                     ('D', 'Deleted')], max_length=1, verbose_name='Status')),
            ],
            options={
                'verbose_name': 'Quote',
                'verbose_name_plural': 'Quotes',
            },
            bases=('crm.salescontract',),
        ),
        migrations.CreateModel(
            name='SalesContractPosition',
            fields=[
                ('position_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.Position')),
            ],
            options={
                'verbose_name': 'Salescontract Position',
                'verbose_name_plural': 'Salescontract Positions',
            },
            bases=('crm.position',),
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('contact_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.Contact')),
                ('offersShipmentToCustomers', models.BooleanField(verbose_name='Offers Shipment to Customer')),
            ],
            options={
                'verbose_name': 'Supplier',
                'verbose_name_plural': 'Supplier',
            },
            bases=('crm.contact',),
        ),
        migrations.AddField(
            model_name='salescontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract',
                                    verbose_name='Contract'),
        ),
        migrations.AddField(
            model_name='salescontract',
            name='currency',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Currency',
                                    verbose_name='Currency'),
        ),
        migrations.AddField(
            model_name='salescontract',
            name='lastmodifiedby',
            field=models.ForeignKey(blank='True', null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_lstscmodified', to=settings.AUTH_USER_MODEL,
                                    verbose_name='Last modified by'),
        ),
        migrations.AddField(
            model_name='salescontract',
            name='staff',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_relscstaff', to=settings.AUTH_USER_MODEL, verbose_name='Staff'),
        ),
        migrations.AddField(
            model_name='product',
            name='defaultunit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Unit', verbose_name='Unit'),
        ),
        migrations.AddField(
            model_name='product',
            name='lastmodifiedby',
            field=models.ForeignKey(blank='True', null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to=settings.AUTH_USER_MODEL, verbose_name='Last modified by'),
        ),
        migrations.AddField(
            model_name='product',
            name='tax',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Tax'),
        ),
        migrations.AddField(
            model_name='price',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Product',
                                    verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='price',
            name='unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Unit', verbose_name='Unit'),
        ),
        migrations.AddField(
            model_name='position',
            name='product',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='crm.Product', verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='position',
            name='unit',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Unit',
                                    verbose_name='Unit'),
        ),
        migrations.AddField(
            model_name='customergrouptransform',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Product',
                                    verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='customergrouptransform',
            name='toCustomerGroup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltransfromtocustomergroup', to='crm.CustomerGroup',
                                    verbose_name='To Unit'),
        ),
        migrations.AddField(
            model_name='contract',
            name='defaultcurrency',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Currency',
                                    verbose_name='Default Currency'),
        ),
        migrations.AddField(
            model_name='contract',
            name='lastmodifiedby',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_contractlstmodified',
                                    to=settings.AUTH_USER_MODEL, verbose_name='Last modified by'),
        ),
        migrations.AddField(
            model_name='contract',
            name='staff',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_relcontractstaff', to=settings.AUTH_USER_MODEL,
                                    verbose_name='Staff'),
        ),
        migrations.AddField(
            model_name='contact',
            name='lastmodifiedby',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE,
                                    to=settings.AUTH_USER_MODEL, verbose_name='Last modified by'),
        ),
        migrations.AddField(
            model_name='salescontractposition',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.SalesContract',
                                    verbose_name='Contract'),
        ),
        migrations.AddField(
            model_name='salescontract',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Customer',
                                    verbose_name='Customer'),
        ),
        migrations.AddField(
            model_name='purchaseorder',
            name='supplier',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Supplier',
                                    verbose_name='Supplier'),
        ),
        migrations.AddField(
            model_name='postaladdressforsalescontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.SalesContract'),
        ),
        migrations.AddField(
            model_name='postaladdressforpurchaseorder',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.PurchaseOrder'),
        ),
        migrations.AddField(
            model_name='postaladdressforcontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract'),
        ),
        migrations.AddField(
            model_name='postaladdressforcontact',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contact'),
        ),
        migrations.AddField(
            model_name='position',
            name='supplier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='crm.Supplier', verbose_name='Shipment Supplier'),
        ),
        migrations.AddField(
            model_name='phoneaddressforsalescontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.SalesContract'),
        ),
        migrations.AddField(
            model_name='phoneaddressforpurchaseorder',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.PurchaseOrder'),
        ),
        migrations.AddField(
            model_name='phoneaddressforcontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract'),
        ),
        migrations.AddField(
            model_name='phoneaddressforcontact',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contact'),
        ),
        migrations.AddField(
            model_name='invoice',
            name='derivatedFromQuote',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Quote'),
        ),
        migrations.AddField(
            model_name='emailaddressforsalescontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.SalesContract'),
        ),
        migrations.AddField(
            model_name='emailaddressforpurchaseorder',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.PurchaseOrder'),
        ),
        migrations.AddField(
            model_name='emailaddressforcontract',
            name='contract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contract'),
        ),
        migrations.AddField(
            model_name='emailaddressforcontact',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Contact'),
        ),
        migrations.AddField(
            model_name='contract',
            name='defaultSupplier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='crm.Supplier', verbose_name='Default Supplier'),
        ),
        migrations.AddField(
            model_name='contract',
            name='defaultcustomer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='crm.Customer', verbose_name='Default Customer'),
        ),
    ]
