# coding: utf-8

"""
    KFM - Application API

    KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as an encryption key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_kfm_api.models.o_auth2_custom_claim import OAuth2CustomClaim  # noqa: F401,E501


class OAuth2AccessRules(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'audience': 'str',
        'bound_claims': 'list[OAuth2CustomClaim]',
        'bound_clients_id': 'list[str]',
        'issuer': 'str',
        'jwks_uri': 'str'
    }

    attribute_map = {
        'audience': 'audience',
        'bound_claims': 'bound_claims',
        'bound_clients_id': 'bound_clients_id',
        'issuer': 'issuer',
        'jwks_uri': 'jwks_uri'
    }

    def __init__(self, audience=None, bound_claims=None, bound_clients_id=None, issuer=None, jwks_uri=None):  # noqa: E501
        """OAuth2AccessRules - a model defined in Swagger"""  # noqa: E501

        self._audience = None
        self._bound_claims = None
        self._bound_clients_id = None
        self._issuer = None
        self._jwks_uri = None
        self.discriminator = None

        if audience is not None:
            self.audience = audience
        if bound_claims is not None:
            self.bound_claims = bound_claims
        if bound_clients_id is not None:
            self.bound_clients_id = bound_clients_id
        if issuer is not None:
            self.issuer = issuer
        if jwks_uri is not None:
            self.jwks_uri = jwks_uri

    @property
    def audience(self):
        """Gets the audience of this OAuth2AccessRules.  # noqa: E501

        The audience in the JWT.  # noqa: E501

        :return: The audience of this OAuth2AccessRules.  # noqa: E501
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """Sets the audience of this OAuth2AccessRules.

        The audience in the JWT.  # noqa: E501

        :param audience: The audience of this OAuth2AccessRules.  # noqa: E501
        :type: str
        """

        self._audience = audience

    @property
    def bound_claims(self):
        """Gets the bound_claims of this OAuth2AccessRules.  # noqa: E501

        The claims that login is restricted to.  # noqa: E501

        :return: The bound_claims of this OAuth2AccessRules.  # noqa: E501
        :rtype: list[OAuth2CustomClaim]
        """
        return self._bound_claims

    @bound_claims.setter
    def bound_claims(self, bound_claims):
        """Sets the bound_claims of this OAuth2AccessRules.

        The claims that login is restricted to.  # noqa: E501

        :param bound_claims: The bound_claims of this OAuth2AccessRules.  # noqa: E501
        :type: list[OAuth2CustomClaim]
        """

        self._bound_claims = bound_claims

    @property
    def bound_clients_id(self):
        """Gets the bound_clients_id of this OAuth2AccessRules.  # noqa: E501

        The clients ids that login is restricted to.  # noqa: E501

        :return: The bound_clients_id of this OAuth2AccessRules.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_clients_id

    @bound_clients_id.setter
    def bound_clients_id(self, bound_clients_id):
        """Sets the bound_clients_id of this OAuth2AccessRules.

        The clients ids that login is restricted to.  # noqa: E501

        :param bound_clients_id: The bound_clients_id of this OAuth2AccessRules.  # noqa: E501
        :type: list[str]
        """

        self._bound_clients_id = bound_clients_id

    @property
    def issuer(self):
        """Gets the issuer of this OAuth2AccessRules.  # noqa: E501

        Issuer URL  # noqa: E501

        :return: The issuer of this OAuth2AccessRules.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this OAuth2AccessRules.

        Issuer URL  # noqa: E501

        :param issuer: The issuer of this OAuth2AccessRules.  # noqa: E501
        :type: str
        """

        self._issuer = issuer

    @property
    def jwks_uri(self):
        """Gets the jwks_uri of this OAuth2AccessRules.  # noqa: E501

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :return: The jwks_uri of this OAuth2AccessRules.  # noqa: E501
        :rtype: str
        """
        return self._jwks_uri

    @jwks_uri.setter
    def jwks_uri(self, jwks_uri):
        """Sets the jwks_uri of this OAuth2AccessRules.

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :param jwks_uri: The jwks_uri of this OAuth2AccessRules.  # noqa: E501
        :type: str
        """

        self._jwks_uri = jwks_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OAuth2AccessRules, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OAuth2AccessRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
