import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { IAMServiceException as __BaseException } from "./IAMServiceException";
import {
  Role,
  ServerCertificateMetadata,
  SigningCertificate,
  SSHPublicKey,
  StatusType,
  Tag,
} from "./models_0";
export interface UntagPolicyRequest {
  PolicyArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagRoleRequest {
  RoleName: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagSAMLProviderRequest {
  SAMLProviderArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagServerCertificateRequest {
  ServerCertificateName: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagUserRequest {
  UserName: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateAccessKeyRequest {
  UserName?: string;
  AccessKeyId: string | undefined;
  Status: StatusType | string | undefined;
}
export interface UpdateAccountPasswordPolicyRequest {
  MinimumPasswordLength?: number;
  RequireSymbols?: boolean;
  RequireNumbers?: boolean;
  RequireUppercaseCharacters?: boolean;
  RequireLowercaseCharacters?: boolean;
  AllowUsersToChangePassword?: boolean;
  MaxPasswordAge?: number;
  PasswordReusePrevention?: number;
  HardExpiry?: boolean;
}
export interface UpdateAssumeRolePolicyRequest {
  RoleName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface UpdateGroupRequest {
  GroupName: string | undefined;
  NewPath?: string;
  NewGroupName?: string;
}
export interface UpdateLoginProfileRequest {
  UserName: string | undefined;
  Password?: string;
  PasswordResetRequired?: boolean;
}
export interface UpdateOpenIDConnectProviderThumbprintRequest {
  OpenIDConnectProviderArn: string | undefined;
  ThumbprintList: string[] | undefined;
}
export interface UpdateRoleRequest {
  RoleName: string | undefined;
  Description?: string;
  MaxSessionDuration?: number;
}
export interface UpdateRoleResponse {}
export interface UpdateRoleDescriptionRequest {
  RoleName: string | undefined;
  Description: string | undefined;
}
export interface UpdateRoleDescriptionResponse {
  Role?: Role;
}
export interface UpdateSAMLProviderRequest {
  SAMLMetadataDocument: string | undefined;
  SAMLProviderArn: string | undefined;
}
export interface UpdateSAMLProviderResponse {
  SAMLProviderArn?: string;
}
export interface UpdateServerCertificateRequest {
  ServerCertificateName: string | undefined;
  NewPath?: string;
  NewServerCertificateName?: string;
}
export interface UpdateServiceSpecificCredentialRequest {
  UserName?: string;
  ServiceSpecificCredentialId: string | undefined;
  Status: StatusType | string | undefined;
}
export interface UpdateSigningCertificateRequest {
  UserName?: string;
  CertificateId: string | undefined;
  Status: StatusType | string | undefined;
}
export interface UpdateSSHPublicKeyRequest {
  UserName: string | undefined;
  SSHPublicKeyId: string | undefined;
  Status: StatusType | string | undefined;
}
export interface UpdateUserRequest {
  UserName: string | undefined;
  NewPath?: string;
  NewUserName?: string;
}
export declare class KeyPairMismatchException extends __BaseException {
  readonly name: "KeyPairMismatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KeyPairMismatchException, __BaseException>
  );
}
export declare class MalformedCertificateException extends __BaseException {
  readonly name: "MalformedCertificateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MalformedCertificateException, __BaseException>
  );
}
export interface UploadServerCertificateRequest {
  Path?: string;
  ServerCertificateName: string | undefined;
  CertificateBody: string | undefined;
  PrivateKey: string | undefined;
  CertificateChain?: string;
  Tags?: Tag[];
}
export interface UploadServerCertificateResponse {
  ServerCertificateMetadata?: ServerCertificateMetadata;
  Tags?: Tag[];
}
export declare class DuplicateCertificateException extends __BaseException {
  readonly name: "DuplicateCertificateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DuplicateCertificateException, __BaseException>
  );
}
export declare class InvalidCertificateException extends __BaseException {
  readonly name: "InvalidCertificateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidCertificateException, __BaseException>
  );
}
export interface UploadSigningCertificateRequest {
  UserName?: string;
  CertificateBody: string | undefined;
}
export interface UploadSigningCertificateResponse {
  Certificate: SigningCertificate | undefined;
}
export declare class DuplicateSSHPublicKeyException extends __BaseException {
  readonly name: "DuplicateSSHPublicKeyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DuplicateSSHPublicKeyException, __BaseException>
  );
}
export declare class InvalidPublicKeyException extends __BaseException {
  readonly name: "InvalidPublicKeyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPublicKeyException, __BaseException>
  );
}
export interface UploadSSHPublicKeyRequest {
  UserName: string | undefined;
  SSHPublicKeyBody: string | undefined;
}
export interface UploadSSHPublicKeyResponse {
  SSHPublicKey?: SSHPublicKey;
}
export declare const UntagPolicyRequestFilterSensitiveLog: (
  obj: UntagPolicyRequest
) => any;
export declare const UntagRoleRequestFilterSensitiveLog: (
  obj: UntagRoleRequest
) => any;
export declare const UntagSAMLProviderRequestFilterSensitiveLog: (
  obj: UntagSAMLProviderRequest
) => any;
export declare const UntagServerCertificateRequestFilterSensitiveLog: (
  obj: UntagServerCertificateRequest
) => any;
export declare const UntagUserRequestFilterSensitiveLog: (
  obj: UntagUserRequest
) => any;
export declare const UpdateAccessKeyRequestFilterSensitiveLog: (
  obj: UpdateAccessKeyRequest
) => any;
export declare const UpdateAccountPasswordPolicyRequestFilterSensitiveLog: (
  obj: UpdateAccountPasswordPolicyRequest
) => any;
export declare const UpdateAssumeRolePolicyRequestFilterSensitiveLog: (
  obj: UpdateAssumeRolePolicyRequest
) => any;
export declare const UpdateGroupRequestFilterSensitiveLog: (
  obj: UpdateGroupRequest
) => any;
export declare const UpdateLoginProfileRequestFilterSensitiveLog: (
  obj: UpdateLoginProfileRequest
) => any;
export declare const UpdateOpenIDConnectProviderThumbprintRequestFilterSensitiveLog: (
  obj: UpdateOpenIDConnectProviderThumbprintRequest
) => any;
export declare const UpdateRoleRequestFilterSensitiveLog: (
  obj: UpdateRoleRequest
) => any;
export declare const UpdateRoleResponseFilterSensitiveLog: (
  obj: UpdateRoleResponse
) => any;
export declare const UpdateRoleDescriptionRequestFilterSensitiveLog: (
  obj: UpdateRoleDescriptionRequest
) => any;
export declare const UpdateRoleDescriptionResponseFilterSensitiveLog: (
  obj: UpdateRoleDescriptionResponse
) => any;
export declare const UpdateSAMLProviderRequestFilterSensitiveLog: (
  obj: UpdateSAMLProviderRequest
) => any;
export declare const UpdateSAMLProviderResponseFilterSensitiveLog: (
  obj: UpdateSAMLProviderResponse
) => any;
export declare const UpdateServerCertificateRequestFilterSensitiveLog: (
  obj: UpdateServerCertificateRequest
) => any;
export declare const UpdateServiceSpecificCredentialRequestFilterSensitiveLog: (
  obj: UpdateServiceSpecificCredentialRequest
) => any;
export declare const UpdateSigningCertificateRequestFilterSensitiveLog: (
  obj: UpdateSigningCertificateRequest
) => any;
export declare const UpdateSSHPublicKeyRequestFilterSensitiveLog: (
  obj: UpdateSSHPublicKeyRequest
) => any;
export declare const UpdateUserRequestFilterSensitiveLog: (
  obj: UpdateUserRequest
) => any;
export declare const UploadServerCertificateRequestFilterSensitiveLog: (
  obj: UploadServerCertificateRequest
) => any;
export declare const UploadServerCertificateResponseFilterSensitiveLog: (
  obj: UploadServerCertificateResponse
) => any;
export declare const UploadSigningCertificateRequestFilterSensitiveLog: (
  obj: UploadSigningCertificateRequest
) => any;
export declare const UploadSigningCertificateResponseFilterSensitiveLog: (
  obj: UploadSigningCertificateResponse
) => any;
export declare const UploadSSHPublicKeyRequestFilterSensitiveLog: (
  obj: UploadSSHPublicKeyRequest
) => any;
export declare const UploadSSHPublicKeyResponseFilterSensitiveLog: (
  obj: UploadSSHPublicKeyResponse
) => any;
