"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilInstanceProfileExists = exports.waitForInstanceProfileExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const GetInstanceProfileCommand_1 = require("../commands/GetInstanceProfileCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetInstanceProfileCommand_1.GetInstanceProfileCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NoSuchEntityException") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForInstanceProfileExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForInstanceProfileExists = waitForInstanceProfileExists;
const waitUntilInstanceProfileExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilInstanceProfileExists = waitUntilInstanceProfileExists;
