import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  RestoreSnapshotTierRequest,
  RestoreSnapshotTierResult,
} from "../models/models_6";
export interface RestoreSnapshotTierCommandInput
  extends RestoreSnapshotTierRequest {}
export interface RestoreSnapshotTierCommandOutput
  extends RestoreSnapshotTierResult,
    __MetadataBearer {}
export declare class RestoreSnapshotTierCommand extends $Command<
  RestoreSnapshotTierCommandInput,
  RestoreSnapshotTierCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RestoreSnapshotTierCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RestoreSnapshotTierCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<RestoreSnapshotTierCommandInput, RestoreSnapshotTierCommandOutput>;
  private serialize;
  private deserialize;
}
