import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyVerifiedAccessGroupRequest,
  ModifyVerifiedAccessGroupResult,
} from "../models/models_6";
export interface ModifyVerifiedAccessGroupCommandInput
  extends ModifyVerifiedAccessGroupRequest {}
export interface ModifyVerifiedAccessGroupCommandOutput
  extends ModifyVerifiedAccessGroupResult,
    __MetadataBearer {}
export declare class ModifyVerifiedAccessGroupCommand extends $Command<
  ModifyVerifiedAccessGroupCommandInput,
  ModifyVerifiedAccessGroupCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyVerifiedAccessGroupCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyVerifiedAccessGroupCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ModifyVerifiedAccessGroupCommandInput,
    ModifyVerifiedAccessGroupCommandOutput
  >;
  private serialize;
  private deserialize;
}
