import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { ImportKeyPairRequest, ImportKeyPairResult } from "../models/models_5";
export interface ImportKeyPairCommandInput extends ImportKeyPairRequest {}
export interface ImportKeyPairCommandOutput
  extends ImportKeyPairResult,
    __MetadataBearer {}
export declare class ImportKeyPairCommand extends $Command<
  ImportKeyPairCommandInput,
  ImportKeyPairCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ImportKeyPairCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ImportKeyPairCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ImportKeyPairCommandInput, ImportKeyPairCommandOutput>;
  private serialize;
  private deserialize;
}
