import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetIpamPoolCidrsRequest,
  GetIpamPoolCidrsResult,
} from "../models/models_5";
export interface GetIpamPoolCidrsCommandInput extends GetIpamPoolCidrsRequest {}
export interface GetIpamPoolCidrsCommandOutput
  extends GetIpamPoolCidrsResult,
    __MetadataBearer {}
export declare class GetIpamPoolCidrsCommand extends $Command<
  GetIpamPoolCidrsCommandInput,
  GetIpamPoolCidrsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetIpamPoolCidrsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetIpamPoolCidrsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<GetIpamPoolCidrsCommandInput, GetIpamPoolCidrsCommandOutput>;
  private serialize;
  private deserialize;
}
