import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DisableFastSnapshotRestoresRequest,
  DisableFastSnapshotRestoresResult,
} from "../models/models_5";
export interface DisableFastSnapshotRestoresCommandInput
  extends DisableFastSnapshotRestoresRequest {}
export interface DisableFastSnapshotRestoresCommandOutput
  extends DisableFastSnapshotRestoresResult,
    __MetadataBearer {}
export declare class DisableFastSnapshotRestoresCommand extends $Command<
  DisableFastSnapshotRestoresCommandInput,
  DisableFastSnapshotRestoresCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DisableFastSnapshotRestoresCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DisableFastSnapshotRestoresCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DisableFastSnapshotRestoresCommandInput,
    DisableFastSnapshotRestoresCommandOutput
  >;
  private serialize;
  private deserialize;
}
