import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVerifiedAccessGroupsRequest,
  DescribeVerifiedAccessGroupsResult,
} from "../models/models_4";
export interface DescribeVerifiedAccessGroupsCommandInput
  extends DescribeVerifiedAccessGroupsRequest {}
export interface DescribeVerifiedAccessGroupsCommandOutput
  extends DescribeVerifiedAccessGroupsResult,
    __MetadataBearer {}
export declare class DescribeVerifiedAccessGroupsCommand extends $Command<
  DescribeVerifiedAccessGroupsCommandInput,
  DescribeVerifiedAccessGroupsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVerifiedAccessGroupsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVerifiedAccessGroupsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVerifiedAccessGroupsCommandInput,
    DescribeVerifiedAccessGroupsCommandOutput
  >;
  private serialize;
  private deserialize;
}
