import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeReservedInstancesRequest,
  DescribeReservedInstancesResult,
} from "../models/models_4";
export interface DescribeReservedInstancesCommandInput
  extends DescribeReservedInstancesRequest {}
export interface DescribeReservedInstancesCommandOutput
  extends DescribeReservedInstancesResult,
    __MetadataBearer {}
export declare class DescribeReservedInstancesCommand extends $Command<
  DescribeReservedInstancesCommandInput,
  DescribeReservedInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeReservedInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeReservedInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeReservedInstancesCommandInput,
    DescribeReservedInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
