import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeNetworkInterfacesRequest,
  DescribeNetworkInterfacesResult,
} from "../models/models_4";
export interface DescribeNetworkInterfacesCommandInput
  extends DescribeNetworkInterfacesRequest {}
export interface DescribeNetworkInterfacesCommandOutput
  extends DescribeNetworkInterfacesResult,
    __MetadataBearer {}
export declare class DescribeNetworkInterfacesCommand extends $Command<
  DescribeNetworkInterfacesCommandInput,
  DescribeNetworkInterfacesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeNetworkInterfacesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeNetworkInterfacesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeNetworkInterfacesCommandInput,
    DescribeNetworkInterfacesCommandOutput
  >;
  private serialize;
  private deserialize;
}
