import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteVerifiedAccessEndpointRequest,
  DeleteVerifiedAccessEndpointResult,
} from "../models/models_3";
export interface DeleteVerifiedAccessEndpointCommandInput
  extends DeleteVerifiedAccessEndpointRequest {}
export interface DeleteVerifiedAccessEndpointCommandOutput
  extends DeleteVerifiedAccessEndpointResult,
    __MetadataBearer {}
export declare class DeleteVerifiedAccessEndpointCommand extends $Command<
  DeleteVerifiedAccessEndpointCommandInput,
  DeleteVerifiedAccessEndpointCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteVerifiedAccessEndpointCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteVerifiedAccessEndpointCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteVerifiedAccessEndpointCommandInput,
    DeleteVerifiedAccessEndpointCommandOutput
  >;
  private serialize;
  private deserialize;
}
