import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateVerifiedAccessInstanceRequest,
  CreateVerifiedAccessInstanceResult,
} from "../models/models_2";
export interface CreateVerifiedAccessInstanceCommandInput
  extends CreateVerifiedAccessInstanceRequest {}
export interface CreateVerifiedAccessInstanceCommandOutput
  extends CreateVerifiedAccessInstanceResult,
    __MetadataBearer {}
export declare class CreateVerifiedAccessInstanceCommand extends $Command<
  CreateVerifiedAccessInstanceCommandInput,
  CreateVerifiedAccessInstanceCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateVerifiedAccessInstanceCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateVerifiedAccessInstanceCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateVerifiedAccessInstanceCommandInput,
    CreateVerifiedAccessInstanceCommandOutput
  >;
  private serialize;
  private deserialize;
}
