import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateTrafficMirrorSessionRequest,
  CreateTrafficMirrorSessionResult,
} from "../models/models_2";
export interface CreateTrafficMirrorSessionCommandInput
  extends CreateTrafficMirrorSessionRequest {}
export interface CreateTrafficMirrorSessionCommandOutput
  extends CreateTrafficMirrorSessionResult,
    __MetadataBearer {}
export declare class CreateTrafficMirrorSessionCommand extends $Command<
  CreateTrafficMirrorSessionCommandInput,
  CreateTrafficMirrorSessionCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateTrafficMirrorSessionCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateTrafficMirrorSessionCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateTrafficMirrorSessionCommandInput,
    CreateTrafficMirrorSessionCommandOutput
  >;
  private serialize;
  private deserialize;
}
