import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateRestoreImageTaskRequest,
  CreateRestoreImageTaskResult,
} from "../models/models_1";
export interface CreateRestoreImageTaskCommandInput
  extends CreateRestoreImageTaskRequest {}
export interface CreateRestoreImageTaskCommandOutput
  extends CreateRestoreImageTaskResult,
    __MetadataBearer {}
export declare class CreateRestoreImageTaskCommand extends $Command<
  CreateRestoreImageTaskCommandInput,
  CreateRestoreImageTaskCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateRestoreImageTaskCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateRestoreImageTaskCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateRestoreImageTaskCommandInput,
    CreateRestoreImageTaskCommandOutput
  >;
  private serialize;
  private deserialize;
}
