import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreatePublicIpv4PoolRequest,
  CreatePublicIpv4PoolResult,
} from "../models/models_1";
export interface CreatePublicIpv4PoolCommandInput
  extends CreatePublicIpv4PoolRequest {}
export interface CreatePublicIpv4PoolCommandOutput
  extends CreatePublicIpv4PoolResult,
    __MetadataBearer {}
export declare class CreatePublicIpv4PoolCommand extends $Command<
  CreatePublicIpv4PoolCommandInput,
  CreatePublicIpv4PoolCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreatePublicIpv4PoolCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreatePublicIpv4PoolCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreatePublicIpv4PoolCommandInput,
    CreatePublicIpv4PoolCommandOutput
  >;
  private serialize;
  private deserialize;
}
