import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CancelSpotFleetRequestsRequest,
  CancelSpotFleetRequestsResponse,
} from "../models/models_0";
export interface CancelSpotFleetRequestsCommandInput
  extends CancelSpotFleetRequestsRequest {}
export interface CancelSpotFleetRequestsCommandOutput
  extends CancelSpotFleetRequestsResponse,
    __MetadataBearer {}
export declare class CancelSpotFleetRequestsCommand extends $Command<
  CancelSpotFleetRequestsCommandInput,
  CancelSpotFleetRequestsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CancelSpotFleetRequestsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CancelSpotFleetRequestsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CancelSpotFleetRequestsCommandInput,
    CancelSpotFleetRequestsCommandOutput
  >;
  private serialize;
  private deserialize;
}
