import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CancelImageLaunchPermissionRequest,
  CancelImageLaunchPermissionResult,
} from "../models/models_0";
export interface CancelImageLaunchPermissionCommandInput
  extends CancelImageLaunchPermissionRequest {}
export interface CancelImageLaunchPermissionCommandOutput
  extends CancelImageLaunchPermissionResult,
    __MetadataBearer {}
export declare class CancelImageLaunchPermissionCommand extends $Command<
  CancelImageLaunchPermissionCommandInput,
  CancelImageLaunchPermissionCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CancelImageLaunchPermissionCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CancelImageLaunchPermissionCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CancelImageLaunchPermissionCommandInput,
    CancelImageLaunchPermissionCommandOutput
  >;
  private serialize;
  private deserialize;
}
