import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CancelBundleTaskRequest,
  CancelBundleTaskResult,
} from "../models/models_0";
export interface CancelBundleTaskCommandInput extends CancelBundleTaskRequest {}
export interface CancelBundleTaskCommandOutput
  extends CancelBundleTaskResult,
    __MetadataBearer {}
export declare class CancelBundleTaskCommand extends $Command<
  CancelBundleTaskCommandInput,
  CancelBundleTaskCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CancelBundleTaskCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CancelBundleTaskCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<CancelBundleTaskCommandInput, CancelBundleTaskCommandOutput>;
  private serialize;
  private deserialize;
}
