import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { AllocateHostsRequest, AllocateHostsResult } from "../models/models_0";
export interface AllocateHostsCommandInput extends AllocateHostsRequest {}
export interface AllocateHostsCommandOutput
  extends AllocateHostsResult,
    __MetadataBearer {}
export declare class AllocateHostsCommand extends $Command<
  AllocateHostsCommandInput,
  AllocateHostsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AllocateHostsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AllocateHostsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<AllocateHostsCommandInput, AllocateHostsCommandOutput>;
  private serialize;
  private deserialize;
}
