import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyVerifiedAccessEndpointRequest, ModifyVerifiedAccessEndpointResult } from "../models/models_6";
export interface ModifyVerifiedAccessEndpointCommandInput extends ModifyVerifiedAccessEndpointRequest {
}
export interface ModifyVerifiedAccessEndpointCommandOutput extends ModifyVerifiedAccessEndpointResult, __MetadataBearer {
}
/**
 * <p>Modifies the configuration of an Amazon Web Services Verified Access endpoint.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyVerifiedAccessEndpointCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyVerifiedAccessEndpointCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyVerifiedAccessEndpointCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyVerifiedAccessEndpointCommandInput} for command's `input` shape.
 * @see {@link ModifyVerifiedAccessEndpointCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyVerifiedAccessEndpointCommand extends $Command<ModifyVerifiedAccessEndpointCommandInput, ModifyVerifiedAccessEndpointCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyVerifiedAccessEndpointCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifyVerifiedAccessEndpointCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyVerifiedAccessEndpointCommandInput, ModifyVerifiedAccessEndpointCommandOutput>;
    private serialize;
    private deserialize;
}
