import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteVerifiedAccessInstanceRequest, DeleteVerifiedAccessInstanceResult } from "../models/models_3";
export interface DeleteVerifiedAccessInstanceCommandInput extends DeleteVerifiedAccessInstanceRequest {
}
export interface DeleteVerifiedAccessInstanceCommandOutput extends DeleteVerifiedAccessInstanceResult, __MetadataBearer {
}
/**
 * <p>Delete an Amazon Web Services Verified Access instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteVerifiedAccessInstanceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteVerifiedAccessInstanceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteVerifiedAccessInstanceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteVerifiedAccessInstanceCommandInput} for command's `input` shape.
 * @see {@link DeleteVerifiedAccessInstanceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteVerifiedAccessInstanceCommand extends $Command<DeleteVerifiedAccessInstanceCommandInput, DeleteVerifiedAccessInstanceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteVerifiedAccessInstanceCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteVerifiedAccessInstanceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteVerifiedAccessInstanceCommandInput, DeleteVerifiedAccessInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
