import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResult } from "../models/models_2";
export interface DeleteNetworkInsightsAccessScopeAnalysisCommandInput extends DeleteNetworkInsightsAccessScopeAnalysisRequest {
}
export interface DeleteNetworkInsightsAccessScopeAnalysisCommandOutput extends DeleteNetworkInsightsAccessScopeAnalysisResult, __MetadataBearer {
}
/**
 * <p>Deletes the specified Network Access Scope analysis.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkInsightsAccessScopeAnalysisCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkInsightsAccessScopeAnalysisCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteNetworkInsightsAccessScopeAnalysisCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteNetworkInsightsAccessScopeAnalysisCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkInsightsAccessScopeAnalysisCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteNetworkInsightsAccessScopeAnalysisCommand extends $Command<DeleteNetworkInsightsAccessScopeAnalysisCommandInput, DeleteNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteNetworkInsightsAccessScopeAnalysisCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteNetworkInsightsAccessScopeAnalysisCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteNetworkInsightsAccessScopeAnalysisCommandInput, DeleteNetworkInsightsAccessScopeAnalysisCommandOutput>;
    private serialize;
    private deserialize;
}
