import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteCoipPoolRequest, DeleteCoipPoolResult } from "../models/models_2";
export interface DeleteCoipPoolCommandInput extends DeleteCoipPoolRequest {
}
export interface DeleteCoipPoolCommandOutput extends DeleteCoipPoolResult, __MetadataBearer {
}
/**
 * <p>Deletes a pool of customer-owned IP (CoIP) addresses. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteCoipPoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteCoipPoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteCoipPoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteCoipPoolCommandInput} for command's `input` shape.
 * @see {@link DeleteCoipPoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteCoipPoolCommand extends $Command<DeleteCoipPoolCommandInput, DeleteCoipPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteCoipPoolCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteCoipPoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteCoipPoolCommandInput, DeleteCoipPoolCommandOutput>;
    private serialize;
    private deserialize;
}
