import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssociateTransitGatewayPolicyTableRequest, AssociateTransitGatewayPolicyTableResult } from "../models/models_0";
export interface AssociateTransitGatewayPolicyTableCommandInput extends AssociateTransitGatewayPolicyTableRequest {
}
export interface AssociateTransitGatewayPolicyTableCommandOutput extends AssociateTransitGatewayPolicyTableResult, __MetadataBearer {
}
/**
 * <p>Associates the specified transit gateway attachment with a transit gateway policy table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, AssociateTransitGatewayPolicyTableCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, AssociateTransitGatewayPolicyTableCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new AssociateTransitGatewayPolicyTableCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link AssociateTransitGatewayPolicyTableCommandInput} for command's `input` shape.
 * @see {@link AssociateTransitGatewayPolicyTableCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class AssociateTransitGatewayPolicyTableCommand extends $Command<AssociateTransitGatewayPolicyTableCommandInput, AssociateTransitGatewayPolicyTableCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AssociateTransitGatewayPolicyTableCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: AssociateTransitGatewayPolicyTableCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AssociateTransitGatewayPolicyTableCommandInput, AssociateTransitGatewayPolicyTableCommandOutput>;
    private serialize;
    private deserialize;
}
