import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeHostReservationOfferingsRequestFilterSensitiveLog, DescribeHostReservationOfferingsResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DescribeHostReservationOfferingsCommand, serializeAws_ec2DescribeHostReservationOfferingsCommand, } from "../protocols/Aws_ec2";
export class DescribeHostReservationOfferingsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeHostReservationOfferingsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeHostReservationOfferingsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeHostReservationOfferingsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeHostReservationOfferingsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeHostReservationOfferingsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeHostReservationOfferingsCommand(output, context);
    }
}
