import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVerifiedAccessInstanceRequestFilterSensitiveLog, DeleteVerifiedAccessInstanceResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DeleteVerifiedAccessInstanceCommand, serializeAws_ec2DeleteVerifiedAccessInstanceCommand, } from "../protocols/Aws_ec2";
export class DeleteVerifiedAccessInstanceCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DeleteVerifiedAccessInstanceCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DeleteVerifiedAccessInstanceCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DeleteVerifiedAccessInstanceRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DeleteVerifiedAccessInstanceResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DeleteVerifiedAccessInstanceCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DeleteVerifiedAccessInstanceCommand(output, context);
    }
}
