import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayConnectPeerRequestFilterSensitiveLog, DeleteTransitGatewayConnectPeerResultFilterSensitiveLog, } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayConnectPeerCommand, serializeAws_ec2DeleteTransitGatewayConnectPeerCommand, } from "../protocols/Aws_ec2";
export class DeleteTransitGatewayConnectPeerCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DeleteTransitGatewayConnectPeerCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DeleteTransitGatewayConnectPeerCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayConnectPeerRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayConnectPeerResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DeleteTransitGatewayConnectPeerCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DeleteTransitGatewayConnectPeerCommand(output, context);
    }
}
