"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilPasswordDataAvailable = exports.waitForPasswordDataAvailable = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const GetPasswordDataCommand_1 = require("../commands/GetPasswordDataCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetPasswordDataCommand_1.GetPasswordDataCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.PasswordData.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForPasswordDataAvailable = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForPasswordDataAvailable = waitForPasswordDataAvailable;
const waitUntilPasswordDataAvailable = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilPasswordDataAvailable = waitUntilPasswordDataAvailable;
