"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilKeyPairExists = exports.waitForKeyPairExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeKeyPairsCommand_1 = require("../commands/DescribeKeyPairsCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeKeyPairsCommand_1.DescribeKeyPairsCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.KeyPairs);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.KeyName;
                });
                return projection_3.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidKeyPair.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForKeyPairExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForKeyPairExists = waitForKeyPairExists;
const waitUntilKeyPairExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilKeyPairExists = waitUntilKeyPairExists;
