"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VTVpc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
//import * as cdk from 'aws-cdk-lib';
//import { RemovalPolicy, Stack, StackProps, Tags, custom_resources as cr, CustomResource, CfnOutput, Duration, } from 'aws-cdk-lib';
const aws_cdk_lib_1 = require("aws-cdk-lib");
//import { aws_ec2 as ec2, aws_logs as logs, aws_iam as iam } from 'aws-cdk-lib';
//import * as lambda from 'aws-cdk-lib/aws-lambda';
//import {aws_ssm as ssm } from 'aws-cdk-lib'
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
//import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
const constructs_1 = require("constructs");
class VTVpc extends constructs_1.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        const natGatewayProvider = aws_cdk_lib_1.aws_ec2.NatProvider.instance({
            instanceType: new aws_cdk_lib_1.aws_ec2.InstanceType('t3.nano'),
        });
        // Create new VPC
        const constructVpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, `${props.solutionName}-VPC`, {
            vpcName: props.solutionName,
            natGatewayProvider: natGatewayProvider,
            maxAzs: 3,
            //cidr: props.cidr,
            ipAddresses: props && props.cidr ? aws_cdk_lib_1.aws_ec2.IpAddresses.cidr(props.cidr) : aws_cdk_lib_1.aws_ec2.IpAddresses.cidr('172.16.0.0/16'),
            natGateways: 2,
            enableDnsHostnames: true,
            enableDnsSupport: true,
            subnetConfiguration: [
                {
                    name: `${props.solutionName}-public-0`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-public-1`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-public-2`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-private-egress-0`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-private-egress-2`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-private-egress-3`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-isolated-0`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
                {
                    name: `${props.solutionName}-isolated-1`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
                {
                    name: `${props.solutionName}-isolated-2`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
            ],
        });
        /*
      // VPCID SSM Param
      new ssm.StringParameter(this, 'vpcid ssm param', {
        parameterName: `/${props.solutionName}/${props.environment}/vpcId`,
        stringValue: vpc.vpcId,
        description: `param for ${props.solutionName} vpcid`,
        type: ssm.ParameterType.STRING,
        tier: ssm.ParameterTier.INTELLIGENT_TIERING,
        allowedPattern: '.*',
      });
       */
        //EC2 Security Group
        const ec2SG = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'EC2-SG', {
            vpc: constructVpc,
            description: `${props.solutionName} EC2 ${props.environment} SecurityGroup`,
            securityGroupName: `${props.solutionName}-EC2-${props.environment}-SG`,
        });
        ec2SG.addIngressRule(ec2SG, aws_cdk_lib_1.aws_ec2.Port.allTraffic(), 'allow all east/west traffic inside security group');
        /*
        // createSsmParam.standardStringParameter(ecsSgSsmParam, ecsSG.securityGroupId);
        new ssm.StringParameter(this, 'ec2 sg ssm param', {
            parameterName: `/${props.solutionName}/${props.environment}/ec2SgId`,
            stringValue: ec2SG.securityGroupId,
            description: `param for ${props.solutionName} ec2 security group id`,
            type: ssm.ParameterType.STRING,
            tier: ssm.ParameterTier.INTELLIGENT_TIERING,
            allowedPattern: '.*',
        });
     */
        // S3 Gateway Endpoint
        constructVpc.addGatewayEndpoint('s3GatewayEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.GatewayVpcEndpointAwsService.S3,
            // Add only to ISOLATED subnets
            subnets: [
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED },
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS },
            ],
        });
        // DynamoDb Gateway endpoint
        constructVpc.addGatewayEndpoint('DynamoDbEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.GatewayVpcEndpointAwsService.DYNAMODB,
            // Add only to ISOLATED subnets
            subnets: [
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED },
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS },
            ],
        });
        // Add an interface endpoint
        constructVpc.addInterfaceEndpoint('SystemsManagerEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.SSM,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CloudWatch interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatchEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CW Events interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatch_Events_Endpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_EVENTS,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CW Logs interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatch_Logs_Endpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // ECR interface endpoint
        constructVpc.addInterfaceEndpoint('EcrDockerEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            securityGroups: [ec2SG],
            lookupSupportedAzs: true,
            open: true,
        });
        // EFS interface endpoint
        constructVpc.addInterfaceEndpoint('EFSEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
        });
        /*
        new ec2.InterfaceVpcEndpoint(this, "efs endpoint", {
          vpc,
          service: new ec2.InterfaceVpcEndpointService(`com.amazonaws.${this.region}.elasticfilesystem`, 2049),
          securityGroups: [ecsSG],
          open: true ,
          lookupSupportedAzs: true
        })
    */
        // Configure Cloudwatch Log group:
        const logGroup = new aws_cdk_lib_1.aws_logs.LogGroup(this, 'create solution Log group', {
            logGroupName: `/${props.solutionName}/${props.environment}/`,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            retention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        /*
      //CW Log group SSM Param
      new ssm.StringParameter(this, 'log group name ssm param', {
        parameterName: `/${props.solutionName}/${props.environment}/logGroupName`,
        stringValue: logGroup.logGroupName,
        description: `param for ${props.solutionName} log group name`,
        type: ssm.ParameterType.STRING,
        tier: ssm.ParameterTier.INTELLIGENT_TIERING,
        allowedPattern: '.*',
      });
       */
        /*
      const vpcFlowlogsRole = new iam.Role(this, `${props.solutionName}-role-for-vpcflowlogs`, {
        assumedBy: new iam.ServicePrincipal('vpc-flow-logs.amazonaws.com')
      });
    
      new ec2.FlowLog(this, 'FlowLog', {
        flowLogName: `${props.solutionName}-${props.environment}-vpclogs`,
        resourceType: ec2.FlowLogResourceType.fromVpc(vpc),
        trafficType: ec2.FlowLogTrafficType.ALL,
        destination: ec2.FlowLogDestination.toCloudWatchLogs(logGroup, vpcFlowlogsRole)
      }); */
        this.vpc = constructVpc;
        // const sdk3layer = new lambda.LayerVersion(this, 'HelperLayer', {
        //   // code: lambda.Code.fromAsset('assets/lambda-layers/aws-sdk-3-layer'),
        //   code: Code.fromAsset(path.join(__dirname, '/../../assets/lambda-layers/aws-sdk-3-layer'), {
        //   //    bundling: {
        //     //   command: [
        //     //     "bash",
        //     //     "-c",
        //     //     "npm install && npm run build && cp -rT /asset-input/dist/ /asset-output/",
        //     //   ],
        //     //   image: lambda.Runtime.NODEJS_14_X.bundlingImage,
        //     //   user: "root",
        //     //  },
        //   }),
        //   description: 'AWS JS SDK v3',
        //   compatibleRuntimes: [lambda.Runtime.NODEJS_14_X, lambda.Runtime.NODEJS_16_X],
        //   removalPolicy: RemovalPolicy.DESTROY,
        // });
        /*
        const crLambda = new NodejsFunction(this, 'customResourceFunction', {
          functionName: `${props.solutionName}-update-infrastructure-${props.environment}`,
          entry: path.join(__dirname, '/../../assets/customResourceLambda/index.ts'),
          runtime: lambda.Runtime.NODEJS_14_X,
          handler: 'handler',
          timeout: Duration.minutes(10),
          layers: [sdk3layer],
          environment: {
            REGION: parent.region,
          },
          bundling: {
            minify: true,
            externalModules: ['aws-sdk', '@aws-sdk/client-iam', '@aws-sdk/client-ec2'],
          },
        });
    
         */
        const crLambda = new aws_lambda_1.Function(this, 'customResourceFunction', {
            functionName: `${props.solutionName}-update-infrastructure-${props.environment}`,
            description: 'customer resource function to tag vpc interfaces and delete natgateway on destroy',
            //entry: path.join(__dirname, '/../../assets/customResourceLambda/index.ts'),
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '/../../lib/assets/customResourceLambda'), {
            //  bundling: {
            //   command: [
            //     "bash",
            //     "-c",
            //     "npm install && npm run build && cp -rT /asset-input/dist/ /asset-output/",
            //   ],
            //   image: lambda.Runtime.NODEJS_14_X.bundlingImage,
            //   user: "root",
            // },
            }),
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            handler: 'index.handler',
            timeout: aws_cdk_lib_1.Duration.minutes(10),
            //layers: [sdk3layer],
            tracing: aws_lambda_1.Tracing.ACTIVE,
            environment: {
                REGION: parent.region,
            },
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: crLambda,
        });
        provider.onEventHandler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['iam:*', 'ec2:*'],
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            resources: ['*'],
        }));
        // Custom resource to add tag to interface gateways and manage nat gateway:
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            properties: {
                natGateways: natGatewayProvider.configuredGateways,
                vpcId: constructVpc.vpcId,
                tags: [{ Key: 'environment', Value: props.environment }, { Key: 'solution', Value: props.solutionName }, { Key: 'costcenter', Value: props.costcenter }],
            },
        });
        // Tags.of(this).add("service", `${props.serviceName}`,{
        //   includeResourceTypes: []
        // })
        aws_cdk_lib_1.Tags.of(this).add('environment', props.environment);
        aws_cdk_lib_1.Tags.of(this).add('solution', props.solutionName);
        aws_cdk_lib_1.Tags.of(this).add('costcenter', props.costcenter);
        //Tags.of(this).add("ShutdownPolicy", "NoShutdown")
        new aws_cdk_lib_1.CfnOutput(this, 'VPCId', { value: constructVpc.vpcId, exportName: `${props.solutionName}:${props.environment}:VPCID:${parent.region}` });
        //new CfnOutput(this, 'NatGateways', { value: natGatewayProvider.configuredGateways.toString()} );
        new aws_cdk_lib_1.CfnOutput(this, 'VPCCIDR', { value: constructVpc.vpcCidrBlock, exportName: `${props.solutionName}:VpcCIDR` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet0', { value: constructVpc.privateSubnets[0].subnetId, exportName: `${props.solutionName}:PrivateSubnet0` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet1', { value: constructVpc.privateSubnets[1].subnetId, exportName: `${props.solutionName}:PrivateSubnet1` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet2', { value: constructVpc.privateSubnets[2].subnetId, exportName: `${props.solutionName}:PrivateSubnet2` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet0-AZ', { value: constructVpc.privateSubnets[0].availabilityZone, exportName: `${props.solutionName}:PrivateAZ0` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet1-AZ', { value: constructVpc.privateSubnets[1].availabilityZone, exportName: `${props.solutionName}:PrivateAZ1` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet2-AZ', { value: constructVpc.privateSubnets[2].availabilityZone, exportName: `${props.solutionName}:PrivateAZ2` });
        new aws_cdk_lib_1.CfnOutput(this, 'EC2SecurityGroup', { value: ec2SG.securityGroupId, exportName: `${props.solutionName}:EC2SecurityGroup` });
        new aws_cdk_lib_1.CfnOutput(this, 'LogGroupName', { value: logGroup.logGroupName });
    }
}
exports.VTVpc = VTVpc;
_a = JSII_RTTI_SYMBOL_1;
VTVpc[_a] = { fqn: "vt-vpc-construct.VTVpc", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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