# Generated by Django 3.1.6 on 2021-04-08 21:25

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("eveuniverse", "0005_type_materials_and_sections"),
        ("moonmining", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="MiningLedgerRecord",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "day",
                    models.DateField(db_index=True, help_text="last_updated in ESI"),
                ),
                ("quantity", models.PositiveBigIntegerField()),
                (
                    "character",
                    models.ForeignKey(
                        help_text="character that did the mining",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "corporation",
                    models.ForeignKey(
                        help_text="corporation of the character at time data was recorded",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "ore_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="mining_ledger",
                        to="moonmining.eveoretype",
                    ),
                ),
                (
                    "refinery",
                    models.ForeignKey(
                        help_text="Refinery this mining activity was observed at",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="mining_ledger",
                        to="moonmining.refinery",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="miningledgerrecord",
            constraint=models.UniqueConstraint(
                fields=("refinery", "day", "character", "ore_type"),
                name="functional_pk_mining_activity",
            ),
        ),
    ]
