## RIMA (RNA-seq IMmune Analysis) Pipeline Description

Tumor RNA-seq has become an important technique for molecular profiling and
immune characterization of tumors. RIMA (RNA-seq IMmune Analysis) performs
integrative computational modeling of tumor microenvironment from bulk tumor
RNA-seq data, which has the potential to offer essential insights to cancer
immunology and immune-oncology studies.
The pre-processing module includes four main procedures:
- Read mapping
- Quality control
- Gene quantification
- Batch effect removal

The downstream analysis includes seven modules:
- Differential expression analysis 
- Immune infiltration estimation 
- Immune repertoire inference 
- Variant identification 
- Neoantigen detection 
- Microbiome characterization 
- Immunotherapy response prediction

RIMA uses a conda virtual environment for software compiling and the python
Snakemake workflow management system for automatic batch processing. The
results generated by RIMA are displayed in HTML summary reports at both
sample- and cohort-level to enable interactive visualization.

### Workflow figure of RIMA pipeline

![](https://raw.githubusercontent.com/CIMAC-CIDC/cidc-ngs-pipeline-api/master/cidc_ngs_pipeline_api/rna/imgs/RIMA.png)

## Versions of Tools and Reference Files Used in RIMA

### Tools

#### Environment: rna

| Software         | Version | Source                | Notes                             |
|:-----------------|:--------|:----------------------|:----------------------------------|
| conda            | 4.8.3   | bioconda              | Environment Management            |
| Snakemake        | 5.5.4   | bioconda              | Pipeline Management               |
| python           | 3.6.8   | conda-forge           | Scripting  Language               |
| numpy            | 1.19.1  | conda-forge           | python library                    |
| perl             | 5.26.2  | conda-forge           | Scripting Language                |
| r                | 3.5.1   | conda-forge           | Scripting Language                |
| multiqc          | 1.10.0  | pip                   | Result Reporting System           |
| star             | 2.6.1   | bioconda              | Read Alignment                    |
| star-fusion      | 1.5.0   | bioconda              | Fusion Transcripts                |
| samtools         | 1.9     | bioconda              | Alignment Utility                 |
| salmon           | 1.3.0   | bioconda              | Gene Quantification               |
| picard           | 2.20.4  | bioconda              | Utility tool for aligned files    |
| bedtools         | 2.26.0  | bioconda              | Utility tool for aligned files    |
| VCFTools         | 0.1.16  | bioconda              | VCF Manipulation                  |
| bcftools         | 1.9     | bioconda              | BCF Manipulation                  |
| rseqc            | 3.0.1   | bioconda              | Quality Check                     |
| limma            | 3.42.0  | bioconductor          | Batch Removal                     |
| deseq2           | 1.26.0  | bioconductor          | Differential Expression Analysis  |
| ensembl-vep      | 96.0.   | git                   | Variant Annotation                |
| VarScan2         | 2.4.4   | conda-forge           | Mutation Calling                  |
| MSISensor2       | 0.1     | git                   | Microsatellite Instability        |
| TRUST4           | 1.0.0   | git                   | Immune repertoire analysis        |
| arcasHLA         | 1.3.2   | conda-forge bioconda  | HLA Typing.                       |
| TIDEpy           | 1.3.6   | git                   | Immune response prediction        |
| pvactools        | 1.5.7   | conda-forge r         | Neoantigen prediction             |
| centrifuge       | 1.0.4   | bioconda              | Microbiome                        |
