"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeSigningConfig = exports.UntrustedArtifactOnDeployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Code signing configuration policy for deployment validation failure.
 *
 * @stability stable
 */
var UntrustedArtifactOnDeployment;
(function (UntrustedArtifactOnDeployment) {
    UntrustedArtifactOnDeployment["ENFORCE"] = "Enforce";
    UntrustedArtifactOnDeployment["WARN"] = "Warn";
})(UntrustedArtifactOnDeployment = exports.UntrustedArtifactOnDeployment || (exports.UntrustedArtifactOnDeployment = {}));
/**
 * Defines a Code Signing Config.
 *
 * @stability stable
 * @resource AWS::Lambda::CodeSigningConfig
 */
class CodeSigningConfig extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const signingProfileVersionArns = props.signingProfiles.map(signingProfile => {
            return signingProfile.signingProfileVersionArn;
        });
        const resource = new lambda_generated_1.CfnCodeSigningConfig(this, 'Resource', {
            allowedPublishers: {
                signingProfileVersionArns,
            },
            codeSigningPolicies: {
                untrustedArtifactOnDeployment: (_b = props.untrustedArtifactOnDeployment) !== null && _b !== void 0 ? _b : UntrustedArtifactOnDeployment.WARN,
            },
            description: props.description,
        });
        this.codeSigningConfigArn = resource.attrCodeSigningConfigArn;
        this.codeSigningConfigId = resource.attrCodeSigningConfigId;
    }
    /**
     * Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param codeSigningConfigArn The ARN of code signing config.
     * @stability stable
     */
    static fromCodeSigningConfigArn(scope, id, codeSigningConfigArn) {
        const codeSigningProfileId = core_1.Stack.of(scope).parseArn(codeSigningConfigArn).resourceName;
        if (!codeSigningProfileId) {
            throw new Error(`Code signing config ARN must be in the format 'arn:aws:lambda:<region>:<account>:code-signing-config:<codeSigningConfigArn>', got: '${codeSigningConfigArn}'`);
        }
        const assertedCodeSigningProfileId = codeSigningProfileId;
        class Import extends core_1.Resource {
            constructor() {
                super(scope, id);
                this.codeSigningConfigArn = codeSigningConfigArn;
                this.codeSigningConfigId = assertedCodeSigningProfileId;
            }
        }
        return new Import();
    }
}
exports.CodeSigningConfig = CodeSigningConfig;
_a = JSII_RTTI_SYMBOL_1;
CodeSigningConfig[_a] = { fqn: "@aws-cdk/aws-lambda.CodeSigningConfig", version: "1.112.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZS1zaWduaW5nLWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvZGUtc2lnbmluZy1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSx3Q0FBMkQ7QUFFM0QseURBQTBEOzs7Ozs7QUFHMUQsSUFBWSw2QkFNWDtBQU5ELFdBQVksNkJBQTZCO0lBRXZDLG9EQUFtQixDQUFBO0lBR25CLDhDQUFhLENBQUE7QUFDZixDQUFDLEVBTlcsNkJBQTZCLEdBQTdCLHFDQUE2QixLQUE3QixxQ0FBNkIsUUFNeEM7Ozs7Ozs7QUF3QkQsTUFBYSxpQkFBa0IsU0FBUSxlQUFROzs7O0lBc0I3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTZCOztRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0seUJBQXlCLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLEVBQUU7WUFDM0UsT0FBTyxjQUFjLENBQUMsd0JBQXdCLENBQUM7UUFDakQsQ0FBQyxDQUFDLENBQUM7UUFFSCxNQUFNLFFBQVEsR0FBeUIsSUFBSSx1Q0FBb0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2hGLGlCQUFpQixFQUFFO2dCQUNqQix5QkFBeUI7YUFDMUI7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsNkJBQTZCLFFBQUUsS0FBSyxDQUFDLDZCQUE2QixtQ0FBSSw2QkFBNkIsQ0FBQyxJQUFJO2FBQ3pHO1lBQ0QsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1NBQy9CLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxvQkFBb0IsR0FBRyxRQUFRLENBQUMsd0JBQXdCLENBQUM7UUFDOUQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFFBQVEsQ0FBQyx1QkFBdUIsQ0FBQztJQUM5RCxDQUFDOzs7Ozs7Ozs7SUF0Q00sTUFBTSxDQUFDLHdCQUF3QixDQUFFLEtBQWdCLEVBQUUsRUFBVSxFQUFFLG9CQUE0QjtRQUNoRyxNQUFNLG9CQUFvQixHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsUUFBUSxDQUFDLG9CQUFvQixDQUFDLENBQUMsWUFBWSxDQUFDO1FBQ3pGLElBQUksQ0FBQyxvQkFBb0IsRUFBRTtZQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLHVJQUF1SSxvQkFBb0IsR0FBRyxDQUFDLENBQUM7U0FDakw7UUFDRCxNQUFNLDRCQUE0QixHQUFHLG9CQUFvQixDQUFDO1FBQzFELE1BQU0sTUFBTyxTQUFRLGVBQVE7WUFJM0I7Z0JBQ0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFKSCx5QkFBb0IsR0FBRyxvQkFBb0IsQ0FBQztnQkFDNUMsd0JBQW1CLEdBQUcsNEJBQTRCLENBQUM7WUFJbkUsQ0FBQztTQUNGO1FBQ0QsT0FBTyxJQUFJLE1BQU0sRUFBRSxDQUFDO0lBQ3RCLENBQUM7O0FBakJILDhDQXlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTaWduaW5nUHJvZmlsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zaWduZXInO1xuaW1wb3J0IHsgSVJlc291cmNlLCBSZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuQ29kZVNpZ25pbmdDb25maWcgfSBmcm9tICcuL2xhbWJkYS5nZW5lcmF0ZWQnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBVbnRydXN0ZWRBcnRpZmFjdE9uRGVwbG95bWVudCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRU5GT1JDRSA9ICdFbmZvcmNlJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgV0FSTiA9ICdXYXJuJyxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUNvZGVTaWduaW5nQ29uZmlnIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb2RlU2lnbmluZ0NvbmZpZ0Fybjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb2RlU2lnbmluZ0NvbmZpZ0lkOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ29kZVNpZ25pbmdDb25maWdQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNpZ25pbmdQcm9maWxlczogSVNpZ25pbmdQcm9maWxlW10sXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB1bnRydXN0ZWRBcnRpZmFjdE9uRGVwbG95bWVudD86IFVudHJ1c3RlZEFydGlmYWN0T25EZXBsb3ltZW50LFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmcsXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBDb2RlU2lnbmluZ0NvbmZpZyBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUNvZGVTaWduaW5nQ29uZmlnIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21Db2RlU2lnbmluZ0NvbmZpZ0Fybiggc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29kZVNpZ25pbmdDb25maWdBcm46IHN0cmluZyk6IElDb2RlU2lnbmluZ0NvbmZpZyB7XG4gICAgY29uc3QgY29kZVNpZ25pbmdQcm9maWxlSWQgPSBTdGFjay5vZihzY29wZSkucGFyc2VBcm4oY29kZVNpZ25pbmdDb25maWdBcm4pLnJlc291cmNlTmFtZTtcbiAgICBpZiAoIWNvZGVTaWduaW5nUHJvZmlsZUlkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYENvZGUgc2lnbmluZyBjb25maWcgQVJOIG11c3QgYmUgaW4gdGhlIGZvcm1hdCAnYXJuOmF3czpsYW1iZGE6PHJlZ2lvbj46PGFjY291bnQ+OmNvZGUtc2lnbmluZy1jb25maWc6PGNvZGVTaWduaW5nQ29uZmlnQXJuPicsIGdvdDogJyR7Y29kZVNpZ25pbmdDb25maWdBcm59J2ApO1xuICAgIH1cbiAgICBjb25zdCBhc3NlcnRlZENvZGVTaWduaW5nUHJvZmlsZUlkID0gY29kZVNpZ25pbmdQcm9maWxlSWQ7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJQ29kZVNpZ25pbmdDb25maWcge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGNvZGVTaWduaW5nQ29uZmlnQXJuID0gY29kZVNpZ25pbmdDb25maWdBcm47XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgY29kZVNpZ25pbmdDb25maWdJZCA9IGFzc2VydGVkQ29kZVNpZ25pbmdQcm9maWxlSWQ7XG5cbiAgICAgIGNvbnN0cnVjdG9yKCkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbmV3IEltcG9ydCgpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGNvZGVTaWduaW5nQ29uZmlnQXJuOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBjb2RlU2lnbmluZ0NvbmZpZ0lkOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENvZGVTaWduaW5nQ29uZmlnUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3Qgc2lnbmluZ1Byb2ZpbGVWZXJzaW9uQXJucyA9IHByb3BzLnNpZ25pbmdQcm9maWxlcy5tYXAoc2lnbmluZ1Byb2ZpbGUgPT4ge1xuICAgICAgcmV0dXJuIHNpZ25pbmdQcm9maWxlLnNpZ25pbmdQcm9maWxlVmVyc2lvbkFybjtcbiAgICB9KTtcblxuICAgIGNvbnN0IHJlc291cmNlOiBDZm5Db2RlU2lnbmluZ0NvbmZpZyA9IG5ldyBDZm5Db2RlU2lnbmluZ0NvbmZpZyh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhbGxvd2VkUHVibGlzaGVyczoge1xuICAgICAgICBzaWduaW5nUHJvZmlsZVZlcnNpb25Bcm5zLFxuICAgICAgfSxcbiAgICAgIGNvZGVTaWduaW5nUG9saWNpZXM6IHtcbiAgICAgICAgdW50cnVzdGVkQXJ0aWZhY3RPbkRlcGxveW1lbnQ6IHByb3BzLnVudHJ1c3RlZEFydGlmYWN0T25EZXBsb3ltZW50ID8/IFVudHJ1c3RlZEFydGlmYWN0T25EZXBsb3ltZW50LldBUk4sXG4gICAgICB9LFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgIH0pO1xuICAgIHRoaXMuY29kZVNpZ25pbmdDb25maWdBcm4gPSByZXNvdXJjZS5hdHRyQ29kZVNpZ25pbmdDb25maWdBcm47XG4gICAgdGhpcy5jb2RlU2lnbmluZ0NvbmZpZ0lkID0gcmVzb3VyY2UuYXR0ckNvZGVTaWduaW5nQ29uZmlnSWQ7XG4gIH1cbn1cbiJdfQ==